\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : TIMING.FRT 
\ DESCRIPTION : Time and date control 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



EXTRA:

\G Return the current date. +n1 is the day {1..31}, +n2 is the month
\G {1..12}, and +n3 is the year (e.g. 1991).
CODE DATE               ( -- +n1 +n2 +n3 )          \ EXTRA
                PUSH    BX
                MOV     AH, # 2A
                INT     21
$IF386
                MOVZX   BX, DL
$ELSE
                MOV     BL, DL
                XOR     BH, BH
$THEN
                PUSH    BX
                MOV     BL, DH
                PUSH    BX
                MOV     BX, CX
                NEXT
END-CODE

\G Return the current time. +n1 is the second {0..59}, +n2
\G is the minute {0..59}, and +n3 is the hour {0..23}.
CODE TIME               ( -- +n1 +n2 +n3 )          \ EXTRA
                PUSH    BX
                MOV     AH, # 2C
                INT     21
$IF386
                MOVZX   BX, DH
$ELSE
                MOV     BL, DH
                XOR     BH, BH
$THEN
                PUSH    BX
                MOV     BL, CL
                PUSH    BX
                MOV     BL, CH
                NEXT
END-CODE

\ d is the number of clock ticks elapsed since midnight.
ORPHAN TICKS            ( -- d )                \ EXTRA
                PUSH    BX
                MOV     AH, # 0
                INT     1A
                PUSH    DX
                MOV     BX, CX
                NEXT
END-CODE

\G d is the number of milliseconds elapsed since midnight.
: GETTIME               ( -- d )                \ EXTRA
        TICKS #14006 #255 M*/
    ;

\G Reset the Forth timer.
: TIMER-RESET           ( -- )                  \ EXTRA
        GETTIME TIMESAVE 2!
        ;

\G Return a random number.
: RANDOM        ( -- u )                        \ EXTRA
        (LIT) SEED 2@ 7465 10 D* 4567 23 D+ 2DUP (LIT) SEED 2! +
        ;

\G Initialize the random number generator.
: RANDOMIZE     ( d -- )                        \ EXTRA
        (LIT) SEED 2!
        ;

:ORPHAN RANDOMTIMER
        GETTIME RANDOMIZE
        ;

\G u2 is a random number less than u2.
: CHOOSE        ( u1 -- u2 )                    \ EXTRA
        RANDOM UM* NIP
        ;

#CPU @ #386 = [IF]

\G Wait for d microseconds, limited to about 1000 by the operating
\G system. Not available in CHForth-86.
CODE MICROSECONDS               ( d -- )        \ EXTRA
                MOV     CX, BX
                POP     DX
                MOV     AH, # 86
                INT     15
                POP     BX
                NEXT
END-CODE

FORTH:

\G Wait u milliseconds.
: MS            ( u -- )                        \ FORTH
        #1000 /MOD 0
        ?DO     4240 0F MICROSECONDS
        LOOP
        #1000 M* MICROSECONDS
        ;  ANS

[ELSE]

\G a-addr is the address of a cell containing a delay to tune MS .
\G The value is set in the file CHFORTH.CFG and can be changed by
\G the user to account for the type of CPU and the clock frequency.
\G Not available in CHForth-386.
VARIABLE FUDGE          ( -- a-addr )           \ EXTRA
        300 T' FUDGE !-T

FORTH:

: MS
        0
        ?DO     FUDGE @ 0
                DO
                LOOP
        LOOP
        ;  ANS

[THEN]

\G Return the current time and date. +n1 is the second {0..59}, +n2
\G is the minute {0..59}, +n3 is the hour {0..23}, +n4 is the day
\G {1..31}, +n5 is the month {1..12}, and +n6 is the year (e.g.
\G 1991).
: TIME&DATE     ( -- +n1 +n2 +n3 +n4 +n5 +n6 )          \ FORTH
        TIME DATE
        ;  ANS

                            \ (* End of Source *) /
