\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Library expert system 
\ CATEGORY    : Examples 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -expert


        MARKER -books



DOC
(*
 * See Forth Dimensions XI, 2 page 23 
*)
ENDDOC


newsystem

question computer_talen    "Wil je wat weten over computertalen ?"
question forth_taal        "Wil je wat weten over Forth ?"
question speciale_versie   "Wil je een bepaalde versie ?"
question forth-79_taal     "Wil je wat weten over Forth-79 ?"
question forth-83_taal     "Wil je wat weten over Forth-83 ?"
question mms-forth_taal    "Wil je wat weten over MMS-Forth ?"
question fig-forth_taal    "Wil je wat weten over fig-Forth ?"
question pascal_taal       "Wil je wat weten over Pascal ?"
question ucsd-pascal_taal  "Wil je wat weten over UCSD Pascal ?"
question turbo-pascal_taal "Wil je wat weten over Turbopascal ?"
question basic_taal        "Wil je wat weten over BASIC ?"
question c_taal            "Wil je wat weten over C ?"

{ computer_talen ? invert }
rule no_plank "Sorry, we hebben alleen boeken over computertalen."

{ forth_taal ? & speciale_versie ? invert }
rule plank_01 "Koop zelf Forth Dimensions."

{ forth_taal ? & speciale_versie ? & forth-79_taal ? }
rule plank_02 "Koop 79-Standard."

{ forth_taal ? & speciale_versie ? & forth-83_taal ? }
rule plank_03 "Koop F83."

{ forth_taal ? & speciale_versie ? & mms-forth_taal ? }
rule plank_04 "Koop MMS-Forth."

{ forth_taal ? & speciale_versie ? & fig-forth_taal ? }
rule plank_05 "Koop figForth."

{ forth_taal ? }
rule plank_05a "Ik kan je niet helpen!"

{ basic_taal ? }
rule plank_06 "Zie BASIC."

{ c_taal ? }
rule plank_07 "Zie C."

{ pascal_taal ? & speciale_versie ? invert }
rule plank_08 "Zie een pascal boek."

{ pascal_taal ? & speciale_versie ? & turbo-pascal_taal ? }
rule plank_09 "Zie een Turbo boek."

{ pascal_taal ? & speciale_versie ? & ucsd-pascal_taal ? }
rule plank_10 "Zie een UCSD boek."

{ true }
rule plank_10a "Ik kan je niet helpen!"

: go
        cr setup ^I emit ." Bibliotheeksysteem" cr
        no_plank !
        plank_01 !
        plank_02 !
        plank_03 !
        plank_04 !
        plank_05 !
        plank_05a !
        plank_06 !
        plank_07 !
        plank_08 !
        plank_09 !
        plank_10 !
        plank_10a ! ;


                            \ (* End of Source *) /
