\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Music on an interrupted basis 
\ CATEGORY    : Examples 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -intvec


        MARKER -muziekst



DOC
  The type INTVEC resets itself to its native state when forgotten.
  Some of them, including $1C will be reset by the Forth system when
  you return to DOS.

        SOUND-ON revectors the clock interrupt to make sound.
        SOUND-OFF resets the original vector.
        RESTART   resets the melody.
ENDDOC


privates

$61 constant ppi        private
$42 constant ctr        private

$1C intvec klok         private

variable melodie        private

: rust
        0 c, , ;        private

: toon
        create  , private
        does>   @ swap c, #1193280. rot um/mod , drop 1 rust ;  private

                #392 2/ toon g3
                #262 toon c4    #277 toon c4#
#277 toon d4&   #294 toon d4    #311 toon d4#
#311 toon e4&   #330 toon e4
                #349 toon f4    #370 toon f4#
#370 toon g4&   #392 toon g4    #415 toon g4#
#415 toon a4&   #440 toon a4    #466 toon a4#
#466 toon b4&   #494 toon b4
                #523 toon c5

#32 8 max constant hele         private
hele 2 / constant halve         private
hele 4 / constant kwart         private
hele 8 / constant achtste       private

create jakob    private
        1 c,
        -1 c,
        4 3 6 3 + + + 4 * 1+ c,         \ 2* aantal tonen + 1* aantal rusten
        kwart c4 kwart d4 kwart e4 kwart c4
        kwart c4 kwart d4 kwart e4 kwart c4
        kwart e4 kwart f4 halve g4
        kwart e4 kwart f4 halve g4
        achtste g4 achtste a4 achtste g4 achtste f4 kwart e4 kwart c4
        achtste g4 achtste a4 achtste g4 achtste f4 kwart e4 kwart c4
        kwart c4 kwart g3 halve c4
        kwart c4 kwart g3 halve c4
        hele rust

jakob melodie !
\ Of course you could think of a finer melody!

code lusje
                mov     bx, melodie
                dec     0 [bx] byte
        0<> if
                ret
        then
                mov     ax, 1 [bx]
                inc     al
                cmp     al, ah
        0= if
                xor     al, al
        then
                mov     1 [bx], al
                xor     ah, ah
                mov     di, ax
                add     di, ax
                add     di, ax
                mov     al, 3 [bx+di]
                test    al, al
        0= if
                mov     al, 4 [bx+di]
                mov     0 [bx], al
                in      al, # ppi
                and     al, # $FE
                out     ppi #, al
                ret
        then
                mov     0 [bx], al
                mov     al, 4 [bx+di]
                out     ctr #, al
                mov     al, 5 [bx+di]
                out     ctr #, al
                in      al, # ppi
                or      al, # 3
                out     ppi #, al
                ret
end-code  private

code intserv
                pushf
                push    ax
                push    bx
                push    di
                push    ds
                push    cs
                pop     ds
                call    ' lusje
                pop     ds
                pop     di
                pop     bx
                pop     ax
                popf
                jmp     far klok
end-code  private

: sound-on              ( -- )
        ['] intserv to klok
        ppi pc@ 3 or ppi pc!
        ;

: sound-off             ( -- )
        clear klok
        ppi pc@ $FC and ppi pc!
        ;

: restart               ( -- )
        $FF01 melodie @ !
        ;

: lus           ( x -- )                        \ broken melody, milliseconds
        restart
        begin   sound-on dup ms sound-off dup ms key?
        until
        drop
        ;

deprive

                            \ (* End of Source *) /
