\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Very high powers of two 
\ CATEGORY    : Examples 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -assembler

        MARKER -powers



DOC
   n TWO   Prints a power of two.
   TEST    Shows a series of numbers of two in 80 columns.
   TEST2   Does the same, in 132 columns.
ENDDOC


privates

#1024 constant /number                  private \ 2^6802 is about 10^2048

create number                           private \ the long number, BCD
        number /number dup allot erase

variable power                          private \ current power of two
variable length                         private \ the length of the BCD number

code calculate                                  \ calculate
                push    es
                push    cs
                pop     es
                mov     dx, power
        begin
                mov     cx, length
                mov     di, # number
                xor     al, al
        do
                mov     al, 0 [di]
                adc     al, al                  \ 2*
                daa                             \ decimal adjust
                stosb
        loop
                dec     dx
        0= until
                pop     es
                next
end-code  private

: prepare               ( -- )                  \ set the number to one
        number /number erase 1 number c!
        ;  private

code -c@                ( c-addr1 -- c-addr2 c )  \ predecrement and fetch
                dec     bx
                push    bx
                mov     bl, 0 [bx]
                xor     bh, bh
                next
end-code  private

: .byte                 ( x -- )                \ type a BCD byte
        push base hex
        0 <# # # #> type
        pop base
        ;  private

: print                 ( -- )                  \ print the number
        out                                             \ start on empty line
        if      cr
        then
        c/l length @ 2* over mod - spaces               \ a few spaces
        number length @ + -c@ dup #10 <
        if      space 0 .r                              \ preceding zero
        else    .byte
        then
        length @ 1- 0                                   \ the rest
        ?do     -c@ .byte
        loop
        drop
        ;  private

: input                 ( x -- )                \ the power of two
        dup power !
        #3010 #20000 */                                 \ log 2 = 0.30103
        1+ 1 max /number 2 - min length !
        ;  private

: two                   ( x -- )
        dup 1 #6803 within
        if      prepare input calculate print
        else    cr ." I can't calculate a power of 2 as great as " .
                cr ." The maximum is 2^6802. "
        then
        ;

: test                  ( -- )
        #260 1
        do      i two stop? ?leave
        loop
        ;

: test2                 ( -- )
        text2
        #432 1
        do      i two stop? ?leave
        loop
        key drop text
        ;

deprive

                            \ (* End of Source *) /
