\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Teenage Mutant Ninja Forth 
\ CATEGORY    : Testing 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------

        NEEDS -array
        NEEDS -strings

        MARKER -mutant


0 value mill

: .windmill
        at-xy
        mill 3 and case
                0 of    ." | |" endof
                1 of    ." \ /" endof
                2 of    ." - -" endof
                3 of    ." / \" endof
        endcase
        1 +to mill ;

vector should

 5 constant max-words
24 constant max-tokens

max-words   array program
max-tokens $array names

' noop alias nop
: fill-stack    20 0 do random loop ;
: check-stack   depth 20 = ;
: clear-stack   depth 0 ?do drop loop ;

: /     dup if /        else 2drop -1 then ;
: mod   dup if mod      else 2drop -1 then ;
: 2+    2 + ;
: 2-    2 - ;

: execute-token
        max-tokens 1- min
        exec:   nop dup swap drop rot over + - 1+ 1- 2+ 2- 2/ abs negate max min and invert or xor * / mod ;

\ 8 new$array names     -- onnodig met deze implementatie

s" NOP"      0 to names s" DUP"      1 to names s" SWAP"      2 to names
s" DROP"     3 to names s" ROT"      4 to names s" OVER"      5 to names
s" +"        6 to names s" -"        7 to names s" 1+"        8 to names
s" 1-"       9 to names s" 2+"      10 to names s" 2-"       11 to names
s" 2/"      12 to names s" ABS"     13 to names s" NEGATE"   14 to names
s" MAX"     15 to names s" MIN"     16 to names s" AND"      17 to names
s" INVERT"  18 to names s" OR"      19 to names s" XOR"      20 to names
s" *"       21 to names s" /"       22 to names s" MOD"      23 to names

: .name?
        max-tokens 1- min dup 0=
        if      drop false
        else    names type 2 spaces true
        then ;

: do-program
        max-words 0
        do      i program execute-token
        loop ;

cr source type ( Look out: ) ' random >body @ cell+ l@ constant seed

: test
        0 0 0 0 seed 2@
        local oldseedhigh local oldseedlow
        local olddepth local top local second local third
        clear-stack fill-stack should
        depth to olddepth
        oldseedlow oldseedhigh seed 2!
        to top to second to third
        clear-stack fill-stack do-program
        depth olddepth <>
        if      clear-stack false
        else    top = swap second = and swap third = and >r clear-stack r>
        then ;

: tests
        40 0
        do      test 0=
                if      false unloop exit
                then
        loop
        true ;

create tries    2 cells allot

: mutate
        cr tries d0! max-words 0
        do      0 i to program
        loop
        begin   tests 0=
        while   max-tokens choose max-words choose to program
                1. tries d+!
                tries cell+ @ 31 and 31 =
                if      0 ?at nip .windmill
                then
                key?
        until   then
        key?
        if      key drop
        then
        cr tries 2@ d. ." tries." ;

: .text
        3 local #out
        cr ." : PROGRAM " max-words 0
        do      #out 3 =
                if      cr 4 spaces clear #out
                then
                i program .name?
                if      1 +to #out
                then
        loop
        ." ;" ;

: .program
        mutate .text ;

:noname
        ?stack 1+
        ;  is should



: .help
        CR CR ." Zie Vijgeblad 41 voor meer informatie"
        CR CR
        ;

.help

                            \ (* End of Source *) /
