\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : System Info
\ CATEGORY    : Utilities
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : July 24, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        IN mem


        ?DEF -si [IF] -si [THEN]


        MARKER -si


: [begin]
        save-input
        ;

: [until]
        if      0
                do      drop
                loop
                exit
        then
        dup local x dup 1+ 0
        do      x pick
        loop
        restore-input throw
        ;

: name
        s" SI.LOG"
        ;

name file-status nip 0= [if]

name delete-file throw

[then]

name logfile place

open-log

cr .(         System Info)      cr
cr .(     Interrupt vectors)    cr allints  cr
cr .(     Hardware Interrupts)  cr .irqs cr
cr .(     Environment strings)  cr .env     cr
cr .(     Ports)                cr .ports   cr
cr .(     Roms)                 cr .roms    cr
cr .(     Disk Drives)          cr .subst   cr
cr .(     Programs)             cr clear n
[begin] n ' -view catch cr 0= ?dup nip 0= [until]
cr .(     DOS blocks, id=8)     cr 8 mcb cr
cr .(     Used Memory Blocks)   cr .blocks  cr
cr .(     Device Drivers)       cr .drivers cr
\ ' bl to key in config

close-log

diagnose

bye


                            \ (* End of Source *) /
