\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : The Famous Sieve of Eratosthanes
\ CATEGORY    : Benchmarks
\ AUTHOR      : Marcel Hendrix
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ LAST CHANGE : October 5th, 1991 MHX
\ ----------------------------------------------------------------------



        NEEDS -assembler


        MARKER -sieveasm



#100  constant #times   
#8192 constant size     

CREATE flags    size ALLOT

CODE DO-PRIME
                push    bx
                push    es
                push    cs
                pop     es
                mov     di, # flags
                mov     cx, # SIZE
                mov     al, # 1
                rep     stosb
                mov     cx, # SIZE
                xor     di, di
                xor     dx, dx
        do
                test    flags [di], # 1 byte
        0<> if
                mov     ax, di
                add     ax, ax
                add     ax, # 3
                mov     bx, ax
                add     bx, di
        begin
                cmp     bx, # SIZE
        < while
                mov     flags [bx], # 0 byte
                add     bx, ax
        repeat
                inc     dx
        then
                inc     di
        loop
                mov     bx, dx
                pop     es
                next    end-code


: PRIMES        CR #times .DEC ." iterations."  TIMER-RESET
                0 #times 0 DO  
                             DROP  DO-PRIME  
                         LOOP 
                CR .  ." primes found." 
                CR .ELAPSED ;


: .help
                CR ." Sieve"
                CR ."             Compile time   Run time    Primes"
                CR ."   Par.C         38.19       8.732       1899"
                CR ."   Inmos ICC     83.98       9.578       1899"
                CR ."   3L C          45.25       5.955       1899"
                CR ."   tForth (WS)    1.00       8.830       1899" 
                CR ."   tForth (main)  1.00      10.273       1899"
                CR ."   CHForth 16     0.49       5.490       1899"
                CR ."   CHForth 40     2.36       1.043       1899"
                CR CR ." Enter PRIMES to run the benchmark." ;

.help

                            \ (* End of Source *) /
