\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Aquarium simulation 
\ CATEGORY    : Games 
\ AUTHOR      : Kees Moerman 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -screensv

DOC
   Vijgeblad 30
ENDDOC


hex

: addr
        dup>r -2 and #40 * + r> 1 and
        if      2000 +
        then
        sbase swap
        ;

#79 constant xmax
#38 constant ymax

#80 constant maxlen

variable foods  2 foods !

variable stepon 5 stepon !

: shape
        -rot 5 * 5 0
        do      2>r count 2r@ addr c!x 2r> 1+
        loop
        drop 2drop
        ;

: shape:
        create  c, c, c, c, c,
        does>   shape
        ;

3E 7F FF 7F 3E shape: ball1
1C 3E 7F 3E 1C shape: ball2
00 1C 3E 1C 00 shape: ball3
08 14 55 55 55 shape: gray
14 24 41 24 08 shape: food
00 00 00 00 00 shape: void

: v@
        5 * 1+ addr c@x
        ;

: food?
        v@ 24 =
        ;

: food|gray?
        v@ dup 24 = swap 55 = or
        ;

: empty?
        v@ 0=
        ;

variable %state         %state off

: initialize
        %state on
        ;

: array
        create  1+ cells ,
        does>   %state @
                if      %state off here over @ allot swap ! exit
                then
                @ []cell
        ;

maxlen array fish0      create len0 0 ,
maxlen array fish1      create len1 0 ,
maxlen array fish2      create len2 0 ,
maxlen array fish3      create len3 0 ,
maxlen array fish4      create len4 0 ,
maxlen array fish5      create len5 0 ,
maxlen array fish6      create len6 0 ,
maxlen array fish7      create len7 0 ,

variable thefish

: >fish
        thefish !
        ;

: fish
        thefish @
        exec: fish0 fish1 fish2 fish3 fish4 fish5 fish6 fish7
        ;

: len
        thefish @
        exec: len0 len1 len2 len3 len4 len5 len6 len7
        ;

: fish@[]
        fish @ split
        ;

: fish![]
        >r join r> fish !
        ;

: fish@
        0 fish@[]
        ;

: fish!
        len @ 1- fish@[] void len @ 4 >
        if      len @ 3 / dup fish@[] ball2 2* fish@[] ball3
        then
        2dup ball1 0 fish dup 2 + maxlen 1- cells cmove> 0 fish![]
        ;

: fish+!
        len @ maxlen 2 - =
        if      fish! exit
        then
        2dup ball1 len @ 4 >
        if      len @ 3 / dup fish@[] ball2 2* fish@[] ball3
        then
        0 fish dup 2 + maxlen 1- cells cmove> 0 fish![] len incr
        ;

: fish-!
        len @ 1 >
        if      len decr len @ fish@[] void
        then
        ;

: newfood
        xmax 1+ choose local x:
        ymax 2/ choose 5 / 5 * local y:
        begin   x:      y: 1+   food|gray?
                x: 1-   y:      food|gray?      or
                x: 1+   y:      food|gray?      or
                x:      y:      empty?          and
                y:      ymax =                  or
                1 +to   y:
        until
        x: y: 1- food
        ;

: x++
        swap 1+ xmax min swap
        ;

: x--
        swap 1- 0 max swap
        ;

: y++
        1+ ymax min
        ;

: y--
        1- 0 max
        ;

: ?step
        2dup empty?
        if      fish! true
        else    2drop false
        then
        ;

: step?
        >r fish@ r> 3 and
        case
                0 of    x--     endof
                1 of    y--     endof
                2 of    x++     endof
                3 of    y++     endof
        endcase
        ?step
        ;

: stepon?
        fish@ 2dup 1 fish@[] rot - 2 + -rot - 2 + 2 lshift or
        case
                B of    y--     endof
                E of    x++     endof
                9 of    y++     endof
                6 of    x--     endof
        endcase
        ?step
        ;

: eat?
        >r fish@ r> 3 and
        case
                0 of    x--     endof
                1 of    y--     endof
                2 of    x++     endof
                3 of    y++     endof
        endcase
        2dup food?
        if      fish+! true
        else    2drop false
        then
        ;

: step
        #10 ms
        false 4 choose 7 0
        do      dup eat?
                if      nip true swap leave
                then
                1+
        loop
        drop
        if      exit
        then
        stepon @ choose
        if      stepon?
                if      exit
                then
        then
        false 4 choose 7 0
        do      dup step?
                if      nip true swap leave
                then
                1+
        loop
        drop 0=
        if      fish-!
        then
        ;

: graphics                                      \ 640 x 200 x 2
        6 setmode
        ;

: init
        initialize fish0 initialize fish1 initialize fish2 initialize fish3
        initialize fish4 initialize fish5 initialize fish6 initialize fish7
        graphics 100 0
        do      newfood
        loop
        xmax 1+ 0
        do      ymax 1+ ymax 9 -
                do      j i food?
                        if      j i gray
                        then
                loop
        loop
        xmax 1+ 0
        do      i ymax 1+ gray
        loop
        40 0
        do      newfood
        loop
        8 0
        do      i >fish len off
                1 xmax 2/ + 1 fish+!
                1 xmax 2/ + 0 fish+!
        loop
        ;

false [if]

: display
        inwindow home 0 8 0
        do      i >fish len @ dup 4 .r +
        loop
        5 .r
        ;

[else]

: display
        ;  immediate

[then]

: go
        0
        begin   1+ dup 3 and 4 + >fish step
                4 choose >fish step
                foods @ choose 0=
                if      newfood
                then
                dup 3FF and 0=
                if      6 choose 1+ foods !
                then
                dup 70 and 0=
                if      5 choose 0=
                        if      fish-!
                        then
                then
                display
                key?
        until
        drop
        ;

create at' 4 allot

: main
        decimal save-screen ?at at' 2!
        init go
        text restore-screen at' 2@ at-xy
        ;

turnkey main aquarium
                            \ (* End of Source *) /
