\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Conversion of ASCII files 
\ CATEGORY    : Turnkey programs 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -stdlib

:noname
        cr ." Bewerken van bestanden." cr
        cr ." SKIP [opties] invoer uitvoer" cr
        cr ."      -a   verwijder afsluitende spaties"
        cr ."      -e   echo regels op het scherm"
        cr ."      -l   verwijder opeenvolgende lege regels"
        cr ."      -p   verwijder paginering"
        cr ."      -t   zet tabs om in spaties"
        cr ."      -vn  Sla de eerste n posities over"
        ;  is .help

variable vanaf  vanaf off
variable leeg?  leeg? off
variable leeg   leeg off
variable pagina pagina off
variable teller teller off
variable echo   echo off
variable trail  trail off
variable tabs   tabs off
variable outfile

: drukaf
        echo @
        if      2dup teller incr teller @ 4 .r space
                c/l 1- out - min type cr
        then
        outfile @ write-line throw
        ;

: delete_page_break
        begin   2dup ^L scan
        while   bl swap c!
        repeat
        drop
        ;

: doen
        save-input
        file-1 @ count r/o open-file throw to source-id
        file-2 @ count w/o create-file throw outfile !
        begin   refill
        while   source tabs @
                if      pad expand
                then
                pagina @
                if      delete_page_break
                then
                trail @
                if      -trailing
                then
                vanaf @ /string 0 max dup
                if      leeg off drukaf
                else    leeg? @
                        if      leeg @ leeg on
                                if      2drop
                                else    drukaf
                                then
                        else    drukaf
                        then
                then
        repeat
        source-id close-file throw
        outfile @ close-file throw
        restore-input throw
        ;

:noname
        decimal
        'a' option
        if      drop trail on
        then
        'e' option
        if      drop echo on
        then
        'l' option
        if      drop leeg? on
        then
        'p' option
        if      drop pagina on
        then
        't' option
        if      drop tabs on
        then
        'v' option
        if      get# vanaf !
        then
        file-1 @ c@
        if      doen
        else    .help
        then
        ;  is proc

signon off

statoff

turnkey main skip
                            \ (* End of Source *) /
