\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Automatic forward referencing and resolving
\ CATEGORY    : Non Standard Programs
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : July 12, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        ?DEF -autofor [IF] -autofor [THEN]


        MARKER -autofor


( See F-PC file AUTOFOR.SEQ )

internal definitions

' ?crash >body @ 3 cells - alias log-the-error

: (forward)      ( x -- )                               \ the handler
        drop                                            \ "word not found"
        #-518 .mess                                     \ "forward reference"
        reveal
        here l,
        push postfix true to postfix
        push warning false to warning
        parsed-word vector                              \ compile new word
        pop warning
        pop postfix
        'name errname !
        #lines @ errline !
        log-the-error
        ;  private

' (forward) is ?crash                                   \ put in vector

#-601 mess" resolving forward reference"

: ((head,))     ( c-addr u -- )
        push warning
        2dup search-context                             \ find word
        if      dup [ here ] literal u>                 \ not too old ?
                if      dup >call
                        [ ' cold >call ] literal =      \ is type ok ?
                        if      align here
                                over >body !            \ patch datafield
                                clear warning
                                #-601 .mess
                                'name errname !
                                #lines @ errline !
                                log-the-error
                        then
                then
                drop
        then
        (head,)                                         \ default action
        pop warning
        ;

' ((head,)) is head,                                    \ put in vector

forth definitions


                            \ (* End of Source *) /
