\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Sorted directory
\ CATEGORY    : DOS Utilities
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : August 04, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        ?DEF -dir [IF] -dir [THEN]


        MARKER -dir


doer: dostring      ( a-addr -- c-addr u )
        char+ count
    ;

: tostring          ( c-addr1 u c-addr2 -- )
        count rot umin swap place
    ;  compile-only

: +tostring          ( c-addr1 u c-addr2 -- )
        count over c@ - rot umin swap append
    ;  compile-only

methods dostring

: to                ( c-addr u name -- )
        postpone literal postpone tostring
    ;

: +to                ( c-addr u name -- )
        postpone literal postpone +tostring
    ;

end-methods

: string            ( u name -- )
        create  dup c, char+ here swap dup allot erase
        dostring
    ;

: []string          ( x a-addr -- c-addr )
        @+ rot * +
    ;

doer: do[]string    ( x a-addr -- c-addr u )
        []string char+ count
    ;

methods do[]string

: to                ( c-addr u x name -- )
        postpone literal postpone []string postpone tostring
    ;

: +to                ( c-addr u x name -- )
        postpone literal postpone []string postpone +tostring
    ;

end-methods

: []strings         ( x1 x2 name -- )
        create  dup 2 chars + , swap 0
                ?do     dup c, here over char+ dup allot erase
                loop
                drop
        do[]string
    ;

#13 constant /size

/size string comparand
/size string temp

#512 constant /dir

/dir /size []strings row

: quick
        2dup + 2/ row to comparand 2dup
        begin   swap
                begin   dup row comparand compare 0<
                while   1+
                repeat
                swap
                begin   dup>r comparand r> row compare 0<
                while   1-
                repeat
                2dup <
                if      2>r r@ row to temp r' row r@ to row temp r' to row 2r>
                then
                2dup > 0=
                if      1- swap 1+ swap
                then
                2dup >
        until
        swap rot 2dup <
        if      recurse
        else    2drop
        then
        2dup <
        if      recurse
        else    2drop
        then ;

: .lower
        out #16 + c/l >
        if      cr
        then
        out
        if      #16 out over mod - spaces
        then
        over c@ bl <
        if      '-'
        else    bl
        then
        emit 1 /string 0
        ?do     count dup 'A' [ 'Z' 1+ ] literal within
                if      bl or
                then
                emit
        loop
        drop
        ;

create str1 1 c, ^_ c,
create str2 1 c, bl c,

: sdir
        bl word c@ 0=
        if      s" *.*" here place
        then
        $10 to find-attribute
        here count find-first-file throw 0 local aantal
        begin   found-file s" ." compare
                if      found-file s" .." compare
                        if      found-attribute $10 =
                                if      str1
                                else    str2
                                then
                                count aantal to row
                                found-file aantal +to row
                                1 +to aantal
                        then
                then
                find-next-file
        until
        cr 0 aantal 1- quick aantal 0
        do      i row .lower
                stop? ?leave
        loop
    ;
