\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : ??????????
\ CATEGORY    : Standard Programs
\ AUTHOR      : Coos Haak
\ LAST CHANGE : November 04, 1994, Coos Haak
\ ----------------------------------------------------------------------



        ?DEF -iterate [IF] -iterate [THEN]


        MARKER -iterate


#8192 constant size     

CREATE flags    size ALLOT

cr .( In assembler [Y,n] ) key dup emit >upc 'N' = [IF]
: DO-PRIME      ( -- n )
                flags size 1 FILL
                0  size 0 DO flags I + 
                             C@ IF I DUP +  3 +  
                                   DUP  I +
                                    BEGIN  DUP size <
                                    WHILE  0 OVER flags + C! 
                                           OVER + 
                                    REPEAT
                                   2DROP 1+  
                             THEN  
                        LOOP ;

[ELSE]
CODE DO-PRIME           ( -- n )
                push    bx
                push    es
                push    cs
                pop     es
                mov     di, # flags
                mov     cx, # SIZE
                mov     al, # 1
                rep     stosb
                mov     cx, # SIZE
                xor     di, di
                xor     dx, dx
        do
                test    flags [di], # 1 byte
        0<> if
                mov     ax, di
                add     ax, ax
                add     ax, # 3
                mov     bx, ax
                add     bx, di
        begin
                cmp     bx, # SIZE
        < while
                mov     flags [bx], # 0 byte
                add     bx, ax
        repeat
                inc     dx
        then
                inc     di
        loop
                mov     bx, dx
                pop     es
                next    end-code
[THEN]

: one
        do-prime drop
    ;

extra definitions

: .ms   ( d -- )
        <# # # # '.' hold #s #> type space
    ;

forth definitions

: run       ( n -- d )
        0
        timer-reset
        do      one
        loop
        gettime timesave 2@ d-
    ;

: go
        cr 0 0 locals| /iter steps |
        10 run 10 um/mod to /iter drop
        10000. /iter um/mod 1 max to steps drop
        steps run 1000 steps m*/ .ms ." ms/iteratie "
        steps . ." stappen "
        .elapsed
    ;



                            \ (* End of Source *) /
