\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : Self fetching and storing variables
\ CATEGORY    : Examples
\ AUTHOR      : Albert Nijhof
\ LAST CHANGE : November 11, 1994, Coos Haak
\ CREATED     : July 27, Albert Nijhof
\ ----------------------------------------------------------------------



        ?DEF -variabele [IF] -variabele [THEN]


        MARKER -variabele


DOC

 Met VARIABELE maak je variabelen waarvan je het adres niet op de stack zet.
VARIABELE verwacht slechts een naam in de inputstroom, maar definieert twee
woorden, een Fetcher en een Stoorder, die hetzelfde adres bewerken. De
Fetcher krijgt @ achter de naam, de Stoorder ! De opgegeven naam komt zelf
niet in het woordenboek.

Vijgeblad 45, 1994, pag. 16.

ENDDOC

VOCABULARY INSIDE                       \ Voor interne woorden, om het Forth-
INSIDE DEFINITIONS                      \ vocabulary overzichtelijk te houden.

CREATE CREATING     $28 ALLOT           \ Kladpapiertje

?DEF -assembler [IF]

DOERCODE DOFETCH
            PUSH    BX
            MOV     BX, AX
            MOV     BX, 4 [BX]
            MOV     BX, 0 [BX]
            NEXT
END-CODE

DOERCODE DOSTORE
            MOV     DI, AX
            MOV     DI, 4 [DI]
            MOV     0 [DI], BX
            POP     BX
            NEXT
END-CODE

[ELSE]

DOER: DOFETCH
        @ @
    ;

DOER: DOSTORE
        @ !
    ;

[THEN]

ALSO FORTH DEFINITIONS

: (VARIABELE        ( addr "name" -- )
        S" CREATE " CREATING PACK       \ Zet de tekst 'CREATE' in CREATING
        BL PARSE-WORD ROT APPEND        \ Plak Name er achteraan.
        [CHAR] @ CREATING APPEND-CHAR   \ Voeg het karakter '@' eraan toe
        CREATING COUNT EVALUATE         \ en evalueer het geheel.
        DUP ,                           \ Verwijs naar het dataveld.
        DOFETCH                         \ Installeer DOER: deel.
        [CHAR] ! CREATING COUNT +
        1 CHARS - C!                    \ Nu met '!'.
        CREATING COUNT EVALUATE
        ,
        DOSTORE
    ;

: VARIABELE         ( "name" -- )
        HERE 0 , (VARIABELE
    ;

PREVIOUS FORTH

\ Voorbeelden
VARIABELE PIP           \ Nu bestaan PIP@ ( -- x ) en PIP! ( x -- )
3 PIP!
PIP@ PIP@ * .           \ Drie maal drie is negen/

\ Ook over bestaande Variables heen:
BASE (VARIABELE BASE    \ Levert BASE@ en BASE! op.


                            \ (* End of Source *) /
