\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Extended memory access 
\ CATEGORY    : MS-DOS 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -screensv
        NEEDS -filling
        NEEDS -extended

        ?DEF -xms [IF] -xms [THEN]

        MARKER -xms


DOC
   Type GO for a test of extended memory.
ENDDOC

decimal

xms-present? invert [if]
cr bright .( No extended memory available!) bright
abort
[then]

-- make a stack

privates

80 constant /stack                      private \ maximum depth
create stack                            private \ the stack itself
        stack /stack cells dup allot erase
variable sp     sp off                  private \ the stack pointer

: >x            ( x -- )                        \ push a value
        sp @ 1+ /stack = abort" User stack full"        \ too much
        sp @ stack []cell !                             \ store value
        sp incr                                         \ postincrement
        ;

: x>            ( -- x )                        \ pop a value
        sp @ 0= abort" User stack empty"                \ nothing more
        sp decr                                         \ predecrement
        sp @ stack []cell @                             \ fetch value
        ;

: x             ( -- x )                        \ have a peek
        sp @ 1- stack []cell @                          \ fetch value
        ;

deprive

: wacht
        ?at ." Press a key to continue." key drop at-xy eol ;

: size
        screensize 1024 /mod swap 0<> - 1024 * ;

: call
        s" see" system ;

statoff

: go
        cr xms-present? invert abort" No extended memory available"
        0 local diepte xms-available abort" No (more) XMS available"
        ." Bytes " 2dup 0 d.r size sm/rem nip ." , blocks "
        dup . xms-handles ." and handles " dup . cr wacht save-screen umin 0
        ?do     size s>d xms-alloc
                if      drop cr ." Depth at break is " diepte . cr key drop
                        leave
                then
                >x 1 +to diepte
                sbase size #paragraphs i '0' + 7 join fillwp
                sbase 0 size s>d x xms-put
                if      x> xms-dealloc abort" Can't return memory" leave
                then
\               100 ms
        loop
        restore-screen call save-screen ?at wacht diepte 0
        ?do     sbase 0 size s>d x xms-get abort" Can't read from XMS"
                x> xms-dealloc abort" Can't free XMS"
\               100 ms
        loop
        restore-screen at-xy call ;


                            \ (* End of Source *) /
