\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Pascal emulated in Forth 
\ CATEGORY    : Examples 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -jensen



DOC
  Pascal user manual and report, Jensen & Wirth, Springer,
  Heidelberg 1978, second edition, page 3.
  Programming with locals and scaled numbers (pseudo floating point).

  You can say INFLATION but not stop it.

ENDDOC


privates

: p.    ( u -- )
        2 .r ;  private

: f.    ( u -- )
        u>d <# # # # # ',' hold # bl hold #> type ;     private

: procent       ( u1 -- u2 )
        100 */ ;        private

: inflation
        10000 10000 10000 0 10 locals| n i w1 w2 w3 |
        begin   cr 1 +to i
                w1 107 procent to w1
                w2 108 procent to w2
                w3 110 procent to w3
                i p. w1 f. w2 f. w3 f.
                i n =
        until ;

deprive

                            \ (* End of Source *) /
