\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Decompiler for CHForth 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        MARKER -decompiler


DOC
   SEE "name"   decompiles a definition.
   addr (SEE)   decompiles Forth code.
   ALL          decompiles all words.
   NO. or YES.  put the decompiler on or off.
ENDDOC

\G Replace the first word list in the search order with the
\G DECOMPILER word list.
VOCABULARY DECOMPILER           ( -- )                  \ DECOMPILER

internal also decompiler definitions also

-- supporting words

privates

: >lwc
        dup 'A' '[' within
        if      bl or
        then ;  private

: (\")
        lseg inline$ countx dup out + 2 + c/l >
        if      nl
        then
        >r countx emit r> 1- 0
        ?do     countx >lwc emit
        loop
        2drop ; private

: \"
        postpone (\") l", ;     immediate

: \head
        (.head) dup out + 1+ c/l >              \ does it fit on the line
        if      nl                              \ no, new line
        then
        type space                              \ type name
        wordspeed @ ms                          \ wait for some time
        ;  private

: ..head
        >head \head ;

: ?cr
        out 8 + c/l >
        if      nl
        then
    ;  private

$70 cells 2* constant maxtab    private

create table            private here maxtab cell+ dup allot erase

: (tab!)
        table dup @ maxtab = abort" Decompiler table full"
        1 cells over +! dup @ + ! ;     private

: tab!
        (tab!) (tab!) ;

: >tab
        out 8 + c/l >
        if      nl
        else    8 out over mod - spaces
        then
    ;  private

: tab@
        table @+ bounds
        do      i @ of  i cell+ @ true unloop exit      then
                2 cells
        +loop
        false
        ;

: .name
        ?cr dup ['] docreate here within
        if      >head dup
                if      dup head>flags h@ =immediate and
                        if      \" POSTPONE "
                        then
                then
                \head exit
        then
        \" <unknown> " drop
        ;

-- defining words

: l@+
        dup cell+ swap l@ ;

: -colon
        begin   dup l@ [ ' ; >body @ cell+ l@ ] literal <>
        while   ?cr dup l@ tab@
                if      execute
                else    .name cell+
                then
        repeat
        drop ;  private

: colon
        -colon nl ." ;  " ;

: >parm
        dup >head .head space #24 dup indent ! htab >body ;

: .flags
        dup =ansi and
        if      \"  ANS "
        then
        dup =comp and
        if      \"  COMPILE-ONLY "
        then
        dup =hidden and
        if      \"  HIDDEN "
        then
        dup =immediate and
        if      \"  IMMEDIATE "
        then
        dup =local and
        if      \"  LOCAL "
        then
        dup =private and
        if      \"  PRIVATE "
        then
        drop
        ;  private
        
:noname
        dup >head head>flags h@ >r
        ." : " dup ..head >body @ cr indent @ htab colon r> .flags
        ;
        dup >call tab! \ colondefs

:noname
        ." VARIABLE " >parm dup .hex @ .hex ;
        find-methods dovar 2 cells + tab!

:noname
        ." 2VARIABLE " >parm dup .hex 2@ ud. ;
        find-methods do2var 2 cells + tab!

:noname
        ." CREATE " >parm dup .hex @ .hex ;
        find-methods docreate 2 cells + tab!

:noname
        ." CONSTANT " >parm @ dup .hex push base decimal 6 .r pop base ;
        find-methods docon 2 cells + tab!

:noname
        ." VALUE " >parm dup .hex @ .hex ;
        find-methods doval 2 cells + tab!

:noname
        ." 2CONSTANT " >parm dup .hex 2@ ud. ;
        find-methods do2con 2 cells + tab!

:noname
        ." MARKER " >parm body> .hex ;
        find-methods domarker 2 cells + tab!

:noname
        ." VECTOR " >parm @
        dup >call tab@
        if      #8 indent ! nl execute exit
        then
        drop dup .hex ..head ;
        find-methods dovector 2 cells + tab!

?def intvec [if]

:noname
        ." INTVEC " >parm count dup b. get-interrupt x. 2@ x. ;
        find-methods dointvec 2 cells + tab!

[then]

:noname
        ." VOCABULARY " >head .head
        ;  dup
        find-methods dovoc 2 cells + tab!
        ' only >call tab!

:noname
        ." SEGMENT " >parm @+ .hex @+ .hex @ .hex ;
        find-methods doseg 2 cells + tab!

:noname
        ." DOS: " >parm '"' emit count type '"' emit ;
        find-methods dos: 2 cells + tab!

:noname
        ." PREFIX " >head .head ;
        find-methods prefix 2 cells + tab!

-- compiled words

: c.str
        locals| len str |
        cell+ l@+ count dup out + len + 4 + c/l >
        if      nl
        then
        str len type '"' emit space stype '"' emit space
        ;  private

: l.str
        locals| len str |
        cell+ lseg over countx dup out + len + 4 + c/l >
        if      nl
        then
        str len type '"' emit space stypex '"' emit space
        dup lc@ 1+ aligned +
        ;  private

:noname
        s" C" c.str ;
        ' (c") tab!

:noname
        s" S" c.str ;
        ' (s") tab!

:noname
        s" ." l.str ;
        ' (.") tab!

:noname
        s" \" l.str ;
        ' (\") tab!

:noname
        s" ABORT" c.str ;
        ' (abort") tab!

: free.hex
        push base
        dup #-9 #10 within
        if      decimal .
        else    hex '$' emit u>d <# #s #> type space
        then
        pop base
        ;

:noname
        cell+ l@+ free.hex ;
        ' (lit) tab!

:noname
        cell+ l@+ \" ['] " ..head ;
        ' (tic) tab!

:noname
        cell+ l@+ dup bl <
        if      '^' emit $40 or emit
        else    ''' emit emit ''' emit
        then
        space ;
        ' (chr) tab!

:noname
        l@+ .name nl ;
        dup ' ?leave tab!
        dup ' leave  tab!
\       dup ' ?error tab!
\       dup ' throw  tab!
        drop

: xx does> ;    private

:noname
        nl cell+ dup l@ cell+ cell+ >call
        [ ' xx >body 3 cells + >call ] literal =
        if      \" DOES> " >tab cell+ exit
        then
        \" ;CODE " l@ cell+ cell+ .hex -r -r ;
        ' modify tab!

:noname
        ." DOES>" >tab >body @ colon ;
        ' xx >body 3 cells + >call tab!

:noname
        nl l@+ .name >tab ;
        ' create tab!

:noname
        \" POSTPONE " cell+ l@+ ..head ;
        ' (postpone) tab!

: >tl
        >tab ind++ ;    private

:noname
        nl \" IF " cell+ cell+ >tl ;
        ' (if) tab!

:noname
        <nl \" ELSE " cell+ cell+ >tl ;
        ' (else) tab!

:noname
        <nl \" THEN " cell+ nl ;
        ' (then) tab!

:noname
        nl \" AHEAD " cell+ cell+ >tl ;
        ' (ahead) tab!

:noname
        nl \" BEGIN " cell+ >tl ;
        ' (begin) tab!

:noname
        <nl \" AGAIN " cell+ cell+ nl ;
        ' (again) tab!

:noname
        <nl \" UNTIL " cell+ cell+ nl ;
        ' (until) tab!

:noname
        <nl \" WHILE " cell+ cell+ >tl ;
        ' (while) tab!

:noname
        <nl \" REPEAT " cell+ cell+ nl ;
        ' (repeat) tab!

:noname
        nl \" CASE " cell+ ind++ nl ;
        ' (case) tab!

:noname
        <nl \" ENDCASE " cell+ nl ;
        ' (endcase) tab!

:noname
        \" OF " cell+ cell+ ind++ >tab ;
        ' (of) tab!

:noname
        >tab \" ENDOF " cell+ cell+ ind-- nl ;
        ' (endof) tab!

:noname
        nl \" DO " cell+ cell+ >tl ;
        ' (do) tab!

:noname
        nl \" ?DO " cell+ cell+ >tl ;
        ' (?do) tab!

:noname
        <nl \" LOOP " cell+ nl ;
        ' (loop) tab!

:noname
        <nl \" +LOOP " cell+ nl ;
        ' (+loop) tab!

:noname
        \" FROM " cell+ l@+ body> ..head ;
        ' (val) tab!

:noname
        \" TO " cell+ l@+ body> ..head ;
        ' (to) tab!

:noname
        \" +TO " cell+ l@+ body> ..head ;
        ' (+to) tab!

:noname
        \" CLEAR " cell+ l@+ body> ..head ;
        ' (clear) tab!

:noname
        \" ADR " cell+ l@+ body> ..head ;
        ' (adr) tab!

:noname
        \" GET " cell+ l@+ body> ..head ;
        ' (get) tab!

:noname
        \" PUSH " cell+ l@+ body> ..head ;
        ' (push) tab!

:noname
        \" POP " cell+ l@+ body> ..head ;
        ' (pop) tab!

:noname
        \" IS " cell+ l@+ body> ..head ;
        ' (is) tab!

:noname
        cell+ l@+ \" LOCAL " 2/ . ;
        ' (loc) tab!

:noname
        cell+ l@+ \" TO LOCAL " 2/ . ;
        ' (toloc) tab!

:noname
        cell+ l@+ \" +TO LOCAL " 2/ . ;
        ' (+toloc) tab!

:noname
        cell+ l@+ \" CLEAR LOCAL " 2/ . ;
        ' (clearloc) tab!

: see-forget
        chain doforget
        table dup dup @ + cell-
        do      i @ _dp @ u< ?leave
                -2 cells dup table +!
        +loop
        ;  private
        ' see-forget is doforget

: ((see))
        dup c@ dup $E9 = swap $E8 = or
        if      dup >call tab@
                if      execute exit
                then
                drop
        then
        ." CODE " >head dup .head head>flags h@ .flags
        ;  private

-- end of subroutines

forth definitions

\G Decompile the definition that has xt as its execution token.
: (SEE)         ( xt -- )                       \ DECOMPILER
        8 indent ! cr ((see)) ;

\G Skip leading space delimiters. Parse name delimited by a space.
\G Find name. If name can not be found exception -13 occurs.
\G If name is high level, decompile it. Otherwise if the
\G disassembler is loaded, disassemble it.
: SEE           ( "name" -- )                   \ DECOMPILER
        ' (see) ;
        ans

deprive

privates

variable decomp?                private
variable teller                 private

: begin-serie
        decomp? @ 0=
        if      cr
        then
        teller off
        ;  private

: totaal
        cr ." Total " teller @ .dec cr
        ;  private

: ?see
        teller incr decomp? @
        if      (see)
        else    ..head
        then
        wordspeed @ #10 * ms
        ;  private

forth definitions

\G Skip leading space delimiters. Parse name delimited by a space.
\G Find name. If name can not be found exception -13 occurs.
\G Otherwise decompile all the words in the current word list
\G starting with the last compiled until name is decompiled.
\G See also: STOP?
: TILL          ( "name" -- )                   \ DECOMPILER
        begin-serie ' >head >r get-context voc@ temporary !
        begin   another
        while   dup head> ?see r@ u> invert
        until
        then
        r>drop totaal
        ;

\G Skip leading space delimiters. Parse name1 delimited by a space.
\G Skip leading space delimiters. Parse name2 delimited by a space.
\G Find name1. Find name2. If any name can not be found exception
\G -13 occurs. Otherwise decompile all the words in the current
\G word list between name1 inclusive and name2 inclusive starting
\G with the last compiled. The order of name1 and name2 is
\G indifferent.
\G See also: STOP?
: BTW           ( "name1" "name2" -- )          \ DECOMPILER
        ' >head local van ' >head local tot 0 local aux
        van tot = abort" words have to be different"
        van tot 2dup umax to van umin to tot begin-serie
        get-context voc@ temporary !
        begin   another
        while   dup head> to aux van =
        until
        then
        begin   aux ?see another
        while   dup head> to aux tot u<
        until
        then
        totaal
        ;

\G Decompile all words in the context word list.
\G See also: STOP?
: ALL           ( -- )                          \ DECOMPILER
        begin-serie get-context voc@ temporary !
        begin   another
        while   head> ?see
        repeat
        totaal
        ;

\G Set the decompiler to normal.
\G See also: NO.
: YES.          ( -- )                          \ DECOMPILER
        decomp? on
        ;  yes.

\G The decompiler shows only the names of the definitions.
\G See also: YES.
: NO.           ( -- )                          \ DECOMPILER
        decomp? off
        ;

deprive

-2 set-order definitions
                            \ (* End of Source *) /
