\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Standard library for turnkey programs 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -stdlib



vector .help
vector proc

variable argc
variable file-1
variable file-2

privates

8 constant maxargs      private
#32 constant argsize    private
variable ^args  private

: malloc
        here dup rot dup allot erase
        ;  private

: initarrays
        argc off
        argsize malloc file-1 !
        argsize malloc file-2 !
        argsize maxargs * malloc ^args !
        ;  private

: argv
        argsize * ^args @ +
        ;

: option
        >upc local optie argc @
        if      argc @ 0
                do      i argv 1+ c@ >upc optie =
                        if      i true unloop exit
                        then
                loop
                false
        else    false
        then
        ;

: dget#
        argv count 1 /string 2dup upper number? 2 <> #-13 ?error
        ;

: get#
        argv count 1 /string 2dup upper number? 1 <> #-13 ?error
        ;

: getargs
        maxargs 0
        do      bl word c@ 0=
                if      leave
                then
                here 1+ c@ dup '-' = swap '/' = or
                if      here char+ char+ c@ '?' =
                        if      .help bye
                        then
                        here count 1 /string argc @ argv place argc incr
                else    here count file-1 @ @
                        if      file-2
                        else    file-1
                        then
                        @ place
                then
        loop
        ;  private

: main
        initarrays $80 count set-source getargs proc
        ;

deprive
                            \ (* End of Source *) /
