\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Animals 
\ CATEGORY    : Games 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



: get$
        refill invert abort" Foutje"
        ^M parse-word rot min dup 0<>
        ;

: filled
        >r here dup rot dup allot r> fill
        ;

#50 constant lens
#40 constant aantal

: set-string
        @ swap lens * + swap lens 1- min swap place
        ;

: get-string
        @ swap lens * + count
        ;

: strings
        create
        does>   get-string type
        ;

methods strings

: to
        postpone literal postpone set-string
        ;

: get
        postpone literal postpone get-string
        ;

end-methods

prefix get

: []getal
        @ []double
        ;

: getallen
        create
        does>   []getal 2@
        ;

methods getallen

: to
        postpone literal postpone []getal postpone 2!
        ;

end-methods

strings rij     here 0 , constant ^rij
getallen wijzer here 0 , constant ^wijzer

variable volgende
variable vraag

create vraag$   here lens dup allot erase

: j/n
        ." [J,n] " key >upc 'N' =
        if      ." nee" false
        else    ." ja" true
        then
        ;

: go
        begin   1 vraag !
                begin   vraag @ wijzer drop
                while   vraag @ wijzer cr vraag @ rij ."  ? " j/n
                        if      drop
                        else    nip
                        then
                        vraag !
                repeat
                cr ." Denk je aan een " vraag @ rij ."  ? " j/n
                if      cr ." Dat dacht ik al."
                else    volgende @ 2 + aantal < invert
                        if
cr ." Ik weet dat je nu aan een heel bijzonder huisdier denkt,"
                                cr ." maar ik heb er mijn buik van vol."
                        else    vraag @ get rij volgende @ to rij
                                cr ." Waar denk je aan ? "
                                begin   lens get$
                                until
                                volgende @ 1+ to rij
cr ." Stel een vraag die onderscheid maakt tussen een "
                                volgende @ rij ."  en een "
                                volgende @ 1+ rij '.' emit cr
                                begin   lens get$
                                until
                                over dup c@ >upc swap c!
                                vraag @ to rij volgende @ 1+ volgende @
                                cr ." Wat is het antwoord voor een "
                                volgende @ 1+ rij ."  ? " j/n invert
                                if      swap
                                then
                                vraag @ to wijzer 2 volgende +!
                        then
                then
                cr ." Nog een keer ? " j/n invert
        until
        ;

: titel
        c/l over 2 lshift - 2/ spaces 0
        do      count >upc emit 3 spaces
        loop
        drop
        ;

: main
        aantal lens * bl filled ^rij !
        aantal 2 lshift 0 filled ^wijzer !
        s" Heeft hij vier poten" 1 to rij
        2 3 1 to wijzer
        s" paard" 2 to rij
        s" spin" 3 to rij
        4 volgende !
        cr s" huisdieren" titel cr cr
        go
        ;

\ Reserve space in CSEG but do not allocate it yet in the executable program
aantal lens * aantal 2 lshift + reserve

turnkey main animals
                            \ (* End of Source *) /
