/* foo.c */

/* sample program */

/*
  Copyright (C) 1999-2000 Jim Hall <jhall1@isd.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include "db.h"

int
main (void)
{
  db_t *ptr;

  db_init (10);

  /* store some values */

  db_insert ("1", "one");
  db_insert ("2", "two");
  db_insert ("3", "three");
  db_insert ("4", "four");
  db_insert ("5", "five");
  db_insert ("10", "ten");
  db_insert ("11", "eleven");
  db_insert ("*", "star");

  /* retrieve some values */

  ptr = db_fetch ("1");
  printf ("1: %s -> %s\n", ptr->key, ptr->value);

  ptr = db_fetch ("11");
  printf ("11: %s -> %s\n", ptr->key, ptr->value);

  ptr = db_fetch ("5");
  printf ("5: %s -> %s\n", ptr->key, ptr->value);

  ptr = db_fetch ("*");
  printf ("*: %s -> %s\n", ptr->key, ptr->value);

  /* done */

  db_free();

  exit (0);
}
