/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*
    SAVEMEM - Wrappers of malloc() and assoc. functions
    Copyright (C) 1998  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
*/
/* $RCSfile: SAVEMEM.H $
   $Locker: ska $	$Name:  $	$State: Exp $

	Wrapper of malloc() and associated functions.
	All functions issue an error message on failure and terminate the
	program.

   ----

   Available functions:

	void *getmem(int len)
		Wrapper of malloc().

	void *cgetmem(int len)
		Wrapper of malloc(). Zeros the malloc()'ed memory area.

	void *chgmem(void *p, int size)
		Wrapper of realloc().

	char *dupstr(char *str)
		Wrapper of strdup().

	char *newvar(char *var, char *str)
		'var' must be an object an address can be taken from.
		Replace the dynamic memory area 'var[]' with the string str,
		that means 'var' must be initialzied with ither NULL or
		a pointer returned by malloc() or assoc. function.
		If str == NULL ==> var := NULL.

	char *strdupe(char *start, char *end)
		Wrapper of strdup() that duplicates the string between "start"
		and "end" or the first '\0' within that range.
		The location at *end is modified during the run of this function.

	char *addStr(char *str, char *s)
	char *addStr_(char **str, char *s)
		Appends "s" to the dynamically allocated string "*str".
		"str" and/or "s" may be NULL, in which case "" is assumed.
		The newly allocated memory area is returned and placed into
		*str as well.
		addStr() is a wrapper of addStr_() that creates the address of
		the first parameter.

   ----

   Target compilers:
   		Micro-C v3.14, Borland C++ v3.1+

   ----
	
	Known bugs:

   ----
	
*/

#ifndef __SAVEMEM__H_
#define __SAVEMEM__H_

extern void *getmem(int len);
extern void *cgetmem(int len);
extern void *chgmem(void *p, int size);
extern char *dupstr(char *str);
#define newstr(var,str) newstr_(&(var),(str))
extern char *newstr_(char **var, char *str);
extern char *strdupe(char *start, char *end);
#define addStr(a,b) addStr_(&(a),(b))
extern char *addStr_(char **str, char *s);

#ifdef TEST
extern void free__(void*);
#define free free__
#endif /*#	defined(TEST) */

#endif /*#	!defined(__SAVEMEM__H_) */ 
