/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: CNTRY.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	DOS NLS implementation

	All DOS-65-XX functions are activated and the results are copied
	into the Country structure.

	MsgCountry() will always return a pointer to the static structure.

*/

#ifdef _MICROC_
#include <intr.h>
#else /*#	!(defined(_MICROC_)) */
#include <dos.h>
#include <string.h>
#endif /*#	defined(_MICROC_) */

#include "cntry.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CNTRY.C 1.3 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

static Country cntry = {0};		/* make sure the structure is zeroed out */


#ifdef _MICROC_
#define savePtr(field)	savePtr_(&cntry.field/**/Len		\
							, &cntry.field/**/Tbl		\
							, &buf[1])
static void savePtr_(int *len, word *tbl, word *ptr)
{	word segm, ofs;

	ofs = *ptr;
	segm = ptr[1];

	if((*len = peekw(segm, ofs)) <= 0x80)
		ofs -= 0x80;
	ofs += 2;

	*tbl = ofs;
	tbl[1] = segm;
}
#else /*#	!(defined(_MICROC_)) */
#define savePtr(field)	savePtr_(&cntry.field##Len		\
							, &cntry.field##Tbl		\
							, (byte far* *)&buf[1])
static void savePtr_(int *len, char far * *tbl, byte far * *ptr)
{	byte far *p;

	p = *ptr;
	if((*len = *(word far*)p) <= 0x80)
		p -= 0x80;
	p += 2;
	*tbl = (char far*)p;
}
#endif /*#	defined(_MICROC_) */



Country *msgCountry(void)
{	return cntry.initialized? aS(cntry): msgNewCountry();
}

Country *msgNewCountry(void)
{	unsigned char buf[50];
#ifdef _MICROC_
	struct REGPACK r;

	r.r_es = get_ds();
	r.r_di = &buf[0];
	r.r_bx = r.r_dx = 0xffff;
#define DOS(val) r.r_ax = 0x6500 | (val);	\
	r.r_cx = sizeof(buf);					\
	intr(0x21, r);							\
	if(!errnr)
#define errnr ((r.r_flags & 1)? r.r_ax : 0)
#else /*#	!(defined(_MICROC_)) */
	union REGS r;
	struct SREGS sr;

	sr.es = FP_SEG(&buf[0]);
	r.x.di = FP_OFF(&buf[0]);
	
	r.x.bx = r.x.dx = 0xffff;
	r.h.ah = 0x65;
#define DOS(val) r.x.ax = 0x6500 | (val);	\
	r.x.cx = sizeof(buf);					\
	intdosx(&r, &r, &sr);					\
	if(!errnr)
#define errnr (r.x.cflag? r.x.ax: 0)
#endif /*#	defined(_MICROC_) */

#define getbyte(idx)	buf[(idx)]
#define getword(idx)	(*(word*)&buf[(idx)])
#define cpybyte(field,idx)	(cntry.field = getbyte(idx))
#define cpyword(field,idx)	(cntry.field = getword(idx))
#define cpymem(field,idx)	memcpy(cntry.field, &buf[(idx)]		\
			, sizeof(cntry.field) - 1)

	memset(aS(cntry), 0, sizeof(cntry));

	DOS(1)	{	/* Extended country inmformation */
		cpyword(country, 3);
		cpyword(charset, 5);
		cpyword(datefmt, 7);
		cpymem(curSymbol, 9);
		cpymem(thousendsSep, 14);
		cpymem(decimalSep, 16);
		cpymem(dateSep, 18);
		cpymem(timeSep, 20);
		cpybyte(curFormat, 22);
		cpybyte(precision, 23);
		cpybyte(timefmt, 24);
		cpymem(listSep, 29);
	}

	DOS(2)		/* uppercase table for normal characters */
		savePtr(uppercase);

	DOS(3)		/* lowercase table for normal characters */
		savePtr(lowercase);

	DOS(4)		/* uppercase table for filename characters */
		savePtr(fupcase);

	DOS(6)		/* lowercase table for normal characters */
		savePtr(collate);

	DOS(5) {	/* filename character table */
#ifdef _MICROC_
		cpymem(illegalChars, 11);
		*(word*)&cntry.illegalChars += 10;
		copy_seg(get_ds(), buf, *(word*)&buf[3], *(word*)&buf[1], 10);
#else /*#	!(defined(_MICROC_)) */
		cntry.illegalChars = *(char far * *)&buf[1] + 10;
		_fmemcpy(buf, *(byte far* *)&buf[1], 10);
#endif /*#	defined(_MICROC_) */

		cpybyte(inclFirst, 3);
		cpybyte(inclLast, 4);
		cpybyte(exclFirst, 6);
		cpybyte(exclLast, 7);
		cntry.illegalLen= getbyte(9); 
	}

	cntry.initialized = 1;

	return aS(cntry);
}

#ifdef TEST
main(void)
{	msgCountry();
	return 0;
}
#endif /*#	defined(TEST) */
