/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MSG2CAT.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	int msgCatalogue(char *fnam)

	Append the catalogue 'fnam' at the end of the catalogue chain.
	(Last items superceed previous items). And insert any found
	language definitions that matches better or equal than the currently
	found languages into the global catalogue structure (msg_glbCat).

	This function should be called, if the user wants to use a catalogue
	that is shipped as an external and free-standing file itself.

	The file must be a binary catalogue in the compiler's native format.

	The catalogue is searched the following order to gain the knowledge
	about if the file is a catalogue at all:
	1) probe the end of the file for MsgStru0,
	2) probe the beginning of the file for any valid magic number.
	
	If step 1) succeeds, anything between the beginning of MsgStru0
	and the position MsgStru0 contains is considered to be part of
	of the catalogue. If step 2) succeeds and the first item is a
	MsgStru0, everything between the position contained in MsgStru0 up to
	the end of the file is considered to form the catalogue. If step 2)
	succeeds, but the first entry is not a MsgStru0, the whole file is
	treated as a catalogue.

	With this information, msgDatabase() is called (see there for more
	details).

	Return:	same as msgDatabase()
 
*/

#include <assert.h>
#include <portable.h>
#include <string.h>
#include "msg2.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MSG2CAT.C 1.2 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

int msgCatalogue(const char * const fnam)
{	dword pos, limit;	/* start & end of item chain within catalogue */
	MSGFILE fd;
	int rv;

	assert(fnam);

	if((fd = msgIdentCat(fnam, aS(pos), aS(limit))) != MSGNOFILE) {
		/* valid catalogue file */
		rv = msgDatabase(fd, pos, limit);	/* join catalogue */
#ifndef MSG_SINGLE_CATALOGUE_FILE
		/* we got the filename supplied --> preserve this instaed of handle */
		assert(msg_catalogues.last);
		if((msg_catalogues.last->fnam = strdup(fnam)) != NULL) {
			msg2CloseCat(msg_catalogues.last->fd);
			msg_catalogues.last->fd = MSGNOFILE;
		}
#endif /*#	!defined(MSG_SINGLE_CATALOGUE_FILE) */
		return rv;
	}

	return 0;
}
