/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MSG2CHG.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	void msgLanguage(msgTLngcode lng)
	void msgCharset(msgTCharset set)

	Change the basic of the NLS environment of the message library
	either the language to speak or the character set to use.

	Any change of the NLS environment will cause a re-read of all
	catalogue files to ensure the changes take effect.

*/

#include "msg2.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MSG2CHG.C 1.2 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

void msgLanguage(msgTLngcode lng)
{	msg_CurLngcode = lng;
	msgRereadCats();
}

void msgCharset(msgTCharset cset)
{	msg_CurCharset = cset;
	msgRereadCats();
}
