/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MSG2DB.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	int msgDatabase(MSGFILE f, dword iM(*)start, dword iM(*)limit);

	Same as msgCatalogue(), but the start and end of the catalogue is
	known and the file has been opened.

	This function should be called, if the user wants to use a catalogue
	that is physically embedded into another file. However, that file
	itself must not be compressed or something like that.

	The function steps the chain of lamguage definitions within the
	catalogue until it reaches the position 'limit', an invalid
	position of the next item (to be more specific: a zero 'next'
	pointer), a MsgStru0 magic number, an invalid magic number,
	or if a read error occures during reading the control area of
	the language definitions.

	No message text is retrieved so far, nor is the text area scanned
	for read errors. So a success return value does not indicate that
	the message strings are physically available, only that the
	logical access paths are available.

	Return value:
 		 > 0: successful scan of the whole catalogue, number of scanned
				language definitions.
		 < 0: an error occured during read/invalid magic number or such;
				abs(rv) == number of successfully scanned language definitions
		== 0: no successful scan of one language definition; that may
				indicate an empty or completely broken catalogue.

	The file can be closed upon return of this function, because msgDatabase()
	duplicates its own copy of the file descriptor and takes care to close
	it if applicable.
 
*/

#include <stdio.h>
#ifndef _MICROC_
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#endif
#include <portable.h>
#include "msg2.h"
#include "msglib.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MSG2DB.C 1.3 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

int msgDatabase(MSGFILE fd, dword iM(*)start, dword iM(*)limit)
{
#ifndef MSG_SINGLE_CATALOGUE_FILE
	/* Append this catalogue into the chain of catalogues */
	MsgCatFile *act;

	if((act = malloc(sizeof(MsgCatFile))) == NULL)
		return 0;		/* error */

	if(msg_catalogues.head)
		msg_catalogues.last->nxt = act;
	else msg_catalogues.head = act;

	msg_catalogues.last = act;

	act->nxt = NULL;
	act->fd = fd;
	act->fnam = NULL;
	longcpy(act->pos, start);
	longcpy(act->limit, limit);
#endif /*#	!defined(MSG_SINGLE_CATALOGUE_FILE) */

#ifdef MSG_MULTIPLE_CATALOGUES
	/* This is the main function to import data into the global
		catalogue --> the best place to allocate the buffer, if
		it is needed only. */
	if(!msg_glbCat && (msg_glbCat = msg_mkCatBuf()) == NULL) {
		/* Cannot create global catalogue --> error */
		putc('\n', stderr);
		fputs(Y_errMR, stderr);
		fputs(Y_noMem, stderr);
		exit(MSG_errNrMR);
	}
#endif

	return msg2ScanLngDefs(PAS_GCAT fd, start, limit);
}
