/*
    MSGLIB - a message handling library
    Copyright (C) 1995,1997-98  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MSG2RTRV.C $
   $Locker: ska $	$Name:  $	$State: Rel $

	char *msg2Retrieve(MSGID2 id)
	char *msg2Rtrv_([msgCat *catalogue,] MSGID2 id)

	Purge the previously fetched message, than fetch message with the id
	from the catalogue.
	If failed, generate a default message.

	Return:
		always != NULL; a pointer to a valid NUL-terminated string

*/

#include <assert.h>

#include "msg2.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MSG2RTRV.C 1.2 1998/10/07 04:42:53 ska Rel ska $";
#endif /*#	defined(RCS_Version) */

char *msg2Rtrv_(DCL_GCAT MSGID2 id)
{	
	MsgStr *msg;


	IF_GCAT {
		msg2Free(PAS_GCAT GCAT lastRetrieve, NULL);
		if((msg = msg2Get(PAS_GCAT id)) != NULL) {
			GCAT lastRetrieve = id;
			return msg->text;
		}
	}

	/* Lock the default message */
	msg = msg2MsgLock(id);
	assert(msg);

	GCAT lastRetrieve = 0;		/* make sure the msg2Get() failed! */

	/* Return the 'text' member */
	return msg->text;
}

char *msg2Retrieve(MSGID2 id)
{	return msg2Rtrv_(PAS_GCAT id);
}
