#!/bin/sh

#set -x

export LD_LIBRARY_PATH='c:/djelf/elf;.'

rm -f *.a *.o *.exe *.so* *.mtb
make.exe -f makefile.djelf rexx.exe client.o rexxsaa.o drexx.o

rm -f nosaa.o rexx.o msgcmp.o execiser.o rexx.exe msgcmp.exe execiser.exe

gcc -B/dev/env/DJDIR/elf -s -o libregina.so -shared -fPIC -DPIC -DDYNAMIC -Wl,--version-script=regina_elf.def *.o

echo -DREGINA_VERSION_DATE=\""31 Dec 2009"\" -DREGINA_VERSION_MAJOR=\"3\" > regina_data.rsp
echo -DREGINA_VERSION_MINOR=\"5\" -DREGINA_VERSION_SUPP=\"\" >> regina_data.rsp
gcc -B/dev/env/DJDIR/elf -c -Os -fPIC -DDYNAMIC -fno-strict-aliasing -funsigned-char @regina_data.rsp test1.c
gcc -B/dev/env/DJDIR/elf -shared -o librxtest1.so test1.o libregina.so
gcc -B/dev/env/DJDIR/elf -c -Os -fPIC -DDYNAMIC -fno-strict-aliasing -funsigned-char @regina_data.rsp test2.c
gcc -B/dev/env/DJDIR/elf -shared -o librxtest2.so test2.o libregina.so

gcc -B/dev/env/DJDIR/elf -o regina.exe regina.c libregina.so -lm -DPIC -fPIC -DDOS

ls -l *.so* *.exe

echo =========================
./regina.exe dynfunc.rexx
echo =========================

rm -f test*.o regina_data.rsp
