\CUSTOMIZ.XPL	16-SEP-2001	VERSION 1.6 (see PAGE1)
\ColorDIR Customizer
\Copyright (C) 1993-2001 Loren Blaney
\
\This program is free software; you can redistribute it and/or modify it under
\ the terms of the GNU General Public License version 2 as published by the
\ Free Software Foundation.
\This program is distributed in the hope that it will be useful, but WITHOUT
\ ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
\ FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
\ details.
\You should have received a copy of the GNU General Public License along with
\ this program (in the file LICENSE.DOC); if not, write to the Free Software
\ Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\
\You can reach me at:			Mail:	Loren Blaney
\ Email: loren_blaney@idcomm.com		502 Pine Glade Dr.
\						Nederland, CO 80466, USA
\
\This program was compiled with the version 2.4 XPL0 compiler (XPLX, 16-bit).
\ I can send you a copy of this compiler if you can't find it.
\
\
\REVISIONS:
\V1.0, Skipped so that customizer program has same version as DI.
\V1.1, MAY-03-93, Released.
\V1.2, MAY-27-93, Change example to show efficiency (%) etc. Fix cursor shape
\ for EGA mode.
\V1.4, FEB-14-98, Free version.
\V1.5, APR-20-99, Convert underlines in extension names into spaces.
\V1.6, 16-SEP-2001, Change version number to be consistent with DI.EXE.


inc	C:\CXPL\CODESI;

def	TV=6, KB=0, BUF=8;
def	INTSIZE= 2;	\Number of bytes in an integer
def	NUL=$00, BEL=$07, BS=$08, TAB=$09, LF=$0A, FF=$0C,	\Control chars
	CR=$0D, EOF=$1A, ESC=$1B, SP=$20, \DEL=$7F\;
def	NO=^N, YES=^Y;
def	UP=-$48, DN=-$50, LT=-$4B, RT=-$4D, PGUP=-$49, PGDN=-$51,
	DEL=-$53, END=-$4F, HOME=-$47, F1=-$3B, F2=-$3C;	\Scan codes
def	AX, BX, CX, DX, DI, SI, BP, CF, CS, DS, SS, ES;		\GETREG registers
def	BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN, WHITE,
	GRAY, LBLUE, LGREEN, LCYAN, LRED, LMAGENTA, YELLOW, LWHITE;

def	PROMPTLINE= 1;	\Line for prompt and error messages

char	PARAM;		\Parameters
def \PARAM\ ATEXT, ALABEL, ALINE, ADIR, ADEFAULT,
	ASIZE, AATB, ADATE, ATIME, AHIDEN,
	LOWERCASE, DECRSIZE, DECRTIME, TJOINT, SHOWHIDEN,
	ALRED, ALGRN, ABKGND;
def	PARAMSIZE=18;	\Number of parameters (must agree with DI)
def	ENTRIES=84;	\Number of color extentions in table (must agree w/ DI)

def	EXTWIDTH=6, EXTHEIGHT=14, EXTSIZE=EXTWIDTH*EXTHEIGHT;

int	MONOCHROME,	\Flag: Monochrome monitor used
	KEY,		\Last keystroke from KEYIN
	EXT,		\Array: (EXTSIZE,4) extension names
	II,
	PAGE,		\Screen page
	OLDCURSOR,	\Initial cursor shape (top and bottom scan lines)
	CONTRAST;	\Array: contrasting color

char	FILENAME,	\Name of ColorDIR program (default = DI.EXE)
	OT;		\Order table, defines order of bytes for SORT

\Variables for DOS file I/O:
int	CPUREG,		\Pointer to system info
	PSPSEG,		\Address of PSP segment (for file I/O)
	DATASEG,	\Address of data segment (heap & stack)
	INHANDLE,	\Input file handle (= -1 if no input file)
	OUTHANDLE;	\Output file handle (= -1 if no output file)
addr	INFILENAME,	\Input file name (all file names are zero terminated)
	OUTFILENAME,	\Output file name
	TMPFILENAME,	\Temporary output file name (.$$$)
	BAKFILENAME;	\Backup output file name (.BAK)
def	NAMESIZE=80;	\Maximum number of chars in a file name (incl path)

\----------------------------------------------------------------------

func	TOUPPER(CH);		\Convert character to uppercase
int	CH;
return if CH>=^a & CH<=^z then CH&$DF else CH;



func	TOLOWER(CH);		\Convert character to lowercase
int	CH;
return if CH>=^A & CH<=^Z then CH!$20 else CH;



proc	SHIFTTEXT(STR);		\Shift a string to lowercase and output it
char	STR;
int	I;
begin
loop	begin
	for I:= 0, 32766 do
		if STR(I) = $A0 then quit
		else CHOUT(6, if PARAM(LOWERCASE)=^Y then TOLOWER(STR(I))
						      else STR(I));
	quit;			\For safety
	end;
end;	\SHIFTTEXT



func	SHIFTKEY;		\Returns 'true' if a shift key is down
int	REG;
begin
REG:= CPUREG;
REG(AX):= $0200;
SOFTINT($16);
return (REG(AX)&$03) # 0;
end;	\SHIFTKEY



func	GETCURSOR;		\Get cursor shape
int	REG;
begin
REG:= GETREG;
REG(AX):= $0300;
SOFTINT($10);
return REG(CX);
end;	\GETCURSOR



proc	SETCURSOR(SHAPE);	\Set cursor shape
int	SHAPE;
int	REG;
begin
REG:= GETREG;
REG(AX):= $0100;
REG(CX):= SHAPE;
SOFTINT($10);
end;	\SETCURSOR


proc	SHOWCURSOR(ON);		\Turn flashing cursor off and on
int	ON;			\Flag: True = cursor on; False = cursor off
SETCURSOR(if ON then (if MONOCHROME then $000D else $0007) else $2000);



func	GETVID;			\Returns the current video mode
int	REG;			\Pointer to array of processor registers
begin
REG:= GETREG;
REG(AX):= $0F00;		\Function $0F
SOFTINT($10);			\Call BIOS routine
return REG(AX) & $FF;
end;	\GETVID

\----------------------------------------------------------------------

proc	HEX1OUT(DEV, VAL);	\Output a hex digit
int	DEV, VAL;
char	HEXDIGIT;
begin
HEXDIGIT:= "0123456789ABCDEF ";
CHOUT(DEV, HEXDIGIT(VAL & $0F));
end;	\HEX1OUT



func	ITOAHEX(D);		\Convert integer to ASCII hex character
int	D;
char	HEXTBL;
begin
if D<0 ! D>$F then return -1;
HEXTBL:= "0123456789ABCDEF ";
return HEXTBL(D);
end;	\ITOAHEX



func	AHEXTOI(C);		\Convert ASCII hex character to integer
int	C;
begin
if C>=^0 & C<=^9 then return C -^0;
if C>=^A & C<=^F then return C -^A +10;
return -1;		\ERROR("HEX DIGIT EXPECTED. ");
end;	\AHEXTOI



proc	BOX(X, Y, W, H);	\Draw a rectangle using box characters
int	X, Y, W, H;		\ with upper-left corner at X, Y
int	I;			\The minimum width (W) & height (H) is 2
begin
CURSOR(X, Y);	CHOUT(6, ^);		\Draw top line with brackets
for I:= 1, W-2 do CHOUT(6, ^);
CHOUT(6, ^);
for I:= 1, H-2 do			\Draw sides
	[CURSOR(X, Y+I);   CHOUT(6, ^);
	CURSOR(X+W-1, Y+I);   CHOUT(6, ^)];
CURSOR(X, Y+H-1);   CHOUT(6, ^);	\Draw bottom line with brackets
for I:= 1, W-2 do CHOUT(6, ^);
CHOUT(6, ^);
end;	\BOX



proc	DELAY(T);	\Delay approximately T 18ths of a second
int	T;
SOUND(0, T, 1000);



proc	SPOUT(DEV, N);	\Output N spaces to specified device
int	DEV, N;
int	I;
begin
for I:= 1, N do
	CHOUT(DEV, SP);
end;	\SPOUT



proc	CTXT(X, Y, STR);	\Display a string at coordinates X,Y
int	X, Y;
char	STR;
begin
CURSOR(X, Y);
RAWTEXT(6, STR);
end;	\CTXT



proc	INVERT(X, Y, LEN);	\Invert video on LEN many characters at X,Y
int	X, Y, LEN;
begin
HILIGHT(X, Y, X+LEN-1, Y, $70);
end;	\INVERT



proc	NORMAL(X, Y, LEN);	\Re-invert video on LEN many characters at X,Y
int	X, Y, LEN;
begin
HILIGHT(X, Y, X+LEN-1, Y, $07);
end;	\NORMAL



func	STRCMP(A, B, SIZE);	\Compare string A to string B
\This returns:
\	-1 if A < B
\	 0 if A = B
\	+1 if A > B
\This provides a general string compare, for example:
\ if CMPSTR(A, B, SIZE) >= 0 then...	(if A >= B then...)
\Also inputs OT, Order Table, which defines the order bytes are compared
addr	A, B;		\Strings to be compared
int	SIZE;		\Number of bytes in A and B
int	I;
begin
for I:= 0, SIZE-1 do
	if A(OT(I)) # B(OT(I)) then
		return if A(OT(I)) > B(OT(I)) then 1 else -1;
return 0;			\They're equal
end;	\STRCMP



proc	SORT(A, N, S, REV);	\Sort array of strings using Shell method
int	A,			\Address of array
	N,			\Number of elements (strings) in array
	S,			\Size of element (string) in bytes
	REV;			\Reverse order
int	J, GAP, I, JG, T;
begin
GAP:= N /2;
while GAP > 0 do
	begin
	for I:= GAP, N-1 do
		begin
		J:= I -GAP;
		loop	begin
			if J < 0 then quit;
			JG:= J +GAP;
			if REV
			    then [if STRCMP(A(J), A(JG), S) >= 0 then quit]
			    else [if STRCMP(A(J), A(JG), S) <= 0 then quit];
			T:= A(J);   A(J):= A(JG);   A(JG):= T;
			J:= J -GAP;
			end;
		end;
		GAP:= GAP /2;
	end;
end;	\SORT

\==================== OPERATOR INTERFACE ROUTINES =====================

proc	HILITE(FLAG);	\Turn full brightness on or off according to flag
int	FLAG;
begin
ATTRIB(if FLAG then $0F else $07);
end;	\HILITE



func	GETKEY;			\Get character from keyboard
int	REG, CH;		\This is a low-level routine with no echo,
begin				\ and no Ctrl-C
REG:= GETREG;
REG(AX):= 0;			\Function $00
SOFTINT($16);			\Call BIOS routine
CH:= REG(AX) & $FF;
if CH = 0 then CH:= -(REG(AX)>>8);
if CH = $03\CTRL-C\ then CH:= ESC;
return CH;
end;	\GETKEY



func	KEYIN;			\Input a keystroke and don't echo it
int	I;
begin
SHOWCURSOR(true);		\Turn on flashing cursor
repeat until CHKKEY;
SHOWCURSOR(false);		\Turn off flashing cursor
KEY:= GETKEY;
return KEY;
end;	\KEYIN



proc	CLRLINE(N);		\Erase line N within the window
int	N;
int	I;
begin
CURSOR(0, N);
SPOUT(TV, 79);			\Beware of bottom line scroll
CURSOR(0, N);
end;	\CLRLINE



proc	PROMPT(MSG);	\Display a message on the prompt (bottom) line
char	MSG;
int	I, C;
begin
if MSG(0) # $A0 then
	begin
	CLRLINE(PROMPTLINE);
	CTXT(0, PROMPTLINE, MSG);
	end;
end;	\PROMPT



proc	ERRMSG(STR);	\Display an error message (and buzz)
char	STR;
int	I;
begin
PROMPT(STR);
INVERT(0, PROMPTLINE, 79);
for I:= 1, 73 do
	begin
	DELAY(1);
	if CHKKEY then I:= 100;
	end;
NORMAL(0, PROMPTLINE, 79);
end;	\ERRMSG



proc	SHOWYN(FIELD, X, Y);	\Show yes/no switch at position X,Y
char	FIELD;
int	X, Y, C;
begin
C:= FIELD(0);				\Get boolean
HILITE(true);
CTXT(X, Y, if C=^Y then "YES " else "NO  ");
HILITE(false);
end;	\SHOWYN



proc	YESNO(FIELD, X, Y, HINT);
\Get a yes/no switch from the operator and display it at X,Y
char	FIELD;
int	X, Y;
char	HINT;
int	CH;
begin
PROMPT(HINT);
loop	begin
	HILITE(true);
	SHOWYN(FIELD, X, Y);
	CURSOR(X, Y);
	HILITE(false);
	CH:= TOUPPER(KEYIN);
	case CH of CR, ESC, DN, UP, LT, RT, HOME, END, PGUP, PGDN: quit other;
	if CH = SP then
		begin
		if FIELD(0) # YES then FIELD(0):= YES
		else if FIELD(0) # NO then FIELD(0):= NO;
		quit;
		end;
	if CH=YES ! CH=NO then [FIELD(0):= CH;   quit]
	else [ERRMSG("PLEASE PRESS Y, N, SPACEBAR OR Enter  ");   PROMPT(HINT)];
	end;
if HINT(0) # $A0 then CLRLINE(PROMPTLINE);	\Erase the prompt message
end;	\YESNO



proc	BLANKFLD(FIELD, SIZE);  \Blank a field by filling it with underlines
char	FIELD;
int	SIZE;
int	I;
begin
for I:= 0, SIZE-1 do FIELD(I):= ^_;
end;	\BLANKFLD



func	DEC(D);
int	D;
begin
D:= AHEXTOI(D);
if D < 0 then D:= 8;
D:= D -1;
if D < 0 then D:= $F;
return ITOAHEX(D);
end;	\DEC



func	INC(D);
int	D;
begin
D:= AHEXTOI(D);
if D < 0 then D:= 6;
D:= D +1;
if D > $F then D:= 0;
return ITOAHEX(D);
end;	\INC



proc	GETFLD0(FIELD, N, X, Y, HINT);
\Input a field (string) of chars. Numbers are entered calculator style;
\ text is entered from left to right.
char	FIELD;	\Address of field
int	N,	\Number of characters in field
	X, Y;	\Field position on screen
char	HINT;	\Prompt message
int	CH,
	M,	\Maximum index of FIELD
	I, J,
	NUMERIC,
	FIRSTTIME;
begin
M:= N -1;
\Fill field with underlines. Unused spaces in the field are converted to
\ underlines, which are converged from both ends.
I:= 0;   while FIELD(I)=SP & I<=M do [FIELD(I):= ^_;   I:= I +1];
I:= M;   while FIELD(I)=SP & I>=0 do [FIELD(I):= ^_;   I:= I -1];

PROMPT(HINT);
FIRSTTIME:= true;
J:= 0;				\Our position in the field
loop	begin
	CURSOR(X, Y);		\Display what we have
	I:= AHEXTOI(FIELD(0));
	ATTRIB(if I>0 & N=1 then I else LWHITE);
	for I:= 0, M do CHOUT(6, FIELD(I));

	CURSOR(X+J, Y);		\Place cursor
	CH:= TOUPPER(KEYIN);
	NUMERIC:= KEY>=^0 & KEY<=^9;
	case KEY of ^-, ^+, ^:, ^., ^E, ^e, SP, ^,, ^_, ^/: NUMERIC:= true
	other;

	case CH of
	   LT:	if J > 0 then [J:= J -1;   FIRSTTIME:= false];
	   RT:	if J < M then [J:= J +1;   FIRSTTIME:= false];
	   FF:	[for I:= 0, M do FIELD(I):= ^_;	\Clear the entire field
		J:= 0];				\Our position in the field
	   DEL:	begin
		for I:= J, M-1 do		\Shift field left
			FIELD(I):= FIELD(I+1);
		FIELD(M):= ^_;
		FIRSTTIME:= false;
		end;
	   BS:	begin
		if J > 0 then
			[J:= J -1;
			for I:= J, M-1 do	\Shift field left
				FIELD(I):= FIELD(I+1);
			FIELD(M):= ^_];
		FIRSTTIME:= false;
		end;
	   HOME: J:= 0;
	   END:  J:= M;
	   CR, ESC, PGDN:	quit
	other	begin
		if CH >= $20 then		\Ignore control chars
			begin
			if FIRSTTIME then BLANKFLD(FIELD, N)
			else	begin
				for I:= -M+1, -J do \Shift right
					FIELD(-I+1):= FIELD(-I);
				end;
			FIELD(J):= CH;
			if J < M then J:= J +1;	\Move cursor right
			FIRSTTIME:= false;
			end;
		end;
	end;

J:= 0;			\Put spaces back in place of underlines
while J<=M & FIELD(J)=^_ do [FIELD(J):= SP;	J:= J +1];
J:= M;
while J>=0 & FIELD(J)=^_ do [FIELD(J):= SP;	J:= J -1];

CURSOR(X, Y);		\Re-display field without underlines
for I:= 0, M do CHOUT(6, FIELD(I));
ATTRIB(WHITE);
if HINT(0) # $A0 then CLRLINE(PROMPTLINE);	\Erase the prompt message
end;	\GETFLD0



proc	GETFLD(FIELD, N, X, Y, HINT);
\Input a field (string) of chars. Numbers are entered calculator style;
\ text is entered from left to right.
char	FIELD;	\Address of field
int	N,	\Number of characters in field
	X, Y;	\Field position on screen
char	HINT;	\Prompt message
int	CH,
	M,	\Maximum index of FIELD
	I, J,
	NUMERIC,
	FIRSTTIME;
begin
M:= N -1;
\Fill field with underlines. Unused spaces in the field are converted to
\ underlines, which are converged from both ends.
I:= 0;   while FIELD(I)=SP & I<=M do [FIELD(I):= ^_;   I:= I +1];
I:= M;   while FIELD(I)=SP & I>=0 do [FIELD(I):= ^_;   I:= I -1];

PROMPT(HINT);
FIRSTTIME:= true;
J:= 0;				\Our position in the field
loop	begin
	CURSOR(X, Y);		\Display what we have
	I:= AHEXTOI(FIELD(0));
	ATTRIB(if I>0 & N=1 then I else LWHITE);
	for I:= 0, M do CHOUT(6, FIELD(I));

	CURSOR(X+J, Y);		\Place cursor
	CH:= TOUPPER(KEYIN);
	NUMERIC:= KEY>=^0 & KEY<=^9;
	case KEY of ^-, ^+, ^:, ^., ^E, ^e, SP, ^,, ^_, ^/: NUMERIC:= true
	other;

	case CH of
	   LT:	if J > 0 then [J:= J -1;   FIRSTTIME:= false] else quit;
	   RT:	if J < M then [J:= J +1;   FIRSTTIME:= false] else quit;
	   FF:	[for I:= 0, M do FIELD(I):= ^_;	\Clear the entire field
		J:= 0];				\Our position in the field
	   DEL:	begin
		for I:= J, M-1 do		\Shift field left
			FIELD(I):= FIELD(I+1);
		FIELD(M):= ^_;
		FIRSTTIME:= false;
		end;
	   BS:	begin
		if J > 0 then
			[J:= J -1;
			for I:= J, M-1 do	\Shift field left
				FIELD(I):= FIELD(I+1);
			FIELD(M):= ^_];
		FIRSTTIME:= false;
		end;
	   CR, ESC, DN, UP, HOME, END, PGUP, PGDN:	quit
	other	if J=M & CH=SP then
			FIELD(J):= if SHIFTKEY then DEC(FIELD(J))
					       else INC(FIELD(J))
		else
		begin
		if CH >= $20 then		\Ignore control chars
			begin
			if FIRSTTIME then BLANKFLD(FIELD, N)
			else	begin
				for I:= -M+1, -J do \Shift right
					FIELD(-I+1):= FIELD(-I);
				end;
			FIELD(J):= CH;
			if J < M then J:= J +1;	\Move cursor right
			FIRSTTIME:= false;
			end;
		end;
	if N = 1 then quit;
	end;

J:= 0;			\Put spaces back in place of underlines
while J<=M & FIELD(J)=^_ do [FIELD(J):= SP;	J:= J +1];
J:= M;
while J>=0 & FIELD(J)=^_ do [FIELD(J):= SP;	J:= J -1];

CURSOR(X, Y);		\Re-display field without underlines
for I:= 0, M do CHOUT(6, FIELD(I));
ATTRIB(WHITE);
if HINT(0) # $A0 then CLRLINE(PROMPTLINE);	\Erase the prompt message
end;	\GETFLD



proc	GETEXTFLD(FIELD, X, Y);
\Input a field (string) of chars. Numbers are entered calculator style;
\ text is entered from left to right.
char	FIELD;	\Address of field
int	X, Y;	\Field position on screen
int	CH,
	M,	\Maximum index of FIELD
	I, J,
	FIRSTTIME;
begin
M:= 4 -1;
\Fill field with underlines. Unused spaces in the field are converted to
\ underlines, which are converged from both ends.
I:= 0;   while FIELD(I)=SP & I<=M do [FIELD(I):= ^_;   I:= I +1];
I:= M;   while FIELD(I)=SP & I>=0 do [FIELD(I):= ^_;   I:= I -1];

FIRSTTIME:= true;
J:= 0;						\Our position in the field
loop	begin
	CURSOR(X, Y);				\Display what we have
	I:= AHEXTOI(FIELD(3));
	if I < 0 then I:= CONTRAST(AHEXTOI(PARAM(ABKGND)));
	ATTRIB(AHEXTOI(PARAM(ABKGND))<<4 + I);

	for I:= 0, 2 do
		CHOUT(6, if PARAM(LOWERCASE)=^Y then TOLOWER(FIELD(I))
						 else FIELD(I));
	I:= AHEXTOI(FIELD(3));
	if I <= 0 then I:= CONTRAST(AHEXTOI(PARAM(ABKGND)));
	ATTRIB(AHEXTOI(PARAM(ABKGND))<<4 + I);
	CHOUT(6, SP);
	CHOUT(6, FIELD(3));
	CURSOR(X+(if J=3 then J+1 else J),  Y);  \Place cursor

	CH:= TOUPPER(KEYIN);

	case CH of
	   LT:	if J > 0 then [J:= J -1;   FIRSTTIME:= false] else quit;
	   RT:	if J < M then [J:= J +1;   FIRSTTIME:= false] else quit;
	   FF:	[BLANKFLD(FIELD, 4);   J:= 0];	\Our position in the field
	   DEL:	begin
		for I:= J, M-1 do		\Shift field left
			FIELD(I):= FIELD(I+1);
		FIELD(M):= ^_;
		FIRSTTIME:= false;
		end;
	   BS:	begin
		if J > 0 then
			[J:= J -1;
			for I:= J, M-1 do	\Shift field left
				FIELD(I):= FIELD(I+1);
			FIELD(M):= ^_];
		FIRSTTIME:= false;
		end;
	   CR, ESC, DN, UP, HOME, END, PGUP, PGDN, F1, F2:	quit
	other	if J=M & CH=SP then
			FIELD(J):= if SHIFTKEY then DEC(FIELD(J))
					       else INC(FIELD(J))
		else
		begin
		if CH >= $20 then		\Ignore control chars
			begin
			if FIRSTTIME then BLANKFLD(FIELD, 4);
			if CH = SP then CH:= ^_;

			if J=M & (CH<^0 ! CH>^9) & (CH<^A ! CH>^F) & CH#^_ then
				begin
				ATTRIB(WHITE);
				ERRMSG(
"PLEASE SELECT 0 THRU 9 OR A THRU F OR USE SPACEBAR. ");
				CH:= ^_;
				PROMPT(
"F1 = Sort by extension.  F2 = Sort by color.  Page Down (PgDn) = continue. ");
				end;

			FIELD(J):= CH;
			if J < M then J:= J +1;	\Move cursor right
			FIRSTTIME:= false;
			end;
		end;
	end;
end;	\GETEXTFLD



proc	SHOWFLD(FIELD, N, X, Y);	\Show a field (string)
char	FIELD;	\Address of field
int	N,	\Number of characters in FILED
	X, Y;	\Screen position
int	I;
begin
CURSOR(X, Y);
I:= AHEXTOI(FIELD(0));
ATTRIB(if I>0 & N=1 then I else LWHITE);
for I:= 0, N-1 do CHOUT(6, FIELD(I));
end;	\SHOWFLD



func	VALCHK(FIELD, N, MIN, MAX, MSG);	\Validity check
\Displays error message and returns 'FALSE' if number exceeds limits
char	FIELD;	\Address of field
int	N,	\Size of field
	MIN, MAX; \Limits
char	MSG;	\Error message
int	I;
begin
I:= AHEXTOI(FIELD(0));
if I>=MIN & I<=MAX then return true;
ERRMSG(MSG);
for I:= 0, N-1 do FIELD(I):= ^_;
return false;
end;	\VALCHK

\========================== DOS I/O ROUTINES ==========================

func	READFILEINFO;		\Read PARAMs from DI.EXE.
\Returns false if marker is not found.
int	C, I, J;
char	STR;
begin

\Scan up to marker
STR:= "XYZZY ";
J:= 0;
TRAP(false);
repeat	C:= CHIN(3);		\Copy and shift to lowercase
	CHOUT(3, C);
	if C = STR(J) then J:= J +1 else J:= 0;
	if GETERR then return false;
until	J = 5;
TRAP(true);
C:= CHIN(3);			\Skip string terminator
CHOUT(3, C);

\Get info
for I:= 0, PARAMSIZE-1 do
	begin
	C:= CHIN(3);
	PARAM(I):= C;
	end;
C:= CHIN(3);			\Skip string terminator
for J:= 0, 3 do
	begin
	for I:= 0, ENTRIES-1 do
		begin
		STR:= EXT(I);
		C:= CHIN(3);
		if C = SP then C:= ^_;		\Version 1.5 change
		STR(J):= C;
		end;
	C:= CHIN(3);		\Skip string terminator
	end;
return true;
end;	\READFILEINFO

\----------------------------------------------------------------------

proc	WRITEFILEINFO;	\Write EXT table and copy the rest of the file
int	C, I, J;
char	STR;
begin
for I:= 0, PARAMSIZE-1 do
	begin
	C:= PARAM(I);
	CHOUT(3, C);
	end;
CHOUT(3, $A0);			\String terminator
for J:= 0, 3 do
	begin
	for I:= 0, ENTRIES-1 do
		begin
		STR:= EXT(I);
		C:= STR(J);
		if C = ^_ then C:= SP;		\Version 1.5 change
		CHOUT(3, C);
		end;
	CHOUT(3, $A0);		\String terminator
	end;

\Copy the rest of the file
TRAP(false);
loop	begin
	C:= CHIN(3);
	if C = EOF then
		begin
		C:= CHIN(3);
		if GETERR then quit
		else CHOUT(3, EOF);
		end;
	CHOUT(3, C);
	end;
TRAP(true);
end;	\WRITEFILEINFO

\----------------------------------------------------------------------

func	DOSOPEN;	\Open MS-DOS files, returns 'false' if error


	proc	COPYNAME(FROM, TO, EXT);
	\Copy file name and replace any existing extension with EXT.
	\If EXT = "@@@" then use extension from FROM.
	addr	FROM, TO,	\Strings are 0 terminated
		EXT;		\Extension
	int	I, J, CH;
	begin
	I:= 0;
	loop	begin
		CH:= FROM(I);
		if CH=^. ! CH=0 ! CH=SP then quit;	\KLUDGE FOR NOW ****
		TO(I):= CH;
		if I < NAMESIZE-1 then I:= I +1;
		end;
	TO(I):= ^.;
	if I < NAMESIZE-1 then I:= I +1;
	for J:= 0, 2 do
		begin
		CH:= EXT(J) & $7F;
		TO(I):= if CH=^@ then FROM(I) else CH;
		if I < NAMESIZE-1 then I:= I +1;
		end;
	TO(I):= 0;
	end;	\COPYNAME


begin	\DOSOPEN
\The existing output file is renamed with a .BAK extension

COPYNAME(FILENAME, INFILENAME, "EXE");
COPYNAME(FILENAME, OUTFILENAME, "EXE");
COPYNAME(FILENAME, TMPFILENAME, "$$$");
COPYNAME(FILENAME, BAKFILENAME, "BAK");

CURSOR(0, 21);	\In case of "ABORT, RETRY, FAIL" message

TRAP(false);
INHANDLE:= FOPEN(INFILENAME, 0);
if GETERR then return false;
FSET(INHANDLE, ^I);
if GETERR then return false;

OUTHANDLE:= FOPEN(TMPFILENAME, 1);
if GETERR then return false;
FSET(OUTHANDLE, ^O);
if GETERR then return false;
TRAP(true);

OPENI(3);   OPENO(3);
return true;
end;	\DOSOPEN

\----------------------------------------------------------------------

proc	DOSCLOSE;	\Close MS-DOS files
begin
FCLOSE(INHANDLE);

CLOSE(3);
FCLOSE(OUTHANDLE);

CPUREG(\AX\0):= $4100;		\DEL OUTFILENAME.BAK
CPUREG(\DS\9):= DATASEG;
CPUREG(\DX\3):= BAKFILENAME;
SOFTINT($21);			\(.BAK file might not exist)

CPUREG(\AX\0):= $5600;		\REN OUTFILENAME.EXT OUTFILENAME.BAK
CPUREG(\DS\9):= DATASEG;
CPUREG(\DX\3):= OUTFILENAME;
CPUREG(\ES\11):= DATASEG;
CPUREG(\DI\4):= BAKFILENAME;
SOFTINT($21);

CPUREG(\AX\0):= $5600;		\REN OUTFILENAME.$$$ OUTFILENAME.EXT
CPUREG(\DS\9):= DATASEG;
CPUREG(\DX\3):= TMPFILENAME;
CPUREG(\ES\11):= DATASEG;
CPUREG(\DI\4):= OUTFILENAME;
SOFTINT($21);
end;	\DOSCLOSE

\----------------------------------------------------------------------

proc	DOSABORT;		\Discard MS-DOS I/O files
begin
FCLOSE(INHANDLE);		\For safety
CLOSE(3);			\Discard partial output file otherwise
FCLOSE(OUTHANDLE);		\ there will be lost allocation units

CPUREG(\AX\0):= $4100;		\DEL TMPFILENAME.$$$
CPUREG(\DS\9):= DATASEG;
CPUREG(\DX\3):= TMPFILENAME;
SOFTINT($21);
end;	\DOSABORT

\######################################################################

proc	PAGE4;
char	FLD;
begin
FLD:= RESERVE(1);
FLD(0):= ^Y;

CHOUT(0, FF);
RAWTEXT(0, 
"Type: ^"Y Enter^" to save changes and exit, or ^"N Enter^" to discard changes.








			   Ŀ
			                          
			      Save changes:       
			                          
			   
 ");

ATTRIB(WHITE);
loop	begin
	YESNO(FLD, 45, 11, "Press ^"Page Up^" (PgUp) to go back. ");
	case KEY of
	  CR:	begin
		if FLD(0) = ^Y then
			[WRITEFILEINFO;   DOSCLOSE]
		else	DOSABORT;
		SETCURSOR(OLDCURSOR);
		CHOUT(0, FF);
		exit;
		end;
	  PGUP, PGDN:	quit
	other;
	end;
end;	\PAGE4

\######################################################################

proc	GETEXT;		\Enter extensions and their colors.
int	ENT,
	I,
	X, Y,		\Logical column and line
	SX, SY;		\Screen coordinates: column and line
char	STR;
def	X0=4, Y0=4;
begin
\ATTRIB(AHEXTOI(PARAM(ABKGND))<<4 + AHEXTOI(PARAM(ALINE)));
ATTRIB(WHITE);
BOX(X0-2, Y0-1, EXTWIDTH*13-4, EXTHEIGHT+2);
\HILIGHT(X0-3, Y0-1, X0-2+EXTWIDTH*13-4, Y0-1+EXTHEIGHT+1,
\	AHEXTOI(PARAM(ABKGND))<<4 + AHEXTOI(PARAM(ALINE)));

for X:= 0, EXTWIDTH-1 do
    for Y:= 0, EXTHEIGHT-1 do
	begin
	ENT:= X*EXTHEIGHT + Y;
	SX:= X0 + 13*X;
	SY:= Y0 + Y;

	STR:= EXT(ENT);
	I:= AHEXTOI(STR(3));
	if I < 0 then I:= CONTRAST(AHEXTOI(PARAM(ABKGND)));
	ATTRIB(AHEXTOI(PARAM(ABKGND))<<4 + I);

	CURSOR(SX, SY);
	for I:= 0, 2 do
		CHOUT(6, if PARAM(LOWERCASE)=^Y then TOLOWER(STR(I))
						 else STR(I));

	I:= AHEXTOI(STR(3));
	if I <= 0 then I:= CONTRAST(AHEXTOI(PARAM(ABKGND)));
	ATTRIB(AHEXTOI(PARAM(ABKGND))<<4 + I);
	CHOUT(6, SP);
	CHOUT(6, STR(3));
	end;

X:= 0;   Y:= 0;
loop	begin
	ENT:= X * EXTHEIGHT + Y;
	SX:= X0 + 13*X;
	SY:= Y0 + Y;

	GETEXTFLD(EXT(ENT), SX, SY);

	case KEY of
	  F1:	begin			\Sort by extension (then color)
		for I:= 0, 3 do OT(I):= I;
		SORT(EXT, EXTSIZE, 4, false);
		quit;
		end;

	  F2:	begin			\Sort by color (then extension)
		OT(0):= 3;
		for I:= 1, 3 do OT(I):= I-1;
		SORT(EXT, EXTSIZE, 4, false);	\Sort bright colors first
		quit;
		end;

	  ESC, PGUP, PGDN: quit;

	  CR:	begin
		Y:= Y +1;
		if Y >= EXTHEIGHT then
			[Y:= 0;
			X:= X +1;
			if X >= EXTWIDTH then X:= 0];
		end;

	  DN:	Y:= Y +1;
	  UP:	Y:= Y -1;
	  RT:	X:= X +1;
	  LT:	X:= X -1;
	  HOME:	[Y:= 0;   X:= 0];
	  END:	[Y:= EXTHEIGHT-1;   X:= EXTWIDTH-1]
	other;

	if X >= EXTWIDTH then X:= 0;
	if X < 0 then X:= EXTWIDTH-1;
	if Y >= EXTHEIGHT then Y:= 0;
	if Y < 0 then Y:= EXTHEIGHT-1;
	end;
end;	\GETEXT

\----------------------------------------------------------------------

proc	COLORTXT;		\Display color selection table
\FILENAME EXT 0       FILENAME EXT 4       FILENAME EXT 8       FILENAME EXT C
\FILENAME EXT 1       FILENAME EXT 5       FILENAME EXT 9       FILENAME EXT D
\FILENAME EXT 2       FILENAME EXT 6       FILENAME EXT A       FILENAME EXT E
\FILENAME EXT 3       FILENAME EXT 7       FILENAME EXT B       FILENAME EXT F
int	I, C;
begin
CURSOR(0, 19);
for I:= 0, 78 do CHOUT(0, ^);
CURSOR(1, 20);
C:= 0;
for I:= 0, $F do
	begin
	ATTRIB(AHEXTOI(PARAM(ABKGND))<<4 + C);
	SHIFTTEXT("FILENAME EXT  ");
	if I = 0 then ATTRIB(AHEXTOI(PARAM(ABKGND))<<4 + 7);
	HEX1OUT(6, C);
	if C >= $C then [CRLF(0);   SPOUT(0, 1);   C:= C -$C +1]
	else [SPOUT(6, 7);   C:= C +4];
	end;
end;	\COLORTXT

\----------------------------------------------------------------------

proc	PAGE3;
begin
CHOUT(0, FF);
RAWTEXT(0, 
"Enter extensions and their colors (0-9 or A-F).  Use arrow keys to select.
F1 = Sort by extension.  F2 = Sort by color.  Page Down (PgDn) = continue.

 ");

COLORTXT;

loop	begin
	GETEXT;
	if KEY#F1 & KEY#F2 then quit;
	end;
end;	\PAGE3

\######################################################################

proc	SHOWEXAMP;		\Show example of directory
int	TBL, I;
def	Y0=19;			\Starting line
\
\ E X A M P L E 
\
\C:/PATH/*.*                                                        VOL LABEL
\
\DIRECTRY      <dir>     03-15-93 10:58pCONFIG   SYS    114  a  03-14-93 12:31a
\AUTOEXEC BAT    128  a  03-26-93  5:43pMSDOS    SYS  37394 s rh04-09-91  5:00a
\
\ 4 files        12,345 bytes        678,900 free       85%       03-27-93 12:01a

begin
CURSOR(0, Y0-2);   RAWTEXT(0,
" E X A M P L E  ");

	\ATB,   X,  Y, "STR"
TBL:=[	ATEXT,  0, Y0+0, "C:\PATH\*.*              ",
	ALABEL,56, Y0+0, "           VOL LABEL    ",

	ADIR,   0, Y0+2, "DIRECTRY      <dir>      ",
	ADATE, 24, Y0+2, "03-15-93  ",
	ATIME, 33, Y0+2, "10:58p ",
	ALINE, 39, Y0+2, " ",
	ADEFAULT,40, Y0+2, "CONFIG   SYS   ",
	ASIZE, 54, Y0+2, "  114  ",
	AATB,  60, Y0+2, " a   ",
	ADATE, 64, Y0+2, "03-14-93  ",
	ATIME, 73, Y0+2, "12:31a ",

	ALRED,  0, Y0+3, "AUTOEXEC BAT     ",
	ASIZE, 16, Y0+3, "128  ",
	AATB,  20, Y0+3, " a   ",
	ADATE, 24, Y0+3, "03-26-93   ",
	ATIME, 34, Y0+3, "5:43p ",
	ALINE, 39, Y0+3, " ",

	AHIDEN,40, Y0+3, "MSDOS    SYS   ",
	ASIZE, 54, Y0+3, "37394  ",
	AATB,  60, Y0+3, "s rh ",
	ADATE, 64, Y0+3, "04-09-91   ",
	ATIME, 74, Y0+3, "5:00a ",

	ASIZE,  0, Y0+5, " 4  ",
	ATEXT,  3, Y0+5, "files         ",
	ASIZE, 16, Y0+5, "85,367  ",
	ATEXT, 23, Y0+5, "bytes         ",
	ASIZE, 36, Y0+5, "123,456,789  ",
	ATEXT, 48, Y0+5, "free    ",
	ASIZE, 56, Y0+5, "85 ",
	ATEXT, 58, Y0+5, "% ",
	ADATE, 64, Y0+5, "03-27-93  ",
	ATIME, 73, Y0+5, "12:01a ",
	-1];

I:= 0;
loop	begin
	if TBL(I) < 0 then quit;
	ATTRIB(AHEXTOI(PARAM(ABKGND))<<4 + AHEXTOI(PARAM(TBL(I))));
	CURSOR(TBL(I+1), TBL(I+2));
	SHIFTTEXT(TBL(I+3));
	I:= I +4;
	end;

if PARAM(SHOWHIDEN) # ^Y then	\Blank out hidden file if they are not shown
	CTXT(40, Y0+3, "                                        ");

\Draw horizontal lines
ATTRIB(AHEXTOI(PARAM(ABKGND))<<4 + AHEXTOI(PARAM(ALINE)));
CURSOR(0, Y0+1);
for I:= 0, 38 do CHOUT(6, ^);
CHOUT(6, if PARAM(TJOINT)=^Y then ^ else ^);
for I:= 0, 38 do CHOUT(6, ^);

CURSOR(0, Y0+4);
for I:= 0, 38 do CHOUT(6, ^);
CHOUT(6, if PARAM(TJOINT)=^Y then ^ else ^);
for I:= 0, 38 do CHOUT(6, ^);

ATTRIB(WHITE);
end;	\SHOWEXAMP

\----------------------------------------------------------------------

proc	PAGE2;
int	ENT,
	I,
	X, Y,	\Logical column and line
	SX, SY,	\Screen coordinates: column and line
	HINTS,
	COLS,
	;
def	Y0=7;	\Starting line
begin
PARAM(ALRED):= ^C;   PARAM(ALGRN):= ^A;	\This turns off monochrome mode in DI

CHOUT(0, FF);
RAWTEXT(0, 
"Enter colors and options.  Use arrow keys to select, ^"Page Down^" to continue.





     C O L O R S  O P T I O N S Ŀ
     Text (path):         Sizes (128):           Lowercase names:       
     Volume label:        Attributes:            Decreasing size:       
     Border lines:        Dates (03-26):         Decreasing time:       
     Directories:         Times (5:43p):         Draw T joints:         
     Default exts:        Hidden files:          Show hidden files:     
    
 ");

\Display colored numbers
CURSOR(10, Y0+6);
for I:= 0, $F do
	begin
	ATTRIB(AHEXTOI(PARAM(ABKGND))<<4 + I);
	HEX1OUT(6, I);
	CHOUT(6, SP);
	end;

HINTS:=["Select color for the text used for path name and legends. (0-9 or A-F). ",
	"Select color for the volume label (0-9 or A-F). ",
	"Select color for the border lines (0-9 or A-F). ",
	"Select color for directory names (0-9 or A-F). ",
	"Select default color for unspecified extensions (0-9 or A-F). ",
	"Select color for the file sizes (number of bytes) (0-9 or A-F). ",
	"Select color for the file attributes (s, a, r, & h) (0-9 or A-F). ",
	"Select color for the dates (0-9 or A-F). ",
	"Select color for the times (0-9 or A-F). ",
	"Select color for the hidden (h) and system (s) files (0-9 or A-F). ",

	"Display file names in lowercase (rather than UPPERCASE) (Y/N)? ",
	"Sort file sizes in decreasing order (rather than increasing order) (Y/N)? ",
	"Sort date and time in decreasing order (rather than increasing order) (Y/N)? ",
	"Draw connecting T joints in border lines (Y/N)? ",
	"Display hidden (h) and system (s) files (rather than hide them) (Y/N)? "
	];

SHOWEXAMP;

COLS:= [20, 42, 70];		\Columns for info
for X:= 0, 2 do
    for Y:= 0, 4 do
	begin
	ENT:= X*5 + Y;
	SX:= COLS(X);
	SY:= Y0 + Y;
	if ENT < 10 then
		SHOWFLD(PARAM+ENT, 1, SX, SY)
	else	SHOWYN(PARAM+ENT, SX, SY);
	end;

X:= 0;   Y:= 0;
ATTRIB(WHITE);
loop	begin
	ENT:= X*5 + Y;
	SX:= COLS(X);
	SY:= Y0 + Y;
	if ENT < 10 then
		repeat	GETFLD(PARAM+ENT, 1, SX, SY, HINTS(ENT));
		until	VALCHK(PARAM+ENT, 1, $0, $F,
			"PLEASE SELECT 0 THRU 9 OR A THRU F OR USE SPACEBAR. ")
	else	YESNO(PARAM+ENT, SX, SY, HINTS(ENT));

	SHOWEXAMP;

	case KEY of
	  ESC, PGUP, PGDN: quit;

	  CR:	begin
		Y:= Y +1;
		if Y >= 5 then
			[Y:= 0;
			X:= X +1;
			if X >= 3 then X:= 0];
		end;

	  DN:	Y:= Y +1;
	  UP:	Y:= Y -1;
	  RT:	X:= X +1;
	  LT:	X:= X -1;
	  HOME:	[Y:= 0;   X:= 0];
	  END:	[Y:= 5-1;   X:= 3-1]
	other;

	if X >= 3 then X:= 0;
	if X < 0 then X:= 3-1;
	if Y >= 5 then Y:= 0;
	if Y < 0 then Y:= 5-1;
	end;
end;	\PAGE2

\######################################################################

proc	PAGE1;
int	I;
begin
CHOUT(0, FF);
RAWTEXT(0, "
       Ŀ      ·            Ŀ    Ŀ           Version 1.6
           Ŀ  Ŀ Ŀ                  Copyright 2001
                      tm        Loren Blaney
                   C U S T O M I Z E R
 ");
if MONOCHROME then
\	HILIGHT( 7, 1, 47, 3, LWHITE)		\\Messes up cursor on XT
else	begin
	HILIGHT( 7, 1, 11, 3, MAGENTA);
	HILIGHT(13, 1, 16, 3, LMAGENTA);
	HILIGHT(18, 1, 19, 3, LBLUE);
	HILIGHT(21, 1, 24, 3, LCYAN);
	HILIGHT(26, 1, 29, 3, LGREEN);
	HILIGHT(32, 1, 36, 3, YELLOW);
	HILIGHT(39, 1, 40, 3, LRED);
	HILIGHT(43, 1, 47, 3, RED);
	HILIGHT(49, 3, 50, 3, GRAY);
	end;

RAWTEXT(0, "


   This is free software.  It comes with ABSOLUTELY NO WARRANTY.




   Enter the name of the ColorDIR program as it appears on your disk.
   Include the path if it is not in the current directory.
   Press ^"Enter ^" to continue.




     File name:
 ");

ATTRIB(WHITE);
BOX(2, 18, 75, 5);

FILENAME:= "DI                                                         ";
loop	begin
	GETFLD0(FILENAME, 58, 16, 20, " ");

	if KEY = ESC then
		begin
		SETCURSOR(OLDCURSOR);
		CHOUT(0, FF);
		exit;
		end;

	if DOSOPEN then
		begin
		CURSOR(3, 24);   TEXT(0, "Loading...");
		DELAY(9);	\Make sure there is enough time to see message
		if READFILEINFO then quit
		else	begin
			DOSABORT;	\Discard partial output file
			CLRLINE(24);
			CTXT(0, 24,
			"INCORRECT VERSION OF .EXE FILE.  (HIT ^"Esc^" TO EXIT.) ");
			INVERT(0, 24, 79);
			for I:= 1, 60 do
				begin
				DELAY(1);
				if CHKKEY then I:= 100;
				end;
			NORMAL(0, 24, 79);
			CLRLINE(24);
			end;
		end
	else	begin
		CLRLINE(24);
		CTXT(0, 24, "FILE NOT FOUND.  (HIT ^"Esc^" TO EXIT.) ");
		INVERT(0, 24, 79);
		for I:= 1, 60 do
			begin
			DELAY(1);
			if CHKKEY then I:= 100;
			end;
		NORMAL(0, 24, 79);
		CLRLINE(24);
		end;
	end;
end;	\PAGE1

\######################################################################

proc	INIT;		\Initialize fields
int	I, J;
char	DEFAULTS,
	S;
begin
case GETVID of 2, 7: MONOCHROME:= true other MONOCHROME:= false;

TRAPC(true);		\Don't let a CTRL-C leave the wrong cursor on
OLDCURSOR:= GETCURSOR;
SHOWCURSOR(false);
end;	\INIT

\----------------------------------------------------------------------

begin	\MAIN
CPUREG:= GETREG;
PSPSEG:= CPUREG(11);
DATASEG:= CPUREG(12);

INFILENAME:= RESERVE(NAMESIZE);
OUTFILENAME:= RESERVE(NAMESIZE);
TMPFILENAME:= RESERVE(NAMESIZE);
BAKFILENAME:= RESERVE(NAMESIZE);

PARAM:= RESERVE(PARAMSIZE);

EXT:= RESERVE(EXTSIZE *INTSIZE);
for II:= 0, EXTSIZE-1 do
	EXT(II):= RESERVE(4);

OT:= RESERVE(4);

\	     0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
CONTRAST:= [$7, $F, $F, $F, $F, $F, $F, $0, $F, $0, $0, $0, $0, $0, $0, $0];

INIT;

PAGE:= 1;
PAGE1;
loop	begin
	if KEY = PGDN then PAGE:= PAGE +1;
	if PAGE > 4 then PAGE:= 4;
	if KEY = PGUP then PAGE:= PAGE -1;
	if PAGE < 2 then PAGE:= 2;
	if KEY = ESC then PAGE:= 4;
	case PAGE of
	  2:	PAGE2;
	  3:	PAGE3;
	  4:	PAGE4
	other;
	end;
end;	\MAIN
