\COLORDIR.XPL	16-SEP-2001	VERSION 1.6  (See DOC in INIT)
\Colorful Directory Displayer
\Copyright (C) 1993-2001 Loren Blaney
\
\This program is free software; you can redistribute it and/or modify it under
\ the terms of the GNU General Public License version 2 as published by the
\ Free Software Foundation.
\This program is distributed in the hope that it will be useful, but WITHOUT
\ ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
\ FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
\ details.
\You should have received a copy of the GNU General Public License along with
\ this program (in the file LICENSE.DOC); if not, write to the Free Software
\ Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\
\You can reach me at:			Mail:	Loren Blaney
\ Email: loren_blaney@idcomm.com		502 Pine Glade Dr.
\						Nederland, CO 80466, USA
\
\This program was compiled with the version 2.4 XPL0 compiler (XPLX, 16-bit).
\ I can send you a copy of this compiler if you can't find it.
\
\
\REVISIONS:
\V1.0, MAR-31-93, Released to bulletin boards.
\V1.1, MAY-03-93, Support options set up by customizer program.
\V1.2, MAY-21-93, Numerous changes: efficiency %, /I and /A options.
\V1.3, JUN-16-93, Don't display a device as a file (i.e: fixed DI PRN).
\V1.4, FEB-14-98, Freeware version.
\V1.5, APR-20-99, Change version number to agree with Customizer.
\V1.6, 16-SEP-2001, Fix command-line redirection when used with Windows 95/98.

inc	C:\CXPL\CODESI;					\Code definitions

def	AX, BX, CX, DX, DI, SI, BP, CF, CS, DS;		\GETREG registers
def	BS=$08, TAB=$09, FF=$0C, CR=$0D, EOF=$1A, ESC=$1B, SP=$20; \ASCII chars

def	BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN, WHITE,	\CGA colors
	GRAY, LBLUE, LGREEN, LCYAN, LRED, LMAGENTA, YELLOW, LWHITE;

def	NAMEMAX=1500;	\Maximum number of file names in a directory
def	SPECSIZE=200;	\Maximum size of file spec path name (deepest tree path)
def	ENTRIES=84;	\Number of entries in color extension tables (6*14=84)

char	CMDLINE,	\Parsed command line [drive:][path][filename][.ext]
	DOC,		\Address of documentation text
	DOC2,		\Second part of doc text
	DTA,		\Disk Transfer Access area for DOS calls
	OD,		\Output device, (6 or 0 if output is redirected)
	OT,		\Order table, defines order of bytes for SORT
	TBL1ST, TBL2ND, TBL3RD, TBLCOL;	\Tables of bytes

int	CPUREG,		\Address of CPU registers from GETREG
	DATASEG,	\Data segment address for this program
	DRIVE,		\Drive code: 0=default, 1=A:, 2=B:, 3=C:, etc.
	II,		\Scratch for MAIN
	LINECTR,	\Line counter to pause screen when full
	LINESIZE,	\Number of lines on screen (25 normally)
	MONOCHROME,	\Flag: Monochrome monitor used
	NAMES,		\Array: file names, attributes, times, dates, sizes
	NAMESIZE,	\Number of file names; Index to last entry in NAMES +1
	FILES,		\Total number of files (same as NAMESIZE except for /X)
	PSPSEG,		\Program Segment Prefix segment, holds command line

	\Graphic characters for line drawing (/A replaces them with normal ASCII):
	CHBAR, CVBAR, CTEE, CITEE, CROSS,

	\Country information:
	CDATEFMT,	\Date format: 0=MDY, 1=DMY, 2=YMD
	CTHOUSEP,	\Thousands separator character (USA = ",")
	CDATESEP,	\Date separator character (USA = "-")
	CTIMESEP,	\Time separator character (USA = ":")
	C24HR,		\Flag: 24/12 hour time (USA = false = 12hr)

	\Switches: sort by Name, Extension, Date, or Size
	SWNAME, SWEXT, SWDATE, SWSIZE, SWWIDE, SWINCL;

real	SIZETOTAL,	\Accumulated total file sizes in directory
	FREESIZE,	\Number of remaining free bytes on selected drive
	CLUSTSIZE,	\Number of bytes in a cluster, the smallest usable space
	CLUSTTOTAL,	\Accumulated file sizes (in CLUSTSIZE increments)
	DIRSIZE;	\Accumulated total file sizes in subdirectories

char	PARAM;		\Array: Parameters for colors and options
def \PARAM\ PTEXT, PLABEL, PLINE, PDIR, PDEFAULT,
	PSIZE, PATB, PDATE, PTIME, PHIDDEN,
	PLOWERCASE, PDECRSIZE, PDECRDATE, PJOINT, PSHOWHIDDEN,
	PLRED, PLGRN, PBKGND;	\Dummies for CUSTOMIZ program
def	PARAMSIZE=18;	\Number of parameters



func	TOUPPER(CH);		\Convert character to uppercase
int	CH;
return if CH>=^a & CH<=^z then CH&$DF else CH;



func	TOLOWER(CH);		\Convert character to lowercase
int	CH;
return if CH>=^A & CH<=^Z then CH!$20 else CH;



proc	CHOUTL(DEV, CH);	\CHOUT with possible shift to lowercase
int	DEV, CH;
CHOUT(DEV, if PARAM(PLOWERCASE) # ^Y then CH else TOLOWER(CH));



func real FLOAT16(N);		\Convert a 16-bit, unsigned integer to a real
int	N;
return if N < 0 then FLOAT(N - $8000) + 32768.0 else FLOAT(N);



proc	SPOUT(DEV, N);		\Output N spaces to specified device
int	DEV, N;
int	I;
for I:= 1, N do CHOUT(DEV, ^ );



func	MIN(A, B);		\Return the smaller of the arguments
int	A, B;
return if A < B then A else B;



proc	INTLEN(N);		\Return the number of digits in N
int	N, I;
for I:= 1, 10 do
	[N:= N /10;   if N = 0 then return I];



func	AHEXTOI(C);		\Convert ASCII hex character to integer
int	C;
begin
if C>=^0 & C<=^9 then return C -^0;
if C>=^A & C<=^F then return C -^A +10;
return -1;
end;	\AHEXTOI



func	GETVID;			\Returns the current video mode
int	REG;			\Pointer to array of processor registers
begin
REG:= GETREG;
REG(AX):= $0F00;		\Function $0F
SOFTINT($10);			\Call BIOS routine
return REG(AX) & $FF;
end;	\GETVID



func	GETDATE;		\Returns the current date in DOS packed format
int	REG;			\Pointer to array of processor registers
begin
REG:= GETREG;
REG(AX):= $2A00;		\Function $2A
SOFTINT($21);			\Call DOS routine
return (REG(CX)-1980)<<9 ! (REG(DX)&$FF00)>>3 ! (REG(DX)&$00FF);
end;	\GETDATE



func	GETTIME;		\Returns the current time in DOS packed format
int	REG;			\Pointer to array of processor registers
begin
REG:= GETREG;
REG(AX):= $2C00;		\Function $2C
SOFTINT($21);			\Call DOS routine
return (REG(CX)&$FF00)<<3 ! (REG(CX)&$00FF)<<5 ! REG(DX)>>9;
end;	\GETTIME



proc	STRCOPY(FROM, TO, SIZE); \Copy string
addr	FROM, TO;		 \Strings
int	SIZE;			 \Number of bytes to copy
int	I;
for I:= 0, SIZE-1 do TO(I):= FROM(I);



func	STRCMP(A, B, SIZE);	\Compare string A to string B
\This returns:
\	-1 if A < B
\	 0 if A = B
\	+1 if A > B
\This provides a general string compare, for example:
\ if CMPSTR(A, B, SIZE) >= 0 then...	(if A >= B then...)
\Also inputs OT, Order Table, which defines the order bytes are compared
addr	A, B;		\Strings to be compared
int	SIZE;		\Number of bytes in A and B
int	I;
begin
for I:= 0, SIZE-1 do
	if A(OT(I)) # B(OT(I)) then
		return if A(OT(I)) > B(OT(I)) then 1 else -1;
return 0;			\They're equal
end;	\STRCMP



proc	SORT(A, N, S, REV);	\Sort array of strings using Shell method
int	A,			\Address of array
	N,			\Number of elements (strings) in array
	S,			\Size of element (string) in bytes
	REV;			\Reverse order
int	J, GAP, I, JG, T;
begin
GAP:= N /2;
while GAP > 0 do
	begin
	for I:= GAP, N-1 do
		begin
		J:= I -GAP;
		loop	begin
			if J < 0 then quit;
			JG:= J +GAP;
			if REV
			    then [if STRCMP(A(J), A(JG), S) >= 0 then quit]
			    else [if STRCMP(A(J), A(JG), S) <= 0 then quit];
			T:= A(J);   A(J):= A(JG);   A(JG):= T;
			J:= J -GAP;
			end;
		end;
		GAP:= GAP /2;
	end;
end;	\SORT

\----------------------------------------------------------------------

proc	COMMAOUT(DEV, X, PLACES);
\Output the integer part of a real with commas (e.g: 1,234,567). This will
\ not output any places after the decimal point, and it doesn't handle
\ some negative numbers correctly (e.g: -,123). Uses device 8 and FORMAT
\ intrinsic.
int	DEV;			\Output device number
real	X;			\Integer part of real to output
int	PLACES;			\Number of character places (to right-justify)
int	I, J, S;
begin
FORMAT(1, 0);			\No places after decimal point
OPENO(8);			\Convert real to ASCII string in device 8 buffer
RLOUT(8, X);
CHOUT(8, ^.);			\Mark end of string

OPENI(8);			\S = Number of digits in front of "."
loop	begin
	for S:= 0, 1000 do
		if CHIN(8) = ^. then quit;
	quit;	\(for safety)
end;
J:= REM(S/3);			\Number of digits in front of first comma

for I:= 1, PLACES -S -(S-1)/3 do \Right justify number
	CHOUT(DEV, ^ );

OPENI(8);			\Output ASCII string and insert commas
for I:= 1, S-1 do		\For all the digits -1 in front of "."
	begin
	CHOUT(DEV, CHIN(8));
	if REM(I/3) = J then CHOUT(DEV, CTHOUSEP); \Use country separator (USA =,)
	end;
CHOUT(DEV, CHIN(8));		\Output last digit in front of "."
end;	\COMMAOUT

\----------------------------------------------------------------------

proc	TIMEOUT(TIME);		\Display time e.g: 5:43p or 17:34
int	TIME;			\Time in DOS packed format
int	HH, MM, SS,		\Hours, Minutes, Seconds
	PM;			\Post Meridiem


	proc	NUMOUT(NN);	\Output 2-digit number with leading zero
	int	NN;
	begin
	if NN <= 9 then CHOUT(OD, ^0);
	INTOUT(OD, NN);
	end;	\NUMOUT


begin	\TIMEOUT
SS:= (TIME & $001F) *2;		\Extract seconds, minutes, hours
MM:= TIME>>5 & $003F;
HH:= TIME>>11;

if C24HR then
	begin				\24-hour clock
	if HH <= 9 then CHOUT(OD, SP);
	INTOUT(OD, HH);
	CHOUT(OD, CTIMESEP);		\Output time separator (USA = ":")
	NUMOUT(MM);
	\CHOUT(OD, CTIMESEP);
	\NUMOUT(SS);
	end
else	begin				\12-hour clock
	PM:= HH >= 12;
	if HH > 12 then HH:= HH -12;
	if HH = 0 then HH:= 12;
	if HH <= 9 then CHOUT(OD, SP);
	INTOUT(OD, HH);
	CHOUT(OD, CTIMESEP);
	NUMOUT(MM);
	\CHOUT(OD, CTIMESEP);
	\NUMOUT(SS);
	CHOUT(OD, if PM then ^p else ^a);
	end;
end;	\TIMEOUT

\----------------------------------------------------------------------

proc	DATEOUT(DATE);		\Display date e.g: MM-DD-YY
int	DATE;			\Date in DOS packed format
int	DD, MM, YY;


	proc	NUMOUT(NN);	\Output 2-digit number with leading zero
	int	NN;
	begin
	if NN <= 9 then CHOUT(OD, ^0);
	INTOUT(OD, NN);
	end;	\NUMOUT


	proc	DODATE(A, B, C); \Output date in AA-BB-CC order
	int	A, B, C;
	begin
	NUMOUT(A);
	CHOUT(OD, CDATESEP);	\Output separator for country (USA = "-")
	NUMOUT(B);
	CHOUT(OD, CDATESEP);
	NUMOUT(C);
	end;


begin	\DATEOUT
DD:= DATE & $001F;		\Extract day, month, year
MM:= DATE>>5 & $000F;
YY:= DATE>>9 + 80;
YY:= REM(YY/100);		\Wrap at the year 2000

case CDATEFMT of		\Output date in proper order for country
  1:	DODATE(DD, MM, YY);	\Europe
  2:	DODATE(YY, MM, DD)	\Japan
other	DODATE(MM, DD, YY);	\USA
end;	\DATEOUT

\----------------------------------------------------------------------

proc	SETCOLOR(EXT);		\Set color according to extension name
char	EXT;			\3-character string containing extension name
int	I;
begin
for I:= 0, ENTRIES-1 do				\Scan for extension in tables
	if EXT(0) = TBL1ST(I) then
	    if EXT(1) = TBL2ND(I) then
		if EXT(2) = TBL3RD(I) then
			[ATTRIB(TBLCOL(I));   return];
ATTRIB(PARAM(PDEFAULT));			\Default color
end;	\SETCOLOR

\======================================================================

proc	SHOWDIR;	\Display directory of NAMES
int	TWOCOL,		\Flag: display detailed, 2-column format (vs. 6-column)
	I,		\Scratch
	J,		\Index into NAMES
	J0,		\Displayed line counter
	K,		\Column counter
	H,		\Height of displayed portion in lines
	HT,		\Total height of directory in lines
	W,		\Width in columns (2 or 6)
	ATB,		\Attribute bits for a file
	B;		\Base index for first name on displayed screen
char	N;		\To access individual bytes in NAMES array
real	SIZE;		\Size of file in bytes

\----------------------------------------------------------------------

proc	SHOWBOTTOM;	\Display bottom lines of directory
int	I;
begin
ATTRIB(WHITE);		\ATI Wonder bug scrolls up color on bottom line
CHOUT(OD, SP);

ATTRIB(PARAM(PSIZE));			\files
INTOUT(OD, FILES);
ATTRIB(PARAM(PTEXT));
TEXT(OD, " file");
CHOUT(OD, if FILES # 1 then ^s else SP);

ATTRIB(PARAM(PSIZE));			\bytes
COMMAOUT(OD, SIZETOTAL, 15);
ATTRIB(PARAM(PTEXT));
TEXT(OD, " byte");
CHOUT(OD, if SIZETOTAL # 1.0 then ^s else SP);

ATTRIB(PARAM(PSIZE));			\free
COMMAOUT(OD, FREESIZE, 15);
ATTRIB(PARAM(PTEXT));
TEXT(OD, " free");

ATTRIB(PARAM(PSIZE));			\efficiency
FORMAT(3, 0);
SPOUT(OD, 5);
if CLUSTTOTAL # 0.0 then 
	RLOUT(OD, SIZETOTAL /CLUSTTOTAL *100.0)
else	RLOUT(OD, 0.0);

ATTRIB(PARAM(PTEXT));
CHOUT(OD, ^%);

I:= INTLEN(FILES) +1 +6 +15 +6 +15 +5 +5 +3 +1;
SPOUT(OD, 79-15-I);			\Space over to date column
if C24HR then CHOUT(OD, SP);

ATTRIB(PARAM(PDATE));			\date
DATEOUT(GETDATE);
CHOUT(OD, SP);

ATTRIB(PARAM(PTIME));			\time
TIMEOUT(GETTIME);

if LINECTR>=LINESIZE & OD=6 then
	begin
	I:= CHIN(1);			\Wait for keystroke
	OPENI(0);			\Flush keyboard buffer
	end;
end;	\SHOWBOTTOM

\----------------------------------------------------------------------

proc	DOCRLF;		\CRLF with pause when screen is full
int	I, J, K, W, CH, C;
begin
if LINECTR>=LINESIZE & OD=6 then
	begin
	CH:= CHIN(1);			\Wait for keystroke
	OPENI(0);			\Flush keyboard buffer

	LINECTR:= 0;			\Restart line counter
	CRLF(0);

	ATTRIB(PARAM(PLINE));		\Draw line separating screens
	W:= if TWOCOL then 2 else 6;	\Width in columns
	J:= if TWOCOL then 39 else 12;
	C:= if PARAM(PJOINT)=^Y then (if CH=ESC then CITEE else CROSS) else CHBAR;
	for K:= 1, W do
		[for I:= 1, J do CHOUT(OD, CHBAR);
		if K < W then CHOUT(OD, C)];

	if CH = ESC then
		begin
		CRLF(0);
		SHOWBOTTOM;
		ATTRIB(WHITE);		\Deal with ATI Wonder bug
		CHOUT(OD, SP);
		exit;
		end;
	end;
CRLF(0);
LINECTR:= LINECTR +1;			\Count this new line
end;	\DOCRLF

\----------------------------------------------------------------------

begin	\SHOWDIR
TWOCOL:= SWNAME ! SWEXT ! SWDATE ! SWSIZE ! SWINCL;	\Command-line switch
if NAMESIZE <= 6 then TWOCOL:= true;	\Default to 2 columns if not enough files
if SWWIDE then TWOCOL:= false;

W:= if TWOCOL then 2 else 6;		\Width in columns
HT:= (NAMESIZE+W-1) /W;			\Total height of directory (lines)

ATTRIB(PARAM(PLINE));			\Draw top border line
J:= if TWOCOL then 39 else 12;
for K:= 1, W do
	[for I:= 1, J do CHOUT(OD, CHBAR);
	if K < W then CHOUT(OD, if PARAM(PJOINT)=^Y then CTEE else CHBAR)];
DOCRLF;

H:= MIN(LINESIZE-1, HT);		\Allow for command line and top border
B:= 0;					\Base index for displayed screen

while HT > 0 do				\While there is something to display...
    begin
    for J0:= 0, H-1 do			\For each line on the screen...
	begin
	J:= J0 +B;				\NAMES index for start of line
	for K:= 1, W do				\For W columns...
		begin
		if J < NAMESIZE then		\If the file exists
			begin
			N:= NAMES(J);		\Get file attributes
			ATB:= N(0);

			N:= NAMES(J) +$1E -$15;	    \Get file name and extension
			case of
			  ATB & $06:			  \Hidden & system
				ATTRIB(PARAM(PHIDDEN));
			  ATB & $10:
				ATTRIB(PARAM(PDIR))	  \(dir) 012345678901
			other SETCOLOR(N+9);		  \      FILENAME EXT

			for I:= 0, 11 do CHOUTL(OD, N(I));\Show name

			N:= NAMES(J) +$1A -$15;		\Get file size
			SIZE:= ( ( FLOAT(N(3)) *256.0 + FLOAT(N(2)) ) *256.0 +
				FLOAT(N(1)) ) *256.0 + FLOAT(N(0));

			if TWOCOL then
				begin			\Two-column display
				if SWINCL then
					begin
					ATTRIB(PARAM(PSIZE));	\Show file size
					COMMAOUT(OD, SIZE, 11);
					CHOUT(OD, SP);
					end
				else	begin
					if ATB & $10 then	\Subdirectory,
						begin		\ "." or ".."
						ATTRIB(PARAM(PDIR));
						TEXT(OD, "  (dir)");
						end
					else	begin
						ATTRIB(PARAM(PSIZE)); \Show file size
						FORMAT(7, 0);
						RLOUT(OD, SIZE);
						end;
					if SIZE+.5 < 1E7 then CHOUT(OD, SP);

					ATTRIB(PARAM(PATB));	\Show attributes
					CHOUT(OD, if ATB & $04 then ^s else SP);
					CHOUT(OD, if ATB & $20 then ^a else SP);
					CHOUT(OD, if ATB & $01 then ^r else SP);
					CHOUT(OD, if ATB & $02 then ^h else SP);
					end;
				if C24HR then CHOUT(OD, SP);

				N:= NAMES(J) +$18 -$15;		\Show date
				ATTRIB(PARAM(PDATE));
				DATEOUT( N(0) + SWAP(N(1)) );
				CHOUT(OD, SP);

				N:= NAMES(J) +$16 -$15;		\Show time
				ATTRIB(PARAM(PTIME));
				TIMEOUT( N(0) + SWAP(N(1)) );
				end;

			ATTRIB(PARAM(PLINE));
			if K < W then CHOUT(OD, CVBAR);
			end
		else	begin			\File does not exits
			if PARAM(PJOINT)=^Y & ~TWOCOL then
				begin
				SPOUT(OD, 12);
				ATTRIB(PARAM(PLINE));
				if K < W then CHOUT(OD, CVBAR);
				end;
			end;
		J:= J +H;		\Index for next column
		end;
	DOCRLF;				\Next line, pause if necessary
	end;
    B:= B + H *W;			\Increase base index by what was displayed
    HT:= HT -H;				\Remaining total height
    H:= MIN(LINESIZE, HT);		\Height of next display screen
    end;	\while

ATTRIB(PARAM(PLINE));			\Draw bottom border line
J:= if TWOCOL then 39 else 12;
for K:= 1, W do
	[for I:= 1, J do CHOUT(OD, CHBAR);
	if K < W then CHOUT(OD, if PARAM(PJOINT)=^Y then CITEE else CHBAR)];
DOCRLF;
SHOWBOTTOM;
end;	\SHOWDIR

\======================================================================

proc	SHOWPATH;	\Show: DRIVE: /PATH/ NAME .EXT
int	I, J, ROOT;
char	STR;
begin
STR:= RESERVE(64+1);

\Show drive:
ATTRIB(PARAM(PTEXT));
if DRIVE = 0 then			\If no drive was specified
	begin
	CPUREG(AX):= $1900;		\Find current drive (0=A, 1=B, 2=C, etc.)
	SOFTINT($21);
	CHOUTL(OD, (CPUREG(AX) & $00FF) + ^A);
	ROOT:= CMDLINE(0) = ^\;
	end
else	begin
	CHOUTL(OD, DRIVE-1+^A);
	ROOT:= CMDLINE(2) = ^\;
	end;
CHOUT(OD, ^:);

\Show pathname:
I:= 0;
STR(I):= 0;				\Make sure string is terminated
if ~ROOT then
	begin				\Not root directory
	CPUREG(AX):= $4700;		\Get current directory into STR
	CPUREG(DX):= DRIVE;
	CPUREG(DS):= DATASEG;
	CPUREG(SI):= STR+1;
	SOFTINT($21);
	if ~CPUREG(CF) then
		begin
		STR(0):= ^\;		\Insert leading slash for root dir
		loop	begin
			for I:= 0, 63 do	\Find end of STR
				if STR(I) = 0 then quit;
			quit;		\(for safety)
			end;
		if I > 1 then		\Don't put two slashes in a row
			begin
			STR(I):= ^\;
			I:= I +1;
			STR(I):= 0;
			end;
		end;
	end;

loop	begin
	for J:= 0, 1000 do			\Append CMDLINE onto STR
		[STR(I):= CMDLINE(J);   I:= I +1;
		if CMDLINE(J) = 0 then quit];
	quit;	\(for safety)
	end;

loop	begin
	for I:= 0, 1000 do			\Clean up STR
		begin
		if STR(I) = 0 then quit;

		if STR(I)=^: & I>0 then		\Remove drive
			[STR(I):= SP;   STR(I-1):= SP];

		if STR(I-1)=^. & STR(I)=^. & I>0 then
			begin			\If ".." then erase preceeding
			J:= I;			\ directory name
			loop	begin
				STR(J):= SP;
				J:= J -1;
				if STR(J)=^\ ! J<0 then quit;
				end;
			loop	begin
				if J < 0 then quit;
				STR(J):= SP;
				J:= J -1;
				if STR(J) = ^\ then quit;
				end;
			if J < 0 then quit;
			STR(J):= SP;
			end
		else if STR(I-1)=^. & STR(I)=^\ & I>0 then
			begin			\If "./" then erase slash and
			STR(I):= SP;		\ preceeding dot
			STR(I-1):= SP;
			end;
		end;
	quit;	\(for safety)
	end;

J:= 2;		\For the "C:"
loop	begin
	for I:= 0, 1000 do			\Show cleaned-up string
		if STR(I) = 0 then quit
		else if STR(I) # SP then [CHOUTL(OD, STR(I));   J:= J +1];
	quit;	\(for safety)
	end;

SPOUT(OD, 78-11-J);				\Space over to label column
end;	\SHOWPATH

\----------------------------------------------------------------------

proc	SHOWLABEL;			\Show volume label
int	I;
char	N;
begin
ATTRIB(PARAM(PLABEL));
CPUREG(AX):= $4E00;			\Get volume label from DOS
CPUREG(CX):= $0008;
CPUREG(DS):= DATASEG;
if DRIVE > 0 then			\Drive was specified
	[N:= " :*.* ";   N(0):= ^A-1+DRIVE;   N(5):= 0]
else	[N:= "*.* ";   N(3):= 0];
CPUREG(DX):= N;
SOFTINT($21);
if (CPUREG(AX) & $FF) = 0 then
	loop	begin
		for I:= $1E, $29 do				\1122222222222
			if DTA(I) = 0 then quit			\EF0123456789A
			else if DTA(I)#^. then CHOUTL(OD, DTA(I))\FILENAME.EXT0
			else if I = $25 then CHOUT(OD, SP);	\MONIQUE JR
		quit;	\(for safety)
		end
else TEXT(OD, "(no label)");

CRLF(0);
end;	\SHOWLABEL

\----------------------------------------------------------------------

proc	SORTDIR;	\Sort directory of NAMES
int	I, J, K, CH, F, ATB;
char	N, M;
begin
M:= RESERVE(12);			\Temporary location for a name

\Put file names into standard format	 EF0123456789A  Index into DTA
for K:= 0, NAMESIZE-1 do		\0123456789ABC
	begin				\FILENAME.EXT0
	N:= NAMES(K);			\FILENAME EXT
	ATB:= N(0);
	N:= NAMES(K) +$1E -$15;
	F:= N(0) # ^.;			\F is true if not a "." or ".."
	loop	begin
		for I:= 0, 8 do
			begin
			CH:= N(I);
			if F & CH=^. ! CH=0 then quit;	\Ignore dir "." & ".."
			M(I):= CH;
			end;
		quit;	\(for safety)
		end;
	for J:= I, 8 do M(J):= SP;	\Fill out name with spaces

	if CH=^. then
		loop	begin		\Get extension
			for J:= 9, 11 do
				begin
				I:= I +1;
				CH:= N(I);
				if CH = 0 then quit;
				M(J):= CH;
				end;
			quit;
			end;
	for I:= J, 11 do M(I):= SP;	\Fill out extension with spaces
	for I:= 0, 11 do N(I):= M(I);	\Copy back to NAMES array

	if (ATB & $10 \DIR\) ! ~F then
		N(12):= 0		\To sort dirs first
	else	N(12):= 1;
	end;

case of					\Sort according to command-line switch
  SWEXT:
	[OT(0):= $2A-$15;			\Dir flag
	for I:= 0, 2 do OT(I+1):= $1E+9-$15+I;	\Ext
	for I:= 0, 7 do OT(I+4):= $1E-$15+I;	\Filename
	SORT(NAMES, NAMESIZE, 1+3+8, false)];

  SWNAME:
	[for I:= 0, 11 do OT(I):= $1E-$15+I;	\Set up sort Order Table for:
	SORT(NAMES, NAMESIZE, 12, false)];	\Filename + ext

  SWDATE:
	[for I:= 0, 3 do OT(I):= $19-$15-I;	\Time + date (MSB last)
	for I:= 0, 11 do OT(I+4):= $1E-$15+I;	\Filename + ext
	SORT(NAMES, NAMESIZE, 4+12, PARAM(PDECRDATE)=^Y)];

  SWSIZE:
	[for I:= 0, 3 do OT(I):= $1D-$15-I;	\Size
	for I:= 0, 11 do OT(I+4):= $1E-$15+I;	\Filename + ext
	SORT(NAMES, NAMESIZE, 4+12, PARAM(PDECRSIZE)=^Y)]
other
	[OT(0):= $2A-$15;			\Dir flag
	for I:= 0, 11 do OT(I+1):= $1E-$15+I;	\Filename + ext
	SORT(NAMES, NAMESIZE, 1+12, false)];
end;	\SORTDIR

\----------------------------------------------------------------------

proc	GETCOUNTRY;		\Get country information
char	BUF;
begin
BUF:= RESERVE($22);

CPUREG(AX):= $3800;		\Get country information from DOS
CPUREG(DS):= DATASEG;
CPUREG(DX):= BUF;
SOFTINT($21);
if CPUREG(CF) ! BUF($0D)=0 then	\Beware of PC-DOS versions 2.0 and 2.1
	begin
	CDATEFMT:= 0;		\Default to USA values
	CTHOUSEP:= ^,;
	CDATESEP:= ^-;
	CTIMESEP:= ^:;
	C24HR:= false;
	end
else	begin
	CDATEFMT:= BUF($00);	\0=MDY, 1=DMY, 2=YMD
	CTHOUSEP:= BUF($07);	\Char
	CDATESEP:= BUF($0B);	\Char
	CTIMESEP:= BUF($0D);	\Char
	C24HR:= (BUF($11) & $01) = 1;
	end;
end;	\GETCOUNTRY

\----------------------------------------------------------------------

proc	APPENDDIR(FILESPEC, DTA);
\Strip off file name (if any) from FILESPEC and append directory name
char	FILESPEC, DTA;
int	I, J, CH;
begin
loop	begin
	for I:= 0, SPECSIZE-1 do		\Move to the end of FILESPEC
		if FILESPEC(I) = 0 then quit;
	quit;	\(for safety)
	end;

\Move back until backslash, colon or start of string
loop	begin
	for I:= -I, 0 do
		case FILESPEC(-I) of ^\, ^:: quit other;
	quit;	\(for safety)
	end;
I:= 1 -I;

\Append directory name
loop	begin
	for J:= 0, 12 do
		begin
		CH:= DTA($1E+J);
		if CH = 0 then quit;
		FILESPEC(I+J):= CH;
		end;
	quit;	\(for safety)
	end;

STRCOPY("\*.* ", FILESPEC+I+J, 4);
FILESPEC(I+J+4):= 0;			\String terminator
end;	\APPENDDIR

\----------------------------------------------------------------------

proc	ADDDIRSIZE(FILESPEC);
\Add the sizes of all the files (including subdirs) to DIRSIZE
char	FILESPEC;	\Name of path to parent directory (ASCIIZ)
char	DTA;
char	FILE2SPEC;
int	I, C, F;
real	SIZE, FRAC;
begin
FILES:= FILES +2;			\Count "." and ".."

DTA:= RESERVE($80);			\Use 128 bytes even though 34 is enough
CPUREG(AX):= $1A00;			\Set up disk transfer access (DTA) area
CPUREG(DX):= DTA;
CPUREG(DS):= DATASEG;
SOFTINT($21);

CPUREG(AX):= $4E00;			\Look up first file name
CPUREG(CX):= $0037;			\Everything except volume label
CPUREG(DS):= DATASEG;
CPUREG(DX):= FILESPEC;
SOFTINT($21);
if (CPUREG(AX) & $FF) \# 0\ then return;

FILE2SPEC:= RESERVE(SPECSIZE);

F:= PARAM(PSHOWHIDDEN)=^Y;
loop	begin			\This is the slowest loop (because of DOS calls)
	if ( F ! (DTA($15)&$06)=0 ) & DTA($1E)#^. & (DTA($15)&$40)=0 then
		begin
		FILES:= FILES +1;
		if DTA($15) & $10 then	\Subdirectory
			begin
			loop	begin
				for I:= 0, SPECSIZE-1 do
					begin
					C:= FILESPEC(I);
					FILE2SPEC(I):= C;
					if C = 0 then quit;
					end;
				quit;	\(for safety)
				end;
			APPENDDIR(FILE2SPEC, DTA);
			ADDDIRSIZE(FILE2SPEC);
			end
		else	begin
			SIZE:= ( ( FLOAT(DTA($1D)) *256.0 +
				   FLOAT(DTA($1C)) ) *256.0 +
				   FLOAT(DTA($1B)) ) *256.0 +
				   FLOAT(DTA($1A));
			DIRSIZE:= DIRSIZE + SIZE;
			SIZETOTAL:= SIZETOTAL + SIZE;
			FRAC:= MOD(SIZE, CLUSTSIZE);
			CLUSTTOTAL:= CLUSTTOTAL + SIZE - FRAC;
			if FRAC>0.0 ! DTA($15)&$10 then	\Dirs add something
				CLUSTTOTAL:= CLUSTTOTAL + CLUSTSIZE;
			end;
		end;

	CPUREG(AX):= $1A00;		\Re-set up DTA
	CPUREG(DX):= DTA;
	CPUREG(DS):= DATASEG;
	SOFTINT($21);

	CPUREG(AX):= $4F00;		\Look up next file name
	SOFTINT($21);
	if (CPUREG(AX) & $FF) \# 0\ then quit;
	end;
end;	\ADDDIRSIZE

\----------------------------------------------------------------------

proc	READFILEINFO;		\Read file names, etc. from selected directory
				\Inputs DTA
int	I, F, C;
char	N;
real	SIZE,	\Size of file in bytes
	FRAC;	\Fractional part of a cluster
char	FILESPEC;
begin
NAMESIZE:= 0;   FILES:= 0;   SIZETOTAL:= 0.0;   CLUSTTOTAL:= 0.0;

CPUREG(AX):= $4E00;		\Look up first file name
CPUREG(CX):= $0037;		\Everything except volume label
CPUREG(DS):= DATASEG;
CPUREG(DX):= CMDLINE;
SOFTINT($21);
if (CPUREG(AX) & $FF) \# 0\ then return;

FILESPEC:= RESERVE(SPECSIZE);

F:= PARAM(PSHOWHIDDEN)=^Y;
loop	begin			\This is the slowest loop (because of DOS calls)
	if (DTA($15)&$40)=0 then
	    case of F, (DTA($15)&$06)=0:	\Showing hidden, or file is not hidden
		begin			\Load array (NAMES) with file names
		N:= NAMES(NAMESIZE);
		for I:= 0, $2A-$15 do N(I):= DTA(I+$15);
		if NAMESIZE < NAMEMAX-1 then NAMESIZE:= NAMESIZE +1;
		FILES:= FILES +1;

		case of (N(0)&$10), N($1E-$15)=^.:
			begin			\Make dir size field = 0
			N($1A-$15):= 0;		\ (in case we sort by size)
			N($1B-$15):= 0;
			N($1C-$15):= 0;
			N($1D-$15):= 0;
			end
		other;

		if SWINCL & (N(0)&$10)\#0\ & N($1E-$15)#^. then	\Subdirectory
			begin
			DIRSIZE:= 0.0;
			loop	begin
				for I:= 0, SPECSIZE-1 do
					begin
					C:= CMDLINE(I);
					FILESPEC(I):= C;
					if C = 0 then quit;
					end;
				quit;	\(for safety)
				end;
			APPENDDIR(FILESPEC, DTA);
			ADDDIRSIZE(FILESPEC);

			\Store DIRSIZE into size field of directory DTA
			SIZE:= MOD(DIRSIZE, 256.0);
			N($1A-$15):= FIX(SIZE);
			DIRSIZE:= (DIRSIZE - SIZE) /256.0;

			SIZE:= MOD(DIRSIZE, 256.0);
			N($1B-$15):= FIX(SIZE);
			DIRSIZE:= (DIRSIZE - SIZE) /256.0;

			SIZE:= MOD(DIRSIZE, 256.0);
			N($1C-$15):= FIX(SIZE);
			DIRSIZE:= (DIRSIZE - SIZE) /256.0;

			SIZE:= MOD(DIRSIZE, 256.0);
			N($1D-$15):= FIX(SIZE);

			CPUREG(AX):= $1A00;		\Re-set up DTA
			CPUREG(DX):= DTA;
			CPUREG(DS):= DATASEG;
			SOFTINT($21);
			end
		else	begin
			SIZE:= ( ( FLOAT(N($1D-$15)) *256.0 + FLOAT(N($1C-$15)) ) *256.0 +
				FLOAT(N($1B-$15)) ) *256.0 + FLOAT(N($1A-$15));
			SIZETOTAL:= SIZETOTAL + SIZE;

			FRAC:= MOD(SIZE, CLUSTSIZE);
			CLUSTTOTAL:= CLUSTTOTAL + SIZE - FRAC;
			if FRAC>0.0 ! N($15-$15)&$10 then	\Dirs add something
				CLUSTTOTAL:= CLUSTTOTAL + CLUSTSIZE;
			end;
		end
	    other;

	CPUREG(AX):= $4F00;		\Look up next file name
	SOFTINT($21);
	if (CPUREG(AX) & $FF) \# 0\ then quit;
	end;
end;	\READFILEINFO

\----------------------------------------------------------------------

proc	SHOWHELP;		\Display the directions
begin
CHOUT(0, FF);	\BEWARE: ATI Wonder bug scrolls up color in bottom-left corner
RAWTEXT(0, DOC);
if MONOCHROME then
\	HILIGHT( 7, 0, 47, 2, LWHITE)		\\Messes up cursor on XT
else	begin
	HILIGHT( 7, 0, 11, 2, MAGENTA);
	HILIGHT(13, 0, 16, 2, LMAGENTA);
	HILIGHT(18, 0, 19, 2, LBLUE);
	HILIGHT(21, 0, 24, 2, LCYAN);
	HILIGHT(26, 0, 29, 2, LGREEN);
	HILIGHT(32, 0, 36, 2, YELLOW);
	HILIGHT(39, 0, 40, 2, LRED);
	HILIGHT(43, 0, 47, 2, RED);
	HILIGHT(49, 2, 50, 2, GRAY);
	end;

RAWTEXT(0, DOC2);
end;	\SHOWHELP

\----------------------------------------------------------------------

func	PARSECMDLINE;
\Parse command line and set up switches and CMDLINE with directory path
\ name. Return 'false' if error.
int	I, J, CH,
	DOT,		\Flag: "." found in last file name
	WILD;		\Flag: "*" or "?" found in command line
char	CMDTAIL;	\Command tail from Program Segment Prefix (PSP)
begin
CMDTAIL:= RESERVE($80);			\Get command tail from PSP
BLIT(PSPSEG, $80, DATASEG, CMDTAIL, $80);

\Copy CMDTAIL into CMDLINE. Remove spaces and switches.
SWNAME:= false;   SWEXT:= false;   SWDATE:= false;   SWSIZE:= false;
SWWIDE:= false;   SWINCL:= false;
CHBAR:= ^;   CVBAR:= ^;   CTEE:= ^;   CITEE:= ^;   CROSS:= ^;

J:= 0;   DOT:= false;   WILD:= false;   DRIVE:= 0;
for I:= 1, CMDTAIL(0) do
	begin
	CH:= TOUPPER(CMDTAIL(I));
	if CH = ^/ then			\Remove switch
		begin
		I:= I +1;		\Skip "/"
		if I > CMDTAIL(0) then return false;
		CH:= TOUPPER(CMDTAIL(I));
		case CH of
		 ^N:	SWNAME:= true;
		 ^E:	SWEXT:= true;
		 ^D:	SWDATE:= true;
		 ^S:	SWSIZE:= true;
		 ^W:	SWWIDE:= true;
		 ^I:	SWINCL:= true;
		 ^A:	[CHBAR:= ^-;   CVBAR:= ^|;   CTEE:= ^+;
			CITEE:= ^+;   CROSS:= ^+]
		other return false;
		end
	else if CH # SP then
		begin
		CMDLINE(J):= CH;   J:= J +1;
		case CH of
		  ^\:	DOT:= false;
		  ^.:	DOT:= true;
		  ^*,^?:WILD:= true;
		  ^::	if J = 2 then DRIVE:= CMDLINE(0) -^A +1
			else return false
		other;
		end;
	end;

CMDLINE(J):= 0;				\Terminate string

CPUREG(AX):= $3600;			\Get drive allocation information
CPUREG(DX):= DRIVE;
SOFTINT($21);
if CPUREG(AX) = -1 then
	[TEXT(0, "Invalid drive specification");   CRLF(0);   exit];
\Cluster size in bytes = sectors per cluster (AX) * bytes per sector (CX)
CLUSTSIZE:= FLOAT16(CPUREG(AX)) * FLOAT16(CPUREG(CX));
\Free space on drive in bytes = number of available clusters * cluster size
FREESIZE:= FLOAT16(CPUREG(BX)) * CLUSTSIZE;

\If not ending in slash, and last name is a directory then add slash
CH:= CMDLINE(J-1);
if J>=1 & CH#^\ & not WILD then
	begin
	CPUREG(AX):= $4E00;		\Look up directory name
	CPUREG(CX):= $0010;
	CPUREG(DS):= DATASEG;
	CPUREG(DX):= CMDLINE;
	SOFTINT($21);
	if not CPUREG(CF) & (DTA($15) & $10) !		\Is directory
	    J>=2 & CH=^. & CMDLINE(J-2)=^. then		\Is ".."
		[CMDLINE(J):= ^\;   J:= J +1;   DOT:= false];
	end;

CH:= CMDLINE(J-1);
case of J=0, CH=^\, CH=^::		\No name specified
	[STRCOPY("*.* ", CMDLINE+J, 3);   J:= J +3]
other	begin
	if not DOT then			\No extension specified
		[STRCOPY(".* ", CMDLINE+J, 2);   J:= J +2];
	end;

CMDLINE(J):= 0;				\Terminate string
return true;				\Indicate success
end;	\PARSECMDLINE

\----------------------------------------------------------------------

proc	INIT;		\Initialize global variables
int	I, J, K;
char	DEFAULTS;
begin
\If this byte is not $01 then the output is redirected. Use device 0 to allow it.
OD:= if PEEK(PSPSEG, $19) # $01 then 0 else 6;	\WARNING: Undocumented DOS feature

I:= "XYZZY ";		\Used by external program to locate these tables
DEFAULTS:= "AE8D7EADB8NNNNY000 ";
\Read downward and don't set MSB on last char (i.e. one extra character)
TBL1ST:= "CEBTDMNLTTSMPHGPBLIIJTTPWPFFGMXPLCCBGHHC6AMPSZAASLMMRSVW____________________________ ";
TBL2ND:= "OXAXOEOTULDSDTICMBFMPGIIPNLLLPPAS PAC PP8SA6RIRRDZOIONOA____________________________ ";
TBL3RD:= "METTC TRTKAGFMFXPMFGGAFCGGIC GLSP PSC PPKMC5CPJCNHDDLDCV____________________________ ";
\Color values in ASCII hex
TBLCOL:= "ABCFFFFFFFFFFF222222222222333366666666664444499999111111____________________________ ";

case GETVID of 2, 7: MONOCHROME:= true other MONOCHROME:= false;
if MONOCHROME & DEFAULTS(PLRED)=^0 \not customized\ then
	DEFAULTS:= "777F7F7777NNNNY000 ";

J:= \AHEXTOI(DEFAULTS(PBKGND)) <<4\ 0;
for I:= 0, 9 do
	begin
	K:= AHEXTOI(DEFAULTS(I));
	if K < 0 then K:= WHITE;
	PARAM(I):= K ! J;
	end;

for I:= 10, PARAMSIZE-1 do
	PARAM(I):= DEFAULTS(I);

for I:= 0, ENTRIES-1 do
	begin
	K:= AHEXTOI(TBLCOL(I));
	if K < 0 then K:= PARAM(PDEFAULT);
	TBLCOL(I):= K ! J;
	end;

LINESIZE:= PEEK(0, $484) +1;		\Get number of lines on screen
if LINESIZE<24 ! LINESIZE>65 then LINESIZE:= 25;	\(for safety)
LINESIZE:= LINESIZE -1;			\Fudge factor to show command line
LINECTR:= 1;

DOC:= 
"       Ŀ      ·            Ŀ    Ŀ
           Ŀ  Ŀ Ŀ                   Version 1.6
                      tm

 ";
DOC2:= "Displays a colorful list of files and subdirectories in a directory.

Usage:   DI [drive:] [\path\] [filename] [.ext] [/options]

     Options:	   /N  Sort by Name		   /W  Use Wide format
		   /E  Sort by Extension	   /I  Include dir sizes
		   /S  Sort by Size		   /A  Use normal ASCII
		   /D  Sort by Date


Copyright (C) 1993-2001 Loren Blaney

ColorDIR comes with ABSOLUTELY NO WARRANTY.

This is free software. You are welcome and encouraged to redistribute
it under certain conditions. For details see LICENSE.DOC.

 ";
end;	\INIT

\----------------------------------------------------------------------

begin	\MAIN
CPUREG:= GETREG;			\Get address of CPU registers
PSPSEG:= CPUREG(11);
DATASEG:= CPUREG(12);

DTA:= RESERVE($80);			\Set up disk transfer access (DTA) area
CPUREG(AX):= $1A00;			\Use 128 bytes even though 34 is enough
CPUREG(DX):= DTA;
CPUREG(DS):= DATASEG;
SOFTINT($21);

CMDLINE:= RESERVE($80+4);		\Set up arrays
NAMES:= RESERVE(NAMEMAX*2);
for II:= 0, NAMEMAX-1 do
	NAMES(II):= RESERVE($2B-$15);
OT:= RESERVE($2B-$15);
PARAM:= RESERVE(PARAMSIZE);

INIT;

GETCOUNTRY;
if PARSECMDLINE then
	[SHOWPATH;   READFILEINFO;   SHOWLABEL;   SORTDIR;   SHOWDIR]
else	SHOWHELP;
if OD = 0 then CRLF(OD);		\Add CR if output was redirected
end;	\MAIN
