	PAGE
;*******************************************************************
;IMPLEMENTATION NOTE: These instructions were coded specifically for
;the 8088/8086. The 8086 calculates the Effective Address by taking
;extra clock cycles. The 186, 286 and 386, calculate in hardware and
;so take no extra cycles. As a result, it is quicker to use PUSH and
;POP instruction for the 8086 and indexed instructions for the 286;
;
;	8086			286
;
;	pop	ax		pop	ax
;	pop	cx		mov	bp,sp
;	add	ax,cx		add	[bp],ax
;	push	ax
;
;*******************************************************************

;$00
;EXIT ROUTINE. ONE-BYTE INSTRUCTION.

EXITDO:	MOV	SP,STKPTR	;RESTORE STACK
	RET

;$01
;ROUTINE TO RETRIVE A VARIABLE'S VALUE AND PUSH IT ON THE STACK
;THREE-BYTE OPCODE:
;   THE OPCODE
;   THE LEVEL IN THE DISPLAY VECTOR OF THE BASE ADDRESS
;   THE OFFSET FROM THAT BASE ADDRESS OF THE ACTUAL VALUE

LODDO:	MOV	BL,[DI]		;GET LEVEL NUMBER OF VARIABLE
	INC	DI		;ADVANCE PC
	MOV	SI,DISPLY[BX]	;GET DISPLAY VECTOR
	MOV	BX,[DI]		;GET OFFSET TO VARIABLE
	ADD	DI,2		;ADVANCE PC
	PUSH	[BX+SI]		;GET VARIABLE AND PUT ON STACK
	JMP	CMLRET		;GO DO NEXT OPCODE (BH#0)
	PAGE

;;$02
;;ROUTINE TO RETURN AN INDEXED BYTE VALUE ON THE STACK
;;THE REFRENCED VARIABLE (LEVEL AND OFFSET GIVEN) CONTAINS
;;THE BASE ADDRESS. THE INDEX IS GOTTEN FROM THE STACK.
;;THE VALUE (ONE BYTE) IS RETURNED AS A 2-BYTE QUANTITY.
;;THE HIGH BYTE IS ZEROED.
;
;LDXDO:	MOV	BL,[DI]		;GET LEVEL OF VARIABLE
;	INC	DI		;ADVANCE PC
;	MOV	SI,DISPLY[BX]	;GET DISPLAY VECTOR
;	MOV	BX,[DI]		;GET OFFSET TO VARIABLE
;	ADD	DI,2		;ADVANCE PC
;	MOV	SI,[BX+SI]	;GET ACTUAL ADDRESS
;	POP	BP		;GET INDEX
;	MOV	BL,[BP+SI]	;GET VARIABLE
;	SUB	BH,BH		;ZERO HIGH BYTE
;	PUSH	BX		; PUT ON STACK
;	JMP	OPGO		;GO EXECUTE NEXT OPCODE

;$02
;THIS ROUTINE FORMS TOS+NOS AND THEN USES THAT VALUE AS AN
;INDIRECT ADDRESS OF A BYTE TO PUSH ONTO TOS (LDX). ONE-BYTE
;INSTRUCTION.

LDXDO:	POP	SI		;GET TOS
	POP	BX		;GET NOS
	MOV	AL,[BX+SI]	;FETCH IT
	XOR	AH,AH		;CLEAR HIGH BYTE
	PUSH	AX		;PUSH WORD THERE
	JMP	CMLRET		;DO NEXT OP (BH#0)

;$03
;ROUTINE TO STORE TOP OF STACK (TOS) INTO A VARIABLE

STODO:	MOV	BL,[DI]		;GET LEVEL OF VARIABLE
	INC	DI		;ADVANCE PC
	MOV	SI,DISPLY[BX]	;GET DISPLAY VECTOR
	MOV	BX,[DI]		;GET OFFSET
	ADD	DI,2		;ADVANCE PC
	POP	[BX+SI]		;STORE TOS
	JMP	CMLRET		;GO DO NEXT OPCODE (BH#0)

;;$04
;;ROUTINE TO STORE VALUE ON STACK INTO INDEXED ELEMENT.
;;SIMILAR TO LDX EXCEPT THAT THE VALUE TO STORE IS ON THE
;;STACK AFTER THE INDEX. THE HIGH BYTE OF THE VALUE IS
;;IGNORED AND THE LOW BYTE IS STORED INTO THE ADDRESS.
;
;STXDO:	MOV	BL,[DI]		;GET LEVEL OF VARIABLE
;	INC	DI		;ADVANCE PC
;	MOV	SI,DISPLY[BX]	;GET DISPLAY VECTOR
;	MOV	BX,[DI]		;GET OFFSET TO VARIABLE
;	ADD	DI,2		;ADVANCE PC
;	MOV	SI,[BX+SI]	;GET ACTUAL ADDRESS
;	POP	AX		;GET VALUE
;	POP	BX		;GET INDEX
;	MOV	[BX+SI],AL	;STORE VARIABLE
;	JMP	CMLRET		;GO EXECUTE NEXT OPCODE (BH#0)

;$04
;STORE LOW BYTE OF TOS INTO ADDRESS IN NOS AND POP BOTH (STX). ONE-BYTE
;INSTRUCTION.

STXDO:	POP	AX		;GET TOS
	POP	SI		;GET NOS
	MOV	[SI],AL		;STORE LOW BYTE OF TOS
	JMP	OPGO		;DO NEXT OP (BH=0)
	PAGE

;$05
;ROUTINE TO CALL A PROCEDURE.
; AFTER A PROCEDURE CALL THE STACK IS SET UP AS FOLLOWS:
;	OLD LEVEL
;	OLD DISPLAY VECTOR AT NEW LEVEL-LOW BYTE
;	OLD DISPLAY VECTOR AT NEW LEVEL-HIGH BYTE
;	RETURN PC - LOW BYTE
;	RETURN PC - HIGH BYTE

;THE DISPLAY VECTOR FOR THE NEW LEVEL IS SET TO THE CURRENT
;HEAP LOCATION.
;THE INSTRUCTION CONSISTS OF 4 BYTES:
;	THE OPCODE
;	THE LEVEL OF THE PROCEDURE TO BE INVOKED
;	THE LOW BYTE OF THE PROCEDURE ENTRY ADDRESS
;	THE HIGH BYTE OF THE PROCEDURE ENTRY ADDRESS

CALDO:	ADD	DI,3		;POINT PAST THIS OPCODE
	MOV	BL,[DI]-3	;GET NEW LEVEL
	PUSH	BX		;SAVE ON STACK
	PUSH	DISPLY[BX]	;SAVE STARTING DISPLAY VALUE
	PUSH	DI		;SAVE RETURN ADDRESS
	MOV	AX,HP		;SET UP NEW DISPLAY VECTOR
	MOV	DISPLY[BX],AX
	MOV	DI,[DI]-2	;POINT TO NEW ADDRESS
	JMP	OPGO		;GET NEXT INSTRUCITON (BH=0)


;$06
;ROUTINE TO RETURN FROM A PROCEDURE. THIS POPS THE STUFF
;PUSHED BY THE CALL. IT RESTORES THE HEAP TO THE DEPTH IT HAD
;AT THE TIME OF THE CALL. THIS IS A ONE-BYTE INSTRUCTION.

RETDO:	POP	DI		;GET RETURN ADDRESS
	POP	AX		;GET STARTING LEVEL
	POP	BX		;GET LEVEL CALLED PROCEDURE LEVEL
	MOV	CX,DISPLY[BX]	;RESTORE HP
	MOV	HP,CX
	MOV	DISPLY[BX],AX	;RESTORE DISPLAY VECTOR
	JMP	CMLRET		;GO GET NEXT OPCODE (BH#0)
	PAGE

;$07
;JUMP INSTRUCTIONS
;THE TWO JUMPS ARE EACH THREE-BYTE INSTRUCTIONS.
;	OPCODE
;	LOW ORDER OF TARGET ADDRESS
;	HIGH ORDER OF TARGET ADDRESS

JMPDO:	MOV	DI,[DI]		;GET NEW ADDRESS
	JMP	OPGO		;GO GET NEXT OPCODE (BH=0)


;$08
;CONDITIONAL JUMP ROUTINE.
;NOTE FALSE IS ZERO; NON-ZERO IS TRUE. THIS ROUTINE JUMPS ON
;FALSE, NOT ON TRUE. THE RESULT OF THE LAST BOOLEAN EXPRESSION
;IS ON THE STACK. IT IS CHECKED AND THE APPROPRIATE IS ACTION TAKEN.

JPCDO:	MOV	DX,[DI]		;GET NEW ADDRESS
	POP	AX		;GET TOS
	OR	AX,AX		;TEST FALSE
	JNZ	JPCDO1		;SKIP IF NOT
	MOV	DI,DX		;SET NEW ADDRES
	JMP	OPGO		;GO GET NEXT OPCODE (BH=0)

JPCDO1:	ADD	DI,2		;ADVANCE PC
	JMP	OPGO		;GO GET NEXT OPCODE (BH=0)

;$09
;INCREMENT THE HEAP POINTER.
;THIS ROUTINE IS USED TO RESERVE HEAP SPACE FOR LOCAL
;VARIABLES AND ARGUMENTS AT RUN TIME. TWO-BYTE INSTRUCTION:
;	OPCODE
;	NUMBER OF BYTES TO SKIP OVER

HPIDO:	MOV	BX,[DI]		;GET VALUE TO INCREMENT BY
	ADD	DI,2		;ADVANCE PC
	ADD	HP,BX
	JC	HPIDO2		;ERROR IF CARRY
	MOV	AX,HEAPHI	;EXCEEDED HEAP SPACE?
	CMP	HP,AX
	JB	HPIDO1		;SKIP IF NOT
HPIDO2:	MOV	AL,2		; THEN FLAG I2L ERROR # 2
	CALL	ERROR
HPIDO1:	JMP	CMLRET		;GO GET NEXT CODE (BH#0)
	PAGE

;$0A
;ROUTINE TO RETRIEVE PROCEDURE ARGUMENTS FROM THE STACK
;AND PUT THEM ON THE HEAP. THE CALLED PROCEDURE WILL THEN
;RESERVE THE SPACE WITH AN "HPI" AND THE VARIABLES THUS
;CREATED WILL BE PRESET TO THEIR APPROPRIATE VALUES.
;TWO-BYTE INSTRUCTION:
;	OPCODE
;	NUMBER OF BYTES OF ARGUMENTS MINUS ONE.

ARGDO:	MOV	BL,[DI]		;GET NUMBER TO COPY
	INC	DI		;ADVANCE PC
	MOV	SI,HP		;GET HEAP POINTER
	JMP SHORT ARGDO2	;ENTER AT MINUS 1

ARGDO1:	DEC	BX		;COUNT BYTES
ARGDO2:	DEC	BX
	JS	ARGDO3		;EXIT IF POINTER NEGATIVE
	POP	[BX+SI]		;PUT TOS ON HEAP
	JMP	ARGDO1		;LOOP

ARGDO3:	JMP	CMLRET		;AND GET NEXT OPCODE


;$0B
;IMMEDIATE LOAD OF A 16-BIT CONSTANT ONTO THE STACK
;THREE BYTES:
;	OPCODE
;	LOW BYTE OF CONSTANT
;	HIGH BYTE OF CONSTANT

IMMDO:	PUSH	[DI]		;GET OPERAND AND PUT ON STACK
	ADD	DI,2		;ADVANCE PC
	JMP	OPGO		;GO GET NEXT OPCODE (BH=0)_
	PAGE

;$0C
;ROUTINE TO CALL AN INTRINSIC. NOTE THAT INTRINSICS ARE NOT
;SUBROUTINES--THEY RETURN BY A DIRECT JUMP TO "CMLRET".
;ARGUMENTS, IF ANY, ARE ON THE STACK IN THE ORDER THEY ARE
;CALLED (TOS IS LAST). IF AN INTRINSIC RETURNS A VALUE, IT WILL
;BE IN TOS. TWO-BYTE INSTRUCTION:
;	OPCODE
;	INTRINSIC NUMBER

CMLDO:	MOV	BL,[DI]		;GET INTRINSIC
	INC	DI		;ADVANCE PC
	SAL	BL,1		;TIMES 2 FOR INDEX
	JC	BADINT		;HANDLE ERROR (OPTIONAL)
	JMP	INTTBL[BX]	;DISPATCH TO INTRINSIC

;HERE IF WE DETECT AN ILLEGAL INTRINSIC NUMBER

BADINT:	MOV	AL,5		;I2L ERROR # 5
	CALL	ERROR		;REPORT ERROR, AND IF RETURN
	JMP	CMLRET		; GIVE IT OUR BEST SHOT
	PAGE

;	*** ARITHMETIC OPERATIONS ***

;THESE ROUTINES OPERATE ON THE TWO ITEMS ON THE TOP OF STACK
;(TOS AND NOS) AND RETURN ON RESULT IN TOS. THEY ARE ALL
;SINGLE-BYTE INSTRUCTIONS.
;
;$0D
;TOS:=NOS+TOS

ADDDO:	POP	AX		;GET ARGUMENTS
	POP	CX
	ADD	AX,CX		;ADD
	PUSH	AX
	JMP	OPGO		;GET NEXT OPCODE (BH=0)


;$0E
;TOS:=NOS-TOS

SUBDO:	POP	CX		;GET TOS
	POP	AX		;GET NOS
	SUB	AX,CX		;SUBTRACT
	PUSH	AX
	JMP	OPGO		;DO NEXT OPCODE (BH=0)


;$0F
;TOS:=NOS*TOS

MULDO:	POP	AX		;GET ARGUMENTS
	POP	CX
	IMUL	CX		;MULTIPLY
	PUSH	AX
	JMP	OPGO		;DO NEXT OPCODE (BH=0)
	PAGE

;$10
;TOS:=NOS/TOS

DIVDO:	POP	CX		;GET TOS
	POP	AX		;GET NOS
	OR	CX,CX		;DIVIDE BY ZERO?
	JNZ	DIVDO1		;SKIP IF NOT
	MOV	AL,1		;SET ERROR CODE
	CALL	ERROR		;HANDLE ERROR
	MOV	AX,07FFFH	;GIVE BEST ANSWER
	SUB	DX,DX
	JMP SHORT DIVDO2	;ENTER COMMON CODE

DIVDO1:	CWD			;CONVERT TO DOUBLE WORD
	IDIV	CX		;DO DIVIDE
DIVDO2:	PUSH	AX		;PUT RESULT ON STACK
	MOV	REMAIN,DX	;SAVE REMAINDER
	JMP	OPGO		;DO NEXT OPCODE (BH=0)


;$11
;TOS:= -TOS

NEGDO:	POP	AX		;GET ARGUMENT
	NEG	AX		;NEGATE IT
	PUSH	AX		;PUT ON STACK
	JMP	OPGO		;DO NEXT OPCODE (BH=0)
	PAGE

;	*** COMPARE OPERATIONS ***
;
;ALL COMPARES OPERATE ON THE TWO TOP ELEMENTS ON THE STACK AND
;RETURN EITHER A TRUE (=$FFFF) OR FALSE (=0) VALUE ON THE
;STACK. THEY ARE ALL ONE-BYTE INSTRUCTIONS.
;
;$12
;TOS:= TOS = NOS

EQDO:	POP	CX		;GET TOS
	POP	AX		;GET NOS
	CMP	AX,CX		;COMPARE
	JE	TRUE10		;SKIP IF TRUE
	PUSH	FALSE		;PUT FALSE ON STACK
	JMP	OPGO		;DO NEXT OP (BH=0)
TRUE10:	PUSH	TRUE		;PUT TRUE ON STACK
	JMP	OPGO		;DO NEXT OP (BH=0)


;$13
;TOS:= TOS # NOS

NEDO:	POP	CX		;GET TOS
	POP	AX		;GET NOS
	CMP	AX,CX		;COMPARE
	JNE	TRUE10		;SKIP IF TRUE
	PUSH	FALSE		;PUT FALSE ON STACK
	JMP	OPGO		;DO NEXT OP (BH=0)



;$14
;TOS:= NOS >= TOS

GEDO:	POP	CX		;GET TOS
	POP	AX		;GET NOS
	CMP	AX,CX		;COMPARE
	JGE	TRUE10		;SKIP IF TRUE
	PUSH	FALSE		;PUT FALSE ON STACK
	JMP	OPGO		;DO NEXT OP (BH=0)
	PAGE

;$15
;TOS:= NOS > TOS

GTDO:	POP	CX		;GET TOS
	POP	AX		;GET NOS
	CMP	AX,CX		;COMPARE
	JG	TRUE10		;SKIP IF TRUE
	PUSH	FALSE		;PUT FALSE ON STACK
	JMP	OPGO		;DO NEXT OP (BH=0)


;$16
;TOS:= NOS <= TOS

LEDO:	POP	CX		;GET TOS
	POP	AX		;GET NOS
	CMP	AX,CX		;COMPARE
	JLE	TRUE10		;SKIP IF TRUE
	PUSH	FALSE		;PUT FALSE ON STACK
	JMP	OPGO		;DO NEXT OP (BH=0)



;$17
;TOS:= NOS < TOS

LTDO:	POP	CX		;GET TOS
	POP	AX		;GET NOS
	CMP	AX,CX		;COMPARE
	JL	TRUE10		;SKIP IF TRUE
	PUSH	FALSE		;PUT FALSE ON STACK
	JMP	OPGO		;DO NEXT OP (BH=0)
	PAGE


;	*** FOR LOOP CONTROL ***

;$19
;INSTRUCTION TO INCREMENT A VARIABLE'S VALUE.
;IT LEAVES A COPY OF THE VARIABLE ON THE TOP OF THE STACK. THE
;STACKED VALUE MUST BE CORRECTLY DISPOSED OF LATER OF COURSE.
;CONVENTIONAL THREE-BYTE INSTRUCTION.

INCDO:	MOV	BL,[DI]		;GET LEVEL NUMBER OF VARIABLE
	INC	DI		;ADVANCE PC
	MOV	SI,DISPLY[BX]	;GET DISPLAY VECTOR
	MOV	BX,[DI]		;GET OFFSET TO VARIABLE
	ADD	DI,2		;ADVANCE PC
	INC	WORD PTR [BX+SI];INCREMENT VARIABLE
	PUSH	[BX+SI]		;GET VARIABLE AND PUT ON STACK
	JMP	CMLRET		;GO DO NEXT OPCODE (BH#0)


;$18
;THIS ROUTINE HANDLES THE TEST AND BRANCH OF THE 'FOR' LOOP.
;THE STACK IS ASSUMED TO CONTAIN THE LIMIT (NOS) AND A COPY OF
;THE LOOP CONTROL VARIABLE (TOS). THEY ARE COMPARED AND IF THE
;LOOP VARIABLE IS GREATER THAN THE LIMIT, THIS OPCODE'S ADDRESS
;IS BRANCHED TO, AND THE STACK IS CLEANED UP (THE 'FOR' LOOP IS
;DONE). OTHERWISE, THE PC IS ADVANCED TO THE NEXT OPCODE, AND
;THE LIMIT VALUE IS LEFT ON THE STACK (THE 'FOR' LOOP
;CONTINUES). THE CODE FOR THIS INSTRUCTION IS 3 BYTES LONG:
;	THE OPCODE
;	THE LOW ORDER OF THE BRANCH ADDRESS
;	THE HIGH ORDER OF THE BRANCH ADDRESS

FORDO:	POP	AX		;GET TOS - LOOP VARIABLE
	MOV	BP,SP		;POINT TO NOS
	CMP	AX,[BP]		;TEST IF DONE
	JG	FORDON		;SKIP IF DONE

	ADD	DI,2		;ADVANCE PC PAST ARGUMENTS
	JMP	OPGO		;CONTINUE WITH 'FOR' LOOP

;IF THE 'FOR' LOOP IS COMPLETE WE COME HERE

FORDON:	MOV	DI,[DI]		;SET NEW PC ADDRESS
	ADD	SP,2		;CLEAN STACK
	JMP	OPGO		;EXIT 'FOR' LOOP


;$4A
;INSTRUCTION TO DECREMENT A VARIABLE'S VALUE.
;IT LEAVES A COPY OF THE VARIABLE ON THE TOP OF THE STACK. THE
;STACKED VALUE MUST BE CORRECTLY DISPOSED OF LATER OF COURSE.
;CONVENTIONAL THREE-BYTE INSTRUCTION.

DECDO:	MOV	BL,[DI]		;GET LEVEL NUMBER OF VARIABLE
	INC	DI		;ADVANCE PC
	MOV	SI,DISPLY[BX]	;GET DISPLAY VECTOR
	MOV	BX,[DI]		;GET OFFSET TO VARIABLE
	ADD	DI,2		;ADVANCE PC
	DEC	WORD PTR [BX+SI];DECREMENT VARIABLE
	PUSH	[BX+SI]		;GET VARIABLE AND PUT ON STACK
	JMP	CMLRET		;GO DO NEXT OPCODE (BH#0)


;$49
;THIS ROUTINE HANDLES THE TEST AND BRANCH OF THE 'FOR' 'DOWNTO' LOOP.
;THE STACK IS ASSUMED TO CONTAIN THE LIMIT (NOS) AND A COPY OF
;THE LOOP CONTROL VARIABLE (TOS). THEY ARE COMPARED AND IF THE
;LOOP VARIABLE IS LESS THAN THE LIMIT, THIS OPCODE'S ADDRESS
;IS BRANCHED TO, AND THE STACK IS CLEANED UP (THE 'FOR' LOOP IS
;DONE). OTHERWISE, THE PC IS ADVANCED TO THE NEXT OPCODE, AND
;THE LIMIT VALUE IS LEFT ON THE STACK (THE 'FOR' LOOP
;CONTINUES). THE CODE FOR THIS INSTRUCTION IS 3 BYTES LONG:
;	THE OPCODE
;	THE LOW ORDER OF THE BRANCH ADDRESS
;	THE HIGH ORDER OF THE BRANCH ADDRESS

FORDDO:	POP	AX		;GET TOS - LOOP VARIABLE
	MOV	BP,SP		;POINT TO NOS
	CMP	AX,[BP]		;TEST IF DONE
	JL	FORDON		;SKIP IF DONE

	ADD	DI,2		;ADVANCE PC PAST ARGUMENTS
	JMP	OPGO		;CONTINUE WITH 'FOR' LOOP
	PAGE

;	*** BOOLEAN OPERATIONS ***

;$1A
;"OR" OPERATION--BITWISE ON ALL 16 BITS

ORDO:	POP	AX		;GET TOS
	POP	CX		;GET NOS
	OR	AX,CX		;DO OR
	PUSH	AX		;PUT IN TOS
	JMP	OPGO		;DO NEXT OPCODE (BH=0)


;$1B
;"AND" OPERATION--BITWISE ON ALL 16 BITS

ANDDO:	POP	AX		;GET TOS
	POP	CX		;GET NOS
	AND	AX,CX		;DO AND
	PUSH	AX		;PUSH ON STACK
	JMP	OPGO		;DO NEXT OPCODE (BH=0)


;$1C
;"NOT" COMPLEMENTS ALL SIXTEEN BITS

NOTDO:	POP	AX		;GET TOS
	NOT	AX		;NOT
	PUSH	AX		;PUT ON STACK
	JMP	OPGO		;DO NEXT OPCODE (BH=0)

;$1D
;EXCLUSIVE OR TOS AND NOS

EORDO:	POP	AX		;GET TOS
	POP	CX		;GET NOS
	XOR	AX,CX		;XOR IT
	PUSH	AX		;PUT ON STACK
	JMP	OPGO		;DO NEXT OPCODE (BH=0)


;$1E
;ROUTINE TO FORM TOS*2+NOS ONTO TOS (DBA). ONE-BYTE INSTRUCTION.

DOUBL:	POP	AX		;GET TOS
	SAL	AX,1		;TIMES 2
	POP	CX		;GET NOS
	ADD	AX,CX		;ADD IT IN
	PUSH	AX		;SAVE ON STACK
	JMP	OPGO		;DO NEXT OP (BH=0)
	PAGE

;$1F
;STORE TOS INTO ADDRESS IN NOS AND POP BOTH (STD). ONE-BYTE
;INSTRUCTION.

DEFSAV:	POP	AX		;GET TOS
	POP	SI		;GET NOS
	MOV	[SI],AX		;STORE TOS
	JMP	OPGO		;DO NEXT OP (BH=0)


;$20
;THIS ROUTINE FORMS TOS*2+NOS AND THEN USES THAT VALUE AS AN
;INDIRECT ADDRESS OF A WORD TO PUSH ONTO TOS (DBX). ONE-BYTE
;INSTRUCTION.

DEFER:	POP	SI		;GET TOS
	SAL	SI,1		;TIMES 2
	POP	BX		;GET NOS
	PUSH	[BX+SI]		;PUSH WORD THERE
	JMP	CMLRET		;DO NEXT OP (BH#0)


;$21
;LOAD THE ADDRESS OF A VARIABLE ONTO THE STACK.
;CONVENTIONAL THREE-BYTE INSTRUCTION.

ADDRDO:	MOV	BL,[DI]		;GET LEVEL NUMBER OF VARIABLE
	INC	DI		;ADVANCE PC
	MOV	SI,DISPLY[BX]	;GET DISPLAY VECTOR
	MOV	BX,[DI]		;GET OFFSET TO VARIABLE
	ADD	DI,2		;ADVANCE PC
	ADD	SI,BX		;ADD OFFSETS
	PUSH	SI		;SAVE ADDRESS ON STACK
	JMP	CMLRET		;GO DO NEXT OPCODE (BH#0)

;$22
;ROUTINE TO REPLACE TOS BY THE INTEGER IT POINTS TO.
;ONE-BYTE INSTRUCTION.

LDIDO:	POP	SI		;GET TOS
	PUSH	[SI]		;PUSH CONTENTS
	JMP	OPGO		;DO NEXT OP (BH=0)
	PAGE

;$23
;INSTRUCTION TO GET AN INTEGER FROM AN ABSOLUTE ADDRESS.
;THREE-BYTE INSTRUCTION:
;	OPCODE
;	LOW BYTE OF ADDRESS
;	HIGH BYTE OF ADDRESS

LDADO:	MOV	SI,[DI]		;GET ADDRESS
	ADD	DI,2		;ADVANCE PC
	PUSH	[SI]		;PUSH THE CONTENT
	JMP	OPGO		;DO NEXT OP (BH=0)


;$24
;SHORT IMMEDIATE LOAD OF AN 8-BIT, SIGNED VALUE.
; TWO-BYTE INSTRUCTION:
;	OPCODE
;	VALUE TO LOAD

SIMMDO:	MOV	AL,[DI]		;GET ARGUMENT
	INC	DI		;ADVANCE PC
	CBW			;EXTEND THE SIGN
	PUSH	AX		;SAVE ON STACK
	JMP	CMLRET		;DO NEXT OP (BH#0)


;$25
;THIS ROUTINE OPTIMIZES THE CASE STATEMENT A LITTLE BIT.
;IT POPS TOS, COMPARES TOS TO NOS AND TAKES THE BRANCH
;ONLY IF NOS WAS NOT EQUAL TO TOS.

CAJMP:	POP	CX		;GET TOS
	MOV	BP,SP		;POINT TO TOS
	CMP	[BP],CX		;COMPARE
	JE	CAJMP1		;SKIP IF EQUAL
	MOV	DI,[DI]		;GET NEW ADDRESS
	JMP	OPGO

;HERE IF WE DON'T JUMP

CAJMP1:	ADD	DI,2		;ADVANCE PC
	JMP	OPGO
	PAGE

;$26
;OPTIMIZED PROCEDURE CALL. USED ONLY IF NO LOCAL VARAIBLES ARE
;PRESENT.  SCOPE IS UNCHANGED THUS IT IS EQUIVALENT TO A MACHINE
;LANGUAGE JSR.

JSRDO:	ADD	DI,2		;POINT TO NEXT OP
	PUSH	DI		;SAVE OLD PC
	MOV	DI,[DI]-2		;SET NEW ADDRESS
	JMP	OPGO


;$27
;OPTIMIZED RETURN, TO MATCH THE ABOVE CALL

RTSDO:	POP	DI		;RESTORE OLD ADDRESS
	JMP	OPGO

;$28
;ROUTINE TO POP TOS & DISCARD IT

DRPDO:	ADD	SP,2		;POP STACK
	JMP	OPGO

;$29
;CALL EXTERNAL SUBROUTINE.  THIS ALLOWS ACCESS TO APPLICATION-
;SPECIFIC, MACHINE-LANGUAGE SUBROUTINES. THE ABSOLUTE ADDRESS  
;APPEARS IN THE INSTRUCTION DIRECTLY.  ARGUMENTS, IF ANY, ARE
;PASSED VIA THE STACK.

EXTDO:	MOV	SI,[DI]		;GET EXTERN ADDRESS
	ADD	DI,2		;ADVANCE PC
	MOV	DISAV,DI
	PUSH	CS		;MAKE IT LOOK LIKE A FAR CALL
	CALL	SI		;CALL ROUTINE
	MOV	DI,DISAV
	JMP	CMLRET		;GO EXECUTE NEXT OPCODE
DISAV	DW	0

;$3D
;"ASR" ARITHMETIC SHIFT RIGHT
; NOS ->> TOS
; SHIFT COUNT IS MODULO 32 TO MAKE 8086 AND 286/386 WORK THE SAME

ASRDO:	POP	CX		;GET SHIFT COUNT FROM TOS
	POP	AX		;GET NOS
	SAR	AX,CL		;SHIFT IT, ARITHMETICALLY
	PUSH	AX		;PUT ON TOS
	JMP	OPGO		;DO NEXT OP (BH=0)

;$3E
;"LSL" LOGICAL SHIFT LEFT
; NOS << TOS
; SHIFT COUNT IS MODULO 32 TO MAKE 8086 AND 286/386 WORK THE SAME

LSLDO:	POP	CX		;GET SHIFT COUNT FROM TOS
	POP	AX		;GET NOS
	SHL	AX,CL		;SHIFT IT
	PUSH	AX		;PUT ON TOS
	JMP	OPGO		;DO NEXT OP (BH=0)

;$3F
;"LSR" LOGICAL SHIFT RIGHT
; NOS >> TOS
; SHIFT COUNT IS MODULO 32 TO MAKE 8086 AND 286/386 WORK THE SAME

LSRDO:	POP	CX		;GET SHIFT COUNT FROM TOS
	POP	AX		;GET NOS
	SHR	AX,CL		;SHIFT IT
	PUSH	AX		;PUT ON TOS
	JMP	OPGO		;DO NEXT OP (BH=0)
	PAGE
;OPCODES FOR 'SEGMENT' TYPE VARIBABLES

;OPCODES FOR 'SEGMENT' LOAD INSTRUCTIONS
;TOS=OFFSET, NOS=SEGMENT

;$40
;LOAD AN INTEGER FROM A SEGMENT VARIABLE

LDSIDO:	POP	BX	;GET OFFSET
	SAL	BX,1	;TIMES 2 BECAUSE IT IS AN INTEGER
	POP	DS	;GET THE SEGMENT
	PUSH	[BX]	;LOAD THE INTEGER
	MOV	AX,ES	;RESTORE DATA SEGMENT
	MOV	DS,AX
	JMP	CMLRET	;RETURN (BH#0)


;$41
;LOAD A BYTE FROM A SEGMENT VARIABLE

LDSBDO:	POP	BX	;GET OFFSET
	POP	DS	;GET THE SEGMENT
	MOV	AL,[BX]	;GET THE BYTE
	XOR	AH,AH	;ZERO HIGH PART
	PUSH	AX	;SAVE ON STACK
	MOV	AX,ES	;RESTORE DATA SEGMENT
	MOV	DS,AX
	JMP	CMLRET	;RETURN (BH#0)


;$42
;ROUTINE TO LOAD A REAL FROM SEGMENT TYPE VARIABLE
;OFFSET IS IN AX (TOS) AND SEGMENT IS IN NOS

LDSRDO:	POP	AX		;GET OFFSET
	POP	CX		;GET THE SEGMENT

;MULTIPLY SEGMENT BY 8 AND CONVERT TO CANONICAL FORM
;SEG= SEG + (OFF*8)/16   OFF= 8 if ODD, 0 if EVEN;

	SUB	BX,BX		;START WITH ZERO
	SHR	AX,1		;DIVIDE OFFSET BY TWO
	SBB	BX,0		;OFFSET WILL BE 0 OR 8 
	AND	BX,08H		;MASK FOR 8 OR 0
	ADD	CX,AX		;ADD OFFSET PART TO SEGMENT
	MOV	DS,CX		;PUT INTO SEGMENT REGISTER

	PUSH	[BX]		;LOAD THE REAL
	PUSH	[BX]+2
	PUSH	[BX]+4
	PUSH	[BX]+6
	MOV	AX,ES		;RESTORE DS
	MOV	DS,AX
	JMP	CMLRET		;RETURN (BH#0)



;OPCODES FOR 'SEGMENT' STORE INSTRUCTIONS
;TOS=VALUE, NOS=OFFSET, NOS=SEGMENT

;$43
;STORE AN INTEGER FROM A SEGMENT VARIABLE

STSIDO:	POP	AX	;GET THE VALUE TO STORE
	POP	BX	;GET OFFSET
	SAL	BX,1	;TIMES 2 BECAUSE IT IS AN INTEGER
	POP	DS	;GET THE SEGMENT
	MOV	[BX],AX	;STORE THE INTEGER
	MOV	AX,ES	;RESTORE DATA SEGMENT
	MOV	DS,AX
	JMP	CMLRET	;RETURN (BH#0)


;$44
;STORE A BYTE FROM A SEGMENT VARIABLE

STSBDO:	POP	AX	;GET VALUE TO STORE
	POP	BX	;GET OFFSET
	POP	DS	;GET THE SEGMENT
	MOV	[BX],AL	;STORE THE BYTE
	MOV	AX,ES	;RESTORE DATA SEGMENT
	MOV	DS,AX
	JMP	CMLRET	;RETURN (BH#0)


;$45
;ROUTINE TO STORE A REAL INTO A SEGMENT TYPE VARIABLE
;VALUE IS IN TOS, OFFSET IS IN NOS AND SEGMENT IS IN NOS

STSRDO:	MOV	BP,SP			;GET STACK FRAME
	MOV	AX,[BP]+RELSIZ		;GET OFFSET
	MOV	CX,[BP]+RELSIZ+2	;GET SEGMENT

;MULTIPLY SEGMENT BY 8 AND CONVERT TO CANONICAL FORM
;SEG= SEG + (OFF*8)/16   OFF= 8 if ODD, 0 if EVEN;

	SUB	BX,BX		;START WITH ZERO
	SHR	AX,1		;DIVIDE OFFSET BY TWO
	SBB	BX,0		;OFFSET WILL BE 0 OR 8 
	AND	BX,08H		;MASK FOR 8 OR 0
	ADD	CX,AX		;ADD OFFSET PART TO SEGMENT
	MOV	DS,CX		;PUT INTO SEGMENT REGISTER

	POP	[BX]+6			;STORE REAL
	POP	[BX]+4
	POP	[BX]+2
	POP	[BX]
	MOV	AX,ES		;RESTORE DS
	MOV	DS,AX
	ADD	SP,4		;ADJUST STACK
	JMP	CMLRET	;RETURN (BH#0)
	PAGE

;$46
;ROUTINE TO LOAD A SHORT REAL FROM SEGMENT TYPE VARIABLE
;SHORT IS CONVERTED TO LONG AND PLACED ON THE STACK
;OFFSET IS IN AX (TOS) AND SEGMENT IS IN NOS

LSHORT:	POP	AX		;GET OFFSET
	POP	CX		;GET THE SEGMENT

;MULTIPLY SEGMENT BY 4 AND CONVERT TO CANONICAL FORM
;SEG= SEG + (OFF*4)/16

	MOV	BX,AX		;GET OFFSET
	AND	BX,3		;ISOLATE 0-3 PART OF OFFSET
	SHL	BX,1		;TIMES FOUR
	SHL	BX,1
	SHR	AX,1		;DIVIDE BY 4 (4/16 = 1/4 = .25)
	SHR	AX,1
	ADD	CX,AX		;ADD OFFSET PART TO SEGMENT
	MOV	DS,CX		;PUT INTO SEGMENT REGISTER

	MOV	AX,[BX]		;LOAD THE REAL
	MOV	BX,[BX]+2

;CONVERT SHORT IN AX, BX TO LONG IN AX, BX, CX, DX

	MOV	DH,AH		;SAVE SIGN BIT
	AND	DH,80H		;ISOLATE SIGN BIT
	AND	AH,7FH		;STIP SIGN BIT
	SUB	CX,CX		;ZERO CX

	SHR	AX,1		;SHIFT WHOLE THING THREE BITS RIGHT
	RCR	BX,1
	RCR	CX,1
	SHR	AX,1
	RCR	BX,1
	RCR	CX,1
	SHR	AX,1
	RCR	BX,1
	RCR	CX,1

	TEST	AX,0FF0H	;ZERO EXPONENT
	JZ	LSHRT1		;THEN EXIT
	CMP	AX,0FF0H	;MAXIMUM EXPONENT
	JAE	LSHINF		;THEN SET SPECIAL EXPONENT

	SUB	AX,07F0H	;UNBIAS EXPONENT
	ADD	AX,03FF0H	;BIAS EXPONENT
LSHRT1:	OR	AH,DH		;RESTORE SIGN
	PUSH	AX		;PUT LONG REAL ON STACK
	PUSH	BX
	PUSH	CX
	SUB	DX,DX		;M3=0
	PUSH	DX

	MOV	AX,ES		;RESTORE DS
	MOV	DS,AX
	JMP	CMLRET		;RETURN (BH#0)

;HANDLE SPECIAL EXPONENT

LSHINF:	OR	AX,7FF0H	;CONVERT TO MAX EXPONENT FOR LONG REAL
	JMP SHORT LSHRT1	;AND EXIT
	PAGE

;$47
;ROUTINE TO STORE A SHORT REAL INTO A SEGMENT TYPE VARIABLE
;VALUE IS IN TOS, OFFSET IS IN NOS AND SEGMENT IS IN NOS

SSHORT:	ADD	SP,2		;DROP BOTTOME OF STACK
	POP	DX		;GET LONG REAL FROM STACK
	POP	CX
	POP	AX

;ROUTINE TO CONVERT A LONG REAL TO A SHORT REAL

	MOV	DL,AH		;SAVE SIGN BIT
	AND	DL,80H		;ISOLATE SIGN BIT

	AND	AX,7FFFH	;STRIP SIGN BIT
	CMP	AX,7FF0H	;SPECIAL NUMBER TYPE?
	JAE	SSHRT1		;EXIT IF SPECIAL
	TEST	AX,7FF0H	;TEST FOR ZERO EXPONENT
	JZ	SSHRT1		;THEN DON'T BIAS

	SUB	AX,3FF0H	;UNBIAS EXPONENT
	CMP	AX,0800H	;EXPONENT OVERFLOW?
	JGE	SSOVER		;HANDLE OVERFLOW
	CMP	AX,0F810H	;EXPONENT UNDERFLOW?
	JLE	SSUNDR		;HANDLE UNDERFLOW
	ADD	AX,07F0H	;BIAS EXPONENT

SSHRT1:	SHL	DH,1		;SHIFT WHOLE THING THREE BITS LEFT
	RCL	CX,1
	RCL	AX,1
	SHL	DH,1
	RCL	CX,1
	RCL	AX,1
	SHL	DH,1
	RCL	CX,1
	RCL	AX,1
	OR	AH,DL		;RESTORE SIGN BIT

;MULTIPLY SEGMENT BY 4 AND CONVERT TO CANONICAL FORM
;SEG= SEG + (OFF*4)/16

SSHRT2:	POP	BX		;GET OFFSET
	MOV	DX,BX		;SAVE OFFSET
	POP	BP		;GET SEGMENT
	AND	BX,3		;ISOLATE 0-3 PART OF OFFSET
	SHL	BX,1		;TIMES FOUR
	SHL	BX,1
	SHR	DX,1		;DIVIDE BY 4 (4/16 = 1/4 = .25)
	SHR	DX,1
	ADD	BP,DX		;ADD OFFSET PART TO SEGMENT
	MOV	DS,BP		;PUT INTO SEGMENT REGISTER

	MOV	[BX],AX		;STORE SHORT REAL
	MOV	[BX]+2,CX

	MOV	AX,ES		;RESTORE DS
	MOV	DS,AX
	JMP	CMLRET	;RETURN (BH#0)

;HANDLE OVERFLOW

SSOVER:	MOV	AX,7F80H	;GET INFINITY
	OR	AH,DH		;OR IN THE CORRECT SIGN
	SUB	CX,CX		;ZERO MANTISSA
	JMP	SSHRT2		;ENTER COMMON CODE

;HANDLE UNDERFLOW

SSUNDR:	SUB	AX,AX		;ZERO EXPONENT AND MANTISSA
	MOV	CX,AX
	JMP	SSHRT2		;ENTER COMMON CODE
	PAGE

;$48
;ROUTINE TO RESERVE A MULTI-DIMENSIONAL ARRAY
; FOR EXAMPLE: MKARRAY((3, 5, 7, 11), 4, 2, addr ARRAYNAME);
; THE STACK CONTAINS:
;   THE NUMBER OF ELEMENTS IN EACH DIMENSION (3, 5, 7, 11)
;   THE NUMBER OF DIMENSIONS (4)
;   THE NUMBER OF BYTES IN EACH ELEMENT OF THE ARRAY (1=CHAR, 2=INT, 8=REAL)
;   THE ADDRESS OF THE POINTER TO THE ARRAY (A POINTER TO A POINTER)
;    (NOTE: THIS ROUTINE SETS THE POINTER TO THE SPACE IT RESERVES)

LEVMAX	DW	0		;MAXIMUM LEVEL OF RECURSION (LAST DIMENSION)

MKARRAY:MOV	DISAV,DI	;SAVE PROGRAM COUNTER IN DI REGISTER
	POP	BX		;GET ADDRESS OF POINTER TO ARRAY
	POP	DI		;GET NUMBER OF BYTES IN EACH ELEMENT
	POP	AX		;GET NUMBER OF DIMENSIONS
	DEC	AX		;CONVERT TO MAXIMUM INDEX OFF OF BP (LEVMAX)
	ADD	AX,AX		;DOUBLE FOR WORD ENTRIES ON THE STACK
	MOV	BP,AX
	ADD	BP,SP		;POINT TO NUMBER OF ELEMENTS IN 1ST DIMENSION
	NEG	AX
	MOV	LEVMAX,AX

	SUB	SI,SI		;SET INDEX TO POINT TO SIZE OF FIRST DIMENSION
	CALL	GENARY		;RESERVE FIRST DIMENSION OF ARRAY AND STORE ITS
				; BASE ADDRESS INTO LOCATION POINTED TO BY BX
	ADD	BP,2		;CLEAN UP STACK--DISCARD ARGUMENTS
	MOV	SP,BP
	MOV	DI,DISAV	;RESTORE PROGRAM COUNTER IN DI REGISTER
	JMP	CMLRET		;GO GET NEXT CODE (BH#0)


;RECURSIVELY CALLED SUBROUTINE FOR SETTING UP A MULTI-DIMENSIONAL ARRAY.
;RESERVE AN ARRAY AND STORE ITS BASE ADDRESS INTO THE LOCATION POINTED TO
; BY THE BX REGISTER.
;REGISTER USAGE (* INDICATES INPUT VALUES):
;	AX - SCRATCH
;  *	BX - ADDRESS OF POINTER TO NEXT DIMENSION OF ARRAY
;	CX - LOOP COUNTER AND INDEX
;	DX - BASE ADDRESS OF CURRENT DIMENSION OF ARRAY
;  *	DI - NUMBER OF BYTES IN AN ELEMENT (1, 2 OR 8)
;  *	SI - INDEX TO SIZE OF EACH DIMENSION, ALSO LEVEL OF RECURSION (* -2)
;  *	BP - POINTS TO FIRST ARGUMENT ON THE STACK (SIZE OF FIRST DIMENSION)

GENARY:	MOV	AX,[BP+SI]	;GET NUMBER OF ELEMENTS FOR CURRENT DIMENSION
	MOV	CX,AX		;SAVE FOR POSSIBLE USE BY LOOP COUNTER BELOW

;RESERVE SPACE ON HEAP
	CMP	SI,LEVMAX	;IS THIS THE LAST DIMENSION?
	JG	GA02		;SKIP IF NOT
	CMP	DI,1		;IS THIS A CHAR ARRAY?
	JE	GA07		;JUMP IF SO (LAST DIMENSION IS A SINGLE BYTE)
GA02:	CMP	DI,8		;IS THIS A REAL ARRAY?
	JNE	GA05		;SKIP IF NOT
	ADD	AX,AX		;MULTIPLY ELEMENTS BY 8 BYTES PER REAL NUMBER
	JC	GA10		;CHECK FOR MEMORY OVERFLOW: ERROR IF > $FFFF
	ADD	AX,AX
	JC	GA10
GA05:	ADD	AX,AX		;MULTIPLY ELEMENTS BY 2 BYTES PER INTEGER
	JC	GA10		;CHECK FOR MEMORY OVERFLOW: ERROR IF > $FFFF
GA07:	MOV	DX,HP		;DX = BASE OF RESERVED HEAP SPACE
	ADD	HP,AX		;ADD NUMBER OF BYTES TO RESERVE TO HEAP POINTER
	JC	GA10		;CHECK FOR MEMORY OVERFLOW: ERROR IF > $FFFF
	MOV	AX,HEAPHI	;CHECK FOR MEMORY OVERFLOW
	CMP	HP,AX
	JB	GA20		;SKIP IF OK
GA10:	MOV	AL,2		;ERROR 2: MEMORY OVERFLOW
	CALL	ERROR
GA20:	MOV	[BX],DX		;STORE BASE ADDRESS OF RESERVED SPACE INTO PTR

	CMP	SI,LEVMAX	;IS THIS THE LAST DIMENSION?
	JLE	GA90		;JUMP IF SO--DON'T RECURSE ANY LOWER

	SUB	AX,AX		;INITIALIZE INDEX TO FIRST ELEMENT
GA30:	CMP	AX,CX		;IS INDEX BEYOND LIMIT?
	JAE	GA90		;JUMP IF SO--EXIT LOOP

	SUB	SI,2		;ADVANCE INDEX TO NEXT DIMENSION SIZE ON STACK
	MOV	BX,AX		;GET INDEX FOR ELEMENT IN CURRENT DIMENSION
	CMP	DI,8		;IS THIS A REAL ARRAY?
	JNE	GA40		;SKIP IF NOT
	ADD	BX,BX		;RESERVE SPACE FOR 8 BYTES
	ADD	BX,BX
GA40:	ADD	BX,BX		;MULTIPLY BY 2 TO INDEX BY WORDS
	ADD	BX,DX		;ADD BASE ADDRESS OF RESERVED SPACE (CURRENT DIM)

	PUSH	AX		;SAVE SOME THINGS (INDEX, LIMIT, BASE ADDR)
	PUSH	CX
	PUSH	DX
	CALL	GENARY		;RESERVE NEXT DIMENSION OF ARRAY AND STORE ITS
	POP	DX		; BASE ADDRESS INTO LOCATION POINTED TO BY BX
	POP	CX		;RESTORE THINGS
	POP	AX
	ADD	SI,2		;RESTORE INDEX TO PREVIOUS DIMENSION SIZE ON STK

	INC	AX		;NEXT ELEMENT
	JMP	SHORT GA30	;LOOP FOR EACH ELEMENT IN THIS DIMENSION

GA90:	RET

;$4E
;TOS:= port(TOS)

PINDO:	POP	DX		;GET PORT ADDRESS
	IN	AL,DX		;READ IN PORT
	XOR	AH,AH		;CLEAR HIGH BYTE
	PUSH	AX		;PUT ON STACK
	JMP	OPGO		;DO NEXT OPCODE (BH=0)

;$4F
;port(NOS):= TOS

POUTDO:	POP	AX		;GET PORT ADDRESS
	POP	DX
	OUT	DX,AL		;READ IN PORT
	JMP	OPGO		;DO NEXT OPCODE (BH=0)

	PAGE

;I2L ERROR HANDLER
; A-REG CONTAINS THE ERROR NUMBER

ERROR:	MOV	ERRNUM,AL	;SAVE THE ERROR NUMBER
	MOV	DL,AL		;GET ERROR NUMBER
	MOV	CX,TRAPS	;GET TRAPS

ERR10:	SHR	CX,1		;SHIFT TRAP BITS TO CARRY
	DEC	DL		;COUNT ERROR CODES
	JNZ	ERR10		;LOOP UNTIL ZERO
	JC	STKDMP		;IF BIT IS SET HANDLE ERROR
	RET


;EXAMINE STACK AND DISPLAY NESTED ALL
;SUBROUTINE CALL'S LEVEL AND RETURN ADDRESS

STKDMP:	MOV	NOWDEV,0	;SET DEVICE CHANNEL
	CALL	CRLF		;NEW LINE

	MOV	BP,STACKHI-10	;FIRST POSSIBLE SUBROUTINE CALL
	MOV	CX,10		;OUTPUT A MAXIMUM OF TEN CALLS
	MOV	DX,30		;SET STACK LIMIT

;PROBABLE STACK WORD WILL BE: NOT ZERO, EVEN AND 14 OR LESS

STKDP1:	MOV	AX,[BP]		;GET STACK WORD
	CMP	AX,0		;LEVEL 0?
	JE	NOTLEV		;EXIT IF YES
	TEST	AX,1		;IS IT ODD?
	JNZ	NOTLEV		;EXIT IF YES
	CMP	AX,14		;AX > 14?
	JA	NOTLEV		;EXIT IF YES

;OUTPUT LEVEL AND RETURN ADDRESS

	PUSH	BP		;SAVE REGISTERS
	PUSH	CX
	PUSH	DX

	PUSH	[BP-4]		; SAVE I2L RETURN ADDRESS
	CALL	WRDOUT		;DISPLAY WORD
	MOV	AL,':'		;OUTPUT A COLON
	CALL	CONOUT
	POP	AX		;RESTORE RETURN ADDRESS
	SUB	AX,PROGLO	;CONVERT TO ZERO BASE
	CALL	WRDOUT		;DISPLAY IT
	CALL	CRLF		;NEW LINE

	POP	DX		;RESTORE REGISTERS
	POP	CX
	POP	BP
	DEC	CX		;COUNT OUTPUTS

NOTLEV:	SUB	BP,2		;POINT TO NEXT LOCATION
	CMP	BP,SP		;DONE?
	JB	STKDPX		;THEN EXIT
	JCXZ	STKDPX		;EXIT IF AT LIMIT
	DEC	DX		;TEST LIMIT
	JNZ	STKDP1		;LOOP UNTIL DONE

STKDPX:	JMP	EXITDO		; ELSE EXIT INTERPRETER
