	PAGE
;******* XPL INTRINSICS MODULE ********

;ASSUMES TOS IS IN AX REGISTER, OTHER ARGUMENTS ARE ON THE STACK.
;SI, DI AND ALL SEGMENT REGISTERS MUST BE PRESERVED. (ES = 0)

;THIS TABLE IS AN INDEX OF INTRINSIC LABELS.
;EACH INTRINSIC HAS TWO LABELS:
;
;1) A NUMBERED LABEL GENERATED BY THE COMPILER WHEN IT GENERATES AN
;   INTRINSIC CALL.
;2) A FUNCTIONAL LABEL THAT CAN BE USED INTERNAL TO THE RUNTIME PACKAGE


;INTR0	-  ABSFUN	- 0 ABSOLUTE VALUE
;INTR1	-  RANFUN	- 1 RANDOM NUMBER
;INTR2	-  REMFUN	- 2 REMAINDER OF LAST DIVIDE
;INTR3	-  RESERV	- 3 RESERVE ARRAY
;INTR4	-  SWAPFU	- 4 SWAP BYTES
;INTR5	-  EXTEN	- 5 EXTEND SIGN FROM LOW BYTE
;INTR6	-  RESTRT	- 6 RESTART CURRENT PROGRAM
;INTR7	-  CHIN		- 7 INPUT A BYTE
;INTR8	-  CHOUT	- 8 OUTPUT A BYTE
;INTR9	-  SKIP		- 9 NEW LINE (CRLF)
;INTR10	-  INTIN	- 10 INPUT AN INTEGER
;INTR11	-  INTOUT	- 11 OUTPUT AN INTEGER
;INTR12	-  TEXT		- 12 OUTPUT A STRING
;INTR13	-  IDEVIN	- 13 INITIALIZE INPUT DEVICE
;INTR14	-  ODEVIN	- 14 INITIALIZE OUTPUT DEVICE
;INTR15	-  ODEVCL	- 15 CLOSE AN OUTPUT DEVICE
;INTR16	-  ABORT	- 16 ABORT PROGRAM (LIKE A CTRL-P)
;INTR17	-  TRAP		- 17 SET TRAP FLAG
;INTR18	-  SPACE	- 18 DETERMINE REMAINING SPACE
;INTR19	-  RERUN	- 19 TEST RERUN FLAG
;INTR20	-  TSTHP	- 20 GET CURRENT HEAP POINTER
;INTR21	-  SETHP	- 21 SET HEAP POINTER
;INTR22	-  GETERR	- 22 GET I2L ERROR NUMBER
;INTR23	-  CURSOR	- 23 SET TV CURSOR POSITION
;INTR24	-  FSET		- 24 SET A FILE HANDLE
;INTR25	-  SETRUN	- 25 SET THE RERUN FLAG
;INTR26	-  HEXI		- 26 INPUT HEX INTEGER
;INTR27	-  HEXO		- 27 OUTPUT HEX INTEGER
;INTR28	-  CHAIN	- 28 CHAIN TO A SAVE FILE
;INTR29	-  FOPEN	- 29 OPEN NEW FILE
;INTR30	-  FWRITE	- 30 WRITE DISK BLOCKS
;INTR31	-  FREAD	- 31 READ DISK BLOCKS
;INTR32	-  FCLOSE	- 32 CLOSE DISK FILE

;INTR33	-  CHKKEY	- 33 CHECK FOR KEY STRIKE
;INTR34	-  SFTINT	- 34 DO SOFTWARE INTERRUPT
;INTR35	-  GETREG	- 35 GET REGISTER ADDRESS
;INTR36	-  BLKTRN	- 36 BLOCK TRANSFER
;INTR37	-  PEEK		- 37 PEEK MEMORY

;INTR38	-  POKE		- 38 POKE INTO MEMORY
;INTR39	-  SOUND	- 39 SQUEAK THE SPEAKER
;INTR40	-  VCLEAR	- 40 CLEAR VIDEO DISPLAY
;INTR41	-  DOT		- 41 PLOT HI-RES POINT
;INTR42	-  LINE		- 42 DRAW A HI-RES LINE
;INTR43	-  MOVE		- 43 HI-RES MOVE
;INTR44	-  REDDOT	- 44 READ BACK PIXEL
;INTR45	-  VIDMOD	- 45 SET VIDEO MODE
	PAGE

;INTR46	-  FLRES	- 46 RESERVE MEMORY FOR REALS
;INTR47	-  FLIN		- 47 INPUT A REAL NUMBER
;INTR48	-  FLOUT	- 48 OUTPUT A REAL NUMBER
;INTR49	-  FLTFUN	- 49 CONVERT INTEGER TO REAL
;INTR50	-  FIXFUN	- 50 CONVERT REAL TO INTEGER
;INTR51	-  FLABS	- 51 ABSOLUTE VALUE OF REAL
;INTR52	-  FMTFUN	- 52 PLACES BEFORE & AFTER DEC POINT

;INTR53	-  FLSQRT	- 53 TOS:=SQRT(TOS)
;INTR54	-  FLLN		- 54 TOS:=LN(TOS)
;INTR55	-  FLEXP	- 55 TOS:=EXP(TOS)
;INTR56	-  FLSIN	- 56 TOS:=SIN(TOS)
;INTR57	-  FLAT2	- 57 TOS:=ATAN(NOS/TOS)
;INTR58	-  FLMOD	- 58 TOS:= NOS MOD TOS
;INTR59	-  FLLOG	- 59 TOS:=LOG(TOS)
;INTR60	-  FLCOS	- 60 TOS:=COS(TOS)
;INTR61	-  FLTAN	- 61 TOS:=TAN(TOS)
;INTR62	-  FLASIN	- 62 TOS:=ASIN(TOS)
;INTR63	-  FLACOS	- 63 TOS:=ACOS(TOS)

;INTR64	-  POUT		- 64 OUTPUT TO PORT
;INTR65	-  PIN		- 65 INPUT FROM PORT
;INTR66	-  INTRET	- 66 EXIT I2L VIA IRET
;INTR67	-  EXTJMP	- 67 JUMP TO FAR ROUTINE
;INTR68	-  EXTCAL	- 68 CALL FAR ROUTINE

;INTR69	-  SETATT	- 69 SET WINDOW ATTRIBUTE
;INTR70	-  SETWND	- 70 SET WINDOW PARAMETERS
;INTR71	-  RAWTXT	- 71 RAW TEXT STRING OUTPUT
;INTR72	-  HLIGHT	- 72 HIGHLIGHT AN AREA OF THE SCREEN

;INTR73	-  MALLOC	- 73 ALLOCATE MEMORY
;INTR74	-  RELEAS	- 74 RELEASE MEMORY
;INTR75	-  TRAPC	- 75 TRAP CONTROL-C
;INTR76	-  TESTC	- 76 TEST CONTROL-C
;INTR77 -  GETEQP	- 77 GET EQUIPMENT LIST
;INTR78 -  SHRINK	- 78 SHRINK PROGRAM SIZE
;INTR79 -  RANSEED	- 79 SET SEED FOR RANDOM NUMBER GENERATOR
;INTR80 -  IRQ		- 80 TURN IRQ OFF OR ON
	PAGE

;START UP INITIALIZATION FOR INTRINSICS MODULE

SETINT	PROC	NEAR
	CALL	RANINT		;RESET RANDOM SEED
	CALL	RESFULLWND	;RESET DEVICE 6 TO FULL SCREEN
	CALL	RESDIB		;RESET DISK BUFFERS
	CALL	RESDOB
	RET
SETINT	ENDP

;**  INTRINSIC #0
;INTRINSIC TO RETURN THE ABSOLUTE VALUE OF TOP OF STACK

INTR0	LABEL	FAR
ABSFUN	PROC	FAR
	TEST	AX,8000H
	JZ	ABS10
	NEG	AX
ABS10:	RET
ABSFUN	ENDP

;RANDOMIZE RANDOM NUMBER GENERATOR
;USES SYSTEM INTERRUPT COUNTER

RANLOC	EQU	46CH		;LOCATION OF RANDOMIZER
RANSEG	EQU	0		;SEGMENT OF RANDOMIZER

RANINT	PROC	NEAR
	PUSH	ES		;SAVE SEGMENT
	MOV	AX,RANSEG	;SET SEGMENT
	MOV	ES,AX
	MOV	AX,ES:RANLOC	;GET RANDOM SEED
	OR	AX,4		;MAKE SURE IT'S NOT ZERO
	MOV	RANK,AX		;SET SEED
	POP	ES		;RESTORE SEGMENT
	RET
RANINT	ENDP
	PAGE

;**  INTRINSIC #1
;GENERATE RANDOM NUMBER BETWEEN 0 AND (TOP OF STACK)-1
; IF TOS = 0 THEN INITIALIZE SEED FOR REPEATABLE SEQUENCE
; IF TOS < 0 THEN RANDOMIZE AND RETURN RAN(-TOS)

DSEG	SEGMENT WORD PUBLIC 'DATA'
RANK	DW	2537
RANL	DW	5149
RANM	DW	7026
DSEG	ENDS

MODK	EQU	33049		;PRIME NUMBERS THAT GIVE GOOD RESULTS
MODL	EQU	32909
MODM	EQU	32771

INTR1	LABEL	FAR
RANFUN	PROC	FAR
	TEST	AX,AX		;RANGE IS IN AX; CHECK FOR ZERO
	JNE	RAN01		;BRANCH IF NOT ZERO

	MOV	RANK,2537	;SET SEEDS FOR A REPEATABLE SEQUENCE
	MOV	RANL,5149
	MOV	RANM,7026
	RET

RAN01:	MOV	BX,AX		;SAVE RANGE
	JNS	RAN05
	NEG	BX
	CALL	RANINT		;RANDOMIZE SEED
RAN05:
	MOV	AX,RANK		;RANK:= REM((RANK+RANK) /MODK);
	ADD	AX,AX
	CMP	AX,MODK
	JB	RAN10
	SUB	AX,MODK
RAN10:	MOV	RANK,AX

	MOV	AX,RANL		;RANL:= REM((RANL+RANL) /MODL);
	ADD	AX,AX
	CMP	AX,MODL
	JB	RAN20
	SUB	AX,MODL
RAN20:	MOV	RANL,AX

	ADD	AX,RANK		;RANM:= REM((RANK+RANL+RANM) /MODM);
	ADD	AX,RANM
RAN30:	CMP	AX,MODM
	JB	RAN35
	SUB	AX,MODM
	JMP	SHORT RAN30
RAN35:	MOV	RANM,AX

	MOV	DH,AL		;MAKE BIT 15 IN AX RANDOM (IT'S USUALLY 0)
	AND	DH,80H		;ESSENTIALLY COPY BIT 7 INTO BIT 15
	XOR	AH,DH

	MOV	DL,AL		;AVOID BIAS ERRORS FOR LARGE RANDOM NUMBERS
	SUB	DH,DH		; BY USING A LARGE DIVIDEND
	TEST	BH,BH		;AVOID DIVIDE OVERFLOW ERROR
	JNZ	RAN40
	SUB	DL,DL
RAN40:	DIV	BX		;UNSIGNED DIVIDE BX INTO DX:AX

	MOV	AX,DX		;RETURN REMAINDER IN AX
	RET
RANFUN	ENDP

;** INTRINSIC #79
;SET SEED FOR RANDOM NUMBER GENERATOR.

INTR79	LABEL	FAR
RANSEED	PROC	FAR
	MOV	RANK,AX
	MOV	RANL,5149	;SET OTHER SEEDS FOR A REPEATABLE SEQUENCE
	MOV	RANM,7026
	RET
RANSEED	ENDP
	PAGE

;**  INTRINSIC #2
;GET REMAINDER OF MOST RECENT DIVISION. THE ARGUMENT IS AN
; EXPRESSION WHOSE RESULT IS THROWN AWAY. THIS EXPRESSION CAN
; CONTAIN A DIVISION OR BE ZERO TO GET THE RESULT OF AN EARLIER
; DIVISION.

INTR2	LABEL	FAR
REMFUN	PROC	FAR
	MOV	AX,REMAIN	;GET LAST REMAINDER
	RET
REMFUN	ENDP

;**  INTRINSIC #3
;RESERVE BYTES ON HEAP AND RETURN THE ADDRESS OF THE RESERVED
; SPACE. THIS IS THE TRICK BY WHICH XPL HANDLES DYNAMIC STORAGE
; FOR ARRAYS. SINCE THE SPACE IS RESERVED IN THE HEAP ALLOCATION
; OF A PROCEDURE, THE ARRAY WILL DISAPPEAR WHEN THE PROCEDURE IS
; EXITED.

INTR3	LABEL	FAR
RESERV	PROC	FAR
	IF	FLAGOPT
	MOV	DX,DI		;SAVE HEAP POINTER
	ADD	DI,AX		;NOW ADD IN RESERVE
	JC	RES80		;ERROR IS HEAP WRAP AROUND
	MOV AX,WORD PTR HEAPHI	;TEST FOR OVERLFOW
	CMP	DI,AX
	ELSE
	MOV	DX,HP		;SAVE HEAP POINTER
	ADD	HP,AX		;NOW ADD IN RESERVE
	JC	RES80		;ERROR IS HEAP WRAP AROUND
	MOV AX,WORD PTR HEAPHI	;TEST FOR OVERLFOW
	CMP	HP,AX
	ENDIF
	JB	RES90		;SKIP IF OK
RES80:	MOV	AL,2		; I2L ERROR # 2
	CALL	ERROR
RES90:	MOV	AX,DX
	RET
RESERV	ENDP


;**  INTRINSIC #4
;SWAP HIGH AND LOW BYTES OF TOP OF STACK.

INTR4	LABEL	FAR
SWAPFU	PROC	FAR
	XCHG	AL,AH
	RET
SWAPFU	ENDP
	PAGE

;**  INTRINSIC #5
;INTRINSIC TO EXTEND SIGN OF LOW BYTE INTO HIGH BYTE

INTR5	LABEL	FAR
EXTEN	PROC	FAR
	CBW
	RET
EXTEN	ENDP


;**  INTRINSIC #6
;INTRINSIC TO RESTART THE CURRENT PROGRAM

INTR6	LABEL	FAR
RESTRT	PROC	FAR
	CALL	RESDVZ		;RESTORE DIVIDE 0 VECTOR
	CALL	RSTBRK		;RESTORE BREAK VECTOR
	MOV	RERUNF,TRUVAL	;SET FLAG
	mov	es, PSPSEG	;START expects this
	push	es
	pop	ds
	JMP	START		;NUMBER SEQUENCE
RESTRT	ENDP


;**  INTRINSIC #7
;INTRINSIC TO INPUT A BYTE AND PUSH IT ONTO THE STACK.

INTR7	LABEL	FAR
CHIN	PROC	FAR
	MOV	NOWDEV,AX		;SET DEVICE NUMBER
	MOV BYTE PTR NOWFUN,INPFUN	;SET FUNCTION
	CALL	KHAND
	XOR	AH,AH			;ZERO HIGH BYTE
	RET
CHIN	ENDP


;**  INTRINSIC #8
;OUTPUT THE BYTE ON TOP OF THE STACK

INTR8	LABEL	FAR
CHOUT	PROC	FAR
	MOV	BP,SP			;POINT TO NOS
	MOV	BX,[BP]+TOSOFF		;GET DEVICE CHANNEL
	MOV	NOWDEV,BX
	MOV BYTE PTR NOWFUN,OUTFUN
	CALL	KHAND			;SEND IT
	RET	2			;DROP ARGS
CHOUT	ENDP
	PAGE

;**  INTRINSIC #9
;INTRINSIC TO PRINT AN END-OF-LINE (CR & LF)

INTR9	LABEL	FAR
SKIP	PROC	FAR
	MOV	NOWDEV,AX		;SET DEVICE #
	MOV BYTE PTR NOWFUN,OUTFUN
	CALL	CRLF
	RET
SKIP	ENDP


;**  INTRINSIC #10
;INTRINSIC TO INPUT A SIGNED INTEGER TO TOP OF STACK

INTR10	LABEL	FAR
INTIN	PROC	FAR
	MOV	NOWDEV,AX	;SET DEV #
	CALL	GETNMB		;GET A SIGNED INTEGER
	RET
INTIN	ENDP


;**  INTRINSIC #11
;INTRINSIC TO OUTPUT THE SIGNED INTEGER ON TOP OF STACK

INTR11	LABEL	FAR
INTOUT	PROC	FAR
	MOV	BP,SP		;POINT TO NOS

	MOV	CX,[BP]+TOSOFF	;GET DEVICE #
	MOV	NOWDEV,CX
	CALL	PUTNMB		;PRINT IT
	RET	2		;DROP ARGS
INTOUT	ENDP
	PAGE

;**  INTRINSIC #12
;INTRINSIC TO PRINT A TEXT STRING. THE STARTING ADDRESS IS
; ON TOP OF STACK. THE STRING TERMINATES ON CHARACTER WITH
; BIT 7 SET.

INTR12	LABEL	FAR
TEXT	PROC	FAR
	MOV	BP,SP		;POINT TO NOS
	MOV	CX,[BP]+TOSOFF	;SET DEVICE #
	MOV	NOWDEV,CX
	PUSH	SI
	MOV	SI,AX		;GET ADDRESS FROM STACK
	CALL	TXTLOP		;PRINT THE LINE
	POP	SI
	RET	2		;DROP ARGS
TEXT	ENDP


;SUBROUTINE TO PRINT A TEXT STRING, TO NOWDEV
;ADDRESS IN SI

TXTLOP	PROC	NEAR
	MOV BYTE PTR NOWFUN,OUTFUN
	CLD				;FORCE INCREMENT MODE
	JMP SHORT TXTLP1		;ENTER LOOP

TXTLP2:	CALL	KHAND			;OUT IT GOES
TXTLP1:	LODSB				;GET CHAR
	TEST	AL,080H			;LAST CHAR?
	JZ	TXTLP2			;LOOP IF NOT

	AND	AL,7FH			;MASK TO 7 BITS
	JMP	KHAND			;OUTPUT LAST CHAR
TXTLOP	ENDP


;INTRINSIC TO PRINT A NULL-TERMINATED TEXT STRING.

INTR12A	LABEL	FAR
TEXTA	PROC	FAR
	MOV	BP,SP		;POINT TO NOS
	MOV	CX,[BP]+TOSOFF	;SET DEVICE #
	MOV	NOWDEV,CX
	PUSH	SI
	MOV	SI,AX		;GET ADDRESS FROM STACK

	MOV BYTE PTR NOWFUN,OUTFUN
	CLD				;FORCE INCREMENT MODE
	JMP SHORT TXTALP1		;ENTER LOOP
TXTALP2:CALL	KHAND			;OUT IT GOES
TXTALP1:LODSB				;GET CHAR
	CMP	AL,0			;LAST CHAR?
	JNE	TXTALP2			;LOOP IF NOT

	POP	SI
	RET	2		;DROP ARGS
TEXTA	ENDP


;**  INTRINSIC #13
;INTRINSIC TO OPEN AN INPUT DEVICE

INTR13	LABEL	FAR
IDEVIN	PROC	FAR
	MOV BYTE PTR NOWFUN,INIFUN	;SET FUNCTION
IDEVN1:	MOV	NOWDEV,AX		;GET DEVICE #
	CALL	KHAND			;DO IT
	RET
IDEVIN	ENDP
	PAGE

;**  INTRINSIC #14
;INTRINSIC TO OPEN AN OUTPUT DEVICE

INTR14	LABEL	FAR
ODEVIN	PROC	FAR
	MOV BYTE PTR NOWFUN,INOFUN	;GET FUNCTION
	JMP	IDEVN1			;ENTER COMMON CODE
ODEVIN	ENDP


;**  INTRINSIC #15
;INTRINSIC TO CLOSE AN OUTPUT DEVICE

INTR15	LABEL	FAR
ODEVCL	PROC	FAR
	MOV BYTE PTR NOWFUN,CLOFUN	;GET FUNCTION
	JMP	IDEVN1			;ENTER COMMON CODE
ODEVCL	ENDP


;**  INTRINSIC #16
;INTRINSIC TO ABORT PROGRAM (LIKE A CTRL-P)
;REQUIRES FAR RETURN BECAUSE CALL TO PROGRAM IS FAR

INTR16	LABEL	FAR
ABORT	PROC	FAR
	MOV	SP,STKPTR
	RETF
ABORT	ENDP


;**  INTRINSIC #17
;INTRINSIC TO SET THE ERROR TRAP FLAGS

INTR17	LABEL	FAR
TRAP	PROC	FAR
	MOV	TRAPS,AX
	RET
TRAP	ENDP
	PAGE

;**  INTRINSIC #18
;INTRINSIC TO TELL A USER HOW MANY BYTES OF SPACE HE HAS LEFT.
; OF COURSE HE MAY NOT RESERVE ALL OF IT, SINCE HE MUST LEAVE A
; WORKING HEAP FOR SUBSEQUENT PROCEDURE CALLS ETC. SINCE ONLY
; THE USER KNOWS HOW MUCH THIS MIGHT BE, IT IS LEFT TO HIM TO
; DECIDE HOW MUCH HE HAS FREE TO PLAY WITH.

INTR18	LABEL	FAR
SPACE	PROC	FAR
	MOV	AX,WORD PTR HEAPHI
	IF	FLAGOPT
	SUB	AX,DI
	ELSE
	SUB	AX,HP
	ENDIF
	RET
SPACE	ENDP


;**  INTRINSIC #19
;INTRINSIC TO TEST THE RERUN FLAG.

INTR19	LABEL	FAR
RERUN	PROC	FAR
	MOV	AX,RERUNF
	RET
RERUN	ENDP


;**  INTRINSIC #20
;INTRINSIC TO RETURN THE CURRENT VALUE OF THE HEAP POINTER
; THIS INTRINSIC IS USED FOR SAVING THE HEAP POINTER FOR
; LATER RESTORATION WITH SETHP. THE USER HAD BETTER HAVE
; A GOOD IDEA OF THE FUNTIONING OF I2L BEFORE DINGING
; WITH THE HEAP POINTER OR HE WILL SURELY BOMB HIMSELF!

INTR20	LABEL	FAR
TSTHP	PROC	FAR
	IF	FLAGOPT
	MOV	AX,DI
	ELSE
	MOV	AX,HP
	ENDIF
	RET
TSTHP	ENDP
	PAGE

;**  INTRINSIC #21
;INTRINSIC TO RESET THE HEAP POINTER--A VERY DANGEROUS
; THING TO DO! SEE TSTHP'S COMMENTS.

INTR21	LABEL	FAR
SETHP	PROC	FAR
	IF	FLAGOPT
	MOV	DI,AX
	ELSE
	MOV	HP,AX
	ENDIF
	RET
SETHP	ENDP


;**  INTRINSIC #22
;INTRINSIC TO RETURN THE I2L ERROR NUMBER AND THEN CLEAR IT

INTR22	LABEL	FAR
GETERR	PROC	FAR
	MOV	AL,ERRNUM
	XOR	AH,AH
	MOV	ERRNUM,0
	RET
GETERR	ENDP

;**  INTRINSIC #23
;THIS INTRINSIC SETS THE TV CURSOR TO A SPECIFIC POSITION

INTR23	LABEL	FAR
CURSOR	PROC	FAR
	MOV	BP,SP		;POINT TO NOS
	MOV	BX,[BP]+TOSOFF	;GET X-POSITION, Y IN AX
	CALL	MCURSE
	RET	2		;DROP ARGS
CURSOR	ENDP


;**  INTRINSIC #25
;INTRINSIC TO SET THE RERUN FLAG DIRECTLY

INTR25	LABEL	FAR
SETRUN	PROC	FAR
	MOV	RERUNF,AX
	RET
SETRUN	ENDP
	PAGE

;**  INTRINSIC #26
;INTRINSIC TO INPUT A HEX INTEGER TO TOP OF STACK

INTR26	LABEL	FAR
HEXI	PROC	FAR
	MOV	NOWDEV,AX	;GET DEVICE NUMBER
	CALL	HEXIN		;INPUT WORD
	RET
HEXI	ENDP


;**  INTRINSIC #27
;INTRINSIC TO OUTPUT THE TOP OF STACK IN HEX FORMAT

INTR27	LABEL	FAR
HEXO	PROC	FAR
	MOV	BP,SP		;POINT NOS
	MOV	CX,[BP]+TOSOFF	;GET DEVICE NUMBER
	MOV	NOWDEV,CX
	CALL	WRDOUT		;OUTPUT WORD
	RET	2		;DROP ARGS
HEXO	ENDP

	PAGE

;DECIMAL INTEGER IO ROUTINES, RESULT IN AX

DSEG	SEGMENT WORD PUBLIC 'DATA'
SIGN	DB	0	;SIGN OF REG1
NUMFLG	DB	0	;NUMERICAL FLAG
TENBYT	DW	10	;FOR IMMEDIATE MULTIPLY
DSEG	ENDS

;INPUT A SIGNED INTEGER IN AX

GETNMB	PROC	NEAR
	MOV BYTE PTR NOWFUN,INPFUN	;SET FUNCTION
	CALL	KHAND			;GET CHAR
	SUB	CX,CX			;CLEAR REGISTER
	MOV	SIGN,CL			;CLEAR SIGN
	MOV	NUMFLG,CL		;CLEAR NUMBER FLAG

	CMP	AL,'-'			;NEGATIVE NUMBER?
	JNE	INTIN2			;SKIP IF NOT
	NOT 	SIGN

INTIN1:	PUSH	CX
INTIN1A:CALL	KHAND			;GET CHAR
	CMP	AL,'_'			;IGNORE ANY UNDERLINES
	JE	INTIN1A
	POP	CX
INTIN2:	CMP	AL,EOF			;END OF FILE
	JE	INTIN5			;YES, THEN EXIT
	SUB	AL,'0'			;CONVERT TO BINARY
	JL	INTIN4			;SKIP IF NOT A DIGIT
	CMP	AL,10			;TEST IT DIGIT
	JGE	INTIN4			;SKIP IF NOT
	INC	NUMFLG			;INDICATE IT'S A DIGIT

	SUB	AH,AH			;ZERO HIGH BYTE
	XCHG	AX,CX			;GET ACCUMULATED VALUE
	MUL	TENBYT			;TIME TEN
	ADD	CX,AX			;ADD IT IN
	JMP	INTIN1			;LOOP

INTIN4:	TEST	NUMFLG,0FFH		;END OF NUMBER?
	JZ	GETNMB			;START OVER IF NOT
INTIN5:	TEST	SIGN,0FFH		;NEGATIVE?
	JZ	INTIN3			;SKIP IF NOT
	NEG	CX			;NEGATE IT
INTIN3:	MOV	AX,CX
	RET
GETNMB	ENDP

	PAGE

;OUTPUT THE INTEGER IN AX

DSEG	SEGMENT WORD PUBLIC 'DATA'
REG1	DW	0	;TEMPORARY REGISTER
SUPRES	DB	0	;TO SUPRESS LEADING ZEROS
DSEG	ENDS

PUTNMB	PROC	NEAR
	PUSH	SI
	MOV BYTE PTR NOWFUN,OUTFUN	;SET FUNCTION
	MOV	SUPRES,0		;FLAG LEADING ZEROS
	MOV	REG1,AX			;SAVE WORD
	TEST	AX,8000H		;NEGATIVE?
	JZ	INTOT1			;SKIP IF NOT
	NEG	REG1			;NEGATE THE WORD
	MOV	AL,'-'			;PRINT MINUS
	CALL	KHAND			;OUTPUT CHAR

INTOT1:	MOV	SI,6		;SET POWER POINTER
INTOT2:	MOV	AX,REG1		;GET THE WORD
	SUB	DX,DX
	DIV	POWER[SI]	;DIVIDE BY POWER OF 10
	MOV	REG1,DX		;SAVE REMAINDER
	TEST	AX,0FFFFH	;ZERO DIGIT?
	JNZ	INTOT4		;SKIP IF NOT
	TEST	SUPRES,0FFH	;STILL SUPRESSING?
	JZ	INTOT3		;SKIP IF YES
INTOT4:	INC	SUPRES		;FLAG NO MORE SUPRESS
	OR	AL,30H		;CONVERT DIGIT TO ASCII
	PUSH	SI		;SAVE INDEX
	CALL	KHAND		;PRINT DIGIT
	POP	SI		;RESTORE INDEX
INTOT3:	SUB	SI,2		;POINT TO NEXT POWER
	JNS	INTOT2		;LOOP TILL DONE
	MOV	AL,BYTE PTR REG1;GET ONES DIGIT
	OR	AL,30H		;CONVERT TO ASCII
	POP	SI
	JMP	KHAND		;PRINT IT
PUTNMB	ENDP

;POWER OF TEN TABLE

DSEG	SEGMENT WORD PUBLIC 'DATA'
POWER	DW	10
	DW	100
	DW	1000
	DW	10000
DSEG	ENDS
	PAGE

;DISPLAY HEX WORD IN AX

WRDOUT	PROC	NEAR
	PUSH	AX		;SAVE WORD
	MOV	AL,AH		;GET HIGH BYTE
	CALL	HEXOUT		;DISPLAY IT
	POP	AX		;GET LOW BYTE
	JMP SHORT HEXOUT	;DISPLAY
WRDOUT	ENDP


;DISPLAY BYTE IN AL AS HEX ON CONSOLE

HEXOUT	PROC	NEAR
	MOV BYTE PTR NOWFUN,OUTFUN	;SET I/O FUNCTION
	CALL	MAKHEX			;CONVERT TO HEX
	PUSH	AX
	MOV	AL,AH			;GET HIGH WORD
	CALL	KHAND			;DISPLAY IT
	POP	AX
	JMP	KHAND
HEXOUT	ENDP


;CONVERT BYTE IN AL TO ASCII HEX IN AX

MAKHEX	PROC	NEAR
	MOV	AH,AL		;SAVE THE BYTE
	MOV	CL,4		;SHIFT INTO LOW NIBBLE
	SHR	AL,CL
	CALL	MAKNIB		;CONVERT TO HEX
	XCHG	AL,AH		;PUT IN HIGH BYTE
	JMP SHORT MAKNIB	;CONVERT LOW NIBBLE TO HEX
MAKHEX	ENDP


;CONVERT LOW NIBBLE IN AL TO ASCII HEX IN AL

MAKNIB	PROC	NEAR
	AND	AL,0FH		;MASK EXTRA BITS
	CMP	AL,0AH		;<A ?
	JL	MAKNB1
	ADD	AL,37H		;CONVERT TO ASCII
	RET
MAKNB1:	ADD	AL,30H		;CONVERT TO ASCII
	RET
MAKNIB	ENDP
	PAGE

;ROUTINE TO INPUT A HEX NUMBER

HEXIN	PROC	NEAR
	SUB	BX,BX			;ZERO REGISTER
	MOV	NUMFLG,BL		;FLAG NO DIGITS YET
	MOV BYTE PTR NOWFUN,INPFUN	;SET I/O FUNCTION

HEXIN1:	PUSH	BX		;SAVE VALUE
HEXIN1A:CALL	KHAND		;GET CHAR
	CMP	AL,'_'		;IGNORE ANY UNDERLINES
	JE	HEXIN1A
	POP	BX		;RESTORE VALUE
	CMP	AL,EOF		;END OF FILE?
	JE	HEXIN3		;YES, THEN EXIT
	CALL	MAKBIN		;CONVERT TO BINARY
	JNC	HEXIN2		;SKIP IF HEX

	CMP	NUMFLG,0	;LAST DIGIT?
	JNE	HEXIN3		;THEN EXIT
	JMP	HEXIN1		;ELSE TRY AGAIN

HEXIN2:	INC	NUMFLG		;FLAG WERE GETTING DIGITS
	MOV	CL,4
	SAL	BX,CL		;MULTIPLY BY 16
	ADD	BX,AX		;COMBINE WITH NEW DIGIT
	JMP	HEXIN1		;LOOP

HEXIN3:	MOV	AX,BX		;GET RESULT
	RET
HEXIN	ENDP


;OUTPUT A NEWLINE

CRLF	PROC	NEAR
	MOV BYTE PTR NOWFUN,OUTFUN	;SET I/O FUNCTION
	MOV	AL,CR
	CALL	KHAND
	MOV	AL,LF
	CALL	KHAND
	RET
CRLF	ENDP
	PAGE

;BLOCK TRANSFER INTRINSIC
; HANDLES OVERLAPPING BLOCKS
; BLIT(FROM_SEG, FROM_ADDR, TO_SEG, TO_ADDR, SIZE);
;       DS:      [SI]   ->   ES:    [DI]      CX

INTR36	LABEL	FAR
BLKTRN	PROC	FAR
	MOV	BP,SP		;POINT TO NOS
	PUSH	DI		;SAVE INDEXES
	PUSH	SI
	PUSH	DS		;SAVE SEGMENTS
	PUSH	ES
	PUSH	AX		;SAVE MOVE SIZE

;CONVERT THE ADDRESS AND SEGMENT TO CANONICAL FORM (NORMALIZE)
	MOV	CL,4		;SET SHIFT COUNT
	MOV	AX,[BP]+INTNOS+2 ;FROM_ADDR
	MOV	SI,AX
	SHR	AX,CL		;ALIGN WITH SEGMENT
	ADD	AX,[BP]+INTNOS+4 ;FROM_SEG
	MOV	DS,AX
	AND	SI,0FH		;MASK OFF REST OF ADDRESS

	MOV	AX,[BP]+TOSOFF	;TO_ADDR; (SS:[BP])
	MOV	DI,AX
	SHR	AX,CL		;ALIGN WITH SEGMENT
	ADD	AX,[BP]+INTNOS	;TO_SEG
	MOV	ES,AX
	AND	DI,0FH		;MASK OFF REST OF ADDRESS

	POP	CX		;GET THE NUMBER OF BYTES TO COPY
	CLD			;ASSUME INCREMENTING MODE FOR HIGH-TO-LOW COPY

;TEST IF COPY IS FROM LOW-TO-HIGH OR HIGH-TO-LOW
	MOV	BX,DS		;COMPARE FROM_SEG TO TO_SEG
	CMP	BX,AX
	JA	HILOW		;DO HIGH-TO-LOW COPY
	JE	BLIT05		;GO COMPARE ADDRESSES

;FROM_SEG IS LESS THAN TO_SEG. AVOID LOW-TO-HIGH COPY IF BLOCKS DON'T OVERLAP.
;WHEN BLITTING IMAGES TO THE SCREEN (A000H), USE INCREMENTING MODE TO AVOID
; A VISIBLE GLITCH
	SUB	AX,BX		;ARE THE SEGMENTS MORE THAN 64K BYTES APART?
BLIT03:	NEG	AX		;(ABSOLUTE VALUE)
	JL	BLIT03
	CMP	AX,2000H
	JGE	HILOW		;JUMP IF SO
	JMP SHORT LOWHI		;ELSE ASSUME THAT THEY MIGHT OVERLAP

;SEGMENTS ARE EQUAL SO COMPARE ADDRESSES
BLIT05:	CMP	SI,DI		;COMPARE FROM_ADDR TO TO_ADDR
	JA	HILOW		;DO HIGH-TO-LOW COPY

;SET UP FOR LOW-TO-HIGH COPY, BY DECREMENTING POINTERS
LOWHI:	ADD	SI,CX		;POINT TO THE LAST BYTES IN THE BLOCKS
	ADD	DI,CX
	DEC	SI
	DEC	DI
	STD			;SET FOR DECREMENTING MODE
	SHR	CX,1		;TRANSFER 2 BYTES AT A TIME FOR SPEED
	JNC	BLIT10		;HANDLE ODD BYTE AT END OF BLOCK, IF ANY
	 MOVSB			;ES:[DI--]:= DS:[SI--]
BLIT10:	DEC	SI		;POINT TO THE LAST WORDS IN THE BLOCKS
	DEC	DI
	REP MOVSW		;ES:[DI--]:= DS:[SI--]; CX--
	CLD			;RESTORE (DEFAULT) INCREMENT MODE
	JMP SHORT BLIT90

;SET UP FOR HIGH-TO-LOW COPY, BY INCREMENTING POINTERS
HILOW:	SHR	CX,1		;TRANSFER 2 BYTES AT A TIME FOR SPEED
	REP MOVSW		;ES:[DI++]:= DS:[SI++]; CX--
	JNC	BLIT90		;HANDLE ODD BYTE AT END OF BLOCK, IF ANY
	 MOVSB			;ES:[DI++]:= DS:[SI++]
BLIT90:
	POP	ES		;RESTORE REGISTERS
	POP	DS
	POP	SI
	POP	DI
	RET	8		;DROP ARGS
BLKTRN	ENDP
	PAGE

;CONVERT THE ADDRESS AND SEGMENT POINTED TO BY BX
;CANONICAL ADDRESS, NORMALIZE

MAKCAN	PROC	NEAR
	MOV	AX,[BX]		;GET ADDRESS PART
	MOV	CL,4		;SET SHIFT
	SHR	AX,CL		;ALIGN WITH SEGMENT
	ADD	[BX]+2,AX	;ADD INTO SEGMENT PART
	AND WORD PTR [BX],0FH	;STRIP OFF REST OF ADDRESS
	RET
MAKCAN	ENDP


;PORT INPUT AND OUTPUT ROUTINES

;* INTRINSIC # 65
;INPUT A VALUE FROM A PORT
;X:=PIN(PORT,SIZE)

INTR65	LABEL	FAR
PIN	PROC	FAR
	MOV	BP,SP		;POINT TO NOS
	MOV	DX,[BP]+4	;GET PORT NUMBER
	OR	AX,AX		;TEST SIZE
	JNZ	PIN1		;SKIP IF 16 BIT
	IN	AL,DX		;READ 8 BIT VALUE
	XOR	AH,AH		;CLEAR HIGH BYTE
	JMP SHORT PIN2		;ENTER COMMON CODE
PIN1:	IN	AX,DX		;READ 16 BIT VALUE
PIN2:	RET	2		;DROP AGRS
PIN	ENDP

;INTRINSIC # 64
;OUTPUT A VALUE TO A PORT
;POUT(VALUE,PORT,SIZE)

INTR64	LABEL	FAR
POUT	PROC	FAR
	MOV	BP,SP		;POINT TO NOS
	MOV	DX,[BP]+4	;GET PORT NUMBER
	MOV	BX,[BP]+6	;GET VALUE
	OR	AX,AX		;TEST SIZE
	MOV	AX,BX		;GET VALUE
	JNZ	POUT1		;SKIP IF 16 BIT
	OUT	DX,AL		;WRITE 8 BIT VALUE
	RET	4		;DROP ARGS
POUT1:	OUT	DX,AX		;WRITE 16 BIT VALUE
	RET	4		;DO NEXT OP
POUT	ENDP
	PAGE

;INTRINSIC TO CALL DOS AND ALLOCATE SYSTEM MEMORY
;CALLED WITH THE NUMBER OF PARAGRAPHS TO ALLOCATE IN TOS
;SEGMENT OF ALLOCATED MEMORY RETURNED IN TOS

INTR73	LABEL	FAR
MALLOC	PROC	FAR
	MOV	BX,AX		;GET ALLOCATION SIZE IN PARAGRAPHS
	MOV	AH,48H		;SETUP FOR MEMORY ALLOCATE FUNCTION
	INT	21H		;CALL DOS
	JNC	MALLC1		;SKIP IF NO ERRORS
	MOV	AXREG,AX	;SAVE ERROR CONDITIONS
	MOV	BXREG,BX
	MOV	AL,2		;FLAG RESERVE ERROR
	CALL	ERROR		;HANDLE ERROR
	MOV	AX,DS		;USE DATA SEGMENT TO BE SAFE
MALLC1:	RET			;RETURN
MALLOC	ENDP

;INTRINSIC TO RELEASE A BLOCK OF MEMORY BACK TO DOS
;SEGMENT OF MEMORY TO BE RELEASED IN TOS

INTR74	LABEL	FAR
RELEAS	PROC	FAR
	PUSH	ES		;SAVE ES
	MOV	ES,AX		;SETUP FOR DOS CALL
	MOV	AH,49H
	INT	21H		;CALL DOS
	POP	ES		;RESTORE ES
	JNC	RELES1		;SKIP IF NO ERRORS
	MOV	AXREG,AX	;SAVE ERROR CONDITIONS
	MOV	AL,2		;FLAG RESERVE ERROR
	CALL	ERROR		;HANDLE ERROR
RELES1:	RET			;RETURN
RELEAS	ENDP
	PAGE

;ROUTINES TO TRAP AND FILTER CONTROL-C AND CONTROL-BREAK

DSEG	SEGMENT WORD PUBLIC 'DATA'
CTCFLG	DW	FALVAL		;FLAG IF CONTROL-C STRUCK
CINFLG	DW	FALVAL		;FLAG IF TRAP IS INSTALLED
INT23	DD	0		;ADDRESS OF ORIGINAL CTRL-C HANDLER
INT1B	DD	0		;ADDRESS OF ORIGINAL CTRL-BREAK HANDLER
DSEG	ENDS


;INTRINSIC RETURN TRUE IF CONTROL-C HAS BEEN HIT, FALSE IF NOT

INTR76	LABEL	FAR
TESTC	PROC	FAR
	MOV	AX,CTCFLG	;GET FLAG
	MOV	CTCFLG,FALVAL	;CLEAR FLAG
	RET
TESTC	ENDP

;INTRINSIC TO TURN ON OR OFF CONTROL-C TRAPPING

INTR75	LABEL	FAR
TRAPC	PROC	FAR
	CMP 	AX,0		;IS FALSE?
	JE	TRAPC1		;THEN TURN OFF TRAP
	CALL	SETBRK		;TURN ON TRAP
	RET
TRAPC1:	CALL	RSTBRK		;TURN OFF TRAP
	RET
TRAPC	ENDP

;CAPTURE AND RESET VECTOR ADDRESS OF BOTH
;CONTROL-C AND CONTROL-BREAK HANDLER

SETBRK:	CMP	CINFLG,0	;ARE OUR VECTORS INSTALLED?
	JNE	RSTBK1		;EXIT IF SO
	PUSH	ES		;SAVE ES
	PUSH	DS		;SAVE DS
	MOV	AX,DS		;GET THE CURRENT DATA SEGMENT
	MOV	CS:DATSEG,AX	;SET UP SO INTERRUPT ROUTINE CAN FIND IT

	MOV	AX,3523H	;SAVE ADDRESS OF INT 23h HANDLER
	INT	21H
	MOV WORD PTR INT23,BX
	MOV WORD PTR INT23+2,ES

	MOV	AX,351BH	;SAVE ADDRESS OF ORIGINAL INT 1BH HANDLER
	INT	21H
	MOV WORD PTR INT1B,BX
	MOV WORD PTR INT1B+2,ES

	MOV DX,OFFSET CTRBRK	;LOAD FAR POINTER BREAK HANDLER
	MOV AX,SEG CTRBRK
	MOV	DS,AX
	MOV	AX,02523H	;SET INT 23H VECTOR
	INT	21H
	MOV	AX,0251BH	;SET INT 1BH VECTOR
	INT	21H
	POP	DS		;RESTORE DS
	MOV	CINFLG,TRUVAL	;FLAG BREAK HANDLER INSTALLED
	POP	ES		;RESTORE ES
	RET


;RESTORE ORIGINAL CTRL-C AND CTRL-BREAK HANDLERS

RSTBRK:	CMP	CINFLG,0	;ARE OUR VECTORS INSTALLED?
	JE	RSTBK1		;EXIT IF NOT
	PUSH	DS		;SAVE DS
	LDS	DX,INT1B	;GET ADDRESS OF PREVIOUS INT 1BH HANDLER
	MOV	AX,251BH	;SET INT 1BH VECTOR
	INT	21H
	LDS	DX,INT23	;GET ADDRESS OF PREVIOUS INT 23H HANDLER
	MOV	AX,2523H	;SET iNT 23h VECTOR
	INT	21H
	POP	DS
RSTBK1:	RET

;CTRL-C AND CTRL-BREAK INTERRUPT HANDLER

;THIS VARIABLE IS A POINTER IN THE CODE SEGEMENT TO THE DATA 
;SEGMENT OF THE PROGRAM

DATSEG	DW	0

CTRBRK:	PUSH	BX	 	;SAVE REGISTERS
	PUSH	DS
	MOV	BX,CS:DATSEG	;GET PROPER SEGMENT ADDRESS
	MOV	DS,BX
	MOV	CTCFLG,TRUVAL	;FLAG THAT WE HAVE A CONTROL-C
	POP	DS		;RESTORE REGISTERS
	POP	BX
	IRET			;RETURN FROM HANDLER

;INTRINSIC TO TURN ON OR OFF IRQ'S

INTR80	LABEL	FAR
IRQ	PROC	FAR
	TEST	AX,AX		;IS IT FALSE?
	JE	IRQ10		;JUMP IF SO
	STI			;ENABLE INTERRUPTS
	RET
IRQ10:
	CLI			;DISABLE INTERRUPTS
	RET
IRQ	ENDP
