
;   FreeDOS APPEND 1.0
;
;   ===================================================================
;
;   FreeDOS extension for some int21h functions (open, find first,
;   exec) to look for files in alternative paths
;
;   Copyright (C) 2004 Aitor Santamara_Merino
;   email:  aitor.sm@wanadoo.es
;
;   WWW:    http://www.freedos.org/
;
;   ===================================================================
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License v. 2.00 as
;   published by the Free Software Foundation
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;

CPU             8086

;===================================================================
; CONSTANTS
;===================================================================
;
;               .       .       .       .       .       line that rules

Version         EQU     0100H           ; see also output message

CommandLine_Offset      EQU     080h    ; where in PSP is commandline

F_AppendEnabled EQU     0001H           ; runtime flags
F_UseDrive      EQU     1000H
F_UsePath       EQU     2000H
F_Env           EQU     4000H
F_X             EQU     8000H

P_Path          EQU     01H             ; switch parameter ussage
P_X             EQU     02H
P_E             EQU     04H


segment code

;===================================================================
; Data through CS
;===================================================================
;
;               .       .       .       .       .       line that rules

AppendPath:     db ';'
                times   255  db 0
MyString        times   256  db 0
wFlags          dw      0
wPathPtr        dw      AppendPath

uAX             dw      0       ; user's registers, to reproduce a call
uBX             dw      0
uDX             dw      0
uFlags          dw      0
uDS             dw      0
uSI             dw      0

wUserFileName   dw      0       ; pointer to the starting of the file name


;===================================================================
; Resident procedures
;===================================================================
;
;               .       .       .       .       .       line that rules

; Fn:   HasDrivePath: test if the string specifies a drive and path
; In:   DS:SI -> string to be tested
; Out:  AH: trashed
;       AL: bits:  0:  drive specified
;                  1:  path specified
;       SI: modified

HasDrivePath:
                xor     ax,ax
                cmp     byte [si+1],58          ; compare with ':'
                jne     skpa1
                inc     ah
skpa1:
                cmp     byte [si],92            ; compare with '\'
                jne     skpa2                   ; (\ is present in string)
                or      ah,2
                jmp     skpa3
skpa2:          inc     si
                test    byte [si-1],0FFh
                jne     skpa1
skpa3:          mov     al,ah
                ret



; Fn:   ComposePath:  compose a new filename to be tried to MyString
;       Variable wPathPtr gets upated in the process
; In:   DS:SI -> user's file name
; Out:  AX, SI  trashed
;

ComposePath:
                push    cx      ; preserve these registers
                push    es
                push    di

                push    ds      ; save registers for later
                push    si

                push    cs              ; ES:DI->AppendPath[PathPtr]
                pop     es
                mov     di,[cs:wPathPtr]

                mov     al, ';'         ; remove the ';'
                mov     cx, 255
                repe    scasb
                dec     di

                push    cs
                pop     ds

                mov     si,di           ; add the path
                mov     di,MyString

skpb1:          movsb
                test    byte [si], 0FFh
                jz      skpb2
                cmp     byte [si],';'
                jne     skpb1

skpb2:
                mov     [cs:wPathPtr],si; update the path ptr

                mov     byte [es:di],92 ; add the \ between
                inc     di

                pop     si              ; finally add the filename
                pop     ds

skpb3:          movsb
                test    byte [si],0FFh
                jnz     skpb3

                mov     byte [es:di],0  ; add the final 0

                pop     di              ; recover registers
                pop     es
                pop     cx
                
                ret


;===================================================================
; Multiplexer handler
;===================================================================
;
;               .       .       .       .       .       line that rules

New2f:          cmp     ah,0b7h
                jnz     jOld2f

                ;************** function 00h: Installation check

                test    al,0ffH
                jnz     mDno0

                mov     al,0ffH

                iret

                ;************** function 01h/04h: Get APPEND Path

mDno0:          cmp     al,01h
                je      func1
                cmp     al,04h
                jne     mDno1

func1:          push    cs
                pop     es
                mov     di,AppendPath

                iret
                
                ;************** function 02h: Dummy for compatibility

mDno1:          cmp     al,02h
                jne     mDno2

                mov     ax,0ffffh

                iret

                ;************** function 03h: Chain to int21 handler

mDno2:          cmp     al,03h
                jne     mDno3

                mov     [cs:dOld21],di
                mov     [cs:dOld21+2],es

                push    cs
                pop     es
                mov     di,New21

                iret
                
                ;************** function 06h: Get APPEND flags

mDno3:          cmp     al,06h
                jne     mDno6

                mov     bx,[cs:wFlags]
                iret
                
                ;************** function 07h: Set APPEND flags

mDno6:          cmp     al,07h
                jne     mDno7

                mov     [cs:wFlags],bx
                iret
                
                ;************** function 10h: Get version info

mDno7:          cmp     al,10h
                jne     jOld2f

                mov     ax,[cs:wFlags]
                xor     bx,bx
                xor     cx,cx
                mov     dx,Version

                iret

                ;************** no more functions, exit

jOld2f:         DB      0eaH
dOld2f:         DD      -16


;===================================================================
; Int 21h handler
;===================================================================
;
;               .       .       .       .       .       line that rules

New21:          push    ax              ; save user's flags
                pushf
                pop     ax
                mov     [cs:uFlags],ax
                pop     ax

                ;****** (a) Determine wether active / should be used

                test    word [cs:wFlags], F_AppendEnabled
                jz      jOld21

                cmp     ah,3Dh          ; File Open (Handle)
                je      CheckOurFlags

                test    word [cs:wFlags], F_X
                jz      jOld21

                cmp     ah,4Eh          ; File Find First (Handle)
                je      CheckOurFlags

                cmp     ah,4Bh          ; EXEC
                jne     jOld21

CheckOurFlags:
                push    ax
                push    bx
                push    cx

                push    si
                mov     si,dx
                call    HasDrivePath
                pop     si

                mov     bx,[cs:wFlags]
                mov     cl,12
                shr     bx,cl
                not     bx
                and     ax,bx

                pop     cx
                pop     bx
                test    al,03
                jz      StageC
                pop     ax
                
                ;****** (b) Chain to DOS int handler
                
jOld21:         DB      0eaH
dOld21:         DD      -16

                ;****** (c) APPEND should do its work
                ;           First try to see if it opens

StageC:         ; save user's registers, to re-call
                mov     [cs:uBX], bx
                mov     [cs:uDX], dx
                mov     ax,ds
                mov     [cs:uDS], ds
                mov     [cs:uSI], si
                pop     ax              ; remember AX was pushed
                mov     [cs:uAX], ax
                ; try a call with user's registers

                push    ax
                mov     ax, [cs:uFlags]
                push    ax
                popf
                pop     ax

                pushf
                call    word FAR [cs:dOld21]

                jc      skpe1
                retf    2

                ;****** (d) It doesn't open, prepare for the loop
                ;       AX, BX, DX, DS, SI are useable
                
skpe1:          ; Save the failure frame to be returned if APPEND fails

                pushf                   ; if APPEND fails, return these two:
                push    ax              ; failure frame

                ; Compute where filename reallys starts
                mov     si, dx
                cmp     byte [si+1],':'
                jne     skpe2
                add     si,2
skpe2:          cmp     byte [si],92
                jne     skpe3
                inc     si
                jmp     skpe2
skpe3:          mov     [cs:wUserFileName],si

                ; Update the pointer to begining of append path
                mov     word [cs:wPathPtr],AppendPath

                ;****** (e) Main APPEND Loop

MainLoop:       ; Compose a new name to MyString

                mov       si,[cs:wUserFileName]
                call      ComposePath

                ; Load frame to try and call

                mov     ax, code                ; set DS:DX->MyString
                mov     ds, ax

                mov     dx, MyString wrt code

                mov     ax, [cs:uFlags]         ; recover the rest
                push    ax
                popf
                mov     ax, [cs:uAX]
                mov     bx, [cs:uBX]
                mov     si, [cs:uSI]
                
                pushf                           ; make a call
                call    word FAR [cs:dOld21]

                jnc     AppendSuccess

                mov     si,[cs:wPathPtr]        ; finally, more paths?
                test    byte [si],0FFh
                jz      AppendFailure

                mov     ax, [cs:uDS]            ; prepare for next iteration
                mov     ds, ax
                jmp     MainLoop
                
                ;****** (f) APPEND succeeded!

AppendSuccess:

                add     sp, 4           ; discard old frame

                mov     bx, [cs:uDS]
                mov     ds,bx
                mov     bx, [cs:uBX]
                mov     dx, [cs:uDX]
                mov     si, [cs:uSI]

                retf    2               ; IRET


                ;****** (g) APPEND failed!
AppendFailure:
                mov     bx, [cs:uDS]
                mov     ds,bx
                mov     bx, [cs:uBX]
                mov     dx, [cs:uDX]
                mov     si, [cs:uSI]

                pop     ax              ; reload failure frame
                popf

                retf    2               ; IRET
                
EndResidentCode:

;===================================================================
; Non resident code
;===================================================================
;
;               .       .       .       .       .       line that rules

; Fn:   OutStrDX
; In:   DX: near pointer to string to be displayed
; Out:  -

OutStrDX:       mov     ah,9
                int     21H
                ret


; Fn:   GetPSP
; In:   -
; Out:  PSP Segment to BX
;       AX trashed

GetPSP:
                mov     ah,062h
                int     021h
                ret


; Fn:   IsBlank
; In:   DS:SI -> character
; Out:  CarryFlag set if blank, clear if not

IsBlank:
                push    ax
                mov     al,[si]
                cmp     al,32
                jne     IsBlank_a
IsBlankExit1:   pop     ax
                stc
                ret
IsBlank_a:      cmp     al,13
                je      IsBlankExit1
                cmp     al,10
                je      IsBlankExit1
                cmp     al,9
                je      IsBlankExit1
                pop     ax
                clc
                ret

; Fn:   TestOnOff
; In:   DS:SI -> string to be tested
; Out:  AL:  1  if ":ON"
;       AL:  0  if ":OFF"
;       AL: FFh if syntax error

TestOnOff:
                push    bx
                push    cx
                xor     al,al
                
                push    si              ; first compare to ON
                mov     cx,4
                mov     di,strOn
                repe    cmpsb
                pop     bx

                jcxz    CheckBlank      ; match: see if blank follows

TestOffAX:
                inc     al
                mov     si,bx           ; recover offset
                mov     cx,5            ; compare to OFF
                mov     di,strOff
                repe    cmpsb

                jcxz    CheckBlank

TestOnOffError:
                mov     al,0FFh
                jmp     EndTestOnOff

CheckBlank:
                dec     si

                call    IsBlank
                jnc     TestOnOffError

EndTestOnOff:
                pop     cx
                pop     bx
                ret

; Jmp:   SyntaxError
; In:    DX: string offset
; Out:   -

SyntaxError:
                mov     ax,data
                mov     ds,ax

                call    OutStrDX
                stc
                jmp     DoneNoTSR
                

; Fn:   ParseSwitch: reads a switch and updates the include/exclude masks
;       non-repetition of switched is also tested
; In:   DS:SI -> switch to be tested
; Out:  on success returns
;       on failure, exits automatically with SyntaxError

ParseSwitch:
                cmp     byte [si],'?'
                jne     skpc0
                inc     si
                mov     dx, SES_SyntaxError
                call    IsBlank
                jnc     SyntaxError
                mov     dx, APPENDFastHelp
                jmp     SyntaxError
skpc0:
                cmp     byte [si],'E'
                jne     skpc1
                inc     si
                mov     dx, SES_SyntaxError
                call    IsBlank
                jnc     SyntaxError
                mov     dx, SES_NotImplemented
                jmp     SyntaxError

skpc1:          cmp     byte [si], 'X'
                jne     skpc10

                mov     dx, SES_ErrorInParams
                test    byte [es:bParsedArgs],P_X
                jnz     SyntaxError
                or      byte [es:bParsedArgs],P_X

                inc     si
                call    IsBlank
                jc      skpc2

                mov     dx, SES_SyntaxError
                call    TestOnOff
                test    al,080H
                jnz     SyntaxError
                test    al,01H
                jz      skpc2

                or      word [es:wExcluded],F_X
                jmp     skpcend
skpc2:          or      word [es:wIncluded],F_X
                jmp     skpcend
                
skpc10:         mov     dx,SES_SyntaxError
                mov     cx,5
                mov     di,strPath
                repe    cmpsb

                test    cl,cl
                jnz     SyntaxError

                mov     dx, SES_ErrorInParams
                test    byte [es:bParsedArgs],P_Path
                jnz     SyntaxError
                or      byte [es:bParsedArgs],P_Path

                dec     si
                mov     dx,SES_SyntaxError
                call    TestOnOff
                test    al,080H
                jnz     SyntaxError
                test    al,01H
                jz      skpc11

                or      word [es:wExcluded],F_UsePath
                jmp     skpcend
skpc11:         or      word [es:wIncluded],F_UsePath
skpcend:        ret


; Fn:   ParseParam:  parses one of the commandline parameters
;       non-repetition of parameters is also tested
; In:   DS:SI -> parameter to be parsed
; Out:  on success returns
;       on failure, exits automatically with SyntaxError

ParseParam:
                cmp     byte [si],'/'
                jne     skpd1
                inc     si
                call    ParseSwitch
                jmp     endParseParam
skpd1:          mov     di,sLocalAppendPath
                mov     dx,SES_ErrorInParams
                test    byte [es:di],0FFH
                jnz     SyntaxError
skpd2:          movsb
                call    IsBlank
                jnc     skpd2
                mov     byte [es:di],0
endParseParam:  ret

                
;===================================================================
; ENTRY POINT
;===================================================================
;
;               .       .       .       .       .       line that rules

..start:
                ;****** (1) Initial stages

                ; Set stack segment

                mov     ax,stack
                mov     ss,ax
                mov     sp,stacktop

                mov     ax,data
                mov     ds,ax

                ; Welcome message
                mov     dx,verMsg
                call    OutStrDX

                ;****** (2) Parse commandline

                ; Set segments for commandline parse: DS->PSP, ES->nonresident data

                mov     ax,data
                mov     es,ax

                call    GetPSP
                mov     ds,bx

                ; Find the string and capitalize it

                mov     cx, [CommandLine_Offset]
                mov     si, CommandLine_Offset+1
loop0:          lodsb
                cmp     al, 13
                je      endUpper
                cmp     al, 'a'
                jb      cont0
                cmp     al, 'z'
                ja      cont0
                sub     al, 'a'-'A'
                mov     [ds:si-1], al
cont0:          loop    loop0
endUpper:

                ; Loop to parse parameters

                mov     cx, [CommandLine_Offset]
                mov     si, CommandLine_Offset+1

loop1:          cmp     byte [si],13
                je      stage3
                call    IsBlank
                jnc     skp1
                inc     si
                loop    loop1
skp1:           call    ParseParam
                loop    loop1


stage3:
                ;****** (3) Determine if APPEND is already loaded

                ; Determine if APPEND exists

                mov     ax, 0B700h
                int     02Fh
                cmp     al,0fFh
                jne     NoAppend

                mov     byte [es:bIsAppendLoaded], 1

                test    byte [es:bParsedArgs],0ffh ; there is APPEND
                jnz     stage4
                test    byte [es:sLocalAppendPath],0ffh
                jnz     stage4                  ; if ANY parameter, exit

                ; Determine if APPEND is enabled, and get append path

                mov     ax, 0B710h              ; we use this function to
                int     02Fh                    ; catch older vers. of MS
                test    ax, F_AppendEnabled
                jz      NotEnabled

                mov     ax, 0B704h      ; get append path to ES:DI
                int     02Fh
                
                push    es              ; Set the segments for the transfer
                pop     ds
                mov     si,di

                mov     ax,data
                mov     es,ax
                mov     di,sLocalAppendPath

                mov     cx,256
loop2:          movsb
                test    byte [si-1], 0ffh
                loopnz  loop2
                mov     byte [es:di],'$'

                push    es
                pop     ds

                mov     dx,sAppendEquals
                call    OutStrDX

                mov     dx,sLocalAppendPath
                call    OutStrDX

                mov     dx,CarriageReturn
                jmp     skp2

                ; APPEND active, but disabled

NotEnabled:     mov     dx,sAppendNotEnabled

                push    es
                pop     ds

skp2:           call    OutStrDX
                jmp     DoneNoTSR
                
                ; There is no APPEND loaded

NoAppend:
                ; Set the multiplex vector
                mov     ax, 0352Fh
                int     021h
                mov     [cs:dOld2f],bx
                mov     [cs:dOld2f+2],es

                mov     dx,New2f wrt code
                mov     ax,code
                mov     ds,ax
                mov     ax,0252Fh
                int     021h

stage4:
                ;****** (4) Upload flags and path

                ; Load the appropriate segment register
                
                mov     ax,data
                mov     ds,ax


                ;****** (5) Update the flags and the string

                ; Here, ANY APPEND is already loaded

                ; Compute and set flags

                mov     ax, 0B706h
                int     2Fh                     ; Get flags

                or      bx, [wIncluded]
                or      bx, F_AppendEnabled+F_UseDrive+F_UsePath

                mov     ax, [wExcluded]
                not     ax
                and     bx, ax
                
                mov     ax, 0B707h
                int     2Fh                     ; Set flags


                ; Upload the obtained string if necessary

                test    byte [sLocalAppendPath], 0FFh
                jz      ExitRoutines

                mov     si, sLocalAppendPath

                mov     ax, 0B704h
                int     2Fh                     ; get APPEND path to ES:DI
                
                mov     cx, 256
loop3:          movsb
                test    byte [si-1],0FFh
                loopnz  loop3

                ;****** (6) Exit routines
ExitRoutines:
                test    byte [bIsAppendLoaded], 0ffh
                jnz     DoneNoTSR

                ; Resident exit
DoneTSR:
                call    GetPSP          ; free environment space
                mov     es,bx
                mov     dx,[es:02Ch]

                mov     ax,04900h
                mov     es,dx
                int     021h

                xor     ax,ax           ; Set our int21h vector
                mov     es,ax

                cli                     ; set it manually (MS kernels don't
                push    bx              ;  seem to like it through int21h)
                mov     bx,[es:84h]
                mov     [cs:dOld21],bx
                mov     bx,[es:86h]
                mov     [cs:dOld21+2],bx

                mov     bx, New21 wrt code
                mov     [es:84h],bx
                mov     bx, code
                mov     [es:86h],bx
                pop     bx
                sti

                mov     dx,EndResidentCode      ; Exit TSR
                add     dx,15
                mov     cl,4
                shr     dx,cl
                push    cs
                pop     cx
                add     dx,cx           ; dx=paragraphs:
                sub     dx,bx           ;  (CSeg - PSPSeg) + [(ofs+15) div 4]
                
                mov     ax,03100h
                int     021h

                ; Non-resident exit
DoneNoTSR:
                mov     ax,0x4c00
                int     0x21


                
;===================================================================
; DATA SEGMENT
;===================================================================
;
;               .       .       .       .       .       line that rules

segment data

verMsg:         db      'FreeDOS APPEND 1.00 - Alternative paths for open, findfirst, exec...', 13, 10
                db      '(c) Aitor SANTAMARIA MERINO 2004 - under the GNU GPL 2.0'
CarriageReturn: db      13, 10, '$'

bParsedArgs     db      0       ; arguments not yet parsed
wIncluded       dw      0       ; parameter include mask
wExcluded       dw      0       ; parameter exclude mask
bIsAppendLoaded db      0       ; is append already loaded?

sLocalAppendPath        times   256     db 0
db '$'

strOn           db      ':ON'
strOff          db      ':OFF'
strPath         db      'PATH'

APPENDFastHelp  db      13,10
                db      '  APPEND [[drive:]path[;...]] [/X[:ON|:OFF]][/PATH:ON|/PATH:OFF] [/E]',13,10
                db      13,10
                db      'Allows programs to open files in specified paths as if they were in',13,10
                db      'current path',13,10
                db      13,10
                db      '   [drive:]path[;...]]  listing of alternative paths where to search',13,10
                db      '   /X[:ON]              applies specified paths to file searches and program',13,10
                db      '                        execution (DOS fns. 3Dh, 4Bh and 4Eh) ',13,10
                db      '   /X:OFF               applies specified paths only to file openings',13,10
                db      '                        (DOS fnl. 3Dh)',13,10
                db      '   /PATH:ON             applies specified paths to filenames already',13,10
                db      '                        containing a path',13,10
                db      '   /PATH:OFF            disables /PATH:ON',13,10
                db      13,10
                db      'To display the list of appended directories, use the following syntax:',13,10
                db      13,10
                db      ' APPEND ',13,10
                db      13,10
                db      'To cancel the existing list of appended directories, use the following: ',13,10
                db      13,10,
                db      ' APPEND ;',13,10,'$'

sAppendNotEnabled       db      'APPEND is not enabled',13,10,'$'
sAppendEquals           db      'APPEND=$'
SES_SyntaxError         db      'Syntax error',13,10,'$'
SES_NotImplemented      db      'Switch /E is not yet implemented',13,10,'$'
SES_ErrorInParams       db      'Error in parameters',13,10,'$'

;===================================================================
; STACK SEGMENT
;===================================================================
;
;               .       .       .       .       .       line that rules

segment stack stack
                resb    256
stacktop:


