
;   FreeDOS DISPLAY:  MuxINT.ASM
;
;   ===================================================================
;
;   Multiplexer (2Fh) DISPLAY API management routines
;
;   Copyright (C) 27 Aug 2002-03 Aitor Santamara_Merino
;   email:  aitor.sm@wanadoo.es
;
;   WWW:    http://www.freedos.org/
;
;   ===================================================================
;
;   ( minimum touches by Ilya )
;               .       .       .       .       .       line that rules
;

;===================================================================
; CONSTANTS
;

MuxCode         EQU     0adh            ; for DISPLAY and KEYB

;===================================================================
; VARIABLES
;

bMuxErrorCode   DB      0               ; we start with no error


;===================================================================
; INTERRUPT ROUTINE FOR 2Fh (DOS Multiplexer)
;
; 00: Installation check (return al non-zero)
; 01: Set Active Codepage (IN: bx=requested codepage)
; 02: Get Active Codepage (OUT: bx=active codepage)
; 0E: Set Codepage information  (IN: DS:SI->buffer)
; 0F: Get codepage information  (IN: ES:DI->buffer)
;
; Note: DISPLAY may not save information about 8x16 font on EGA,
;       so don't expect to get 8x16 font from EGA via Fn 0F
;
;        .      .       .       .       .       .       line that rules

                ;************** check first MUX code for DISPLAY: ADh

New2f:          pushf                   ; we must preserve flags!
                cmp     ah,MuxCode
                jnz     jOld2f

                ;************** function 00h: Installation check

                test    al,0ffH
                jnz     mDno0

                mov     ah,0ffH         ; required for MS-DISPLAY compatibility
                mov     bx, Version     ; return version in BX (major.minor)
                                        ; bh=0 will stand for the beta versions of
                                        ; FreeDOS DISPLAY
                popf
                clc                     ; clear carry
                retf    2

                ;************** function 01h: Set active codepage

mDno0:          cmp     al,01
                jnz     mDno1

                push    dx
                xor     dx,dx
                call    SelectCodepage   ; returns success on AX
                mov     [cs:bMuxErrorCode],dl
                pop     dx               ; dl is the possible error code

                test    ax, 0ffffh
                jz      retSet

retClear:       mov     BYTE [cs:bMuxErrorCode],0
                popf                    ; restore flags,
                clc                     ; clear carry (success)
                retf    2               ; and return, discarding flags
retSet:         popf
                stc                     ; set carry: error
                retf    2


                ;************** function 02h: Get active codepage

mDno1:          cmp     al,02
                jnz     mDno2           ; we return the active codepage

                mov     bx, [cs:wCPselected]

                cmp     bx, -1          ; if it was never set,
                jne     retClear        ; then we have to
                mov     ax, 0001h       ; set ax to 1 (see RBIL)
                mov     BYTE [cs:bMuxErrorCode],ERR_CPNotSelected
                jmp     retSet

                ;************** jump to next multiplex handler

jOld2f:         popf
                DB      0eaH
dOld2f:         DD      -16

                ;************** function 03h: Get codepage information

mDno2:          cmp     al,03
                jnz     mDno3

                push    ax
                mov     ax,[cs:wNumSoftCPs]
                add     ax,[cs:wNumHardCPs]
                add     ax,3            ; cps + header (3)
                shl     ax,1            ; they are in words!
                cmp     ax,cx
                mov     cx,ax           ; if failure: CX: size of table
                pop     ax
                ja      retSet          ; buffer too small!

                push    ds              ; set DS:SI
                push    si

                push    cs
                pop     ds

                mov     si,wNumSoftCPs
                shr     cx,1            ; transfer size = our size (in words)
                cld			; for crazy callers
           rep  movsw

                pop     si
                pop     ds

                jmp     retClear

                ;************** function 05h: Get error code for last op


mDno3:          cmp     al,05
                jne     mDno5

                mov     bl, [cs:bMuxErrorCode]
                jmp     retClear

                ;************** function 0Eh: Set codepage table (from DS:SI)
mDno5:
                cmp     al,0eh
                jne     jOld2f

                call    PrepareCodepage

                mov     [cs:bMuxErrorCode],dl
                test    dx,0ffh
                jz      retClear
                jmp     retSet


