
/************************************************************************/
/*                                                                      */
/* FILE: error.c                                                        */
/* command.com Error support                                            */
/*                                                                      */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* This file is part of G-COM.                                          */
/* G-COM is derived from DOS-C source (GPL).                            */
/*                                                                      */
/* (C) Copyright 1999-2000  Roberto Gordo Saez   (GCOM)                 */
/* (C) Copyright 1995-1998  Pasquale J. Villani  (DOSC)                 */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option)  */
/* any later version.                                                   */
/*                                                                      */
/* This program is distributed in the hope that it will be useful, but  */
/* WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU     */
/* General Public License for more details.                             */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.                  */
/*                                                                      */
/************************************************************************/


#include "globals.h"


/* -- Function prototypes --------------------------------------------- */

void error_message (enum error_msg_idx);
void InitHandler(void);
void INTERRUPT FAR BreakHandler (void);
void INTERRUPT FAR CriticalError (unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned, unsigned);


/* -------------------------------------------------------------------- */
/* error_message                                                        */
/* -------------------------------------------------------------------- */

void error_message(enum error_msg_idx index)
{
    DosWrite(STDERR, (char FAR *)error_messages[index], strlen(error_messages[index]));
    if(*error_msg_str != '\0')
    {
        DosWrite(STDERR, (char FAR *)" -> ", 4);
        DosWrite(STDERR, (char FAR *)error_msg_str, strlen(error_msg_str));
    }
    DosWrite(STDERR, (char FAR *)newline, 2);
    error_msg_str = "";
}


/* -------------------------------------------------------------------- */
/* InitHandler                                                          */
/* -------------------------------------------------------------------- */

void InitHandler(void)
{
    DosSetInt(0x24, CriticalError);
    DosSetInt(0x23, BreakHandler);
}


/* -------------------------------------------------------------------- */
/* BreakHandler                                                         */
/* -------------------------------------------------------------------- */

void INTERRUPT FAR BreakHandler(void)
{
    /* FIXME */
}


/* -------------------------------------------------------------------- */
/* CriticalError                                                        */
/* -------------------------------------------------------------------- */

void INTERRUPT FAR CriticalError(unsigned reg_bp, unsigned reg_di, unsigned reg_si, unsigned reg_ds, unsigned reg_es, unsigned reg_dx, unsigned reg_cx, unsigned reg_bx, unsigned reg_ax)
{
    /* FIXME */
    reg_ax &= 0xFF00;
    reg_ax |= 3;
}

