
/************************************************************************/
/*                                                                      */
/* FILE: exec.c                                                         */
/* External program execution                                           */
/*                                                                      */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* This file is part of G-COM.                                          */
/* G-COM is derived from DOS-C source (GPL).                            */
/*                                                                      */
/* (C) Copyright 1999-2000  Roberto Gordo Saez   (GCOM)                 */
/* (C) Copyright 1995-1998  Pasquale J. Villani  (DOSC)                 */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option)  */
/* any later version.                                                   */
/*                                                                      */
/* This program is distributed in the hope that it will be useful, but  */
/* WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU     */
/* General Public License for more details.                             */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.                  */
/*                                                                      */
/************************************************************************/


#include "globals.h"


/* -- Function prototypes --------------------------------------------- */

BOOL ExecCmd (char*, int, char*);
BOOL Execute (char*, int, char*);
static char *get_execblk (fcb*, fcb*, exec_block*, tail*, char*);


/* -------------------------------------------------------------------- */
/* ExecCmd                                                              */
/* -------------------------------------------------------------------- */

BOOL ExecCmd(char *cmd_name, int argc, char *arguments)
{
    exec_block exb;
    fcb fcb1, fcb2;
    tail CmdTail;
    char *extns[2] = {".COM",".EXE"};
    char *batfile = ".BAT";
    char *p_ext = NULL;
    int i;
    BOOL warning = FALSE;
    char FAR *env_path;
    char path[MAX_PATH+FNAME_MAX+1], *p_path;

    p_ext = get_execblk(&fcb1, &fcb2, &exb, &CmdTail, cmd_name);

    env_path = EnvLookup("PATH");
    *path = '\0';
    p_path = path;

    do
    {
        if(*env_path == ';')
            ++env_path;

        if(*path != '\0')
        {
            p_path = &path[strlen(path)-1];
            if(*p_path != '\\')
            {
                *++p_path = '\\';
                *++p_path = '\0';
            }
        }

        for(i = 0; cmd_name[i] != '\0'; i++, p_path++)
            *p_path = cmd_name[i];
        *p_path = '\0';

        if(p_ext == NULL)
            strcpy(p_path, batfile);

        if(p_ext == NULL || strcmp(p_ext, batfile))
        {
            switch(batch(path, argc, arguments))
            {
            case 1:
                return TRUE;

            case -1:
                return FALSE;
            }
        }

        for(i = 0; i < 2; i++)
        {
            if(p_ext == NULL)
                strcpy(p_path, extns[i]);

            switch(DosExec((char FAR *)path, (exec_block FAR *)&exb))
            {
            case DE_SUCCESS:
                rtn_errlvl = DosRtnValue() & 0xFF;
                return TRUE;

            case DE_FILENOTFND:
                break;

            case DE_INVLDFUNC:
                error_message(INV_FUNCTION_PARAM);
                return FALSE;

            case DE_PATHNOTFND:
                error_message(PATH_NOT_FOUND);
                return FALSE;

            case DE_TOOMANY:
                error_message(TOO_FILES_OPEN);
                return FALSE;

            case DE_ACCESS:
                error_message(ACCESS_DENIED);
                return FALSE;

            case DE_NOMEM:
                error_message(INSUFF_MEM);
                return FALSE;

            default:
                error_message(EXEC_ERR);
                return FALSE;
            }

            if(p_ext != NULL)
                break;
        }

        do
        {
            p_path = path;
            *path = '\0';
            i = 0;
            while(*env_path!='\0' && *env_path!=';' && i < MAX_PATH)
                *p_path++ = *env_path++;
            if(i >= (MAX_PATH-1) && !warning)
            {
                error_message(PATH_LONG);
                warning = TRUE;
            }
            else
                *p_path = '\0';
        }
        while(i == MAX_PATH);
    }
    while(*path != '\0');

    error_message(BAD_CMD_FILE_NAME);
    return FALSE;
}


/* -------------------------------------------------------------------- */
/* Execute                                                              */
/* -------------------------------------------------------------------- */

BOOL Execute(char *command, int argc, char *arguments)
{
    char *p_ext;
    int i;
    char *extns[2] = {".COM",".EXE"};
    char *batfile = ".BAT";
    tail CmdTail;
    exec_block exb;
    fcb fcb1, fcb2;
    char path[MAX_PATH+FNAME_MAX+1];
    char *p_path = path;
    char *pointer;

    pointer = command;
    while(!issep(*pointer))
        *p_path++ = *pointer++;
    *p_path = '\0';

    p_ext = get_execblk(&fcb1, &fcb2, &exb, &CmdTail, path);

    if(p_ext == NULL)
        strcpy(p_path, batfile);

    if(p_ext == NULL || strcmp(p_ext, batfile))
    {
        switch(batch(path, argc, arguments))
        {
        case 1:
            return TRUE;

        case -1:
            return FALSE;
        }
    }

    for(i = 0; i < 2; i++)
    {
        if(p_ext == NULL)
            strcpy(p_path, extns[i]);

        switch(DosExec((char FAR *)path, (exec_block FAR *)&exb))
        {
        case DE_SUCCESS:
            rtn_errlvl = DosRtnValue() & 0xFF;
            return TRUE;

        case DE_FILENOTFND:
            break;

        case DE_INVLDFUNC:
            error_message(INV_FUNCTION_PARAM);
            return FALSE;

        case DE_PATHNOTFND:
            error_message(PATH_NOT_FOUND);
            return FALSE;

        case DE_TOOMANY:
            error_message(TOO_FILES_OPEN);
            return FALSE;

        case DE_ACCESS:
            error_message(ACCESS_DENIED);
            return FALSE;

        case DE_NOMEM:
            error_message(INSUFF_MEM);
            return FALSE;

        default:
            error_message(EXEC_ERR);
            return FALSE;
        }

        if(p_ext != NULL)
            break;
    }
    error_message(BAD_CMD_FILE_NAME);
    return FALSE;
}


static char *get_execblk(fcb *fcb1, fcb *fcb2, exec_block *exb, tail *CmdTail, char *cmd_name)
{
    char *pointer = cmd_name;
    char *p_ext = NULL;
    int i;

    while(!issep(*pointer))
    {
        if(*pointer == '.')
            p_ext = pointer;
        else
        {
            if(*pointer == '\\')
                p_ext = NULL;
        }
        pointer++;
    }

    pointer = cmd_tail;
    for(i = 0; *pointer != '\0' && i < MAX_TAILSIZE; i++)
        CmdTail -> ctBuffer[i] = *pointer++;
    CmdTail -> ctCount = i;
    if(i < MAX_TAILSIZE)
    {
        CmdTail -> ctBuffer[i] = '\r';
        while(++i < MAX_TAILSIZE)
            CmdTail -> ctBuffer[i] = '\0';
    }

    exb -> env_seg = FP_SEG(lpEnviron);
    exb -> cmd_line = (tail FAR *)CmdTail;

    pointer = skipwh(cmd_tail);
    DosParseFilename(pointer, (fcb FAR *)fcb1, 0);
    exb -> fcb_1 = (fcb FAR *)fcb1;

    while(*pointer != ' ' && *pointer != '\0')
        pointer++;
    pointer = skipwh(pointer);

    DosParseFilename(skipwh(++pointer), (fcb FAR *)fcb2, 0);
    exb -> fcb_2 = (fcb FAR *)fcb2;

    return p_ext;
}
