
/************************************************************************/
/*                                                                      */
/* FILE: globals.h                                                      */
/* Global data structures and declarations.                             */
/*                                                                      */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* This file is part of G-COM.                                          */
/* G-COM is derived from DOS-C source (GPL).                            */
/*                                                                      */
/* (C) Copyright 1999-2000  Roberto Gordo Saez   (GCOM)                 */
/* (C) Copyright 1995-1998  Pasquale J. Villani  (DOSC)                 */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option)  */
/* any later version.                                                   */
/*                                                                      */
/* This program is distributed in the hope that it will be useful, but  */
/* WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU     */
/* General Public License for more details.                             */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.                  */
/*                                                                      */
/************************************************************************/


/* -------------------------------------------------------------------- */
/* Version information                                                  */
/* -------------------------------------------------------------------- */

#define MAJOR_RELEASE   0
#define MINOR_RELEASE   85


/* -------------------------------------------------------------------- */
/* Types and definitions                                                */
/* -------------------------------------------------------------------- */

#define FAR             __far
#define INTERRUPT       __interrupt
#ifndef DEBUG
#define REG             register
#else
#define REG
#endif
#define ASM             __asm

#define PARASIZE        16              /* paragraph size               */

#ifndef TRUE
#define TRUE            1               /* definition of TRUE           */
#endif
#ifndef FALSE
#define FALSE           0               /* definition of FALSE          */
#endif

#ifndef NULL
#define NULL            0               /* definition of NULL           */
#endif

typedef char            BOOL;           /* boolean type                 */
typedef char            BYTE;           /* signed 8 bit type            */
typedef short           WORD;           /* signed 16 bit type           */
typedef signed long     DWORD;          /* signed 32 bit type           */
typedef unsigned long   UDWORD;         /* unsigned 32 bit type         */
typedef unsigned char   UBYTE;          /* unsigned 8 bit type          */
typedef unsigned short  UWORD;          /* unsigned 16 bit type         */

typedef unsigned short  SEGMENT;
typedef unsigned short  OFFSET;


/* -------------------------------------------------------------------- */
/* Constants and macros                                                 */
/* -------------------------------------------------------------------- */

#define FOREVER         for(;;)
#define tonum(c)        ((c) - '0')
#define CTL_Z           26

#define STDIN           0               /* CON, standard input          */
#define STDOUT          1               /* CON, standard output         */
#define STDERR          2               /* CON, standard error          */
#define STDAUX          3               /* AUX, auxiliary device        */
#define STDPRN          4               /* PRN, list device             */


/* General far pointer macros                                           */

#define MK_FP(seg,ofs)  ((void FAR *)(((UDWORD)(seg)<<16)|(UWORD)(ofs)))
#define FP_SEG(fp)      (*((UWORD FAR *)&(fp)+1))
#define FP_OFF(fp)      (*((UWORD FAR *)&(fp)))


/* Defaults and limits                                                  */

#define MAX_PATH        128
#define MAX_CMDLINE     128
#define MAX_CMDBUFFER   2048
#define ENV_DEFAULT     256


/* -------------------------------------------------------------------- */
/* Global variables                                                     */
/* -------------------------------------------------------------------- */

extern int default_drive;
extern char FAR *lpEnviron;
extern char *error_msg_str;
extern int rtn_errlvl;
extern char switchchar;
extern char *newline;

extern char prompt_string[MAX_CMDLINE];
extern char cmd_line[MAX_CMDLINE];
extern char cmd_buffer[MAX_CMDBUFFER];
extern char *cmd_tail;

extern BOOL batch_flag;
extern BOOL echo_flag;
extern BOOL break_flag;


/* Strings - located in file: strings.c                                 */

extern char *version;
extern char *announce;
extern char *default_prompt;
extern char *str_line;
extern char *copyright;
extern char *day_of_week[];
extern char *error_messages[];


enum error_msg_idx
{
    ACCESS_DENIED = 0,
    BAD_CMD_FILE_NAME,
    INV_NUM_PARAMS,
    INV_DIR,
    INV_FUNCTION_PARAM,
    INV_SYNTAX,
    EXEC_ERR,
    FILE_NOT_FOUND,
    INSUFF_MEM,
    FILE_PIPE_ERR,
    INTERNAL_ERR,
    ON_OFF,
    OUT_ENV_SPACE,
    PARAM_FORMAT,
    PARAM_RANGE_ERR,
    PATH_NOT_FOUND,
    SYNTAX_ERR,
    TOO_FILES_OPEN,
    INV_LABEL,
    LABEL_NOT_FOUND,
    PATH_LONG,
    CMDLINE_LONG,
    TEMP_VAR
};


/* -------------------------------------------------------------------- */
/* More DOS structures and declarations                                 */
/* -------------------------------------------------------------------- */

#include "struct.h"


/* -------------------------------------------------------------------- */
/* Function prototypes                                                  */
/* -------------------------------------------------------------------- */

#include "proto.h"
