;	DPMICL16.ASM NASM Sample for a 16-bit DPMI client.

;	To assemble, use:
;		nasm dpmicl16.asm -O 2 -o dpmicl16.com
;

LF	equ	10
CR	equ	13

	org	100h
    
	cpu	286

	mov bx, 1000h	;release unused DOS memory
	mov ah, 4Ah
    int 21h
    mov ax, 1687h	;DPMI host installed?
    int 2Fh
    and ax, ax
    jnz nohost
    push es			;save DPMI entry address
    push di
    and si, si		;requires host client-specific DOS memory?
    jz nomemneeded
    mov bx, si
    mov ah, 48h		;alloc DOS memory
    int 21h
    jc nomem
    mov es, ax
nomemneeded:
	mov bp, sp
    mov ax, 0000	;start a 16-bit client
    call far [bp]	;initial switch to protected-mode
    jc initfailed
    mov si, szWelcome
    call printstring
exit:    
    mov ax, 4C00h	;this exits protected-mode
    int 21h
nohost:
	mov dx, dErr1
error:    
    mov ah, 9
    int 21h
    jmp exit
nomem:
	mov dx, dErr2
    jmp error
initfailed:
	mov dx, dErr3
    jmp error

;--- print a string in protected-mode with simple
;--- DOS commands not using pointers.

printstring:    
    lodsb
    and al,al
    jz stringdone
    mov dl,al
    mov ah,2
    int 21h
    jmp printstring
stringdone:
	ret
    
szWelcome db "welcome in protected-mode",CR,LF,0
dErr1 db "no DPMI host installed",CR,LF,'$'
dErr2 db "not enough DOS memory for client initialisation",CR,LF,'$'
dErr3 db "DPMI initialisation failed",CR,LF,'$'

