/* 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Currently missing functions are:
 * bcd bcd(int x);      or      bcd(double x, int decimals);
 * int bdosptr(int dosfun, void arg, unsigned dosal);
 * double conj(complex z);
 * struct country *country(int countrycode, country countryp);
 * void geninterrupt(int intr_num);
 * int gsignal(sig);
 * int movetext(int left, int top, int right, int bottom, int newleft, int newtop);
 * double norm(complex z);
 * complex polar(double magnit, double angle);
 * double poly(double x, int num, double cf[]);
 * int (*ssignal(int sig, int *action))();
 * Most graphics functions are missing; right now I'm focusing on text and regular functions
 */
#ifdef __WATCOMC__

#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include <fcntl.h>
#include <string.h>
#include <math.h>
#include <bios.h>
#include <io.h>
#include <graph.h>
#include <errno.h>
#include <direct.h>
#include "tcc2wat.h"
#undef _matherr

void ctrlbrk(int (*fptr)(void))
{
	_dos_setvect(0x23, (void (__interrupt __far *))fptr);
}

int getcbrk(void)
{
      union REGS regs;

      regs.h.ah = 0x33;
      intdos(&regs, &regs);
      return (int)regs.h.dl;
}

int fnsplit(const char *path, char *drive, char *dir, char *name, char *ext)
{
	int a = 0;
	char rname[_MAX_FNAME];
	_splitpath(path, drive, dir, rname, ext);
	if (strchr(path, '.') != NULL) a+=EXTENSION;
	if (strlen(rname) > 0) a+=FILENAME;
	if (strchr(path, '\\') != NULL) a+=DIRECTORY;
	if (strchr(path, ':') != NULL) a+=DRIVE;
	if (strchr(path, '*') != NULL || strchr(path, '?') != NULL) a+=WILDCARDS;
	strcpy(name, rname);
	return a;
}

int setcbrk(int value)
{
	if(value == 1) {break_on();return 1;}
	if(value == 0) break_off();
	return 0;
}

int getdisk(void)
{
	unsigned drive;
	_dos_getdrive(&drive);
	return drive-1;
}

int setdisk(int drive)
{
	unsigned a;
	_dos_setdrive(drive-1, &a);
	return a;
}

struct country *country(int xcode, struct country *cp)
{
	union REGS regs;
	struct SREGS sregs;
	regs.h.ah = 0x38;
	if(xcode<255) regs.h.al = xcode;
	else {regs.h.al = 255;regs.x.bx = xcode;}
	sregs.ds = FP_SEG(cp);
	regs.x.dx = FP_OFF(cp);
	intdosx(&regs, &regs, &sregs);
	if(regs.x.cflag) return NULL;
	return cp;	
}

#endif