/* error.c -- error messages for edlin

  AUTHOR: Gregory Pietsch <GKP1@flash.net>

  DESCRIPTION:

  This file contains error routines for edlin, an 
  edlin-style line editor.

  COPYRIGHT NOTICE AND DISCLAIMER:

  Copyright (C) 2003 Gregory Pietsch

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

*/

/* includes */
#include <stdio.h>
#include "error.h"
#include "msgs.h"

/* static variables */
const char *error_msgs[] = {
    /* NO_ERROR,               */ "",
    /* ERR_OUT_OF_MEMORY,      */ G00030,
    /* ERR_LENGTH,             */ G00031,
    /* ERR_STRING_POSITION,    */ G00032,
    /* ERR_INVALID_USER_INPUT, */ G00033,
    /* ERR_NO_FILENAME,        */ G00034,
    /* ERR_ARRAY_TOO_BIG,      */ G00035,
    /* ERR_INVALID_POSITION    */ G00036,
    /* ERR_MAX                 */ "",
};

/* functions */
void error(ERROR_T err)
{
    fprintf(stderr, G00037, error_msgs[err]);
}

/* END OF FILE */
