/*  FreeDOS HTML Help Viewer

    GUI - Graphical User Interface

    Copyright (c) Express Software 1998-2003
    See doc\htmlhelp\copying for licensing terms
    Created by: Joseph Cosentino.

*/

/* I N C L U D E S *********************************************************/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#define HELP_GUI_C
#include "help_gui.h"
#include "conio.h"

/* F U N C T I O N S *******************************************************/

void show_error(char *msg)
{
    int x, y=H/2, w, h=4, pressed;
    struct event ev;
    char *buf;

    w = strlen(msg)+6;
    if (w%2 == 1)
        w++;

    if (w > W-2)
        w=W-2;

    x = (W-w)/2+1;

    buf = malloc(4*W*2);
    if (buf)
       save_window(x,y,w,h,buf);

    border_window(Red+BakBlack,x,y,w,h, Border22f);
    write_string(Yellow+BakBlack, x+3, y+1, msg);
    write_string(Black+BakWhite, x+w/2-2, y+2," OK ");
    pressed=0;
    while (1)
        {
        get_event(&ev, EV_KEY | EV_MOUSE);

        if ((ev.ev_type & EV_KEY) && (ev.key==27 || ev.key==13))
            break;

        if (ev.ev_type & EV_MOUSE)
            if (ev.x>=x+w/2-2 && ev.x<x+w/2+2 && ev.y==y+2)
                {
                if (ev.left==1)
                    pressed=1;

                if (ev.left==0 && pressed==1)
                    break;

                }
            else
                pressed=0;

        }

    if (buf)
    {
      load_window(x,y,w,h,buf);
      free(buf);
    }
}

/* Collected together and defined out some of the gui functions:
   they are potentially very useful, but are currently not used.
   Not including them saves on binary size */
#ifdef UNUSED_GUI

int get_keys(unsigned short *keys, int num_keys)
{
    struct event ev;
    int i, x, y, w, h, q;
    char *buf, *tmp;

    x=1;
    w=W;
    y=H-2;
    h=3;

    tmp = malloc(512*3);
    if (tmp == 0)
        return 0;

    buf = malloc(H*W*2);
    if (buf != 0)
       save_window(x,y,w,h,buf);

    border_window(Yellow+BakWhite, x, y, w, h, Border22f);
    write_string(Yellow+BakWhite, x+53, y+h-1," Esc, BkSp, \\ - quote ");

    q=0;
    while (1)
        {
        clear_window(BrWhite+BakBlack, x+2, y+1, w-4, 1);
        for (i=0;i<num_keys;i++)
            {
	    sprintf(tmp,"%04X",keys[i]);
            write_string(BrWhite+BakBlack,x+2+5*i,y+1,tmp);
            }

        move_cursor(x+2+5*i,y+1);
        get_event(&ev,EV_KEY);
        if (q == 0 && ev.key == 27)
            break;
        else if (q == 0 && ev.key == 8)
            {
            if (num_keys > 0)
                num_keys--;

            }
        else if (q == 0 && ev.key == '\\')
            {
            if (num_keys < 15)
                q=1;

            }
        else if (num_keys < 15)
            {
            keys[num_keys++]=ev.scan;
            q=0;
            }

        }

    for (i=num_keys;i<15;i++)
        keys[i]=0;

    if (buf)
    {
       load_window(x,y,w,h,buf);
       free(buf);
    }

    free(tmp);
    return num_keys;
}

/***************************************************************************/

int write_int(int attr, int x, int y, int w, unsigned long xx)
{
    char tmp[30];

    sprintf(tmp,"%*ld",w,xx);
    write_string(attr,x,y,tmp);
    return 0;

}


void edit_str_field(struct event *ev, int ev_mask, int attr, int x, int y, int maxlen, char *str, int *pos)
{
    int i;

    while (1)
        {
        i=strlen(str);
        if(*pos > i)
           *pos=i;

        if (*pos == maxlen - 1)
            (*pos)--;

        clear_window(attr,x+i,y,maxlen-i-1,1);
        write_string(attr,x,y,str);
        move_cursor(x+*pos,y);

        get_event(ev,ev_mask|EV_KEY);
        if (!(ev->ev_type & EV_KEY))
            break;
     
        if (ev->scan==0x47E0 || ev->scan==0x4700)  /* Home. */
            {
            *pos=0;
            } 
        else if (ev->scan==0x4FE0 || ev->scan==0x4F00) /* End. */
            {
            *pos=strlen(str);
            } 
        else if (*pos>0 && (ev->scan==0x4BE0 || ev->scan==0x4B00)) /* Left. */
            {
            (*pos)--;
            }
        else if (*pos<strlen(str) && (ev->scan==0x4DE0 || ev->scan==0x4D00)) /* Right. */
            {
            (*pos)++;
            }
        else if (ev->key==8 && *pos>0)  /* Backspace. */
            {
            for (i=*pos;i<maxlen && str[i]!=0;i++)
                str[i-1]=str[i];

            str[i-1]=0;
            (*pos)--;
            }
        else if (ev->scan==0x5300 || ev->scan==0x53E0) /* Del. */
            {
            for (i=*pos;i<maxlen && str[i]!=0;i++)
                str[i]=str[i+1];

            str[i]=0;
            }
        else if (ev->key>=' ')
            {
            if (strlen(str)<maxlen-1)
               {
               for (i=maxlen-1;i>*pos;i--)
                   str[i]=str[i-1];

               str[i]=ev->key;
               (*pos)++;
               }

            }
        else
            break;

        }

} 


void edit_int_field(struct event *ev, int ev_mask, int attr, int x, int y, int field_len, unsigned long *n, unsigned long limit)
{
    int i;
 
    while (1)
        {
        if(field_len>0)
            {
            sprintf(tmp,"%*lu",field_len,*n);
            move_cursor(x+field_len-1,y);
            }
        else
            {
            sprintf(tmp,"%-*lu",-field_len,*n);
            for (i=0;tmp[i]!=' ' && tmp[i]!=0;i++);
            move_cursor(x+i,y);
            }

        write_string(attr,x,y,tmp);
        get_event(ev,ev_mask|EV_KEY);
        if (!(ev->ev_type & EV_KEY))
            break;
     
        if (ev->key==8 || ev->scan==0x5300 || ev->scan==0x53E0) // Backspace || Del.
            {
            (*n)/=10;
            }
        else if (ev->key == '+')
            {
            if ((*n) < limit)
                (*n)++;

            }
        else if (ev->key=='-')
            {
            if ((*n) > 0)
                (*n)--;

            }
        else if (ev->key>='0' && ev->key<='9')
            {
            i=ev->key-'0';
            if (limit>=i && (*n)<=(limit-i)/10)
                (*n)=(*n)*10+i;

            }
        else
            break;

        }

}

int enter_string(int x, int y, char *prompt, int maxlen, char *str, char *help)
{
    struct event ev;
    int i, w, x2, w2;

    w2=W-7-x-strlen(prompt);
    if (w2 > maxlen)
        w2=maxlen;

    w=strlen(prompt)+5+w2;
    x2=x+strlen(prompt)+3;
    save_window(x,y,w,3,buf);
    border_window(Yellow+BakWhite,x,y,w,3, Border22f);
    write_string(Black+BakWhite,x+2,y+1,prompt);
 
    if (help != 0)
        write_string(Yellow+BakWhite, x+w-14, y+2, " F1 - Help ");

    i=0;
    str[0]=0;

    while (1)
        {
        edit_str_field(&ev, 0, BrWhite+BakBlack, x2, y+1, w2, str, &i);

        if (ev.key == 27)
            {
            i=0;
            break;
            }

        if (ev.key == 13)
            {
            i=1;
            break;
            }

        if (ev.scan==0x3B00 && help!=0) // F1 - Help.
            {
            html_view(help);
            }

        }

    load_window(x,y,w,3,buf);
    return i;

} 

#endif
