/* 
	JEMM386.H
*/

#define NULL 0
#define TRUE 1
#define FALSE 0

#define MK_FP(seg,ofs)        ((void far *)(((ulong)(seg)<<16)|(ushort)(ofs)))
#define FP_SEG(fp)            ((ushort)((ulong)(void far *)(fp)>>16))
#define FP_OFF(fp)            ((ushort)(fp))

typedef unsigned char uchar;
typedef unsigned int   uint;
typedef unsigned short ushort;
typedef unsigned long ulong;

extern int printf(char *,...);
extern void memset(char *s1, char c, int count);
extern void memcpy(char *s1, char *s2,int len);
extern int  strlen(char *s);

/* extern int  toupper (unsigned c); */
extern char * pascal FindCommand(char *commandline, char *searchstring);
extern unsigned long pascal GetValue(char *commandline, int base, char usesuffix);
extern ushort IsProtectedMode(void);
extern int emmcall(uchar);
#if INTEGRATED==0
extern int xmscall(uchar);
extern int xmscall32(uchar);
extern int XMSinit(void);
#else
extern int GetA20Method(char *);
extern int EnableA20(void);
extern int DisableA20(void);
extern ulong I15GetMemoryStatus(ushort);
extern ulong I15AllocMemory(int, ulong);
#endif
extern ulong InitJemm(void);
extern int IsDPMI(void);
extern int VMwareDetect(void);
extern int EmmStatus(void);
extern int EmmUpdate(void);
/* extern int AddIfContiguousWithDosMem(int,int); */
/* extern int InstallXMSHandler(int); */
extern int TestForSystemRAM(void *, int, unsigned int *);


#define isWhite(c) ((c) == ' ' || (c) == '\t')

/* your code must provide this function */

#define EXECMODE_SYS 0
#define EXECMODE_EXE 1

/* globals, also defined in JEMM386.INC or JEMM32.ASM */

#ifndef INTEGRATED
#define INTEGRATED 0
#endif

#define MAX_EMS_PAGES_POSSIBLE 0x8000
#define MAX_EMS_PAGES_ALLOWED 0x800
#define MINMEM16K_DEFAULT 0
#define MAXMEM16K_DEFAULT 0x1E00
#define DMABUFFDEFAULT 64
#define	UMB_MAX_BLOCKS	8

/* compiler switches, requires switches in JEMM386.INC to be set as well */

#define SBSUPP        1
#define VMESUPP       1
#define LOADSUPP      1
#define A20SUPP       1
#define EMXSUPP       1
#define PGESUPP       1
#define UNLOADSUPP    1
#define FASTBOOT      1

/* equates, must match the ones in JEMM32.ASM */

#define V86F_SB       1    /* SB compat switch set */
#define V86F_NOCHECK  2    /* NOCHECK switch set */
#define V86F_EMX      4    /* EMX compat switch set */
#if FASTBOOT
#define V86F_FASTBOOT 8    /* FASTBOOT switch set */
#endif

#define CHECK00FFONLY 0    /* I=TEST checks pages for 0x00 and 0xFF values only */

/* structures */

/* structure for calling XMS V3 functions */

struct reg32
{
	ulong eax;
	ulong ebx;
	ulong ecx;
	ulong edx;
};

/* structure for calling XMS V2 and EMS functions */

struct reg16
{
	ushort ax;
	ushort bx;
	ushort cx;
	ushort dx;
};

/* UMB block 'array' ; this structure is also defined in JEMM386.INC */

typedef struct tagUMBBLK {
	ushort segment;
	ushort size;
} UMBBLK;

/* structure for v86 monitor initialization */
/* this structure is also defined in JEMM386.INC */

typedef struct tagJEMMINIT {
    ulong MonitorStart;     /* XMS/I15 block physical start */
    ulong MonitorEnd;       /* XMS/I15 block physical end */
    ulong TotalMemory;      /* XMS/I15 highest physical address */
    ulong MaxMem16k;        /* MAX=xxxx (default 120M), in 16kB units */
    ulong MinMem16k;        /* MIN=xxxx (default 0), in 16kB units */
    ulong XMSHandleTable;   /* far16 address XMS handle table */
    uchar far * pPageMap;   /* far16 address 1. MB page map */
    ushort MaxEMSPages;     /* Min(32M, MaxMem16k), in 16 kB units */
    ushort XMSControlHandle;/* XMS handle for memory block or 0000 */
    ushort DMABufferSize;   /* DMA buffer size in kB */
    ushort Frame;
    ushort Border;
    uchar NoEMS;
    uchar NoFrame;
    uchar NoPool;
    uchar AltBoot;
    uchar NoVME;
    uchar NoVDS;
    uchar NoPGE;
    uchar NoA20;
    uchar NoVCPI;
    uchar NoInvlPg;
    uchar V86Flags;
    uchar NoRAM;
    uchar NoHigh;
    uchar FirstUMB;
    uchar NumUMBs;
#if INTEGRATED
    uchar A20Method;
    ushort HmaMin;
    ushort X2Max;
#endif
} JEMMINIT;

