
ifndef ?MASM
?MASM equ 0
endif

LF              EQU 0AH
CR              EQU 0DH

?VERSIONHIGH	equ 5
?VERSIONLOW		equ 33

?DMA            EQU 1               ; 1=enable DMA support
?VDS            EQU 1               ; 1=enable VDS support
?VCPI           EQU 1               ; 1=enable VCPI support
?RING0EXC       EQU 1               ; 1=display more infos on exc in ring 0
?A20XMS         EQU 1               ; 1=emu A20 by trapping XMS functions
?A20PORTS       EQU 1               ; 1=emu A20 by trapping ports (92, 64, 60)
?ROMRO			EQU 1               ; 1=make ROM page FF000 r/o
?VME			EQU 1               ; 1=support P1+ VME extension
?EMMXXXX0		EQU 1				; 1=implement EMMXXXX0 IOCTL
?ALTBOOT		EQU 1				; 1=support ALTBOOT option
?MMASK			EQU 1				; 1=trap DMA master mask port (0F, DE)
?INVLPG			EQU 1				; 1=use INVLPG opcode on 80486+
?LOADSUPP		EQU 1				; 1=support LOAD command line option
?EMX			EQU 1				; 1=EMX compat switch supported
?SB 			EQU 1				; 1=SB compat switch supported
?PGE     		EQU 1				; 1=support PGE on P3+ (requires ?INVLPG!) 
?EMM4F  		EQU 1				; 1=implement int 67h, ah=4Fh
?EMM5556		EQU 1				; 1=implement int 67h, ah=55h/56h

?SAFEMODE		EQU 0				; 1=make some additional security checks
?CODEIN2PAGE	EQU 0               ; 1=move code away from first page
?FASTBOOT		EQU 0				; 1=fast boot (not impl. yet)
?UNIMPL_EMS_DBG	EQU	0


V86_TOS         EQU 200H            ; Size of monitor stack

?SYSPDE  		EQU 004h            ; offset in pagedir for sys page table
?SYSPTE         EQU 4				; offset in sys page table for system space
?SYSLINEAR		EQU ?SYSPDE shl 20 + ?SYSPTE shl 10
?SCRATCHPTE 	EQU 800h-8*4        ; offset in sys page table scratch PTEs
?SCRATCHLINEAR	EQU ?SYSPDE shl 20 + ?SCRATCHPTE shl 10
?DMAPTE      	EQU ?SCRATCHPTE - 40h*4; start PTEs for DMA buffer
?DMALINEAR	 	EQU ?SYSPDE shl 20 + ?DMAPTE shl 10 ; linear address DMA buffer
?HMAPTE      	EQU ?SCRATCHPTE - 10h*4; start PTEs for HMA copy
?HMALINEAR	 	EQU ?SYSPDE shl 20 + ?HMAPTE shl 10 ; linear address HMA copy

?PAGEDIR		equ ?SYSLINEAR		; page dir is mapped at a fix linear address

?BPOPC			equ 0F4h			; opcode used for breakpoints

MAX_EMS_PAGES_ALLOWED	EQU	800h	; 32M max mem (16K each page), always even
; keep this value low for buggy VCPI clients that fail with large free amounts
MAXMEM16K_DEFAULT	EQU	1E00h	; 120M in 16K blocks

@KB_FLAG        EQU 417H			; Status SHIFT/CTRL/ALT etcetera.
@RESET_FLAG     EQU 472H			; Flag for Warmboot (=1234h)

if ?DMA

?DMABUFFDEFAULT EQU 64				; default DMA-Buffer size in kB
?DMABUFFMAX		EQU 128				; max DMA-Buffer size in kB

;--- bits in GblFlags

HiLoFlag1       EQU     0     ; adressing the Hi-Byte , DMA #1
HiLoFlag2       EQU     1     ; Same for DMA controller #2
NeedBuffer      EQU     2     ; if DMA buffer is required

endif


REPCMD  MACRO CMD,OP         ;; Call Command with different
	IRP     OPERAND,<&OP>    ;; operands back
	CMD     OPERAND
	ENDM
	ENDM

; Macro for bypassing the 386-Bug with 32-Bit-Stringoperations
; only needed for Mask-version B3
; AddressSize - Prefix + NOP attached

BIG_NOP MACRO
;;		DB 67h    ;  32-Bit-Prefix
;;		NOP
		ENDM

; VCPI switch from V86 to protected mode data structure
if ?VCPI
SWSTR	STRUC
	SW_CR3		DD	?	; client's CR3 value
	SW_GDTOFFS	DD	?	; offset of client's GDTR value
	SW_IDTOFFS	DD	?	; offset of client's IDTR value
	SW_LDTR		DW	?	; client's LDTR value
	SW_TR		DW	?	; client's TR value
	SW_EIP		DD	?	; entry point in client
	SW_CS		DW	?
SWSTR	ENDS

if ?MASM
LPSWSTR typedef ptr SWSTR
endif

endif

@assumem macro reg_, pstruct_
if ?MASM
	assume reg_: pstruct_
endif
	endm

;--- EMS constants

MAX_HANDLES     EQU     255   ; There are only 255 handles to give away (lt.
                              ; Documentation  LIM EMS 4.0)
FREEPAGE_ID     EQU     255   ; Owner Handle of a free page

;--- EMS handle status

EMSH_SYSTEM	equ -1
EMSH_FREE	equ -2
EMSH_USED	equ -3

EMSPD struc
wNibOfs dw ?		;nibble offset in pool descriptor
wPD		dw ?		;pool descriptor ID (offset/64 into PoolAlloc array)
EMSPD ends

; number of bytes for system info in EMS/VCPI pool allocation block,
;  must be >= sizeof POOL_SYSTEM_INFO_STRUC or bad things will happen quickly
POOLBLOCK_SYSTEM_SPACE	EQU	16

; number of bytes for allocation in a pool allocation block
; that are 48*8=384 bits, -> 384 * 4 kB -> 1536 kB
POOLBLOCK_ALLOCATION_SPACE	EQU	48

POOLBLOCK_TOTAL_SPACE	EQU	POOLBLOCK_SYSTEM_SPACE+POOLBLOCK_ALLOCATION_SPACE

POOL_SYSTEM_INFO_STRUC	struc
	psi_addressK	DD	?	; base address in K (may not be XMS handle base if handle size changed later)
	psi_descptr	DD	?	; pointer to XMS handle descriptor array entry/pseudo-handle value
	psi_startadj	DB	?	; unused K from XMS handle base for 4K alignment (0-3)
	psi_endadj	DB	?	; unused K at XMS handle end as 32K chunks (0-31)
	psi_16kmax	DB	?	; maximum number of 16K allocations (used allocation bytes*2), always even
	psi_16kfree	DB	?	; free number of 16K slots
	psi_4kfree	DW	?	; free number of 4K slots (>psi_16kfree*4 if any partials)
	psi_flags	DB	?	; various flag values
	psi_unused	DB	?
POOL_SYSTEM_INFO_STRUC	ends

if ?MASM
LPPOOL_SYSTEM_INFO_STRUC typedef ptr POOL_SYSTEM_INFO_STRUC
endif

POOLBLOCK_FLAG_DONTEXPAND	EQU	1	; don't try to expand or release this pool allocation block

XMS_ARRAY_STRUC	struc
	xas_flag		DB	?
	xas_lockcount	DB	?
	xas_addressK	DD	?
	xas_sizeK		DD	?
XMS_ARRAY_STRUC	ends

if ?MASM
LPXMS_ARRAY_STRUC typedef ptr XMS_ARRAY_STRUC
endif

;--- XMS handle flags

XMS_FREE	equ 1	;handle describes a free EMB
XMS_USED	equ 2	;handle describes a used EMB
XMS_INPOOL  equ 4	;handle is free


XMS_HANDLE_TABLE_STRUC	struc
	xht_sig			DB	?
	xht_sizeof		DB	?
	xht_numhandle	DW	?
	xht_array    	DD	?		;converted to linear address!
XMS_HANDLE_TABLE_STRUC	ends

;--- stack frame for PUSHAD

PUSHADS struc
rEDI    dd ?
rESI    dd ?
rEBP    dd ?
RESERVE dd ?
rEBX    dd ?
rEDX    dd ?
rECX    dd ?
rEAX    dd ?
PUSHADS ends

;--- stack frame for normal INTs in v86 mode

IRETDV86 struc
vIP		dw ?	;+0
		dw ?
vCS		dw ?    ;+4	
		dw ?
vFL 	dw ?	;+8
		dw ?
vSP		dw ?	;+12
		dw ?
vSS		dw ?	;+16
		dw ?
vES		dw ?	;+20
		dw ?
vDS		dw ?	;+24
		dw ?
vFS		dw ?	;+28
		dw ?
vGS		dw ?	;+32
		dw ?
IRETDV86 ends

if 0
;--- stack frame for int 06 handler real-mode

EXC6FR struc
	PUSHADS <>	;be very careful with structures and TASM
wDS	dw ?
wES	dw ?
wFS	dw ?
wGS	dw ?
wSP dw ?
wSS dw ?
wIP	dw ?
wCS	dw ?
wFL	dw ?
EXC6FR ends

endif

if ?EMMXXXX0

EMX06 struc
e_NoEMS 	db ? ;+0
e_Frame		dw ? ;+1    segment
e_NoVCPI	db ? ;+3
e_DMABuff   dd ? ;+4    physical address DMA buffer
e_NoPGE     db ? ;+8
            db 3 dup (?)
e_DMASize   dw ? ;+12   in KB
e_NoVME     db ? ;+14
e_NoA20     db ? ;+15
e_VCPITotal dd ? ;+16   VCPI pages total (def 120 MB)
e_VCPIUsed  dd ? ;+20   VCPI pages allocated
EMX06 ends

endif

;--- stack frame in V86_MONITOR on exception 0D (16+4+36=56 (==38h))

V86FRGP  struc
gECX	dd ?	;+0
gEBX	dd ?	;+4
gEAX	dd ?	;+8
gRet	dd ?	;+12 return address to skip
gErrC	dd ?	;+16
gIP		dd ?	;+20
gCS		dw ?    ;+24	
		dw ?
gFL 	dw ?	;+28
		dw ?
gSP		dw ?	;+32
		dw ?
gSS		dw ?	;+36
		dw ?
gES		dw ?	;+40
		dw ?
gDS		dw ?	;+44
		dw ?
gFS		dw ?	;+48
		dw ?
gGS		dw ?	;+52
		dw ?
V86FRGP ends        

;--- stack frame inside EMM/VCPI functions

EMMFRAME struc
eRet	dd ?	;+0
eEcx	dd ?	;+4
eEdi	dd ?	;+8
eEsi	dd ?	;+12
eEip	dd ?	;+16
eCs		dd ?	;+20
eEfl	dd ?	;+24
eEsp	dd ?	;+28
eSs		dd ?	;+32
eEs		dd ?	;+36
eDs		dd ?	;+40
eFs		dd ?	;+44
eGs		dd ?	;+48
EMMFRAME ends

@BPOPC macro
	db ?BPOPC
    endm

@mov_eax_cr4 macro
	db 0fh, 20h, 0E0h
    endm
@mov_ecx_cr4 macro
	db 0fh, 20h, 0E1h
    endm

@mov_cr4_eax macro
	db 0fh, 22h, 0E0h
    endm
@mov_cr4_ecx macro
	db 0fh, 22h, 0E1h
    endm

@cpuid	macro
;	cpuid
	db 0Fh,0A2h
	endm

@wrmsr	macro
	db 0Fh,030h
	endm
    
@rdtsc	macro
	db 0Fh,031h
	endm

@rdmsr	macro
	db 0Fh,032h
	endm
    
@GETPTEPTR macro reg, ofs, bIsConst
if 0
	mov reg,[PAGEDIR]
  ifnb <ofs>  
    lea reg, [reg+ofs]
  endif  
else
  ifnb <ofs>
    ifnb <bIsConst>
      mov reg,?PAGEDIR+ofs
    else
      lea reg,[?PAGEDIR+ofs]
    endif
  else
    mov reg, ?PAGEDIR
  endif
endif
    endm

@GETPTE macro reg, ofs, bIsConst
if 0
	mov reg,[PAGEDIR]
    mov reg,[reg+ofs]
else
    ifnb <bIsConst>
      mov reg,ds:[?PAGEDIR+ofs]
    else
      mov reg,[?PAGEDIR+ofs]
    endif
endif
    endm

