

		.struct FARPTR
offs	.dw
seg		.dw
		.ends

dos_version:
		.dw		0
lfn_only_flag:
		.db		1			; default to matching long file name only (unlike w95)
lfn_case_flag:
		.db		1			; default to case sensitive matching
filename_buffer:
		.db	261 .dup 0
path_buffer:
		.db	261 .dup 0

.include "doserr.inc"
.include "stack.inc"
.include "string.inc"
.include "disk.inc"
.include "int21.inc"
.include "directory.inc"
.include "lfn_find.inc"
.include "lfn_file.inc"
.include "lfn_dir.inc"
.include "lfn_misc.inc"

banner_message:
		.db		"lfn.exe copyright 1998 Bill Currie.\r\n"
		.db		"Long file name support.\r\n"
banner_length = . - banner_message
		.start
		push	cs
		pop		ds
		mov		[lfn_seg],ds
		mov		dx,banner_message
		mov		cx,banner_length
		call	write_message

		pushf
		pop		ax
		and		ah,0x0f
		mov		bh,ah
		push	ax
		popf
		pushf
		pop		ax
		and		ah,0xf0
		cmp		ah,0xf0		; if all bits 12-15 set, 
		jne		?is386		; oops, 8086/88
		jmpl	?not386
	?is386:
		mov		ah,bh
		or		ah,0xf0
		push	ax
		popf
		pushf
		pop		ax
		and		ah,0xf0		; if all bits 12-15 clear,
		jnz		?IS386		; oops, 286
	?not386:
		mov		dx,not386_message
		mov		cx,not386_length
		call	write_message
		jmpl	error_exit

	?IS386:
		mov		si,0x80
		cld
		es:
		lodsb
		xor		cx,cx
		mov		cl,al
		jcxz	end_of_command_line
scan_command_line:
		es:
		lodsb
		cmp		al,'\t'
		jz		?next_char
		cmp		al,' '
		jz		?next_char
		cmp		al,'\r'
		jz		?next_char
		cmp		al,'-'
		jnzl	invalid_arg
		dec		cx
		jzl		invalid_arg
		es:
		lodsb
		cmp		al,'?'
		jnz		?unload
		call	usage
		jmpl	ok_exit
	?unload:
		cmp		al,'u'
		jzl		unload_lfn
		jmpl	invalid_arg
	?next_char:
		loop	scan_command_line
end_of_command_line:

		mov		ax,0x3306
		int		0x21
		mov		ax,bx
		jnc		?vers_ok
		mov		ax,0x3000
		int		0x21
	?vers_ok:
		xchg	al,ah
		mov		[dos_version],ax
		; turf the environment block
		mov		ax,[es:0x2c]
		movw	[es:0x2c],0
		mov		es,ax
		mov		ah,0x49
		int		0x21
		; hook interrupt 0x21 (dos)
		mov		ax,0
		mov		es,ax
		; hook int 0x21
		mov		ax,cs
		shl		eax,16
		mov		ax,int21
		mov		edx,[es:0x21*4]
		mov		[old_int21],edx
		mov		[es:0x21*4],eax
		; close file handles
		mov		ah,0x3e
		mov		bx,0
		int		0x21
		mov		ah,0x3e
		mov		bx,1
		int		0x21
		mov		ah,0x3e
		mov		bx,2
		int		0x21
		mov		ah,0x3e
		mov		bx,3
		int		0x21
		mov		ah,0x3e
		mov		bx,4
		int		0x21
		; initialize lfn_find
		call	init_lfn_find
		; just haning around...
		push	cs
		pop		es
		mov		ax,0x3100				; TSR, 0 exit code
		mov		dx,__end+15+0x100
		shr		dx,4
		int		0x21

ok_exit:
		call	test_lfn
		mov		ax,0x4c00
		int		0x21

invalid_arg:
		mov		dx,invalid_arg_message
		mov		cx,invalid_arg_length
		call	write_message
		jmp		error_exit

write_message:
		; Writes a message to stderr
		; Call with:
		;	ds:dx -> message string
		;	cx -> message length
		stderr = 2
		mov		ah,0x40
		mov		bx,stderr
		int		0x21
		ret

error_exit:
		mov		ax,0x4c01
		int		0x21

usage:
		mov		dx,usage_message
		mov		cx,usage_length
		call	write_message
		ret

unload_lfn:
		jmp		error_exit

puts:
		push	cx
		push	dx
		push	di
		push	bx
		push	ds
		push	es

		push	ds
		pop		es
		xor		cx,cx
		dec		cx
		cld
		mov		di,si
		mov		al,0
		repne
		scasb
		not		cx
		dec		cx
		mov		ah,0x40
		mov		dx,si
		mov		bx,stderr
		int		0x21

		mov		ah,0x40
		mov		dx,?cr_lf
		push	cs
		pop		ds
		mov		cx,2
		mov		bx,stderr
		int		0x21

		pop		es
		pop		ds
		pop		bx
		pop		di
		pop		dx
		pop		cx
		ret
	?cr_lf:
		.db		"\r\n"

test_lfn:
		mov		ax,0x3306
		int		0x21
		mov		ax,bx
		jnc		?vers_ok
		mov		ax,0x3000
		int		0x21
	?vers_ok:
		xchg	al,ah
		mov		[dos_version],ax

		call	init_lfn_find
		push	cs
		pop		es
		mov		ax,0x7160
		mov		cx,0x0002
		mov		si,path
		mov		di,buffer
		call	lfn_dos_int
		mov		si,di
		call	puts
		movb	[buffer],0
		mov		ax,0x7160
		mov		cx,0x0001
		mov		si,path
		mov		di,buffer
		call	lfn_dos_int
		mov		si,di
		call	puts
		mov		ax,0x714e	;lfn find first
		mov		si,1		;dos date/time
		mov		cx,0x3f
		mov		dx,spec
		mov		di,finddata
		call	lfn_dos_int
		jc		?search_done
		mov		bx,ax		;find handle
	?search_loop:
		mov		si,finddata.lfn
		call	puts
		mov		ax,0x714f	;lfn find next
		mov		si,1		;dos date/time
		mov		cx,0x3f
		call	lfn_dos_int
		jnc		?search_loop
	?search_done:
		; close the search handle
		mov		ax,0x71a1
		call	lfn_dos_int

		mov		si,buffer
		mov		ax,0x7147	; get current directory
		mov		dl,0		; default drive
		call	lfn_dos_int
		call	puts

;		mov		si,fname
;		mov		ax,0x716c
;		mov		bx,2
;		mov		cx,0x0000
;		mov		dx,0x10
;		xor		di,di
;		call	lfn_dos_int

;		mov		bx,ax
;		mov		ah,0x3e
;		int		0x21

;		mov		ax,0x7141
;		mov		dx,fname
;		mov		si,0
;		call	lfn_dos_int

;		mov		ax,0x7139
;		mov		dx,fname
;		call	lfn_dos_int

;		mov		ax,0x713a
;		mov		dx,fname
;		call	lfn_dos_int

		call	uninit_lfn_find
		ret
lfn_dos_int:
		pushf
		push	cs
		call	int21
		ret
path:
		.db		"./LFN.ASM\0"
buffer:
		.db 261 .dup 0
finddata .struct FindData
spec:
		.db		"../foo/*\0"
;		.db		"*\0"
fname:
		.db		"TESTLONG.name\0"
not386_message:
		.db		"This program requires a 386 or better. Sorry.\r\n"
not386_length = . - not386_message

usage_message:
		.db		"Usage: lfn [arg]\r\n"
		.db		"  -?\tHelp\r\n"
		.db		"  -u\tUnload driver (not implemented)\r\n"
usage_length = . - usage_message

invalid_arg_message:
		.db		"Invalid arguement. Try -? for help.\r\n"
invalid_arg_length = . - invalid_arg_message

__end:
