/* CHOOSE
 * Displays a user-specified message, then waits for a keypress that is
 * in the provided list.
 *
 * Copyright (C) 1996 James Hall.
 */

#include <stdio.h>
#include <stdlib.h>

main (int argc, char **argv)
{
	int key, i, max_i;

	/* Check command line */

	if (argc < 3) {
		fprintf (stderr, "Incorrect number of arguments.\n");
		fprintf (stderr, "Usage: CHOOSE options message..\n");
		exit (0);
	}

	/* Uppercase the first argument */

	max_i = strlen (argv[1]);

	for (i = 0; i < max_i; i++) {
		argv[1][i] = toupper (argv[1][i]);
	}

	/* Display message */

	for (i = 2; i < argc; i++) {
		printf ("%s ", argv[i]);
	}

	/* Get the correct key */

	while (1) {
		key = toupper (x_getkey ());
		for (i = 0; i < max_i; i++) {
			if (key == argv[1][i]) {
				printf ("%c\n", key);
				exit (i + 1);
			}
		}
	}
}
