; A tool for APM power management in FreeDOS.
; Copyright Eric Auer 2003. Please do not spread - just send
; me (NASM) CODE to complete the project! When done, you will
; be credited and the project will be released under GPL 2.
; Please read apmnotes.txt for an outline of the workings.

; This file: The parser. Calls all other parts as appropriate.
; Sets up quitmode and tsrmode as appropriate. Destroys registers.
; Returns CY set if quitmode is 1. Function name: parseOptions.

quitmode	db 0	; 0 means EXIT, 1 means GO TSR
	; *** (TSR means: keep everything up to parser itself) ***
tsrmode		db 0	; 0 means no TSR, 1 means int 2f API needed
	; tsrmode can be 1 while quitmode is 0: use old TSR then.

; *** quitmsg	db "Done.",13,10,"$"
tsrmsg		db "Going resident.",13,10,"$"
oldtsrmsg	db "Configured resident POWER.",13,10,"$"

parseOptions:	; parse command line and call functions as needed.
	cld
	mov si,81h	; command line buffer (ignore length byte)
lpCase:	mov al,[si]
	cmp al,'a'
	jb okCase
	cmp al,'z'
	ja okCase
	sub al,'a'-'A'	; make command line upper case
	mov [si],al
okCase:	inc si
	cmp si,0ffh
	ja fullCL
	cmp al,13	; CR / NUL / ... end of line?
	ja lpCase
fullCL:	mov al,0
	dec si		; rewind the inc si
	mov [si],al	; NUL terminate command line
	mov [0ffh],al
	;
	mov si,81h	; command line buffer (ignore length byte)
preSkip:
	lodsb
	cmp al,'-'
	jz preSkip
	cmp al,'/'
	jz preSkip
	cmp al,' '
	jz preSkip
	cmp al,9	; TAB
	jz preSkip
	cmp al,13	; CR, NUL, etc.
	ja anyWord
noWord:
	call wxHelp	; show help screen if nothing found
	jmp short parserQuit
anyWord:
	dec si		; rewind SI after lodsb
	mov cx,si	; remember start
	mov si,keywordlist
tryNextWord:
	mov bx,cx	; (re-)point to word start
	lodsw		; pointer to string for comparison
	mov di,ax
	lodsw		; pointer to processing function
	mov bp,ax
	or di,di
	jz noWord	; end of list reached
	or bp,bp
	jz noWord	; end of list reached
strCmp:			; now compare strings at BX and DI
	mov al,[bx]	; USER word
	cmp al,[di]	; LIST word
	jnz tryNextWord	; comparison MISMATCH
	or al,al	; end of string?
	jz wordFound	; comparison MATCH
	inc di
	inc bx
	jmp short strCmp
	
wordFound:
	mov dx,wordfoundmsg
	mov ah,9
	int 21h
	mov si,cx	; fetch word again
citeIt:	mov al,[si]
	or al,al	; cite word until NUL reached
	jz cited
	call showtty
	inc si
	jmp short citeIt
cited:	call crlf	; go to next line on stdout
	mov ax,processedReturn
	push ax		; where to RETURN from CALL
	push bp		; where to START with CALL
	ret		; CALL the processing function!

processedReturn:	; DONE with all (only 1 word checked)
	mov al,[ds:tsrmode]
	or al,al		; TSR involved?
	jz noTSRused
	call statusPOWER	; *** show status of the TSR
noTSRused:
	mov al,[ds:quitmode]
	or al,al
	jz parserQuit
	stc
	ret

parserQuit:
; ***	mov dx,quitmsg
; ***	mov ah,9
; ***	int 21h
	clc
	ret

; -------------

	; SHOW APM INFORMATION
wxInfo:	call statusAPM
	mov ax,[cs:apmversion]
	cmp ax,100h
	jae wxInf1
	mov dx,noapminfomsg
	mov ah,9
	int 21h
wxInf1:	ret

	; SHOW POWER TSR INFORMATION
wxStats:
	call statusPOWER
	ret

	; UNLOAD TSR (JUST TELL "NOT IMPLEMENTED")
wxUnl:	mov dx,unloadmsg
	mov ah,9
	int 21h
	ret

	; SHOW HELP MESSAGE
wxHelp:	mov dx,helpmsg
	mov ah,9
	int 21h
	ret

; -------------

	; DISABLE ALL SAVINGS
wxOff:	call connectAPM
	jc wxOffNoAPM
	mov ax,5306h	; CPU BUSY
	int 15h
	call disableAPM
	jmp short wxOffAPM
wxOffNoAPM:
	mov dx,havenoapmmsg
	mov ah,9
	int 21h
wxOffAPM:
	mov ax,5400h
	xor bx,bx
	int 2fh ; POWER install check
	cmp bx,504dh
	jnz wxOffNoPOWER
	mov ax,5401h
	mov bx,0100h	; set (1) to mode "no DOS, no APM" (0)
	int 2fh
	ret
wxOffNoPOWER:
	mov dx,havenopowermsg
	mov ah,9
	int 21h
	ret

	; ENABLE BIOS APM SAVINGS
	; Should a POWER be installed if only BIOS APM requested?
	; Currently, my answer to this question is NO.
wxBios:	call connectAPM
	jc wxBiosNoAPM
	mov ax,5305h	; CPU IDLE (until next IRQ)
	int 15h
	call enableAPM
	jmp short wxBiosAPM
wxBiosNoAPM:
	mov dx,havenoapmmsg
	mov ah,9
	int 21h
wxBiosAPM:
	mov ax,5400h
	xor bx,bx
	int 2fh ; POWER install check
	cmp bx,504dh
	jnz wxBiosNoPOWER
	mov ax,5401h
	mov bx,0102h	; set (1) to mode "no DOS, but APM" (2)
	int 2fh
	ret
wxBiosNoPOWER:
	mov dx,havenopowermsg
	mov ah,9
	int 21h
	ret

	; ENABLE DOS AND BIOS APM SAVINGS
	; Should a POWER be installed if only BIOS APM requested?
	; Currently, my answer to this question is NO.
wxDos:	call connectAPM
	jc wxDosNoAPM
	mov ax,5305h	; CPU IDLE (until next IRQ)
	int 15h
	call enableAPM
	jmp short wxDosAPM
wxDosNoAPM:
	mov dx,havenoapmmsg
	mov ah,9
	int 21h
wxDosAPM:
	mov ax,5400h
	xor bx,bx
	int 2fh ; POWER install check
	cmp bx,504dh
	jz wxDosPOWER
	; *** if no POWER TSR found, create one!
useTSR:	call hookhandlers	; HOOK ALL NEEDED INTERRUPTS!
	jc existingTSR
newTSR:	mov dx,tsrmsg
	mov ah,9
	int 21h
	mov byte [quitmode],1
	jmp short wxDosPOWER
existingTSR:
	mov dx,oldtsrmsg
	mov ah,9
	int 21h
	; ***
wxDosPOWER:
	mov ax,5401h
	mov bx,0103h	; set (1) to mode "DOS and APM" (3)
	int 2fh
	ret

; -------------

	; PUT SYSTEM INTO STAND BY MODE
wxStdby:
	mov ax,3	; stand-by
	call shutDownHandler
	jmp short wxNorm

	; PUT SYSTEM INTO SUSPEND MODE
wxSusp:
	mov ax,4	; suspend
	call shutDownHandler
	jmp short wxNorm

	; POWER OFF SYSTEM (NEEDS APM 1.2+)
wxPowOff:
	mov ax,5	; power off
	call shutDownHandler
	; (probably not reached)
	; (fall through to wxNorm anyway: MY BIOS offers power off
	; but MY POWER SUPPLY cannot turn itself off!)
	; shutDownHandler itself already goes "SUSPEND" if "OFF" is n/a!
	; jmp short wxNorm

wxNorm:			; system RETURNING from standby / suspend
	mov dx,normalstatemsg
	mov ah,9
	int 21h
	ret

	; INT 19 REBOOT
wxHot:
	mov ax,0	; hot reboot
	call shutDownHandler
	ret


	; WARM REBOOT
wxWarm:
	mov ax,1	; warm reboot
	call shutDownHandler
	ret


	; COLD REBOOT
wxCold:
	mov ax,2	; cold reboot
	call shutDownHandler
	ret

	; TURN ON VGA SIGNAL
wxVgaOn:
	mov ax,0x1200	; ENABLE refresh
	jmp short wxVga

	; TURN OFF VGA SIGNAL / SCREEN
wxVgaOff:
	mov ax,0x1201	; DISABLE refresh
wxVga:
	mov bl,0x36
	push ax
	int 0x10	; INT 10.1012.BL=36 VGA refresh control
	; returns AL=12 if function supported, but the user will
	; notice anyway... (whole screen will show DAC[0] color)
	pop bx		; BL is used to remember the on/off decision
	; *** TODO: check if VGA is really present! ***
	; *** TODO: decide whether 3d4 or 3b4 is correct ***
	; int 10.1012.bl=36 is VGA only, but the rest is EGA and VGA
	;
	mov dx,0x3c4
	mov al,1	; EGA/VGA sequencer: clocking
	out dx,al
	inc dx
	in al,dx
	and al,0xd0	; VGA screen refresh on
	cmp bl,0	; 0 means "enable"
	jz wxVgaOn1	; if enabled, skip "refresh off"
	or al,0x20	; VGA screen refresh off
wxVgaOn1:
	out dx,al
	;
	mov dx,0x3d4	; *** TODO: check color/mono *** *** *** ***
	mov al,0x17	; EGA/VGA: mode control
	out dx,al
	inc dx
	in al,dx
	and al,0x7f	; reset/stop CRTC
	cmp bl,1	; 1 means "disable"
	jz wxVgaOff1	; if disabled, stay in stop mode
	or al,0x80	; CRTC resume from stop
wxVgaOff1:
	out dx,al
	ret

; -------------

wxOff2:	
	call compatwarn
	jmp wxOff
wxBios2:
	call compatwarn
	jmp wxBios
wxDos2:
	call compatwarn
	jmp wxDos

compatwarn:
	push ds
	push ax
	push dx
	mov ax,cs
	mov ds,ax
	mov dx,compatmsg
	mov ah,9
	int 0x21
	pop dx
	pop ax
	pop ds
	ret

; -------------

keywordlist:
	dw wOff, wxOff, wBios, wxBios, wDos, wxDos
	dw wOffMS, wxOff2, wBiosMS, wxBios2, wDosMS1, wxDos2
	dw wDosMS2, wxDos2, wDosMS3, wxDos2, wDosMS4, wxDos2
	dw wInfo, wxInfo, wStats, wxStats, wUnl, wxUnl, wHelp, wxHelp
	dw wStdby, wxStdby, wSusp, wxSusp, wPowOff, wxPowOff
	dw wHot, wxHot, wWarm, wxWarm, wCold, wxCold
	dw wVgaOn, wxVgaOn, wVgaOff, wxVgaOff
	dw wSpinUp, spinUpDisks, wSpinDn, spinDownDisks
	dw 0,0

wOff	db "APMOFF",0
wOffMS	db "OFF",0
wBios	db "APMBIOS",0
wBiosMS	db "STD",0
wDos	db "APMDOS",0
wDosMS1	db "ADV",0
wDosMS2	db "ADV:MIN",0
wDosMS3	db "ADV:REG",0
wDosMS4	db "ADV:MAX",0

wInfo	db "INFO",0
wStats	db "STATS",0
wUnl	db "UNLOAD",0
wHelp	db "HELP",0

wStdby	db "STANDBY",0
wSusp	db "SUSPEND",0
wPowOff	db "POWEROFF",0

wHot	db "HOTBOOT",0
wWarm	db "WARMBOOT",0
wCold	db "COLDBOOT",0

wVgaOn	db "VGAON",0
wVgaOff	db "VGAOFF",0

wSpinUp	db "SPINUP",0
wSpinDn	db "SPINDOWN",0

unloadmsg	db "Removal of an existing POWER TSR"
		db " not yet possible.",13,10,"$"

normalstatemsg	db "System returning to normal power on state."
		db 13,10,"$"

noapminfomsg	db "At least APM 1.0 needed - "
		db "cannot show information.",13,10,"$"
havenoapmmsg	db "APM not available, skipping setup.",13,10,"$"
havenopowermsg	db "POWER not resident, skipping setup.",13,10,"$"

wordfoundmsg	db "Performing action: $"

compatmsg	db "Compatibility warning: Please use APMOFF,",13,10
		db "APMDOS and APMBIOS instead of OFF, ADV...",13,10
		db "and STD options (which are mapped to FDAPM",13,10
		db "modes to give you more command line 'POWER'",13,10
		db "compatibility).",13,10,"$"

helpmsg	db "Usage: Give any one option from the following list.",13,10
	db "You can prefix options with -, -- or / if you want.",13,10
	db "Case of options is irrelevant. This is GPL 2 software."
	db 13,10,13,10
	db "APMoff   - turn off BIOS APM savings, go full speed",13,10
	db "APMbios  - enable standard BIOS APM savings",13,10
	db "APMdos   - use resident handler for DOS and BIOS savings",
	db 13,10
	db "HELP     - display this help screen",13,10
	db "INFO     - show information about APM status",13,10
	db "STATS    - show statistics of resident handler",13,10
	db "UNLOAD   - remove resident handler (not yet possible)"
	db 13,10,13,10
	db "STANDBY  - flush caches and enter stand-by mode",13,10
	db "SUSPEND  - flush caches, stop IDE disks, enter suspend mode"
	db 13,10
	db "POWEROFF - flush caches, stop IDE disks, power off VGA and system"
	db 13,10
	db "VGAOFF   - turn off VGA (DPMS screen saver)",13,10
	db "VGAON    - turn on VGA again",13,10
	db "HOTBOOT  - reboot using int 19h "
	db "(only reload DOS kernel, dangerous!)",13,10
	db "WARMBOOT - perform a classical warm reboot",13,10
	db "COLDBOOT - perform a cold boot (like at power on)",13,10
	db "$"

	; SPINUP and SPINDOWN are undocumented commands due to lack of
	; space in the help screen for now...
	; I did not even issue a CACHE FLUSH before SPINDOWN, so this
	; really is a command line option for experts ;-)


