/**********************************************************************

  SHSUCDX Version 1.4b
  (c) John H. McCoy, October 2000
  csc_hm@shsu.edu

  Version 2.0
  Jason Hood, June 2003
  jadoxa@yahoo.com.au

  Version 2.0 modifies the filename generation for long ISO entries. Instead
     of using the first eleven characters, it uses the first eight, skips to
     the dot, then uses the next three. There is also an option to generate
     "tilded" entries (similar, but not identical, to Windows), which
     overcomes same-name limitations. The block size has been fixed at 2K;
     set VARBLKSIZE (in undoc.inc and redir.h) to read the block size from
     the CD.

  Version 1.4b fixed a problem with findfirst that caused a problem when
     a program expected getting the volid would also set it up for
     scanning the root directory with findnext.

  Version 1.4a changed the dos version check so that it will rund under MEDos
     with set ver.  MEDos is version 8

  Version 1.4 increased the allowed length of directories from 64K bytes to
     64K sectors (128 M bytes) to solve the problem of lost entries that
     occurred when a directory exceeded 32 sectors.

  SHSUCDX Version 1.1a
  (c) John H. McCoy, May 1996
  Sam Houston St. Univ., TX 77341-2206

  CMDS.C is a subset of redirector functions used by SHSUCDX.  SHSUCDX
  is an unloadable CD_ROM redirector substitute for the Mirosoft CD-ROM
  extensions (MSCDEX).

  Microsoft has not documented the redirector functions.  I have borrowed
  from and am particularly indebted to the authors of:

     A CD-ROM redirector for HighSierra and ISO 9660 disks.
	Jim Harper, DDJ, March 1993

     Inside the ISO-9660 Filesystem Format
	William and Lynne Jolitz, DDJ, December 1992

     Undocumented DOS, Chapter 4.
	Andrew Schulman, et. al, Addison Wesley, 1990

   SHSUCDX and CMDS.C are copyright reserved, free use programs.
   (c)John H. McCoy, 2000, Sam Houston St. Univ., TX 77341-2206

   Modified September 2000 - changed ParentSize in SDB from bytes to
     blocks.  Upped directory size from 64K to 128M

***********************************************************************
   C subroutines written for MSC 5.1
   jmh: I've used MSC 8.00c, tweaked to produce the best assembly
***********************************************************************/

#pragma check_stack(off)

#include <stdlib.h>
#include <memory.h>
#include <dos.h>

typedef unsigned char BYTE;
typedef unsigned int  WORD;
typedef unsigned long DWORD;
typedef void*         NPTR;
typedef void far*     FPTR;

#pragma pack(1)
#include "cdrom.h"
#include "redir.h"

/* Set & Clear Error Flag MACROS */
#define SetC() _FLAGS |=  0x01
#define ClrC() _FLAGS &= ~0x01

typedef struct DirEnt* PDirEnt;
typedef char _far* FPchar;

/* Globals.  Most of these are set up in SHSUCDX.ASM */
extern FPchar FN1p, SAttrp;
extern FPchar _far* DTApp;
extern struct SDB _far* SDBp;
extern BYTE DriveNo, NoDrives;
extern WORD _AX, _BX, _CX, _DX, _SI, _DI, _ES, _FLAGS;

extern struct DrvEnt  Drive[];
extern struct DrvEnt* DriveOfs;

#define IOBuf (DriveOfs->Bufp)
WORD far* Ticks = (WORD far*)0x0040006CL; /* clock in BIOS data area */

#ifdef VARBLKSIZE
# define DrvBlkSize  (DriveOfs->BlkSize)
# define DrvBlkShift (DriveOfs->BlkShift)
#else
# define DrvBlkSize  2048
# define DrvBlkShift   11
#endif

/* Protos */

void pascal ToIBM( char*, int, FPchar, int ),
     pascal ToFront( PDirEnt ),
     pascal InitCD( void ),
     pascal GetCABID( BYTE, FPchar );

WORD pascal SetDDD( BYTE ),
     pascal ForUs( BYTE ),
     pascal CDMediaChanged( void ),
     pascal GetDirEntry( FPchar, FPchar ),
     pascal DoGetSpace( void ),
     pascal DoChDir( void ),
     pascal DoFindFirst( void ),
     pascal DoFindNext( void ),
     pascal DoGetAttr( void ),
     pascal DoOpen( struct SFT _far* ),
     pascal DoRead( struct SFT _far* ),
     pascal DoClose( struct SFT _far* ),
     pascal DoSeek( struct SFT _far* ),
     pascal CdReadBlk( DWORD ),
     pascal CdReadLong( FPchar, DWORD, WORD );

DWORD pascal ToDosDateTime( struct Date_Time* );

int pascal Match( char*, char* ),
    pascal Lookup( PDirEnt* ),
    pascal DirLook( PDirEnt*, char* );

PDirEnt pascal LookupDir( void ),
	pascal PathLookup( char* );

//char pascal to_upper( char );
char* pascal FindEntry( PDirEnt, char*, char* );

/* For some reason this function gets included, but it is not referenced.
   Provide a dummy one to save a few bytes.
*/
void _aNulshr( void ) { }


WORD pascal SetDDD( BYTE DriveLetter )
/* Search for matching drive letter and set DriveOfs and DriveNo */
{
  int i;

  i = NoDrives;
  DriveOfs = Drive;
  do
  {
    if (DriveOfs->Letter == DriveLetter)
    {
      DriveNo = DriveOfs->No;
      break;
    }
    DriveOfs++;
  } while (--i != 0);

  return( i );
}


WORD pascal ForUs( BYTE DriveLetter )
{
  /* See if this call is for us and set DriveOfs and DriveNo */

  if (!SetDDD( DriveLetter )) return( 1 );

  /* Force re-init if it's been a while and the media has changed.  */

  if ((*Ticks - DriveOfs->LastAccess) > 128)
  {
    if (CDMediaChanged() != 1)
    {
      DriveOfs->Type = UNKNOWN;
    }
  }

  /* May need to initialize this drive	*/

  if (DriveOfs->Type == UNKNOWN)
  {
    DriveOfs->BufBlkNo = 0xFFFFFFFFL;
    if (CdReadBlk( 0x10L ))
    {
      return( 2 );
    }
    else
    {
      InitCD();
    }
  }

  DriveOfs->LastAccess = *Ticks;

  return( 0 );
}


void pascal InitCD( void )
{
  struct isoVolDesc* isoVolDescp;
  struct isoDirRec*  isoDp;
  struct hsVolDesc*  hsVolDescp;
  //struct hsDirRec*   hsDp;	// the relevant fields are the same
  PDirEnt	     Dp, rDp;
  char* 	     volid = NULL;

  /* Flush the directory cache */

  rDp = &DriveOfs->RootEnt;
  Dp = rDp->Forw;
  do
  {
    Dp->FName[0] = '\0';
    Dp = Dp->Forw;
  } while (Dp != rDp);

  hsVolDescp = (struct hsVolDesc*)IOBuf;
  isoVolDescp = (struct isoVolDesc*)IOBuf;

  //if (memcmp( isoVolDescp->ID, "CD001", 5 ) == 0)
  if (*(DWORD*)isoVolDescp->ID == 0x30304443L && isoVolDescp->ID[4] == '1')
  {
    DriveOfs->Type = ISO9660;
#ifdef VARBLKSIZE
    DriveOfs->BlkSize = isoVolDescp->BlkSizeLSB;
#endif
    DriveOfs->VolSize = isoVolDescp->VolSizeLSB;
    isoDp = (struct isoDirRec*)isoVolDescp->DirRec;
    volid = isoVolDescp->VolID;
    goto do_copy;
  }
  //if (memcmp( hsVolDescp->ID, "CDROM", 5 ) == 0)
  if (*(DWORD*)hsVolDescp->ID == 0x4f524443L && hsVolDescp->ID[4] == 'M')
  {
    DriveOfs->Type = HIGHSIERRA;
#ifdef VARBLKSIZE
    DriveOfs->BlkSize = hsVolDescp->BlkSizeLSB;
#endif
    DriveOfs->VolSize = hsVolDescp->VolSizeLSB;
    isoDp = (struct isoDirRec*)hsVolDescp->DirRec;
    volid = hsVolDescp->VolID;
    goto do_copy;
  }
  return;

do_copy:
  memcpy( DriveOfs->VLabel, volid, 11 );

  rDp->Fattr = _A_SUBDIR;
  rDp->FTime = ToDosDateTime( &isoDp->Date );
  rDp->ParentBlk =
  rDp->BlkNo = isoDp->ExtLocLSB;
  rDp->FSize = isoDp->DataLenLSB;

#ifdef VARBLKSIZE
  DriveOfs->BlkShift = 10;	// 2048 is the minimum
  while ((DriveOfs->BlkSize >> ++DriveOfs->BlkShift) != 1) ;
#endif
}


void pascal GetCABID( BYTE ActionCode, FPchar XBufp )
{
  int		     i;
  struct isoVolDesc* isoVolDescp;
  char* 	     CABp;

  CdReadBlk( 0x10L );

  isoVolDescp = (struct isoVolDesc*)IOBuf;

  if (DriveOfs->Type == HIGHSIERRA)
  {
    if (ActionCode == 0x04)
    {
      goto done;	/* no such thing for hs */
    }
    else
    {
      i = 32;
      CABp = ((struct hsVolDesc*)isoVolDescp)->CopyRightID;
    }
  }
  else
  {
    i = 37;
    CABp = isoVolDescp->CopyRightID;
  }
  switch ((char)ActionCode)
  {
    case 0x04: CABp += i;
    case 0x03: CABp += i;
  }
  while (*CABp != ' ')
  {
    *XBufp++ = *CABp++;
    if (--i == 0) break;
  }
done:
  *XBufp = '\0';
}


WORD pascal GetDirEntry( FPchar Dp, FPchar Pathp )
{
  char	  Name[11], WantName[11];
  PDirEnt pDp;
  char*   Chp;
  FPchar  Fnp;

  if (*Pathp != PATHSEPARATOR)
  {
    SetC();
    return( FILENOTFOUND );
  }

  Fnp  = FN1p;
  FN1p = Pathp - RootSlashOff;

  pDp  = PathLookup( WantName );

  FN1p = Fnp;

  if (!pDp) return( PATHNOTFOUND );

  Chp = FindEntry( pDp, WantName, Name );

  if (Chp == (char*)-1)
  {
    SetC();
    return( FILENOTFOUND );
  }

  _fmemcpy( Dp, Chp, *(BYTE*)Chp );

  ClrC();
  return( (char)(DriveOfs->Type - HIGHSIERRA) );
}


WORD pascal DoChDir( void )
{
  return( LookupDir() ? 0 : PATHNOTFOUND );
}


WORD pascal DoFindFirst( void )
{
  PDirEnt	   Dp;
  WORD		   Err;
  char		   TemPlate[11], SAttr;
  struct FDB _far* FDBp;

  if (!(Dp = PathLookup( TemPlate ))) return( PATHNOTFOUND );

  /* Fill in the SDB */
  _fmemcpy( SDBp->TemPlate, TemPlate, 11 );
  SDBp->DriveLet = DriveNo | 0xC0;
  SDBp->ParentBlk = (Dp->FSize - 1) >> DrvBlkShift;
  SDBp->ParentSize = (WORD)SDBp->ParentBlk;
  SDBp->ParentBlk = Dp->BlkNo;
  SDBp->Entry = (Dp->BlkNo == DriveOfs->RootEnt.BlkNo)
		? 2  /* Skip the . & .. entries in root dir */
		: 0;
  SDBp->SAttr = SAttr = *SAttrp;

  /* Handle vol id */
  if (SAttr & _A_VOLID)
  {
    if (SAttr == _A_VOLID || SDBp->Entry == 2)
    {
      FDBp = (struct FDB _far*)(*DTApp + sizeof( struct SDB ));
      FDBp->FTime = 0;
      //FDBp->FDate = 0;
      FDBp->FSize = 0;
      FDBp->Fattr = _A_VOLID;
      _fmemcpy( FDBp->FName, DriveOfs->VLabel, 11 );

      ClrC();
      return( 0 );
    }
  }

  /* Now see if it can be found */
  Err = DoFindNext();
  //return (Err == NOMOREFILES) ? FILENOTFOUND : Err;
  return( Err ? FILENOTFOUND : 0 );
}


WORD pascal DoFindNext( void )
{
  int		   FlagsOff;
  BYTE		   Flags, SAttr;
  WORD		   Entry;
  char		   *Chp, *BlkEnd;
  char		   IBMName[11], TemPlate[11];
  DWORD 	   BlkNo;
  struct FDB _far* FDBp;

  struct SDB _far* lSDBp = SDBp;
  #define SDBp lSDBp

  /* Make sure we're not continuing an already finished searched. */
  if (SDBp->ParentSize == (WORD)-1)
  {
    SetC();
    return( NOMOREFILES );
  }

  /* Get copy of search template */
  _fmemcpy( TemPlate, SDBp->TemPlate, 11 );

  /* Where's the end of the dir extent?
     ISO directories are supposed to be padded with zeroes to 2048
     bytes.  Don't know about HS and not all ISO CD's do so we will
     take precautions.
  */
  BlkEnd = IOBuf + DrvBlkSize;

  FlagsOff = DriveOfs->Type;
  SAttr = SDBp->SAttr;

  /* Search parent dir for matching entry */
  Entry = SDBp->Entry & 0xffc0u;
  BlkNo = SDBp->ParentBlk;
  do
  {
    CdReadBlk( BlkNo );
    Chp = IOBuf;
    do
    {
      /* Ignore entries < our start entry # */
      if ((Entry >= SDBp->Entry) && !(Chp[FlagsOff] & ASSOCFILE))
      {
	//Flags  = (Chp[FlagsOff] & DIR)    ? _A_SUBDIR : _A_NORMAL;
	//Flags |= (Chp[FlagsOff] & HIDDEN) ? _A_HIDDEN : 0;
	Flags  = (Chp[FlagsOff] & DIR)	  << 3;
	Flags |= (Chp[FlagsOff] & HIDDEN) << 1;

	if ((SAttr & Flags) == Flags)
	{
	  ToIBM( IBMName, Chp[FIDLenoff], Chp + Nameoff, Entry );
	  if (!Match( IBMName, TemPlate ))
	  {
	    /* Save start point for next time */
	    SDBp->Entry = Entry + 1;

	    /* Fill in the FDB */
	    FDBp = (struct FDB _far*)(*DTApp + sizeof( struct SDB ));
	    FDBp->FTime = ToDosDateTime( (struct Date_Time*)(Chp + Dateoff) );
	    FDBp->FSize = *((DWORD*)(Chp + Sizeoff));
	    FDBp->Fattr = Flags;
	    _fmemcpy( FDBp->FName, IBMName, 11 );

	    ClrC();
	    return( 0 );
	  }
	}
      }
      Entry++;
      Chp += *(BYTE*)Chp;
    } while (*Chp && Chp < BlkEnd);

    /* Update things especially the SDB */
    Entry = (Entry & 0xffc0u) + 64;
    BlkNo++;
    SDBp->Entry = Entry;
    SDBp->ParentBlk++;
  } while ((int)--SDBp->ParentSize >= 0);

  #undef SDBp

  SetC();
  return( NOMOREFILES );
}


WORD pascal DoGetAttr( void )
{
  PDirEnt Dp;
  int	  Err;

  /* Look up filename (full path) */
  if ((Err = Lookup( &Dp )) != 0) return( Err );

  /* Get attributes */
  return( Dp->Fattr );
}


WORD pascal DoOpen( struct SFT _far* SFTp )
{
  PDirEnt Dp;
  WORD	  Err;

  /* Look up filename */
  if ((Err = Lookup( &Dp )) != 0) return( Err );

  /* Gotta be a file, not a dir */
  if (Dp->Fattr & _A_SUBDIR)
  {
    SetC();
    return( FILENOTFOUND );
  }

  /* Fill in SFT */
  _fmemcpy( SFTp->Name, Dp->FName, 11 );
  SFTp->Mode |= 0x02;
  SFTp->Flags = 0x8000 | 0x40 | (char)DriveNo;
  SFTp->DirAttrib = Dp->Fattr;
  SFTp->YMDHMS = Dp->FTime;
  SFTp->FBN = Dp->BlkNo;
  SFTp->FilSiz = Dp->FSize;
  SFTp->FilPos = 0;

  return( 0 );
}


WORD pascal DoRead( struct SFT _far* SFTp )
{
  FPchar DTAp;
  WORD	 Offset, NumRead, ReadLen;
  DWORD  BlkNo;
  long	 left;

  left = SFTp->FilSiz - SFTp->FilPos;

  /* Cant't read past EOF */
  if (left <= 0)
  {
    _CX = 0;
  }
  else if (_CX)
  {
    /* Chop read back if too long */
    if (_CX > (DWORD)left)
      _CX = (WORD)left;

    /* Keep track of how much left to read */
    ReadLen = _CX;

    /* Get DTA ptr */
    DTAp = *DTApp;

    /* Calc blk w/start of data */
    Offset = (WORD)(SFTp->FilPos & (DrvBlkSize - 1));
    BlkNo = SFTp->FBN + (SFTp->FilPos >> DrvBlkShift);
    do
    {
      if (ReadLen >= DrvBlkSize && Offset == 0)
      {
	/* Read complete blocks */
	NumRead = ReadLen >> DrvBlkShift;
	CdReadLong( DTAp, BlkNo, NumRead );
	BlkNo += NumRead;
	NumRead <<= DrvBlkShift;
      }
      else
      {
	/* Partial block */
	NumRead = min( DrvBlkSize - Offset, ReadLen );
	CdReadBlk( BlkNo++ );
	_fmemcpy( DTAp, IOBuf + Offset, NumRead );
	Offset = 0;
      }
      SFTp->FilPos += NumRead;
      DTAp += NumRead;
      ReadLen -= NumRead;
    } while (ReadLen);
  }

  ClrC();
  return( 0 );
}


WORD pascal DoClose( struct SFT _far* SFTp )
{
  //if (SFTp->RefCnt >= 1) SFTp->RefCnt--;
  if ((int)--SFTp->RefCnt < 0) SFTp->RefCnt++;

  ClrC();
  return( 0 );
}


DWORD pascal ToDosDateTime( struct Date_Time* Date )
{
  WORD d, t;
  int  y;

  d = (Date->Mth << 5) | Date->Day;
  y = Date->Yr - 80;
  if (y > 0)
    d |= y << 9;

  t = (Date->Hr << 11) | (Date->Min << 5) | (Date->Sec >> 1);

  return( ((DWORD)d << 16) | t );
}


PDirEnt pascal PathLookup( char* Namep )
/*
 * Find name, returning its directory and placing its IBM name in Namep.
 */
{
  int	  i, j;
  FPchar  Fnp;
  PDirEnt Dp;

  /* find last path separator */
  for (i = j = RootSlashOff; FN1p[j]; j++)
    if (FN1p[j] == PATHSEPARATOR) i = j;

  Fnp = FN1p + i;
  if (i == RootSlashOff)
  {
    Dp = &DriveOfs->RootEnt;
    if (*Fnp) ++Fnp;
  }
  else
  {
    /* Isolate directory path */
    *Fnp = '\0';

    /* Look for the directory */
    Dp = LookupDir();

    /* Restore full pathname */
    *Fnp++ = PATHSEPARATOR;

    /* Gotta be a dir, not a file */
    if (!Dp)
    {
      return( Dp );
    }
  }
  for (i = 0; Fnp[i]; i++) ;
  ToIBM( Namep, i, Fnp, 0 );

  return( Dp );
}


PDirEnt pascal LookupDir( void )
{
  PDirEnt Dp;

  if (Lookup( &Dp ) != 0) return( 0 );

  /* Gotta be a dir, not a file */
  if ((Dp->Fattr & _A_SUBDIR) == 0)
  {
    SetC();
    return( 0 );
  }

  return( Dp );
}


int pascal Lookup( PDirEnt* Dpp ) /* Find name in dir if it exists */
{
  char	  Name[11];
  PDirEnt cDp;
  int	  i, Err;
  FPchar  Pathp;

  /* Start at root */
  cDp = &DriveOfs->RootEnt;

  /* Skip drive letters form \\D.\U.    */
  Pathp = FN1p + RootSlashOff;

  while (*Pathp == PATHSEPARATOR)
  {
    i = 0;
    ++Pathp;
    while (Pathp[i] && Pathp[i] != PATHSEPARATOR) i++;

    /* Convert Name to IBM style */
    ToIBM( Name, i, Pathp, 0 );

    /* Look up Name */
    if ((Err = DirLook( &cDp, Name )) != 0)
    {
      SetC();
      return( Err );
    }

    Pathp += i;
  }
  *Dpp = cDp;

  ClrC();
  return( 0 );
}


int pascal DirLook( PDirEnt* cDpp, char* Name )
/*
 * See if Name is present in *cDpp, if so return a DirEnt struct using cDpp
 * *cDpp - Parent DirEnt structure pointer.
 * cDpp - Child DirEnt structure pointer pointer.
 */
{
  PDirEnt Dp, pDp, rDp;
  char	  *Chp, FName[11];

  pDp = *cDpp;

  /* Is a dir? */
  if ((pDp->Fattr & _A_SUBDIR) == 0) return( PATHNOTFOUND );

  /* Check cache */
  rDp = &DriveOfs->RootEnt;
  Dp = rDp->Forw;
  do
  {
    if (Dp->ParentBlk == pDp->BlkNo && !memcmp( Name, Dp->FName, 11 ))
    {
      ToFront( Dp );
      *cDpp = Dp;
      return( 0 );
    }
    Dp = Dp->Forw;
  } while (Dp != rDp);

  Chp = FindEntry( pDp, Name, FName );

  if (Chp == (char*)-1) return( FILENOTFOUND );

  /* Take from tail of cache queue */
  Dp = DriveOfs->RootEnt.Back;
  memcpy( Dp->FName, FName, 11 );
  Dp->Fattr = ((Chp[DriveOfs->Type] & DIR)    << 3)
	    | ((Chp[DriveOfs->Type] & HIDDEN) << 1);
  Dp->FTime = ToDosDateTime( (struct Date_Time*)(Chp + Dateoff) );
  Dp->BlkNo = *((DWORD*)(Chp + Blkoff)) + *((BYTE*)(Chp + 1));
  Dp->FSize = *((DWORD*)(Chp + Sizeoff));
  Dp->ParentBlk = pDp->BlkNo;

  /* Move Dp to front of cache queue */
  ToFront( Dp );

  *cDpp = Dp;
  return( 0 );
}


char* pascal FindEntry( PDirEnt pDp, char* Name, char* FName )
/*
 * See if Name (in IBM style) is present in pDp (which is a directory).
 * If so return a pointer to it's directory entry with the IBM style name
 * copied to FName; otherwise -1.
 */
{
  char	*Chp, *BlkEnd;
  DWORD BlkNo, BlkSize;
  long	EndBlk;
  int	FlagsOff, Entry;

  /* Where's the end of the dir extent?
     ISO directories are supposed to be padded with zeroes to 2048
     bytes.  Don't know about HS and not all ISO CD's do so we will
     take precautions.
  */
  BlkSize = DrvBlkSize;
  BlkEnd = IOBuf + (WORD)BlkSize;
  EndBlk = pDp->FSize;

  /* Read dir extent and scan it for match */
  FlagsOff = DriveOfs->Type;
  Entry = 0;
  BlkNo = pDp->BlkNo;
  do
  {
    CdReadBlk( BlkNo );
    Chp = IOBuf;
    do
    {
      /* ignore associative entries  */
      if (!(Chp[FlagsOff] & ASSOCFILE))
      {
	/* Convert to IBM style name */
	ToIBM( FName, Chp[FIDLenoff], Chp + Nameoff, Entry );
	if (!Match( FName, Name ))
	{
	  return( Chp );
	}
      }
      Entry++;
      Chp += *(BYTE*)Chp;
    } while (*Chp && Chp < BlkEnd);
    Entry = (Entry & 0xffc0u) + 64;
    BlkNo++;
    EndBlk -= BlkSize;
  } while (EndBlk > 0);

  return( (char*)-1 );
}


void pascal ToFront( PDirEnt Dp ) /* Move cache entry to front */
{
  Dp->Forw->Back = Dp->Back;		/* Unlink */
  Dp->Back->Forw = Dp->Forw;

  Dp->Forw = DriveOfs->RootEnt.Forw;	/* Link in after RootEnt */
  DriveOfs->RootEnt.Forw = Dp;
  Dp->Back = Dp->Forw->Back;
  Dp->Forw->Back = Dp;
}
