#!/bin/bash

# some NASM versions need -d, others -D ...

echo Now creating debug versions lbacachD.sys and lbacachD.com...
nasm -o comcache.bin comcache.asm
nasm -DSDEBUGNB=1 -DREDIRBUG=1 -o lbacachd.sys lbacache.asm
cat comcache.bin lbacachd.sys > lbacachd.com
upx --8086 lbacachd.sys lbacachd.com
echo Debug versions lbacachD.com and lbacachD.sys have been updated.

echo Now creating lbacache.sys and lbacache.com...
nasm -o comcache.bin comcache.asm
nasm -DREDIRBUG=1 -o lbacache.sys lbacache.asm
cat comcache.bin lbacache.sys > lbacache.com
echo lbacache.com and lbacache.sys have been updated.

# in the past, you could create uncache.com from uncache.asm
# now,         uncache is part of lbacache.

ls -l *.com *.sys

echo
echo Please move lbacach*.{com,sys} to ../../BIN/
echo if you want to make them the active version now.

