; provids some convenient string routines
; strncpy
; strcpy
; strlen
; end_of_string

strncpy:
		; Much like strncpy in C
		; in
		;	ds:si=source asciiz string
		;	es:di=destination buffer
		;	cx=destination size
		jcxz	?exit
		push	ax
		push	cx
		push	si
		push	di
	?loop:
		lodsb
		stosb
		cmp		al,0
		loopne	?loop
		rep
		stosb
		pop		di
		pop		si
		pop		cx
		pop		ax
	?exit:
		ret
; end of strncpy

strcpy:
		; Much like strcpy in C
		; in
		;	ds:si=source asciiz string
		;	es:di=destination buffer
		push	ax
		push	si
		push	di
	?loop:
		lodsb
		stosb
		cmp		al,0
		jne		?loop
		pop		di
		pop		si
		pop		ax
		ret
; end of strcpy

strucpy:
		; Much like strcpy in C, but converts to uppercase
		; in
		;	ds:si=source asciiz string
		;	es:di=destination buffer
		push	ax
		push	si
		push	di
	?loop:
		lodsb
		call	toupper
		stosb
		cmp		al,0
		jne		?loop
		pop		di
		pop		si
		pop		ax
		ret
; end of strucpy

strlen:
		; Much like strlen in C
		; in
		;	es:di=asciiz string
		; out
		;	ax=length
		push	cx
		push	di
		mov		al,0
		mov		cx,0xffff
		repne
		scasb
		not		cx
		dec		cx
		mov		ax,cx
		pop		di
		pop		cx
		ret
; end of strlen

end_of_string:
		; moves di to the end of the string
		; in
		;	es:di=asciiz string
		; out
		;	es:di=terminating 0 of string
		push	ax
		push	cx
		mov		al,0
		mov		cx,0xffff
		repne
		scasb
		dec		di
		pop		cx
		pop		ax
		ret
; end of end_of_string
