; xms (eg himem.sys) interface
; for now sticks to xms 2.0
;		22 Oct 1997		only allocate, free and move implemented.

xms_api	.struct FARPTR
xms_version:
		.dw		0

xms_init:
		; Checks for an xms driver and if it's there, get's the api entry
		; point. Also checks to makesure the driver implements at least
		; version 2.0 of the spec (does it matter??)
		; out
		;	cf clear
		;	ax=xms version
		;	cf set (error, no xms or too old a driver)
		;	ax=0
		push	bx
		push	es
		; check to see if xms is there
		mov		ax,0x4300
		int		0x2f
		cmp		al,0x80
		jne		?no_xms
		; get the xms api entry point
		mov		ax,0x4310
		int		0x2f
		mov		[cs:xms_api.offs],bx
		mov		[cs:xms_api.seg],es
		; get the xms version
		mov		ah,0x00
		callf	[cs:xms_api]
		mov		[cs:xms_version],ax
		; want 2.00 or better
		cmp		ax,0x200
		jb		?no_xms
		pop		es
		pop		bx
		ret
	?no_xms:
		movd	[cs:xms_api],0
		xor		ax,ax
		stc
		pop		es
		pop		bx
		ret
; end of xms_init

xms_allocate_block:
		; Gets a block of extended memroy from the xms driver
		; in
		;	ax=size of block in Kb
		; out
		;	ax=handle
		;	cf=clear, ok
		;	cf=set, error
		;		bl=error code
		;		ax=0
		push	bx
		push	dx
		mov		dx,ax
		mov		ah,0x09
		callf	[cs:xms_api]
		shr		ax,1
		cmc
		mov		ax,dx
		pop		dx
		pop		bx
		ret
	?error:
		pop		dx
		mov		[esp],bl
		pop		bx
		ret
; end of xms_allocate_block

xms_free_block:
		; Releases a block of extended memory back to the xms driver
		; in
		;	ax=handle
		; out
		;	ax=0
		;	cf=clear, ok
		;	cf=set, error
		;		bl=error code
		push	bx
		push	dx
		mov		dx,ax
		mov		ah,0x0a
		callf	[cs:xms_api]
		shr		ax,1
		cmc
		pop		dx
		pop		bx
		ret
	?error:
		pop		dx
		mov		[esp],bl
		pop		bx
		ret
; end of xms_free_block

		.struct	XMS_MOVE
length		.dd
src_handle	.dw
src_offset	.struct FARPTR	; or .dd
dst_handle	.dw
dst_offset	.struct FARPTR	; or .dd
		.ends

xms_move	.struct XMS_MOVE

xms_move_block:
		; Moves a block to/from/within extended memory
		; in
		;	bx:esi=source address handle:offset
		;	dx:edi=destination address handle:offset
		;	ecx=length of move
		;	if bx==0, ds is used as the source segment and si as the source
		;	offset
		;	if dx==0, es is used as the source segment and di as the source
		;	offset
		; out
		;	ax=0
		;	cf=clear, ok
		;	cf=set, error
		;		bl=error code
		push	bx
		push	ds
		push	si
		mov		[cs:xms_move.length],cx
		mov		[cs:xms_move.src_handle],bx
		mov		[cs:xms_move.src_offset],esi
		or		bx,bx
		jnz		?source_done
		mov		[cs:xms_move.src_offset.seg],ds
	?source_done:
		mov		[cs:xms_move.dst_handle],dx
		mov		[cs:xms_move.dst_offset],edi
		or		dx,dx
		jnz		?dest_done
		mov		[cs:xms_move.dst_offset.seg],es
	?dest_done:
		push	cs
		pop		ds
		mov		si,xms_move
		mov		ah,0x0b
		callf	[cs:xms_api]
		shr		ax,1
		cmc
		jc		?error
		pop		si
		pop		ds
		pop		bx
		ret
	?error:
		pop		si
		pop		ds
		mov		[esp],bl
		pop		bx
		ret
; end of xms_move_block
