;******************************************************************************
;******************************************************************************
;	A George Kalwitz Production, 1990
;******************************************************************************
;******************************************************************************
;
;******************************************************************************
; BOARD ID USAGE
;
;	GetBoardID
;
;	Near CALL
;
;		ON ENTRY:	DX = Base I/O Address of Board in Question
;				AX = 1 if the machine is Micro Channel
;				     0 if the machine is AT
;
;		On EXIT:	AX = Board ID Feature Bits
;				DX = Extra Info Bits
;
;				All Registers are preserved except:
;				BX and CX
;
;******************************************************************************
;
;******************************************************************************
; BOARD ID DEFINITIONS
;
; Two 16 bit values will be returned 
;
;	The first word (in AX) contains Feature Bits which make up a
;	unique ID for a given class of boards.
;
;		e.g. STARLAN MEDIA, INTERFACE_CHIP, MICROCHANNEL
;
;	The next word (in DX) contains Extra Bits which do not change the
;	boards ID.
;
;		e.g. INTERFACE_584_CHIP, 16 BIT SLOT, ALTERNATE IRQ
;
;******************************************************************************
;
BOARD_ID_EQU_INCLUDED	EQU	1
;
;first set of equates to be used with the value returned in AX, the Board ID
;
STARLAN_MEDIA		equ	0001h		; StarLAN
ETHERNET_MEDIA		equ	0002h		; AUI & BNC 
TWISTED_PAIR_MEDIA	equ	0003h		; AUI & UTP 
EW_MEDIA		equ	0004h		; AUI, BNC, and UTP 
MICROCHANNEL		equ	0008h		; MicroChannel Adapter
INTERFACE_CHIP		equ	0010h		; Soft Config Adapter
ADVANCED_FEATURES	equ	0020h		; Adv. netw. interface features
BOARD_16BIT		equ	0040h		; 16 bit capability
;
;second set of equates to be used with the value returned in DX, the Extra Bits
;
RAM_SIZE_UNKNOWN	equ	0000h		; Unknown RAM size
RAM_SIZE_RESERVED_1	equ	0001h		; Reserved RAM size
RAM_SIZE_8K		equ	0002h		; 8k RAM
RAM_SIZE_16K		equ	0003h		; 16k RAM
RAM_SIZE_32K		equ	0004h		; 32k RAM
RAM_SIZE_64K		equ	0005h		; 64k RAM
RAM_SIZE_RESERVED_6	equ	0006h		; Reserved RAM size
RAM_SIZE_RESERVED_7	equ	0007h		; Reserved RAM size
;BID_UNUSED_2		equ	0001h		; used to be RAM size field
;BID_UNUSED_3		equ	0002h		; used to be RAM size field
;BID_UNUSED_4		equ	0004h		; used to be RAM size field
SLOT_16BIT		equ	0008h		; 16 bit board - 16 bit slot
NIC_690_BIT		equ	0010h		; NIC is 690
ALTERNATE_IRQ_BIT	equ	0020h		; Alternate IRQ is used
INTERFACE_5X3_CHIP	equ	0000h		; 0000 = 583 or 593 chips
INTERFACE_584_CHIP	equ	0040h		; 0001 = 584 chip
INTERFACE_594_CHIP	equ	0080h		; 0010 = 594 chip
INTERFACE_585_CHIP	equ	0100h		; 0100 = 585 or 790 Chip
MEDIA_MASK		equ	0007h		; Isolates Media Type
RAM_SIZE_MASK		equ	0007h		; Isolates RAM Size
INTERFACE_CHIP_MASK	equ	03C0h		; Isolates Intfc Chip Type
NIC_790_BIT		equ	0800h		; NIC is 790 BIC/NIC Chip
;******************************************************************************
;	Full board type definitions
;******************************************************************************

WD8003E		equ	ETHERNET_MEDIA
WD8003EBT	equ	WD8003E
WD8003S		equ	STARLAN_MEDIA
WD8003SH	equ	WD8003S
WD8003WT	equ	TWISTED_PAIR_MEDIA
WD8003W		equ	(TWISTED_PAIR_MEDIA OR INTERFACE_CHIP)
WD8003EB	equ	(ETHERNET_MEDIA OR INTERFACE_CHIP)
WD8003EP	equ	WD8003EB	; with INTERFACE_584_CHIP
WD8003EW	equ	(EW_MEDIA OR INTERFACE_CHIP)
WD8003ETA	equ	(ETHERNET_MEDIA OR MICROCHANNEL)
WD8003STA	equ	(STARLAN_MEDIA OR MICROCHANNEL)
WD8003EA	equ	(ETHERNET_MEDIA OR MICROCHANNEL OR INTERFACE_CHIP)
WD8013EPA	equ	WD8003EA	; with INTERFACE_594_CHIP
WD8003SHA	equ	(STARLAN_MEDIA OR MICROCHANNEL OR INTERFACE_CHIP)
WD8003WA	equ	(TWISTED_PAIR_MEDIA OR MICROCHANNEL OR INTERFACE_CHIP)
WD8013WPA	equ	WD8003WA	; with INTERFACE_594_CHIP
WD8013EBT	equ	(ETHERNET_MEDIA OR BOARD_16BIT)
WD8013EB	equ	(ETHERNET_MEDIA OR BOARD_16BIT OR INTERFACE_CHIP)
WD8013W		equ	(TWISTED_PAIR_MEDIA OR BOARD_16BIT OR INTERFACE_CHIP)
WD8013EW	equ	(EW_MEDIA OR BOARD_16BIT OR INTERFACE_CHIP)
WD8013EWC	equ	(WD8013EW OR ADVANCED_FEATURES)
WD8013WC	equ	(WD8013W OR ADVANCED_FEATURES)
WD8013EPC	equ	(WD8013EB OR ADVANCED_FEATURES)
WD8003WC	equ	(WD8003W OR ADVANCED_FEATURES)
