{$M 8004,0,23000}
{
*****************************************************************************
*                                                                           *
* GDScript Interpreter v2.0 - 27.7.2000                                     *
* written by Heinz Rath (heinz.rath@gmx.at)                                 *
* some modifications by Ben A L Jemmett <ben.jemmett@ukonline.co.uk>        *
*                                                                           *
* The GEMBIND unit is originaly written by Jan Willamowius                  *
* The extensions of the GEMBIND unit are by HR and BALJ                     *
*                                                                           *
* This is Free software under the License of GPL.                           *
*                                                                           *
*****************************************************************************
Implemented commands:
---------------------
CURVER
VER
GDSVER
CHECKVER
PATBAT
CD
MD
DOS
EXIT
END
REN
DEL
RUN
LABEL
?
:
:=
:*
REM
#
/* */
//
;
CALL
GOTO
GOSUB
RETURN
IFNOSPC
DISKSPACE
IF1BUTN
IF2BUTN
IF3BUTN
IF ERRORLEVEL
IF NOT ERRORLEVEL
IF EXIST
IF NOT EXIST
IF LANGUAGE
IF NOT LANGUAGE
IF BUTTON
IF NOT BUTTON
IF XBUTTON
IF NOT XBUTTON
IF FLAG
IF NOT FLAG
IF SOUND
IF NOT SOUND
IF XMGEM
IF NOT XMGEM
LANGUAGE
IFFD
IFHD
SRCMSG
ALERT
COPY
TYPE
OUTFILE
DEBUG
WAIT
SHOWBMP
FOR
NEXT
BREAK
CONT
PRINT
CLR
CLS
WIN 
MENU
CHAIN
LET
MENUITEM
PLAYWAV
DELAY
SETFLAG
CLRFLAG
IFERR
IFFLAG
COLOR
COLOUR
WINTITLE
NOWINTITLE
SELFILE
CHKVOL
             **** Commands added with v2.0 ****
STOP
IPLAYWAV
ECHO
SELECTOR
SETALLFLAG
CLRALLFLAG
SETXBTN1
SETXBTN2
SETXBTN3
CLRXBTN
MENUTITLE
CLRBTN
CLRSCR
OPEN
CREATE
CLOSE
READ
WRITE
INFOWIN
WAITKEY
BKGROUND
(Additional Commands existing in Uninstall ONLY !!!!!!)
DELETE
ERASE
TITLE
}
{DEFINE UNINSTALL}
{
If UNINSTALL is defined then is GDS compiled with the following changes
DEL command is not exisiting instead of this the command is called ERASE.
Protect is ignored!
}
{----------------------------------------------------------------------------}
{$IFDEF VER60 or VER70} { Only needed with TP6.0 and TP7.0 ! }
 {$G-}   { For XT - Compatibility }
{$ENDIF}
{----------------------------------------------------------------------------}
uses dos,gembind;
Const GDS_FILE='INSTALL.GDS'; { Set here the name of the script file to execute }
      gds_version=$0200;
type LabelEntry=Record
      name:String[40]; { Does anyone really want to write a label longer than 40 chars ? }
      Line:LongInt;
     end;

var outfile,CopyRight,aler,ac,fileName:String;
    ContStr,RetStr,GoSubStr,Commstr,nfStr,CopyStr,ToStr,CancelStr,LabelStr,InstallStr,SyntaxStr,LineStr,WaitStr:String[40];
    drive,FormStr,WfStr,delstr,ConStr,IdStr,srr,ForStr,NextStr,PathnFStr,NoFileStr,FFnFStr,WiStr,nbmpstr:String[40];
    xbtn1,xbtn2,xbtn3,JaStr,NeinStr:String[10];
    LabelList:array [1..100] of LabelEntry;
    Gosub:array [1..10] of longint;
    unif:Text;
    BkColor,mwx,mwy,mww,mwh,ife,sh,wbox,hbox,wchar,hchar:Integer;
    lng:string[2];
    men:array [1..10] of string[40];
    scroll:Array [1..17] of string[80];
    scrollcol:Array [1..17] of integer;                               { BALJ }
    textColor:Integer;                                                { BALJ }
    ShowFileName:Window_Title;                                        { BALJ }
    HaveShowFileName:Boolean;                                         { BALJ }
    WindowName:Window_Title;                                          { BALJ }
    deskx,desky,deskw,deskh:Integer;                                  { BALJ }
    Va:array [1..5] of string[80];
    Cdialog,WDialog:Dialog_ptr;
    i,Gint,alrn,mb,BNP,lc:Integer;
    erl:WOrd;
    fll,Lcx,foo,Lic:LongInt;
    Flag:Array [0..9] of boolean;
    pl,ply:Integer;
    spc:Char;
    Mntt,title,spcl:String[80];
    sr:Procedure;
    xmgem,mono,ipp,security,sound,Forl,win,comm,space,debug,dc,fd,hd:Boolean;
    fle,sec,vn,cmd:byte;
    dir:SearchRec;
    WinHandle:Integer;
    ad,oc:String;
    a:Text;
{----------------------------------------------------------------------------}
function hex(w:Word):string; Forward;
{----------------------------------------------------------------------------}
Function Remove(p:String):String;
var pl:iNteger;
begin
 for pl:=1 to length(p) do if p[pl]=#9 then delete(p,pl,1);
 remove:=p;
end;
{----------------------------------------------------------------------------}
Function FindSpace(p:String):INteger;
var fl,ni:Integer;
begin
 fl:=0;
 for ni:=1 to length(p) do if (p[ni]=' ') and (fl=0) then fl:=ni;
 FindSpace:=fl;
end;
{----------------------------------------------------------------------------}
Function Find(st:String;sa:Char):Integer;
var ui,ua:Integer;
begin
 ua:=0;
 for ui:=1 to length(st) do if st[ui]=sa then ua:=ui;
 Find:=ua;
end;
{----------------------------------------------------------------------------}
Function Scan(st,sa:String):Boolean;
var re:boolean;
    ui,ua:Integer;
begin
ua:=1;
re:=False;
for ui:=1 to length(st) do
 begin
  if st[ui]=sa[ua] then inc(ua)
   else ua:=1;
  if ua=length(sa)+1 then re:=true;
 end;
Scan:=re;
end;
{----------------------------------------------------------------------------}
Function Name(P:String):String;
var ns:string;
    nn,ni:Integer;
begin
ns:='';
nn:=0;
for ni:=1 to length(p) do
 begin
  if (p[ni]<>' ') and (nn=0) then ns:=ns+p[ni]
   else nn:=1;
 end;
Name:=ns;
end;
{----------------------------------------------------------------------------}
Function Number(P:string):Longint;
var nn,ni:INteger;
    ns:String;
begin
ns:='';
nn:=0;
for ni:=1 to length(p) do
 begin
  if (nn=0) and (p[ni] in ['0','1','2','3','4','5','6','7','8','9']) then ns:=ns+p[ni]
   else nn:=1;
 end;
val(ns,nn,ni);
if ni=0 then Number:=nn
 else number:=0;
end;
{----------------------------------------------------------------------------}
Function UpStr(ust:string):String;
var ui:Integer;
    ups:String;
begin
 ups:='';
 for ui:=1 to length(ust) do ups:=ups+upcase(ust[ui]);
 UpStr:=Ups;
end;
{----------------------------------------------------------------------------}
Function Strip(st:string;V:boolean):string;
var j,i:INteger;
begin
if st[1]=' ' then
 begin
  j:=0;
  for i:=1 to length(st) do if (j=0) and (st[i]<>' ') then j:=i-1;
  Delete(st,1,j);
 end;
if v=True then
 begin
  if st[length(st)]=' ' then
   begin
    j:=0;
    for i:=length(st) downto 1 do if (j=0) and (st[i]<>' ') then j:=i;
    st[0]:=chr(j);
   end;
 end;
Strip:=st;
end;
{----------------------------------------------------------------------------}
function mid(str:string;x,le:integer):string;
var mi:integer;
    r:string;
begin
 r:='';
 for mi:=x to x+le-1 do r:=r+upcase(str[mi]);
 mid:=r;
end;
{----------------------------------------------------------------------------}
Function VarPrint(ust:string):String;
var ox,oy,fl,ad,ui:Integer;
    s:Boolean;
    por,ua,ups:String;
begin
 s:=False;
 ua:='';
 ups:='';
 for ui:=1 to length(ust) do
  begin
   if (ust[ui]<>'$') and (ust[ui]<>'%') and (ust[ui]<>'&') then ups:=ups+ust[ui];
   if ust[ui]='%' then
    begin
     inc(ui);
     if ust[ui] in ['1','2','3','4','5'] then
      begin
       ad:=0;
       case ust[ui] of
        '1' : ad:=1;
        '2' : ad:=2;
        '3' : ad:=3;
        '4' : ad:=4;
        '5' : ad:=5;
       end;
       if (va[ad]<>'') and (ad>0) then ups:=ups+va[ad]
        else ups:=ups+'%'+ust[ui];
      end
       else ups:=ups+ust[ui];
    end;
   if ust[ui]='$' then
    begin
     inc(ui);
     if ust[ui]<>'$' then
      begin
       repeat
       ua:=ua+upcase(ust[ui]);
       inc(ui);
       until ust[ui]=';';
      if (ua<>'COM1') and (ua<>'COM2') and (ua<>'COM3') and (ua<>'COM4') and (ua<>'LPT1') and (ua<>'LPT2') and
      (ua<>'LPT3') and (ua<>'LPT4') and (ua<>'GDSVER') and (ua<>'AESVER') then foo:=do_alert('[1]['+WiStr+']['+ContStr+']',1)
       else
        begin
         if ua='AESVER' then
          begin
           por:=hex(AES_version);
           delete(por,1,1);
           ups:=ups+por[1]+por[2]+'.'+por[3]+por[4];
          end;
         if ua='GDSVER' then
          begin
           por:=hex(gds_version);
           delete(por,1,1);
           ups:=ups+por[1]+por[2]+'.'+por[3]+por[4];
          end;
         if ua[1]='C' then { Com Port }
          begin
           por:='$0000';
           case ua[4] of
            '1': por:=hex(memw[$40:0000]);
            '2': por:=hex(memw[$40:0002]);
            '3': por:=hex(memw[$40:0004]);
            '4': por:=hex(memw[$40:0006]);
           end;
           delete(por,1,1);
           if por='0000' then ups:=ups+'NONE'
            else ups:=ups+por;
          end;
         if ua[1]='L' then { Lpt Port }
          begin
           por:='$0000';
           case ua[4] of
            '1': por:=hex(memw[$40:0008]);
            '2': por:=hex(memw[$40:$000A]);
            '3': por:=hex(memw[$40:$000C]);
            '4': por:=hex(memw[$40:$000E]);
           end;
           delete(por,1,1);
           if por='0000' then ups:=ups+'NONE'
            else ups:=ups+por;
          end;
        end;
      end;
      inc(ui);
    end;
   if ust[ui]='&' then
    begin
     inc(ui);
     if ust[ui]<>'&' then
      begin
       repeat
       ua:=ua+ust[ui];
       inc(ui);
       until ust[ui]=';';
       ups:=ups+GETEnv(ua)
      end;
      inc(ui);
    end;
   if ui>length(ust) then ui:=length(ust);
  end;
 VarPrint:=Ups;
end;
{----------------------------------------------------------------------------}
function DriveChange(st:string):String;
var dci:Integer;
begin
 if dc=True then
  begin
   for dci:=1 to length(st) do if (st[dci]=oc) and (st[dci+1]=':') then st[dci]:=ad[1];
  end;
 DriveChange:=st;
end;
{----------------------------------------------------------------------------}
Function GetOnOff(st:string):Boolean;
var sa:string;
begin
sa:=upstr(st);
sa:=strip(st,False);
if copy(st,1,2)='ON' then GetOnOff:=True
 else GetOnOff:=False;
end;
{----------------------------------------------------------------------------}
Procedure Labels;
var b:String;
    lic:LongInt;
begin
assign(a,filename);
reset(a);
lcx:=0;
lic:=1;
repeat
 readln(a,b);
 inc(lcx);
 b:=remove(b);
 b:=Strip(b,True);
{$IFDEF UNINSTALL}
 if mid(b,1,6)='TITLE ' then
  begin
   delete(b,1,6);
   title:=b;
  end;
{$ENDIF}
 if mid(b,1,6)='LABEL ' then delete(b,1,6);
 if (b[1]=':') and (b[2]<>'=') and (b[2]<>'*') then { :=,:*  --> Comment }
  begin
   b:=UpStr(b);
   delete(b,1,1);
   LabelList[lc].name:=b;
   LabelList[lc].Line:=lic;
   inc(lc);
   if lc>150 then
    begin
     foo:=do_alert('[1]['+LabelStr+']['+CancelStr+']',1);
     close(a);
     Exit_GEM;
     Halt(1);
    end;
  end;
inc(lic);
until eof(a);
close(a);
end;
Procedure Nop;
begin
 cmd:=1;
end;
{----------------------------------------------------------------------------}
Procedure Secu(s:Byte);
begin
if s=1 then foo:=do_alert('[1]['+DelStr+']['+JaStr+'|'+NeinStr+']',2);
if s=2 then foo:=do_alert('[1]['+FormStr+']['+JaStr+'|'+NeinStr+']',2);
sec:=0;
if foo=2 then sec:=1;
end;
{----------------------------------------------------------------------------}
Function CMDS(st:string):string;
var j,i:Integer;
    e:String;
begin
e:='';j:=0;
for i:=1 to length(st) do
 begin
  if (j=0) and (st[i]<>' ') then e:=e+upcase(st[i]);
  if st[i]=' ' then j:=i-1;
 end;
cmds:=e;
end;
{----------------------------------------------------------------------------}
Procedure Alert(st:string;v:byte);
var dn,cc,i:Integer;
    ale:String[255];
    label r;
begin
cc:=0;
delete(st,1,6); { Remove Command }
ale:=st;
r:
for i:=1 to length(st) do
 begin
  if st[i]=']' then Inc(cc);
 end;
 if cc<3 then
  begin
   readlN(a,st);
   inc(lcx);
   st:=remove(st);
   st:=strip(st,False);
   ale:=ale+st;
   goto r;
  end;
if ale[1]='1' then dn:=1;
if ale[1]='2' then dn:=2;
if ale[1]='3' then dn:=3;
delete(ale,1,1);
if v=1 then bnp:=do_alert(ale,dn);
if v=2 then
 begin
  aler:=ale;
  alrn:=dn;
 end;
end;
{----------------------------------------------------------------------------}
Procedure Jmp(b:String);
var go,i:integer;
begin
 go:=0;
 b:=Strip(b,true);
 if mid(b,1,5)='GOTO ' then delete(b,1,5);
 if mid(b,1,6)='GOSUB ' then
  begin
   delete(b,1,6);
   if gint>10 then foo:=do_alert('[1]['+GoSubStr+']['+ContStr+']',1)
    else
     begin
      Gosub[Gint]:=lcx;
      inc(gint);
     end;
  end;
 b:=upstr(b);
 for i:=1 to lc do
  begin
   if b=LabelList[i].name then go:=labellist[i].line;
  end;
 if go>0 then
  begin
   close(a);
   assign(a,filename);
   reset(a);
   for i:=1 to go do readln(a,b);
   lcx:=go;
  end
   else foo:=do_alert('[1][Label '+b+' '+nfStr+']['+CancelStr+']',1);
end;
{----------------------------------------------------------------------------}
Procedure GoLine(le:LongInt);
var i:LongInt;
    b:String;
begin
 close(a);
 assign(a,filename);
 reset(a);
 for i:=1 to le do readln(a,b);
 lcx:=le;
end;
{----------------------------------------------------------------------------}
Procedure Bmp(st:String);
var ww,hw:Integer;
Procedure Load_Bmp(x,y:Integer;str:String);
var f:File;
    g,eve,ok,c,a,b:Byte;
    br:INteger;
    v:array [1..1024] of Byte;
    h2,ww,y1,x1,dummy,w,h,start:Word;
    label raus;
Function Color(c:Byte):Byte;
var co:array [0..15] of byte;
begin
 co[0]:=1;
 co[1]:=10;
 co[2]:=11;
 co[3]:=13;
 co[4]:=12;
 co[5]:=15;
 co[6]:=14;
 co[7]:=8;
 co[8]:=9;
 co[9]:=2;
 co[10]:=3;
 co[11]:=6;
 co[12]:=4;
 co[13]:=7;
 co[14]:=5;
 co[15]:=0;
 color:=co[c];
end;
begin
Hide_Mouse;
assign(f,str);
{$I-}
reset(f,1);
{$I-}
 if ioresult<>0 then
  begin
   Show_Mouse;
   foo:=do_alert('[1]['+nbmpstr+']['+COntstr+']',1);
   Hide_MOuse;
  end
else
begin
seek(f,18);
blockread(f,h2,2,dummy);
seek(f,$12);
blockread(f,w,2,dummy);
seek(f,$16);
blockread(f,h,2,dummy);
seek(f,$0A);
blockread(f,start,2,dummy);
seek(f,$1C);
blockread(f,c,1,dummy);
if c<>4 then  { Only 16 Colors (4-Bit) format is supported }
 begin
  close(f);
  Show_Mouse;
  goto raus;
 end;
seek(f,start);
g:=255;
Paint_Style(Solid);
Paint_Color(White);
Paint_Rect(x,y,w,h);
ww:=0;
while c*h2>ww*8 do inc(ww);
for y1:=h downto 1 do
 begin
 br:=1;
 blockread(f,v,ww,dummy);
 for x1:=1 to w do
  begin
   a:=v[br];
   a:=a shr 4;
   b:=v[br]-a shl 4;
   inc(br);
   if (g<>a) then Line_Color(Color(a));
   if Color(a)<>0 then Pline(x+x1,y+y1,x+x1+1,y+y1);
   if (a<>b) then Line_Color(Color(b));
   inc(x1);
   if Color(b)<>0 then Pline(x+x1,y+y1,x+x1+1,y+y1);
   g:=a;
 end;
 blockread(f,v,(4-(ww) mod 4) mod 4);
end;
close(f);
end;
Show_Mouse;
raus:
end;
begin
st:=strip(st,False);
ww:=number(st);
if ww<10 then delete(st,1,1)
 else if ww<100 then delete(st,1,2)
  else if ww<1000 then delete(st,1,3);
st:=strip(st,False);
hw:=number(st);
if hw<10 then delete(st,1,1)
 else if hw<100 then delete(st,1,2)
  else if hw<1000 then delete(st,1,3);
st:=strip(st,false);
LOAD_BMP(ww,hw,st);
end;
{----------------------------------------------------------------------------}
Procedure Run(st:String);
var s3,s1,s2,s4:string;
    v1,v2,v3:char;
    t,a1,a2,a3,i,j:INteger;
    sta:boolean;
    label out;
begin
{$IFNDEF UNINSTALL}
if (scan(st,'DEL ')=True) or (scan(st,'DELTREE')=True) or (scan(st,'FORMAT')=true) then
 begin
  if security=true then
   begin
    if scan(st,'FORMAT')=true then secu(2)
     else secu(1);
   end;
 end;
 if sec=1 then goto out;
{$ENDIF}
 v1:=st[1];
 v2:=st[3];
 v3:=st[5];
delete(st,1,6);
 s3:=st;
 s1:='';
 s2:='';
 j:=0;
 for i:=1 to length(st) do
  begin
   if (J=0) and (st[i]<>' ') then s1:=s1+st[i];
   if (st[i]=' ') and (j=0) then j:=i;
  end;
 s2:=st;
 delete(s2,1,j);
 if j=0 then s2:='';
 s1:=strip(s1,True);
 s2:=strip(s2,True);
a1:=ord(v1)-48;
a2:=ord(v2)-48;
a3:=ord(v3)-48;
if (a1<2) then
 begin
  close(a);
  sta:=shel_write(a1,a2,a3,s1,s2);
  Exit_GEM;
  halt(1);
  erl:=0;
 end;
if (a1=2) then
 begin
  SwapVectors;
  if a2=0 then Exec(GETENv('COMSPEC'),'/C '+s3+' >NUL');
  SwapVectors;
  if doserror=8 then foo:=do_alert('[2][Out of memory][Continue]',1);
  erl:=DosExitCode;
 end;
if (a1=3) then
 begin
  SwapVectors;
  if a2=0 then Exec(GETENv('COMSPEC'),'/C '+s3+' >output.lst');
  if a2=1 then Exec(GETENv('COMSPEC'),'/C '+s3+' >'+outfile);
  SwapVectors;
  erl:=DosExitCode;
 end;
if (a1=4) then
 begin
  t:=-1;
  s4:='';
  for i:=1 to length(s3) do if (s3[i]=' ') and (t=-1) then t:=i;
  if t<>-1 then
   begin
    s4:=copy(s3,t+1,length(s3)-t);
    s3:=copy(s3,1,t-1);
   end;
  SwapVectors;
  Exec(s3,s4);
  SwapVectors;
  if doserror=8 then foo:=do_alert('[2][Out of memory][Continue]',1);
  erl:=DosExitCode;
 end;
out:
end;
{----------------------------------------------------------------------------}
Procedure PatBat(st:string);
var a,b:String;
    Dialog:Dialog_Ptr;
    but:array [3..30] of integer;
    bt,bx,by,bn,dummy,button,okay,cancel:Integer;
begin
 oc:=st[1];
 Dialog := New_Dialog(12, 0, 0, 34, 9);
 Dummy := Add_DItem(Dialog, G_String, None, 4, 1, 0, 0, 0, 0);
 Set_DText(Dialog, Dummy, InstallStr, System_Font, TE_Left);
 bx:=22;
 by:=2;
 bn:=3;
 bt:=3;
 repeat
  if disksize(bn)=-1 then bn:=27; { I will change this to later to use the drive array  HR }
  if bn<27 then
   begin
    but[bn]:=Add_DItem(Dialog, G_Button, Selectable Or Radio_Btn or Default,bx,by,1,1,1,$1180);
    Set_DText(Dialog, but[bn], chr(64+bn), System_Font, TE_Left);
    inc(bx,2);
    if bx>32 then
     begin
      bx:=22;
      inc(by,2);
     end;
    inc(bn);
    inc(bt);
   end;
 until bn=27;
 okay:= Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn Or Default,
                       8, 5, 7, 1, 4, $1180);

 Set_DText(Dialog, okay, 'OK', System_Font, TE_Left);
 cancel:= Add_DItem(Dialog, G_Button, Selectable Or Exit_Btn,
                       8, 7, 7, 1, 4, $1180);
 Set_DText(Dialog, cancel, CancelStr, System_Font, TE_Left);
 Center_Dialog(Dialog);
 button:= Do_Dialog(Dialog, 0);
 Obj_SetState(Dialog, Button, Normal, True);
 End_Dialog (Dialog);
 Delete_Dialog(Dialog);
{ foo:=obj_state(Dialog,but[3]);
 str(foo,a);
 foo:=do_alert('[1][ '+a+' ][C]',1);}
 if button=cancel then dc:=False;
 if button=okay then
  begin
   dc:=True;
   for bn:=3 to bt-1 do
    begin
     foo:=obj_state(Dialog,bn);
     if foo=1 then ad[1]:=chr(65+bn);
    end;
  end;
end;
{----------------------------------------------------------------------------}
Procedure CopyWin(st:string);
var C1,T1:integer;
    a,b:String;
    f1,f2:file;
    s1,s2:String;
    j,i:Integer;
    dummy,w:word;
    Buf:Pointer;
    disk:Searchrec;
Function Point(s:string):Boolean;
var p:INteger;
    f:boolean;
begin
f:=False;
for p:=1 to length(s) do if s[p]='.' then f:=true;
Point:=f;
end;
begin
 Getmem(buf,8192);
 s1:='';
 s2:='';
 j:=0;
 for i:=1 to length(st) do
  begin
   if (J=0) and (st[i]<>' ') then s1:=s1+st[i];
   if (st[i]=' ') then j:=i;
  end;
 s2:=st;
 delete(s2,1,j);
 s1:=strip(s1,True);
 s2:=strip(s2,True);
   CDialog := New_Dialog(2, 2, 2, 70, 5);
   C1 := Add_DItem(CDialog, G_String, None, 4, 1, 0, 0, 0, 0);
   T1 := Add_DItem(CDialog, G_String, None, 6, 2, 0, 0, 0, 0);
 FindFirst(s1,Archive,Disk);
 if doserror=18 then foo:=do_alert('[1]['+NoFileStr+']['+CancelStr+']',1);
 while doserror=0 do
  begin
   Assign(F1,disk.name);
   {$I-}
   Reset(f1,1);
   {$I+}
   if ioresult<>0 then
    begin
     if aler<>'' then bnp:=do_alert(aler,alrn);
    end
   else
    begin
   Set_DText(CDialog, C1, CopyStr+' '+disk.name, System_Font, TE_Left);
   s2:=Upstr(s2);
   if (Point(s2)=False) and (s2[length(s2)]<>'\') then s2:=s2+'\';
   if Point(s2)=False then Set_DText(CDialog, t1, ToStr+' '+s2+disk.name, System_Font, TE_Left);
   if Point(s2)=True then Set_DText(CDialog, t1, ToStr+' '+s2, System_Font, TE_Left);
   Show_Dialog(CDialog);
   a:=Disk.name;
   foo:=1;
   if Point(s2)=False then assign(f2,s2+disk.name);
   if Point(s2)=True then assign(f2,s2);
   foo:=1;
   Rewrite(f2,1);
   Repeat
    BlockRead(F1,Buf^,8192,dummy);
    BlockWrite(F2,Buf^,dummy,w);
    if w<>dummy then foo:=do_alert('[1][Error during copy ][Continue]',1);
   Until (dummy=0) or (w<>dummy);
   Close(F1);
   end;
   Close(F2);
  FindNExt(disk);
  end;
 if doserror=2 then foo:=Do_alert('[1]['+ffnfStr+']['+ContStr+']',1);
 if doserror=3 then foo:=Do_alert('[1]['+PathnfStr+']['+ContStr+']',1);
 End_Dialog (CDialog);
 Delete_Dialog(CDialog);
 Freemem(buf,8192);
end;
{----------------------------------------------------------------------------}
function FileExists(st:string):Boolean;
var f: file;
begin
 {$I-}
 Assign(f,st);
 Reset(f);
 Close(f);
 {$I+}
 FileExists:=(IOResult=0) and (st<>'');
end;
{----------------------------------------------------------------------------}
Procedure Ifrout(st,sa:string);
var c:Word;
    l:INteger;
    s,s3,s4,s1,s2:String[80];
    tr:Byte;
    trf,notf:Boolean;
begin
 notf:=False;
 st:=Strip(st,False);
 sa:=strip(sa,False);
 if mid(st,1,3)='NOT' then
  begin
   delete(st,1,3);
   st:=strip(st,false);
   delete(sa,1,3);
   sa:=strip(sa,false);
   notf:=True;
   cmd:=1;
  end;
 if find(st,'=')>0 then
  begin
   cmd:=1;
   l:=Find(sa,'=');
   s1:=mid(sa,1,l-1);
   l:=Find(st,'=');
   s2:=st;
   delete(s2,1,l);
   s2:=Strip(s2,False);
   s3:=s2;
   l:=find(s3,' ');
   s2:=mid(s2,1,l-1);
   delete(s3,1,l);
   s3:=strip(s3,True);
   case s1[2] of
    '1' : tr:=1;
    '2' : tr:=2;
    '3' : tr:=3;
    '4' : tr:=4;
    '5' : tr:=5;
    else foo:=do_alert('[1]['+SyntaxStr+':'+filename+' |'+LineStr+'IF '+s1+'='+s2+' ]['+ContStr+']',1);
   end;
   if tr<>0 then
    begin
     s4:=upstr(va[tr]);
     s2:=upstr(s2);
     if (s4=s2) and (notf=FALSE) then jmp(s3);
     if (s4<>s2) and (notf=TRUE) then jmp(s3);
     cmd:=1;
    end;
   cmd:=1;
  end;
 if mid(st,1,8)='LANGUAGE' then
  begin
   delete(st,1,8);
   st:=strip(st,False);
   s1:=name(st);
   s1:=upstr(s1);
   s1:=strip(s1,True);
   delete(st,1,length(s1));
   s2:=strip(st,TRue);
   s2:=Upstr(s2);
   cmd:=1;
   if (s1=Lng) and (notf=False) then Jmp(s2);
   if (s1<>Lng) and (notf=TRUE) then Jmp(s2);
  end;
 if mid(st,1,5)='EXIST' then
  begin
   delete(st,1,5);
   st:=strip(st,false);
   s1:=Name(st);
   delete(st,1,length(s1));
   s2:=strip(s2,TRue);
   cmd:=1;
   if (fileexists(st)=True) and (notf=False) then jmp(s2);
   if (fileexists(st)=False) and (notf=TRUE) then jmp(s2);
  end;
 if mid(st,1,6)='BUTTON' then
  begin
   cmd:=1;
   delete(st,1,6);
   st:=Strip(st,False);
   c:=Number(st);
   if (mb<>c) and (notf=TRUE) then
    begin
     c:=FindSpace(st);
     delete(st,1,c);
     Jmp(st);
    end;
   if (mb=c) and (notf=FALSE) then
    begin
     c:=FindSpace(st);
     delete(st,1,c);
     Jmp(st);
    end;
  end;
 if mid(st,1,4)='FLAG' then
  begin
   cmd:=1;
   delete(st,1,4);
   st:=Strip(st,False);
   c:=Number(st);
   if (flag[c]=FALSE) and (notf=TRUE) then
    begin
     c:=FindSpace(st);
     delete(st,1,c);
     Jmp(st);
    end;
   if (flag[c]=TRUE) and (notf=FALSE) then
    begin
     c:=FindSpace(st);
     delete(st,1,c);
     Jmp(st);
    end;
  end;
 if mid(st,1,7)='XBUTTON' then
  begin
   cmd:=1;
   delete(st,1,7);
   st:=Strip(st,False);
   c:=Number(st);
   if (bnp<>c) and (notf=TRUE) then
    begin
     c:=FindSpace(st);
     delete(st,1,c);
     Jmp(st);
    end;
   if (bnp=c) and (notf=FALSE) then
    begin
     c:=FindSpace(st);
     delete(st,1,c);
     Jmp(st);
    end;
  end;
 if mid(st,1,5)='SOUND' then
  begin
   cmd:=1;
   delete(st,1,6);
   st:=Strip(st,False);
   c:=Number(st);
   if c=0 then trf:=False;
   if c>=1 then trf:=True;
   if (sound <>trf) and (notf=TRUE) then
    begin
     c:=FindSpace(st);
     delete(st,1,c);
     Jmp(st);
    end;
   if (sound=trf) and (notf=FALSE) then
    begin
     c:=FindSpace(st);
     delete(st,1,c);
     Jmp(st);
    end;
  end;
 if mid(st,1,5)='XMGEM' then
  begin
   cmd:=1;
   delete(st,1,6);
   st:=Strip(st,False);
   c:=Number(st);
   if c=0 then trf:=False;
   if c>=1 then trf:=True;
   if (xmgem <>trf) and (notf=TRUE) then
    begin
     c:=FindSpace(st);
     delete(st,1,c);
     Jmp(st);
    end;
   if (xmgem=trf) and (notf=FALSE) then
    begin
     c:=FindSpace(st);
     delete(st,1,c);
     Jmp(st);
    end;
  end;
 if mid(st,1,10)='ERRORLEVEL' then
  begin
   cmd:=1;
   delete(st,1,10);
   st:=Strip(st,False);
   c:=Number(st);
   if (erl<>c) and (notf=TRUE) then
    begin
     c:=FindSpace(st);
     delete(st,1,c);
     Jmp(st);
    end;
   if (erl=c) and (notf=FALSE) then
    begin
     c:=FindSpace(st);
     delete(st,1,c);
     Jmp(st);
    end;
  end;
end;
{----------------------------------------------------------------------------}
Procedure del(st:string);
var df:File;
begin
 st:=Strip(st,false);
 assign(df,st);
 {$I-}
 Reset(df);
 {$I+}
 ife:=ioresult;
 if ioresult=0 then
  begin
   close(df);
   erase(df);
  end;
end;
{----------------------------------------------------------------------------}
Procedure ren(st:string);
var df:File;
    s1,s2:string;
    l:INteger;
begin
 st:=Strip(st,false);
 l:=FInd(st,' ');
 s1:=mid(st,1,l-1);
 s2:=st;
 delete(s2,1,l);
 s2:=strip(s2,True);
 assign(df,st);
 {$I-}
 rename(df,s2);
 {$I+}
 ife:=ioresult;
end;
{----------------------------------------------------------------------------}
Procedure ShowFile(fn:string);
var sf:Text;
    sa:String;
    wn:Window_Title;
    i,ly:Integer;
    tt,lnr:LongInt;
    foo,aus,event:Integer;
    mx,my,mb,key,xw,yw,ww,hw,Handle:Integer;
    msg: Message_Buffer;
    bar:Real;                                                         { BALJ }
Procedure LoadTxt(st:string;lnr:longint);
var i:Integer;
    r:longint;
begin
 r:=0;
 Hide_Mouse;
 assign(sf,st);
 reset(sf);
 if lnr>1 then for i:=1 to lnr do
  begin
   readlN(sf,sa);
   inc(r);
  end;
 Work_Rect(handle,xw,yw,ww,hw);
 Paint_Style(Solid);
 Paint_Color(BkColor);
 Paint_Rect(xw,yw,ww,hw);
 ly:=yw+8;
 xw:=xw+2;
 for i:=1 to 17 do
  begin
   sa:='                                                                              ';
   readlN(sf,sa);
   if length(sa) > 80 then sa := mid(sa,1,80);                        { BALJ }
   Draw_string(xw,ly,sa);
   inc(ly,8);
   inc(r);
   if eof(sf) then sa:='                                                                              ';
   if (eof(sf)) and (tt=-1) then tt:=r-1;
  end;
 close(sf);
 Show_Mouse;
end;
begin
 if bkcolor<>White then Draw_Mode(Trans_Mode);
 tt:=-1;
 fn:=Strip(fn,false);
 wn:=Fn;                                                              { BALJ }
 if HaveShowFileName then wn:=ShowFileName;                           { BALJ }
 handle:= New_Window(G_MOVE+G_Name+G_UPArrow+G_DnArrow+G_CLOSE+G_HotClose,wn,0,0,0,0); { BALJ }
 xw:=deskx;                                                           { BALJ }
 yw:=desky;                                                           { BALJ }
 hw:=(17*8)+4;                                                        { BALJ }
 ww:=81*6;                                                            { BALJ }
 Wind_Calc(0,G_MOVE+G_Name+G_UPArrow+G_DnArrow+G_CLOSE+G_HotClose,xw,yw,ww,hw); { BALJ }
 bar:=(deskw-ww)/2;                                                   { BALJ }
 xw:=Round(bar);                                                      { BALJ }
 yw:=desky+16;                                                        { BALJ }
 Open_Window(handle,xw,yw,ww,hw);
 Text_Color(textColor);                                               { BALJ }
 Work_Rect(handle,xw,yw,ww,hw);
 Hide_Mouse;
 Paint_Style(Solid);
 Paint_Color(BkColor);
 Paint_Rect(xw,yw,ww,hw);
 foo:=Text_Point(8);
 Show_Mouse;
 ly:=yw;
 aus:=0;
 lnr:=1;
 LoadTxt(fn,lnr);
 repeat
  event:=Get_Event(E_keyboard or E_Message or E_Button or E_MOuse1, 1, 1, 1, 0,
                   TRUE, 0, 0,800, 600,
                   false, 0, 0, 0, 0,
                   msg, key, foo, mb,mx,my, foo);
 if event and E_Keyboard <>0 then
  begin
   if key=11779 then aus:=1; { Ctrl + C }
   if Hi(key)=72 then
    begin
     dec(lnr);
     if lnr<1 then lnr:=1;
     LoadTxt(fn,lnr);
    end;
   if Hi(key)=80 then
    begin
     inc(lnr);
     if (lnr>tt) and (tt<>-1) then lnr:=tt;
     LoadTxt(fn,lnr);
    end;
  end;
 if event AND E_Message <> 0 then
  begin
   Begin_Update;
   case msg[0] of
    WM_Moved:
     begin
      Set_WSize(handle, msg[4],msg[5], msg[6], msg[7]);
      LoadTxt(fn,lnr);
     end;
    WM_Closed : aus:=1;
    WM_Arrowed:
     begin
      case msg[4] of  
       WA_UPLINE:
        begin
         dec(lnr);
         if lnr<1 then lnr:=1;
         LoadTxt(fn,lnr);
        end;
       WA_DNLINE:
        begin
         inc(lnr);
         if (lnr>tt) and (tt<>-1) then lnr:=tt;
         LoadTxt(fn,lnr);
        end;
      end;
      foo:=Get_Timer(50);                                             { BALJ }
     end;
   end;
   End_Update;
  end;
 until aus=1;
 foo:=Text_Point(sh);
 Text_Color(Black);                                                   { BALJ }
 Close_Window(handle);
 Delete_Window(handle);
 if Win then Set_WName(WinHandle,WindowName);                         { BALJ }
 if bkcolor<>White then Draw_Mode(Replace_Mode);
end;
{----------------------------------------------------------------------------}
Procedure WinOn;
var sf:Text;
    sa:String;
    wn:Window_Title;
    i:Integer;
    tt,lnr:LongInt;
    mx,my,mb,key,xw,yw,ww,hw:Integer;
    msg: Message_Buffer;
    foo:Real;                                                         { BALJ }
begin
 tt:=-1;wn:='';
 Winhandle:= New_Window(G_Name,WindowName,0,0,0,0);                   { BALJ }
 { BALJ - Removed Work_Rect(0 call }
 hw:=(17*8)+4;                                                        { BALJ }
 ww:=81*6;                                                            { BALJ }
 xw:=deskx;                                                           { BALJ }
 yw:=desky;                                                           { BALJ }
 Wind_Calc(0,G_Name,xw,yw,ww,hw);                                     { BALJ }
 foo:=(deskw-ww)/2;                                                   { BALJ }
 xw:=Round(foo);                                                      { BALJ }
 yw:=(desky+deskh)-(hw+16);                                           { BALJ }
 Open_Window(Winhandle,xw,yw,ww,hw);
 Work_Rect(Winhandle,xw,yw,ww,hw);
 Hide_Mouse;
 Paint_Style(Solid);
 Paint_Color(bkcolor);
 Paint_Rect(xw,yw,ww,hw);
 Show_Mouse;
 ply:=yw+8;
 lnr:=1;
 Pl:=1;
end;
{----------------------------------------------------------------------------}
Procedure WinTitle(wn:Window_Title);                                  { BALJ }
begin                                                                 { BALJ }
  WindowName:=wn;                                                     { BALJ }
  Set_WName(WinHandle, wn);                                           { BALJ }
end;                                                                  { BALJ }
{----------------------------------------------------------------------------}
Procedure Cls;
var xw,yw,ww,hw:Integer;
begin
 Work_Rect(WinHandle,xw,yw,ww,hw);
 Hide_Mouse;                                                          { BALJ }
 Paint_Style(Solid);
 Paint_Color(BkColor);
 Paint_Rect(xw,yw,ww,hw);
 Show_Mouse;                                                          { BALJ }
 ply:=yw+8;
 pl:=1;
end;
{----------------------------------------------------------------------------}
Procedure Print(St:String);
var xw,yw,ww,hw:Integer;
    foo:Integer;
begin
 Hide_Mouse;
 Work_Rect(WinHandle,xw,yw,ww,hw);
 foo:=Text_Point(8);
 Text_Color(Black);
 if bkcolor<>White then Draw_Mode(Trans_Mode);
 if pl>17 then
  begin
   pl:=16;
   dec(ply,8);
   Paint_Style(Solid);
   Paint_Color(BKColor);
   Paint_Rect(xw,yw,ww,hw);
   ply:=yw+8;
   for pl:=2 to 17 do
    begin
     Text_Color(scrollcol[pl]);                                       { BALJ }
     Draw_string(xw,ply,scroll[pl]);
     inc(ply,8);
     scroll[pl-1]:=scroll[pl];
     scrollcol[pl-1]:=scrollcol[pl];                                  { BALJ }
    end;
  end;
 Text_Color(textColor);                                               { BALJ }
 if length(st) > 80 then st := mid(st,1,80);                          { BALJ }
 Draw_string(xw,ply,st);
 Text_Color(Black);                                                   { BALJ }
 Scroll[pl]:=st;
 ScrollCol[pl]:=textColor;                                            { BALJ }
 inc(pl);
 inc(ply,8);
 foo:=Text_Point(sh);
 Show_Mouse;
 if bkcolor<>White then Draw_Mode(Replace_mode);
end;
{----------------------------------------------------------------------------}
Procedure Wind(St:string);
var done:Boolean;                                                     { BALJ }  
begin
st:=strip(st,TRUE);
done:=false;                                                          { BALJ }
{ BALJ - Removed st:=upstr(st) }
if upstr(st)='ON' then                                                { BALJ }
 begin
  if win=False then WinON;
  win:=True;
  done:=true;                                                         { BALJ }
 end;
if upstr(st)='OFF' then                                               { BALJ }
 begin
  if win=true then
   begin
    Close_Window(WinHandle);
    Delete_Window(WinHandle);
   end;
  win:=False;
  done:=true;                                                         { BALJ }
 end;
if not done then WinTitle(st);                                        { BALJ }
end;
{----------------------------------------------------------------------------}
Procedure Wait(st:String);
var dummy:Integer;
begin
st:=strip(st,false);
{ BALJ - Removed st:=upstr(st) }
if upstr(st)<>'OFF' then
 begin
  WDialog := New_Dialog(2, 2, 2, 70, 5);
  dummy := Add_DItem(WDialog, G_String, None, 4, 1, 0, 0, 0, 0);
  if upstr(ST)='ON' then Set_DText(WDialog, dummy,WaitStr, System_Font, TE_Left)
   else Set_DText(WDialog, dummy, st, System_Font, TE_Left);
  Center_Dialog(WDialog);
  Show_Dialog(WDialog);
 end;
if upstr(st)='OFF' then                                               { BALJ }
 begin
  End_Dialog (WDialog);
  Delete_Dialog(WDialog);
 end;
end;
{----------------------------------------------------------------------------}
function hex(w:Word):string;
function h(r:byte):char;
begin
 if r>=10 then h:=chr(55+r)
  else h:=chr(48+r);
end;
begin
  hex:='$'+h(hi(w) div 16)+h(hi(w) mod 16)+h(lo(w) div 16)+h(lo(w) mod 16);
end;
{----------------------------------------------------------------------------}
Procedure NoSpace(st:string);
var ww:INteger;
begin
 st:=strip(st,TRUE);
 Space:=True;
 spc:=st[1];
 delete(st,1,2);
 st:=strip(st,false);
 ww:=number(st);
 if ww<10 then delete(st,1,1)
  else if ww<100 then delete(st,1,2)
   else if ww<1000 then delete(st,1,3);
 st:=strip(st,false);
 st:=upstr(st);
 spcl:=st;
end;
{----------------------------------------------------------------------------}
Function QoutStr(str:String):String;
var qi,f:integer;
    r:string;
begin
f:=0;
r:='';
for qi:=1 to length(str) do
 begin
  if (str[qi]=#34) and (f=0) then
   begin
    str[qi]:=#32;
    f:=1;
   end;
  if (str[qi]=#34) and (f=1) then f:=0;
  if (str[qi]<>#34) and (f=1) then r:=r+str[qi];
 end;
Qoutstr:=r;
end;
{----------------------------------------------------------------------------}
Procedure Fread(sa,sb:String);
var tr:Integer;
    s2,s1:String;
begin
tr:=0;
s1:=strip(sa,True);
s2:=Strip(sb,False);
 case s1[2] of
  '1' : tr:=1;
  '2' : tr:=2;
  '3' : tr:=3;
  '4' : tr:=4;
  '5' : tr:=5;
   else foo:=do_alert('[1]['+SyntaxStr+filename+' |'+LineStr+'READ ]['+ContStr+']',1);
 end;
 if tr<>0 then
  begin
   va[tr]:='';
   if (s2[1]='"') and (s2[2]<>'"') then va[tr]:=QoutStr(s2);
   if s2[1]<>'"' then va[tr]:=S2;
  end;
end;
{----------------------------------------------------------------------------}
Procedure Let(sa,sb:String);
var tr,l:Integer;
    s1,s2:String;
begin
 sb:=strip(sb,True);
 l:=Find(sb,'=');
 s1:=mid(sb,1,l-1);
 l:=Find(sa,'=');
 s2:=sa;
 delete(s2,1,l);
 s2:=Strip(s2,true);
 case s1[2] of
  '1' : tr:=1;
  '2' : tr:=2;
  '3' : tr:=3;
  '4' : tr:=4;
  '5' : tr:=5;
   else foo:=do_alert('[1]['+SyntaxStr+filename+' |'+LineStr+'LET '+s1+'='+s2+' ]['+ContStr+']',1);
 end;
 if tr<>0 then
  begin
   va[tr]:='';
   if (s2[1]='"') and (s2[2]<>'"') then va[tr]:=QoutStr(s2);
   if s2[1]<>'"' then va[tr]:=S2;
  end;
end;
{----------------------------------------------------------------------------}
Procedure ForRout(st:String);
var l:Integer;
    s3,s1,s2:string;
begin
 st:=strip(st,True);
 l:=Find(st,'=');
 s1:=mid(st,1,l-1);
 s2:=st;
 delete(s2,1,l);
 FindFirst(s2,Archive,Dir);
 fll:=lcx;
 str(fll,s3);
 vn:=0;
 if doserror=0 then
  begin
   case s1[2] of
    '1' : vn:=1;
    '2' : vn:=2;
    '3' : vn:=3;
    '4' : vn:=4;
    '5' : vn:=5;
     else foo:=do_alert('[1]['+SyntaxStr+filename+' |'+LineStr+'FOR '+s1+'='+s2+' ]['+ContStr+']',1);
   end;
  if vn<>0 then
   begin
    va[vn]:='';
    va[vn]:=dir.name;
   end;
  end;
end;
{----------------------------------------------------------------------------}
Procedure MenuItem(St:string);
var ww:Integer;
begin
 st:=strip(st,False);
 ww:=Number(st);
 if ww<10 then delete(st,1,1)
  else if ww<100 then delete(st,1,2);
 if (ww<0) or (ww>10) then foo:=do_alert('[1]['+IdStr+']['+ContStr+']',1)
  else
   begin
    st:=strip(st,false);
    Men[ww]:=st;
   end;
end;
{----------------------------------------------------------------------------}
procedure IfFlag(st:string);
var ww:INteger;
begin
 st:=strip(st,False);
 ww:=Number(st);
 if ww<10 then delete(st,1,1);
 if (ww<0) or (ww>9) then foo:=do_alert('[1]['+WfStr+']['+ContStr+']',1)
  else
   begin
    st:=strip(st,TRUE);
    if flag[ww]=True then Jmp(st);
   end;
end;
{----------------------------------------------------------------------------}
procedure SetFlag(st:string;se:Boolean);
var ie,code:Integer;
begin
st:=strip(st,True);
val(st,ie,code);
if (ie>=0) and (ie<10) then flag[ie]:=se
 else foo:=do_alert('[1]['+WfStr+']['+ContStr+']',1)
end;
{----------------------------------------------------------------------------}
Procedure Menu(ST:string);
var button,dummy,ww,code:Integer;
    Menu:Dialog_Ptr;
    id:array [1..10] of integer;
begin
 st:=strip(st,False);
 val(st,ww,code);
 if (ww<0) or (ww>10) then foo:=do_alert('[1]['+IdStr+']['+ContStr+']',1)
  else
   begin
    Menu:=New_Dialog(10, 2, 5, 45, 3+(ww*2));
    dummy:=Add_Ditem(Menu,G_STring,None,2,1,40,1,0,0);
    Set_DText(Menu, Dummy,Mntt ,System_Font, TE_Center);
    for i:=1 to ww do
     begin
      id[i]:=Add_DItem(Menu, G_Button, Selectable Or Exit_Btn Or Default,
                       2, (i*2)+1, 40, 1, 4, $1180);
      Set_DText(Menu, Id[i], ' '+Men[i]+' ', System_Font, TE_Center);
     end;
    Center_Dialog(Menu);
    Show_Dialog(Menu);
    button:= Do_Dialog(Menu,0);
    Obj_SetState(Menu,Button,Normal,True);
    End_Dialog (Menu);
    Delete_Dialog(Menu);
    for i:=1 to 10 do if button=id[i] then mb:=i;
   end;
end;
{----------------------------------------------------------------------------}
Procedure Selector(ST:string);
var button,dummy,ww,code:Integer;
    Menu:Dialog_Ptr;
    xb1,xb2,xb3:Integer;
    id:array [1..10] of integer;
begin
 st:=strip(st,False);
 val(st,ww,code);
 if (ww<0) or (ww>10) then foo:=do_alert('[1]['+IdStr+']['+ContStr+']',1)
  else
   begin
    Menu:=New_Dialog(10, 2, 5, 51,5+(ww*2));
    dummy:=Add_Ditem(Menu,G_STring,None,2,1,40,1,0,0);
    Set_DText(Menu, Dummy,Mntt ,System_Font, TE_Center);
    for i:=1 to ww do
     begin
      id[i]:=Add_DItem(Menu, G_Button, Selectable Or Exit_Btn Or Default,
                       2, (i*2)+1, 1, 1, 4, $1180);
      iF flag[i-1]=False then Set_DText(Menu, Id[i], ' ', System_Font, TE_Center)
       else Set_DText(Menu, Id[i], #8, System_Font, TE_Center);
     dummy:=Add_Ditem(Menu,G_STring,None,5,(i*2)+1,40,1,0,0);
     Set_DText(Menu, Dummy,Men[i] ,System_Font, TE_Left);
     end;
     if xbtn1<>'' then
      begin
       xb1:=Add_DItem(Menu,G_Button,Selectable Or Exit_Btn Or Default,2,(i*2)+3,10,1,4,$1180);
       Set_DText(Menu,xb1,xbtn1,System_Font,TE_Center);
      end;
     if xbtn2<>'' then
      begin
       xb2:=Add_DItem(Menu,G_Button,Selectable Or Exit_Btn Or Default,20,(i*2)+3,10,1,4,$1180);
       Set_DText(Menu,xb2,xbtn2,System_Font,TE_Center);
      end;
     if xbtn3<>'' then
      begin
       xb3:=Add_DItem(Menu,G_Button,Selectable Or Exit_Btn Or Default,40,(i*2)+3,10,1,4,$1180);
       Set_DText(Menu,xb3,xbtn3,System_Font,TE_Center);
      end;
    Center_Dialog(Menu);
    Show_Dialog(Menu);
    repeat
    button:= Do_Dialog(Menu,0);
    Obj_SetState(Menu,Button,Normal,True);
    for i:=1 to 10 do
     begin
      if button=id[i] then
       begin
        if flag[i-1]=True then flag[i-1]:=False
         else flag[i-1]:=True;
       end;
      iF flag[i-1]=False then Set_DText(Menu, Id[i], ' ', System_Font, TE_Center)
       else Set_DText(Menu, Id[i], #8, System_Font, TE_Center);
     end;
    until (button=xb1) or (button=xb2) or (button=xb3);
    if button=xb1 then bnp:=1;
    if button=xb2 then bnp:=2;
    if button=xb3 then bnp:=3;
    End_Dialog (Menu);
    Delete_Dialog(Menu);
{    for i:=1 to 10 do if button=id[i] then mb:=i;}
   end;
end;
{----------------------------------------------------------------------------}
Procedure InfoWin(ST:string);
var button,dummy,ww,code:Integer;
    Menu:Dialog_Ptr;
    xb1,xb2,xb3:Integer;
    da:strING;
begin
 st:=strip(st,False);
 val(st,ww,code);
 if (ww<0) or (ww>10) then foo:=do_alert('[1]['+IdStr+']['+ContStr+']',1)
  else
   begin
    Menu:=New_Dialog(10, 2, 5, 51,5+(ww*2));
    dummy:=Add_Ditem(Menu,G_STring,None,2,1,40,1,0,0);
    Set_DText(Menu, Dummy,Mntt ,System_Font, TE_Center);
    for i:=1 to ww do
     begin
      dummy:=Add_Ditem(Menu,G_STring,None,2,2+i,40,1,0,0);
      Set_DText(Menu, Dummy,Men[i] ,System_Font, TE_Left);
     end;
     if xbtn1<>'' then
      begin
       xb1:=Add_DItem(Menu,G_Button,Selectable Or Exit_Btn Or Default,2,(i*2)+3,10,1,4,$1180);
       Set_DText(Menu,xb1,xbtn1,System_Font,TE_Center);
      end;
     if xbtn2<>'' then
      begin
       xb2:=Add_DItem(Menu,G_Button,Selectable Or Exit_Btn Or Default,20,(i*2)+3,10,1,4,$1180);
       Set_DText(Menu,xb2,xbtn2,System_Font,TE_Center);
      end;
     if xbtn3<>'' then
      begin
       xb3:=Add_DItem(Menu,G_Button,Selectable Or Exit_Btn Or Default,40,(i*2)+3,10,1,4,$1180);
       Set_DText(Menu,xb3,xbtn3,System_Font,TE_Center);
      end;
    Center_Dialog(Menu);
    Show_Dialog(Menu);
    repeat
     button:= Do_Dialog(Menu,0);
     Obj_SetState(Menu,Button,Normal,True);
     until (button=xb1) or (button=xb2) or (button=xb3);
    if button=xb1 then bnp:=1;
    if button=xb2 then bnp:=2;
    if button=xb3 then bnp:=3;
    End_Dialog (Menu);
    Delete_Dialog(Menu);
   end;
end;
{----------------------------------------------------------------------------}
Procedure Pause(st:String);
var ff,fe,p,c:Integer;
begin
 st:=strip(st,true);
 val(st,p,c);
 c:=Get_Timer(p);
end;
{----------------------------------------------------------------------------}
Procedure Back;
var xw,yw,ww,hw:Integer;
begin
 Work_Rect(WinHandle,xw,yw,ww,hw);
 Hide_Mouse;
 Paint_Style(Solid);
 Paint_Color(bkcolor);
 Paint_Rect(xw,yw,ww,hw);
 Show_Mouse;
end;
{----------------------------------------------------------------------------}
Procedure IfErr(st:String);
var ww:Integer;
begin
 st:=strip(st,false);
 ww:=Number(st);
 if ww<10 then delete(st,1,1)
  else if ww<100 then delete(st,1,2);
 st:=strip(st,True);
 if (ww=ife) or (ife=-1) then
  begin
   if ww<>0 then jmp(st);
  end;
end;
{----------------------------------------------------------------------------}
Procedure CHkVol(st:String);
var dr:string[10];
    i:Integer;
    dis:Searchrec;
begin
st:=strip(st,True);
if st[2]=':' then
 begin
  dr:=st[1]+st[2]+'\*.*';
  delete(st,1,2);
  st:=upstr(st);
  FindFirst(dr,VolumeId,dis);
  bnp:=2;
  if doserror=0 then
   begin
    for I:=1 to length(dis.name) do if dis.name[i]='.' then delete(dis.name,i,1);
    if dis.name=st then bnp:=1;
   end;
 end;
end;
{----------------------------------------------------------------------------}
Procedure Colour(st:String);                                          { BALJ }
var ff,fe,p,c:Integer;                                                { BALJ }
begin                                                                 { BALJ }
 st:=strip(st,true);                                                  { BALJ }
 val(st,textColor,c);                                                 { BALJ }
end;                                                                  { BALJ }
{----------------------------------------------------------------------------}
Procedure SelFile(st:String);                                       { BALJ }
var fn:Path_Name;                                                   { BALJ }
    pn:Path_Name;                                                    { BALJ }
    ok:Boolean;                                                      { BALJ }
begin                                                                { BALJ }
{ va[1]:='';}                                                          { BALJ }
 va[1]:='???.???';{ This is easier to check if no file was selected       HR}
 st:=strip(st,true);                                                 { BALJ }
 if length(st) > 0 then                                              { BALJ }
  begin
   if (st[1]<>'\') and (st[2]<>':') then st:='\'+st;
   {This "if" line is needed so that script's like Owen Rudges's WAV play
    script work correct                                                   HR}
   pn:=st;                                                            { BALJ }
  end
 else                                                                { BALJ }
  pn:='\*.*';                                                        { BALJ }
 fn:='';                                                             { BALJ }
 ok:=Get_In_File(pn,fn);                                             { BALJ }
 if ok then                                                          { BALJ }
 begin                                                               { BALJ }
  va[1]:=fn;                                                         { BALJ }
 end;                                                                { BALJ }
end;                                                                 { BALJ }
{----------------------------------------------------------------------------}
Procedure Loop;
var bl,f,e,d,c,b:string;
    gf:string[15];
    res:String;
    r,siz,go:Longint;
    ff:Byte;
    cd,g,h,i,ver,code:Integer;
    as,out:Boolean;
begin
lcx:=0;
out:=False;
assign(a,filename);
{$I-}
reset(a);
{$I+}
if ioresult<>0 then
 begin
  foo:=do_alert('[1]['+ffnfStr+']['+CancelStr+']',1);
  Exit_GEM;
  halt(1);
 end;
cmd:=0;
repeat
 sec:=0;
 readln(a,b);
 inc(lcx);
 b:=remove(b);
 if eof(a) then out:=True;
 b:=Strip(b,False);
 b:=DriveChange(b);
 res:=b; { This is the original Line without variables inserted}
 b:=VarPrint(b);
 c:='';
 cmd:=0;
 if b='' then cmd:=1;
 if (b[1]<>':') and (comm=False) then c:=Cmds(b);
 if debug=True then
  begin
   bl:='';
   for r:=1 to lengtH(b) do if (b[r]<>'[') and (b[r]<>']') and (b[r]<>'|') then bl:=bl+b[r];
   foo:=do_alert('[1][Line:'+bl+'|Cmd:'+c+']['+CancelStr+']',1);
  end;
 if (b[1]=':') or (b[1]=';') or (b[1]='#') then cmd:=1;
 if (b[1]='/') and (b[2]='*') then
  begin
   cmd:=1;
   comm:=True;
  end;
 if (b[1]='/') and (b[2]='/') then cmd:=1;
 if (scan(b,'*/')=True) and (comm=True) then
  begin
   cmd:=1;
   b:='';
   c:='';
   comm:=False;
  end;
 if comm=True then
  begin
   c:='';
   b:='';
   cmd:=1;
  end;
 if c='REM' then cmd:=1;
 if c='LABEL' then cmd:=1;
 if c='CD' then
  begin
   cmd:=1;
   delete(b,1,3);
   chdir(b);
  end;
 if c='SHOWBMP' then
  begin
   cmd:=1;
   delete(b,1,8);
   BMP(b);
  end;
 if c='MD' then
  begin
   cmd:=1;
   delete(b,1,3);
   {$I-}
   mkdir(b);
   {$i+}   
   ife:=ioresult;
   if spcl<>'' then if ioresult=5 then Jmp(Spcl);
  end;
 if c='DEBUG' then
  begin
   cmd:=1;
   debug:=True;
  end;
 if (c='DOS') or (c='EXIT') or (c='END') then
  begin
   cmd:=1;
   Out:=True;
  end;
 if c='OUTFILE' then
  begin
   cmd:=1;
   delete(b,1,8);
   b:=Strip(b,false);
   outFile:=b;
  end;
 if (c='PRINT') or (b[1]='?') or (c='ECHO') then
  begin
   cmd:=1;
   if c='PRINT' then delete(b,1,6);
   if c='ECHO' then delete(b,1,5);
   if b[1]='?' then delete(b,1,2);
   b:=Strip(b,false);
   if win=False then
    begin
     win:=true;
     WinOn;
    end;
   print(b);
  end;
 if c='LET' then
  begin
   delete(b,1,4);
   delete(res,1,4);
   cmd:=1;
   let(b,res);
  end;
 if c='CLRMT' then
  begin
   cmd:=1;
   mntt:='';
  end;
 if c='CLR' then
  begin
   fle:=0;
   fll:=0;
   forl:=False;
   for i:=1 to 5 do va[i]:='';
   for i:=0 to 9 do flag[i]:=False;
   vn:=0;
   cmd:=1;
  end;
 if c='BREAK' then
  begin
   fll:=0;
   forl:=False;
   vn:=0;
   cmd:=1;
  end;
 if c='CLS' then
  begin
   Cls;
   cmd:=1;
  end;
 if c='WIN' then
  begin
   cmd:=1;
   delete(b,1,4);
   Wind(b);
  end;
 if c='WAIT' then
  begin
   cmd:=1;
   delete(b,1,5);
   Wait(b);
  end;
 if c='TYPENAME' then                                           { BALJ }
  begin                                                         { BALJ }
   cmd:=1;                                                      { BALJ }
   delete(b,1,8);                                               { BALJ }
   HaveShowFileName:=true;                                      { BALJ }
   ShowFileName:=b;                                             { BALJ }
  end;                                                          { BALJ }
 if c='NOTYPENAME' then                                         { BALJ }
  begin                                                         { BALJ }
   cmd:=1;                                                      { BALJ }
   HaveShowFileName:=false;                                     { BALJ }
   ShowFileName:='';                                            { BALJ }
  end;                                                          { BALJ }
 if c='TYPE' then
  begin
   cmd:=1;
   delete(b,1,5);
   ShowFile(b);
  end;
(* This is the Original code from BALJ i have optimized it a little bit
 if c='COLOUR' then                                     { BALJ }
  begin                                                 { BALJ }
   cmd:=1;                                              { BALJ }
   delete(b,1,6);                                       { BALJ }
   Colour(b);                                           { BALJ }
  end;                                                  { BALJ }
 if c='COLOR' then                                      { BALJ }
  begin                                                 { BALJ }
   cmd:=1;                                              { BALJ }
   delete(b,1,5);                                       { BALJ }
   Colour(b);                                           { BALJ }
  end;                                                  { BALJ }        *)
 if (c='COLOR') or (c='COLOUR') then
  begin                                                 { BALJ }
   cmd:=1;                                              { BALJ }
   if c='COLOUR' then delete(b,1,6)
    else delete(b,1,5);
   Colour(b);                                           { BALJ }
  end;                                                  { BALJ }
 if (c='VER') or (c='CURVER') then
  begin
   delete(b,1,3);
   if c='CURVER' then delete(b,1,3);
   g:=Lo(dosversion);
   h:=hi(dosversion);
   str(h,e);
   str(g,f);
   f:=f+'.'+e;
   e:=hex(aes_version);
   delete(e,1,1);
   if e[1]='0' then e[1]:=' ';
   gf:=e[1]+e[2]+'.'+e[3]+e[4];
   if xmgem=True then gf:='XM/GEM '+f;
   {$IFNDEF UNINSTALL}
     foo:=do_alert('[1][GDScript v2.0|Dos-Version:'+f+'|GEM-Version:'+gf+'][Continue]',1);
   {$ELSE}
     foo:=do_alert('[1][GDScript v2.0 Uninstall|Dos-Version:'+f+'|GEM-Version:'+gf+'][Continue]',1);
   {$ENDIF}
   cmd:=1;
  end;
 if c='CHAIN' then
  begin
   delete(b,1,6);
   b:=strip(b,True);
   b:='2 0 0 '+b;
   run(b);
   cmd:=1;
  end;
 if c='RUN' then
  begin
   delete(b,1,4);
   run(b);
   cmd:=1;
  end;
 if c='BKGROUND' then
  begin
   cmd:=1;
   delete(b,1,9);
   b:=strip(b,true);
   val(b,bkcolor,code);
   if WIn=True then Back;
  end;
 if c='SCRIPT' then
  begin
   cmd:=1;
   delete(b,1,6);
   close(a);
   b:=Strip(b,False);
   filename:=b;
   lcx:=0;
   lic:=1;
   Labels;
   Loop;
   out:=true;
  end;
 if c='REN' then
  begin
   delete(b,1,4);
   Ren(b);
   cmd:=1;
  end;
{$IFNDEF UNINSTALL}
 if c='DEL' then
  begin
   delete(b,1,4);
   if security=True then Secu(1);
   if sec=0 then Del(b);
   cmd:=1;
  end;
{$ELSE}
 if (c='ERASE') or (C='DELETE') then
  begin
   if c='ERASE' then delete(b,1,6);
   if c='DELETE' then delete(b,1,7);
   Del(b);
   cmd:=1;
  end;
{$ENDIF}
 if c='FOR' then
  begin
   delete(b,1,4);
   ForRout(b);
   forl:=True;
   cmd:=1;
  end;
 if (c='NEXT') or (c='CONT') then
  begin
   if c='NEXT' then if forl=False then foo:=do_alert('[1]['+NextStr+']['+CancelStr+']',1);
   if c='CONT' then if forl=False then foo:=do_alert('[1]['+ConStr+']['+CancelStr+']',1);
   if fll>0 then
    begin
     FindNext(Dir);
     if Doserror=0 then
      begin
       va[vn]:=Dir.Name;
       GOLine(fll);
      end
       else
        begin
         forl:=False;
         fll:=0;
        end;
    end;
   cmd:=1;
  end;
 if c='COPY' then
  begin
   delete(b,1,5);
   copywin(b);
   cmd:=1;
  end;
 if c='MENU' then
  begin
   delete(b,1,5);
   Menu(b);
   cmd:=1;
  end;
 if c='SELECTOR' then
  begin
   delete(b,1,9);
   Selector(b);
   cmd:=1;
  end;
 if c='INFOWIN' then
  begin
   delete(b,1,7);
   InfoWin(b);
   cmd:=1;
  end;
 if c='SETALLFLAG' then
  begin
   cmd:=1;
   delete(b,1,11);
   for i:=0 to 9 do flag[i]:=TRue;
  end;
 if c='CLRALLFLAG' then
  begin
   cmd:=1;
   delete(b,1,11);
   for i:=0 to 9 do flag[i]:=False;
  end;
 if c='MENUITEM' then
  begin
   cmd:=1;
   delete(b,1,9);
   MenuItem(b);
  end;
 if c='SELECTOR' then
  begin
   cmd:=1;
   delete(b,1,9);
   If GetONOff(b)=True then
    begin
     delete(b,1,2);
     b:=strip(b,false);
     b:=#8+b;
    end
   else
    begin
     delete(b,1,3);
     b:=strip(b,false);
     b:=#0+b;
    end;
   MenuItem(b);
  end;
 if c='IFERR' then
  begin
   cmd:=1;
   delete(b,1,5);
   Iferr(b);
  end;
 if c='IF1BUTN' then
  begin
   if bnp=1 then
    begin
     delete(b,1,8);
     Jmp(b);
    end;
   cmd:=1;
  end;
 if c='IF2BUTN' then
  begin
   if bnp=2 then
    begin
     delete(b,1,8);
     Jmp(b);
    end;
   cmd:=1;
  end;
 if c='IF3BUTN' then
  begin
   if bnp=3 then
    begin
     delete(b,1,8);
     Jmp(b);
    end;
   cmd:=1;
  end;
 if c='IF' then
  begin
   cmd:=1;
   delete(b,1,2);
   delete(res,1,2);
   Ifrout(b,res);
  end;
 if c='IFFD' then
  begin
   if fd=True then
    begin
     delete(b,1,5);
     Jmp(b);
    end;
   cmd:=1;
  end;
 if c='IFHD' then
  begin
   if fd=True then
    begin
     delete(b,1,5);
     Jmp(b);
    end;
   cmd:=1;
  end;
 if c='PATBAT' then
  begin
   delete(b,1,7);
   PatBat(b);
   cmd:=1;
  end;
 if c='CHECKVER' then
  begin
   delete(b,1,9);
   d:='$'+b;
   val(d,ver,code);
   if ver>aes_version then bnp:=1;
   if ver=aes_version then bnp:=2;
   if ver<aes_version then bnp:=3;
   cmd:=1;
  end;
 if c='DISKSPACE' then
  begin
   delete(b,1,9);
   b:=strip(b,False);
   ff:=ord(upcase(b[1]))-64;
   delete(b,1,2);
   b:=strip(b,False);
   siz:=Number(b);
   if siz>diskfree(ff) then bnp:=1;
   if siz=diskfree(ff) then bnp:=2;
   if siz<diskfree(ff) then bnp:=3;
   cmd:=1;
  end;
 if c='GDSVER' then
  begin
   delete(b,1,9);
   d:='$'+b;
   val(d,ver,code);
   if ver>gds_version then bnp:=1;
   if ver=gds_version then bnp:=2;
   if ver<gds_version then bnp:=3;
   cmd:=1;
  end;
{$IFNDEF UNINSTALL}
 if c='PLAYWAV' then
  begin
   cmd:=1;
   delete(b,1,8);
   b:=strip(b,True);
   if sound=True then as:=PlayWav(b);
  end;
 if c='IPLAYWAV' then
  begin
   if ipp=True then
    begin
     cmd:=1;
     delete(b,1,9);
     b:=strip(b,True);
     if sound=True then as:=PlayIWav(b);
    end;
  end;
 if c='STOP' then
  begin
   if ipp=True then
    begin
     cmd:=1;
     delete(b,1,9);
     b:=strip(b,True);
     if sound=True then StopWav;
    end;
  end;
{$ENDIF}
 if c='CLRSCR' then
  begin
   cmd:=1;
   delete(b,1,7);
   Work_Rect(0,mwx,mwy,mww,mwh);
   if mono=false then Paint_Color(4)
    else Paint_Color(1);
   Paint_Style(Dashed);
   Paint_Rect(mwx,mwy,mww,mwh);
  end;
 if c='DELAY' then
  begin
   cmd:=1;
   delete(b,1,6);
   Pause(b);
  end;
 if c='SELFILE' then                                    { BALJ }
  begin                                                 { BALJ }
   cmd:=1;                                              { BALJ }
   delete(b,1,8);                                       { BALJ }
   SelFile(b);                                          { BALJ }
  end;                                                  { BALJ }
 if c='LANGUAGE' then
  begin
   delete(b,1,8);
   b:=strip(b,TRUE);
   lng:=b[1]+b[2];
   cmd:=1;
  end;
 if c='GOTO' then
  begin
   delete(b,1,5);
   Jmp(b);
   cmd:=1;
  end;
 if c='CALL' then
  begin
   delete(b,1,5);
   Jmp(b);
   cmd:=1;
  end;
 if c='RETURN' then
  begin
   dec(Gint);
   if Gint>0 then GoLine(Gosub[Gint]);
   if Gint=0 then
    begin
     foo:=do_alert('[1]['+RetStr+']['+ContStr+']',1);
     Gint:=1;
    end;
   cmd:=1;
  end;
 if c='GOSUB' then
  begin
   delete(b,1,5);
   b:=strip(b,TRUE);
   cmd:=1;
   if gint>10 then foo:=do_alert('[1]['+GoSubStr+']['+ContStr+']',1)
    else
     begin
      Gosub[Gint]:=lcx;
      inc(gint);
      Jmp(b);
      cmd:=1;
     end;
  end;
 if c='MENUTITLE' then
  begin
   delete(b,1,10);
   b:=strip(b,True);
   mntt:=b;
   cmd:=1;
  end;
 if c='CLRXBTN' then
  begin
   xbtn1:='';
   xbtn2:='';
   xbtn3:='';
   cmd:=1;
  end;
 if c='SETXBTN1' then
  begin
   delete(b,1,9);
   b:=strip(b,True);
   xbtn1:=b;
   cmd:=1;
  end;
 if c='SETXBTN2' then
  begin
   delete(b,1,9);
   b:=strip(b,True);
   xbtn2:=b;
   cmd:=1;
  end;
 if c='SETXBTN3' then
  begin
   delete(b,1,9);
   b:=strip(b,True);
   xbtn3:=b;
   cmd:=1;
  end;
 if c='SETFLAG' then
  begin
   delete(b,1,7);
   SetFlag(b,True);
   cmd:=1;
  end;
 if c='CLRFLAG' then
  begin
   delete(b,1,7);
   SetFlag(b,False);
   cmd:=1;
  end;
 if c='CHKVOL' then
  begin
   delete(b,1,6);
   ChkVol(b);
   cmd:=1;
  end;
 if c='IFFLAG' then
  begin
   delete(b,1,6);
   IfFlag(b);
   cmd:=1;
  end;
 if c='CREATE' then
  begin
   cmd:=1;
   delete(b,1,7);
   b:=strip(b,True);
   assign(unif,b);
   rewrite(unif);
  end;
 if c='CLOSE' then
  begin
   cmd:=1;
   delete(b,1,6);
   close(unif);
  end;
 if c='OPEN' then
  begin
   cmd:=1;
   delete(b,1,5);
   b:=strip(b,True);
   assign(unif,b);
   reset(unif);
  end;
 if c='READ' then
  begin
   cmd:=1;
   delete(b,1,5);
   delete(res,1,5);
   b:=strip(b,True);
   readln(unif,b);
   fread(res,b);
  end;
 if c='WRITE' then
  begin
   cmd:=1;
   delete(b,1,6);
   b:=strip(b,False);
   writeln(unif,b);
  end;
 if c='WAITKEY' then
  begin
   cmd:=1;
   cd:=Get_Keyboard;
  end;
 if c='CLTBTN' then
  begin
   cmd:=1;
   bnp:=0;
  end;
 if c='SRCMSG' then
  begin
   Alert(b,2);
   cmd:=1;
  end;
 if c='SETVOL' then
  begin
   cmd:=1;
  end;
 if c='ALERT' then
  begin
   alert(b,1);
   cmd:=1;
  end;
 if c='IFNOSPC' then
  begin
   delete(b,1,8);
   NoSpace(b);
   cmd:=1;
  end;
 if c='CREATEMSG' then
  begin
   alert(b,3);
   cmd:=1;
  end;
 if c='DSTMSG' then
  begin
   alert(b,3);
   cmd:=1;
  end;
if cmd=0 then
 begin
  str(lcx,aler);
  foo:=do_alert('[1]['+SyntaxStr+filename+' |'+LineStr+b+'|Line:'+aler+' ]['+CancelStr+']',1);
  out:=true;
 end;
until out=True;
close(a);
if comm=true then foo:=do_alert('[1]['+CommStr+']['+CancelStr+']',1);
if forl=true then foo:=do_alert('[1]['+ForStr+']['+CancelStr+']',1);
if win=true then
 begin
  Close_Window(WinHandle);
  Delete_Window(WinHandle);
 end;
end;
Procedure InitLanguage;
var iL:text;
    st2,st:string;
begin
 CopyStr:='Copy:';
 ToStr:='To:';
 CancelStr:='Cancel';
 LabelStr:='Too much labels';
 InstallStr:='Install on drive:';
 SyntaxStr:='Illegal command in file:';
 LineStr:='Line:';
 WaitStr:='Please Wait...';
 nfStr:='not found';
 CommStr:='*/ not found!';
 GoSubStr:='GOSUB is to deep';
 RetStr:='RETURN without GOSUB';
 ContStr:='Continue';
 lng:='UK';
 ffnfStr:='File not found';
 NoFileStr:='No files';
 PathNfStr:='Path not found';
 ForStr:='FOR without NEXT';
 NextStr:='NEXT without FOR';
 IdStr:='Wrong Menu ID';
 ConStr:='CONT without FOR';
 DelStr:='Do you really want to execute DEL ?';
 JaStr:='Yes';
 NeinStr:='No';
 WFstr:='Wrong FLAG number';
 WiStr:='Wrong $ command';
 FormStr:='Do you really want to execute FORMAT ?';
 nbmpStr:='SHOWBMP didn`t find file';
assign(il,'GDS.LNG');
{$I-}
reset(il);
{$I+}
if ioresult=0 then
 begin
  repeat
   readln(il,st);
   st2:=upstr(st);
   if st[1]<>'#' then
    begin
     delete(st,1,5);
     if mid(st2,1,5)='LANG=' then Lng:=st;
     if mid(st2,1,5)='MSG0=' then CopyStr:=st;
     if mid(st2,1,5)='MSG1=' then ToStr:=st;
     if mid(st2,1,5)='MSG2=' then CancelStr:=st;
     if mid(st2,1,5)='MSG3=' then LabelStr:=st;
     if mid(st2,1,5)='MSG4=' then InstallStr:=st;
     if mid(st2,1,5)='MSG5=' then SyntaxStr:=st;
     if mid(st2,1,5)='MSG6=' then LineStr:=st;
     if mid(st2,1,5)='MSG7=' then WaitStr:=st;
     if mid(st2,1,5)='MSG8=' then nfstr:=st;
     if mid(st2,1,5)='MSG9=' then CommStr:=st;
     if st2[6]='=' then delete(st,1,1);
     if mid(st2,1,6)='MSG10=' then GoSubStr:=st;
     if mid(st2,1,6)='MSG11=' then RetStr:=st;
     if mid(st2,1,6)='MSG12=' then ContStr:=st;
     if mid(st2,1,6)='MSG13=' then ffnfStr:=st;
     if mid(st2,1,6)='MSG14=' then NoFileStr:=st;
     if mid(st2,1,6)='MSG15=' then PathnfStr:=st;
     if mid(st2,1,6)='MSG16=' then ForStr:=st;
     if mid(st2,1,6)='MSG17=' then NextStr:=st;
     if mid(st2,1,6)='MSG18=' then IDStr:=st;
     if mid(st2,1,6)='MSG19=' then ConStr:=st;
     if mid(st2,1,6)='MSG20=' then DelStr:=st;
     if mid(st2,1,6)='MSG21=' then JaStr:=st;
     if mid(st2,1,6)='MSG22=' then NeinStr:=st;
     if mid(st2,1,6)='MSG23=' then WfStr:=st;
     if mid(st2,1,6)='MSG24=' then FormStr:=st;
     if mid(st2,1,6)='MSG25=' then WiStr:=st;
     if mid(st2,1,6)='MSG26=' then NbmpStr:=st;
    end;
  until eof(il);
  close(il);
 end;
end;
{----------------------------------------------------------------------------}
Function Bin(S:Integer):String;
var i,ok,wek,eve:Integer;
    r:String;
begin
 r:='';
 wek:=hi(s);
 for i:=1 to 2 do
 begin
 eve:=128;
 for ok:=0 to 7 do
  begin
   if wek div eve=1 then
    begin
     r:=r+'1';
     wek:=wek-eve;
    end
    else r:=r+'0';
   eve:=eve div 2;
  end;
 wek:=lo(s);
 end;
Bin:=r;
end;
{----------------------------------------------------------------------------}
begin
if getenv('SOUND')<>'' then sound:=True
 else sound:=False;
aler:=paramstr(0);
if mid(aler,lengtH(aler)-2,3)='EXE' then
 begin
  writeln('This is a GEM Application please rename it to APP');
  halt(1);
 end;
foo:=Init_Gem;
if Global[1]=1 then xmgem:=False
 else xmgem:=True;
mono:=False;
if Int_Out[35]=0 then mono:=True;
if sound=True then { Check if Interrupt sound playing is possible }
 begin
  SD_Info;
  if Sd_Version<$0001 then
   begin
    foo:=do_alert('[1][Illegal Sounddriver version ! Please Update][Cancel]',1);
    Exit_GEm;
    halt(1);
   end;
  if SD_Version>$300 then ipp:=True;
 end;
for i:=1 to 5 do va[i]:='';
for i:=1 to 10 do
 begin
  men[i]:='';
  flag[i-1]:=False;
 end;
InitLanguage;
erl:=0;
security:=False;
Work_Rect(0,deskx,desky,deskw,deskh);                                 { BALJ }
Sys_Font_size(wchar,hchar,wbox,hbox);
if hchar=16 then sh:=14; { Vga,Svga}
if hchar=16 then sh:=11; { Ega}
if hchar=8 then sh:=7;   { CGA,Hercules }
textcolor:=Black;
Set_Mouse(M_Arrow);
HaveShowFileName:=False;                                              { BALJ }
WindowName:='';                                                       { BALJ }
SHowFileName:='';
spcl:='';
dc:=False;
sec:=0;
bkcolor:=White;
debug:=False;
space:=False;
win:=False;
spc:=#32;
ife:=0;
mb:=0;
ad:='C';
oc:='C';
Gint:=1;
comm:=False;
Forl:=False;
cmd:=0;
lc:=1;
lcx:=0;
vn:=0;
fll:=0;
Lic:=1;
srr:='*.*';
Mntt:='';
bnp:=0;
if GetEnv('PROTECT')<>'' then
 begin
  aler:=GetEnv('PROTECT');
  aler:=upstr(aler);
  if aler='ON' then security:=True
   else security:=False;
 end;
drive:=bin(global[14]);
aler:='[1]['+FFnfStr+']['+ContStr+']';
xbtn1:='';
xbtn2:='';
xbtn3:='';
hd:=False;
alrn:=1;
fd:=True; { Floppy should be there}
for i:=3 to length(drive) do
 begin
  if drive[i]='1' then
   begin
    hd:=True;
    fd:=False;
   end;
 end;
if paramcount=0 then filename:=GDS_File
 else filename:=paramstr(1);
{$IFDEF UNINSTALL}
 Title:=filename; { IF no TITLE variable is set then use the filename }
{$ENDIF}
Labels;
{$IFDEF UNINSTALL}
foo:=do_alert('[1][UnInstall script|Removes '+title+'][Continue|Cancel]',1);
if foo=2 then
 begin
  Exit_Gem;
  halt(1);
 end;
{$ENDIF}
Loop;
Exit_GEM;
{----------------------------------------------------------------------------}
CopyRight:=
'-------------------------------------------------'#13#10+
'GDScript                             Version 2.0 '#13#10+
'Copyright (C) 2000                        HR,BALJ'#13#10+
'-------------------------------------------------'#13#10+
'27/07/2000'#13#10;
end.
